#ifndef SCANNER_OPTS_H
#define SCANNER_OPTS_H

#include <glib.h>


typedef struct _scanner_opts_struct	scanner_opts_struct;
#define SCANNER_OPTS(p)			((scanner_opts_struct *)(p))


/*
 *	Scanner Flags:
 */
typedef enum {
	SCANNER_FLAG_REPORT_ALL_OBJECTS		= (1 << 0)
} scanner_flags;


/*
 *	Scanner CPU Priority:
 */
typedef enum {
	SCANNER_CPU_PRIORITY_HIGHEST,
	SCANNER_CPU_PRIORITY_HIGH,
	SCANNER_CPU_PRIORITY_MEDIUM,
	SCANNER_CPU_PRIORITY_LOW,
	SCANNER_CPU_PRIORITY_LOWEST
} scanner_cpu_priority;


/*
 *	Scanner Options:
 */
struct _scanner_opts_struct {

	scanner_flags	flags;

	gulong		max_files,		/* Max files to scan in an
						 * archive */
			max_file_size_bytes,	/* Max size of a file to scan
						 * in an archive */
			max_recursions,		/* Max archive scan recursions */
			max_mail_recursions,	/* Max mail scan recursions */
			max_compression_ratio;	/* Max archive compression ratio */

	scanner_cpu_priority	cpu_priority;

};


#endif	/* SCANNER_OPTS_H */
