/*==============================================================*/
/* Database name:  axyl                                         */
/* DBMS name:      MySQL 4.0                                    */
/* Created on:     27/05/2005 9:12:08 p.m.                      */
/*==============================================================*/


/*==============================================================*/
/* Table: ax_block                                              */
/*==============================================================*/
create table ax_block
(
   block_id                       int                            not null,
   layout_id                      int                            not null,
   background_img                 int,
   lang_id                        varchar(64)                    not null default '0',
   block_desc                     longtext,
   block_style                    longtext,
   block_type                     longtext,
   cols                           int                            not null default 1,
   gutter_width                   int                            not null default 0,
   gutter_colour                  longtext,
   blocklet_sep                   int                            not null default 0,
   border_width                   int                            not null default 0,
   border_colour                  longtext,
   background_colour              longtext,
   justify                        varchar(10)                    not null default '',
   valign                         varchar(10)                    not null default '',
   exportable                     smallint                       not null default 0,
   cache                          longtext,
   cache_updated                  datetime,
   last_modified                  datetime                       not null default 'now()',
   primary key (block_id)
);

/*==============================================================*/
/* Index: "ax_block_bg_image_FK"                                            */
/*==============================================================*/
create index ax_block_bg_image_FK on ax_block
(
   background_img
);
/*==============================================================*/
/* Index: "ax_block_language_FK"                                            */
/*==============================================================*/
create index ax_block_language_FK on ax_block
(
   lang_id
);

/*==============================================================*/
/* Index: ax_block_layout_FK                                    */
/*==============================================================*/
create index ax_block_layout_FK on ax_block
(
   layout_id
);

/*==============================================================*/
/* Table: ax_block_blocklet                                     */
/*==============================================================*/
create table ax_block_blocklet
(
   blocklet_id                    int                            not null,
   block_id                       int                            not null,
   display_order                  int                            not null default 0,
   visible                        smallint                       not null default 1,
   primary key (blocklet_id, block_id)
);

/*==============================================================*/
/* Index: ax_block_blocklet_FK                                  */
/*==============================================================*/
create index ax_block_blocklet_FK on ax_block_blocklet
(
   blocklet_id
);

/*==============================================================*/
/* Index: ax_block_blocklet_FK2                                 */
/*==============================================================*/
create index ax_block_blocklet_FK2 on ax_block_blocklet
(
   block_id
);

/*==============================================================*/
/* Table: ax_blocklet                                           */
/*==============================================================*/
create table ax_blocklet
(
   blocklet_id                    int                            not null,
   blocklet_desc                  longtext,
   blocklet_type                  varchar(10)                    not null default 'text',
   blocklet_width                 int                            not null default 100,
   blocklet_style                 longtext,
   justify                        varchar(10)                    not null default '',
   heading                        longtext,
   heading_level                  int                            not null default 3,
   heading_colour                 longtext,
   ruler                          varchar(10)                    not null default 'none',
   ruler_width                    int                            not null default 100,
   ruler_size                     int                            not null default 1,
   ruler_colour                   longtext,
   content                        longtext,
   content_size                   float(7,1)                     not null default 1.0,
   content_colour                 longtext,
   table_style                    longtext,
   table_autojustify              smallint                       not null default 0,
   table_rowstripes               smallint                       not null default 0,
   primary key (blocklet_id)
);

/*==============================================================*/
/* Table: ax_catalog                                            */
/*==============================================================*/
create table ax_catalog
(
   cat_id                         int                            not null,
   cat_name                       longtext                       not null,
   cat_desc                       longtext,
   mime_type                      longtext                       not null,
   mime_category                  longtext                       not null,
   upload_timestamp               datetime                       not null default 'now()',
   category                       longtext,
   keywords                       longtext,
   filesize                       int                            not null default 0,
   filepath                       longtext                       not null,
   width                          int                            not null default 0,
   height                         int                            not null default 0,
   primary key (cat_id)
);

/*==============================================================*/
/* Table: ax_config                                             */
/*==============================================================*/
create table ax_config
(
   config_name                    varchar(64)                    not null,
   config_fields                  longtext,
   primary key (config_name)
);

/*==============================================================*/
/* Table: ax_configuration                                      */
/*==============================================================*/
create table ax_configuration
(
   config_name                    varchar(64)                    not null,
   config_id                      varchar(64)                    not null,
   config_set                     longtext,
   primary key (config_name, config_id)
);

/*==============================================================*/
/* Index: ax_configuration_config_FK                            */
/*==============================================================*/
create index ax_configuration_config_FK on ax_configuration
(
   config_name
);

/*==============================================================*/
/* Table: ax_contactinfo                                        */
/*==============================================================*/
create table ax_contactinfo
(
   contactinfo_id                 int                            not null,
   addr_postal                    longtext,
   addr_street                    longtext,
   addr_suburb                    longtext,
   addr_city                      longtext,
   addr_country                   longtext,
   addr_code                      longtext,
   addr_other                     longtext,
   emails                         longtext,
   phone                          longtext,
   phone_fax                      longtext,
   phone_work                     longtext,
   phone_mobile                   longtext,
   urls                           longtext,
   primary key (contactinfo_id)
);

/*==============================================================*/
/* Table: ax_content_location                                   */
/*==============================================================*/
create table ax_content_location
(
   location_id                    int                            not null,
   location_name                  longtext                       not null,
   location_desc                  longtext,
   enabled                        smallint                       not null default 1,
   primary key (location_id)
)
comment = "Contains unique logical locations on the website for content. These are not necessarily physical pages, but can be used in your application code to present the story in the locations required.";

/*==============================================================*/
/* Table: ax_control                                            */
/*==============================================================*/
create table ax_control
(
   app_prefix                     longtext,
   site_axyl_version              longtext,
   site_docroot                   longtext
)
comment = "Details which are registered for any Axyl website, on first access, or on upgrade.";

/*==============================================================*/
/* Table: ax_element_set_enc                                    */
/*==============================================================*/
create table ax_element_set_enc
(
   schema_name                    varchar(64)                    not null,
   element_id                     int                            not null,
   enc_scheme_id                  int                            not null,
   primary key (schema_name, element_id, enc_scheme_id)
);

/*==============================================================*/
/* Index: "ax_elemset_enc_set_FK"                                            */
/*==============================================================*/
create index ax_elemset_enc_set_FK on ax_element_set_enc
(
   schema_name,
   element_id
);
/*==============================================================*/
/* Index: "ax_elemset_enc_enc_FK"                                            */
/*==============================================================*/
create index ax_elemset_enc_enc_FK on ax_element_set_enc
(
   enc_scheme_id
);

/*==============================================================*/
/* Table: ax_enc_qualifier                                      */
/*==============================================================*/
create table ax_enc_qualifier
(
   enc_scheme_id                  int                            not null,
   qual_name                      varchar(64)                    not null,
   qual_label                     longtext,
   comments                       longtext,
   default_value                  longtext,
   list_of_values                 longtext,
   display_order                  int                            not null default 999,
   primary key (enc_scheme_id, qual_name)
);

/*==============================================================*/
/* Index: "ax_enc_qual_scheme_FK"                                            */
/*==============================================================*/
create index ax_enc_qual_scheme_FK on ax_enc_qualifier
(
   enc_scheme_id
);

/*==============================================================*/
/* Table: ax_enc_scheme                                         */
/*==============================================================*/
create table ax_enc_scheme
(
   enc_scheme_id                  int                            not null,
   enc_scheme_name                longtext                       not null,
   label                          longtext,
   tag_name                       longtext                       not null,
   description                    longtext,
   datasrc_uri                    longtext,
   reference_url                  longtext,
   enabled                        smallint                       not null default 1,
   primary key (enc_scheme_id)
)
comment = "This table holds encoding schemes, which are basically lists of values. An example would be an encoding scheme for Media Types, which is essentially a list of mime-types. Other examples include Language Name Codes, and even Medical Subject Headings.";

/*==============================================================*/
/* Table: ax_enc_value                                          */
/*==============================================================*/
create table ax_enc_value
(
   enc_scheme_id                  int                            not null,
   enc_value                      longtext                       not null,
   enc_label                      longtext,
   primary key (enc_scheme_id, enc_value)
);

/*==============================================================*/
/* Index: "ax_enc_schema_value_FK"                                            */
/*==============================================================*/
create index ax_enc_schema_value_FK on ax_enc_value
(
   enc_scheme_id
);

/*==============================================================*/
/* Table: ax_forum                                              */
/*==============================================================*/
create table ax_forum
(
   forum_id                       int                            not null,
   moderator                      varchar(64),
   forum_name                     longtext                       not null,
   forum_desc                     longtext,
   enabled                        smallint                       not null default 1,
   private                        smallint                       not null default 0,
   last_author                    longtext,
   threadlast_author              int                            not null default 0,
   datelast_author                date,
   posts                          int                            not null default 0,
   primary key (forum_id)
);

/*==============================================================*/
/* Index: "ax_forum_moderator_FK"                                            */
/*==============================================================*/
create index ax_forum_moderator_FK on ax_forum
(
   moderator
);

/*==============================================================*/
/* Table: ax_forum_member                                       */
/*==============================================================*/
create table ax_forum_member
(
   user_id                        varchar(64)                    not null,
   forum_id                       int                            not null,
   primary key (user_id, forum_id)
);

/*==============================================================*/
/* Index: ax_forum_member_FK                                    */
/*==============================================================*/
create index ax_forum_member_FK on ax_forum_member
(
   user_id
);

/*==============================================================*/
/* Index: ax_forum_member_FK2                                   */
/*==============================================================*/
create index ax_forum_member_FK2 on ax_forum_member
(
   forum_id
);

/*==============================================================*/
/* Table: ax_forum_msg                                          */
/*==============================================================*/
create table ax_forum_msg
(
   msg_id                         int                            not null,
   forum_id                       int                            not null,
   msg_subject                    longtext                       not null,
   msg_text                       longtext                       not null,
   msg_author                     longtext                       not null,
   msg_votes                      int                            not null default 0,
   last_modified                  datetime                       not null default 'now()',
   parent_thread_id               int,
   sticky                         smallint                       not null default 0,
   locked                         smallint                       not null default 0,
   views                          int                            not null default 0,
   enabled                        smallint                       not null default 1,
   replies                        int                            not null default 0,
   primary key (msg_id)
);

/*==============================================================*/
/* Index: "parent_thread_FK"                                            */
/*==============================================================*/
create index parent_thread_FK on ax_forum_msg
(
   parent_thread_id
);

/*==============================================================*/
/* Index: ax_fk_forum_msg_forum_FK                              */
/*==============================================================*/
create index ax_fk_forum_msg_forum_FK on ax_forum_msg
(
   forum_id
);

/*==============================================================*/
/* Table: ax_group                                              */
/*==============================================================*/
create table ax_group
(
   group_id                       int                            not null,
   group_desc                     longtext                       not null,
   primary key (group_id)
);

/*==============================================================*/
/* Table: ax_language                                           */
/*==============================================================*/
create table ax_language
(
   lang_id                        varchar(64)                    not null,
   lang_desc                      longtext                       not null,
   char_encoding                  longtext                       not null,
   direction                      varchar(4)                     not null default 'LTR',
   is_default                     smallint                       not null default 0,
   display_order                  int                            not null default 999,
   enabled                        smallint                       not null default 1,
   primary key (lang_id)
)
comment = "Contains the languages that Axyl supports.";

/*==============================================================*/
/* Table: ax_layout                                             */
/*==============================================================*/
create table ax_layout
(
   layout_id                      int                            not null,
   layout_name                    varchar(64)                    not null,
   lang_id                        int                            not null default 0,
   index_category                 longtext,
   layout_table                   longtext,
   show_last_modified             smallint                       not null default 0,
   format_last_modified           longtext,
   prefix_last_modified           longtext,
   layout_style                   longtext,
   cache                          longtext,
   cache_updated                  datetime,
   last_modified                  datetime                       not null default 'now()',
   primary key (layout_id)
);

/*==============================================================*/
/* Index: "ax_layout_language_FK"                                            */
/*==============================================================*/
create index ax_layout_language_FK on ax_layout
(
   lang_id
);

/*==============================================================*/
/* Index: ax_layout_set_FK                                      */
/*==============================================================*/
create index ax_layout_set_FK on ax_layout
(
   layout_name
);

/*==============================================================*/
/* Table: ax_layout_metadata                                    */
/*==============================================================*/
create table ax_layout_metadata
(
   layout_id                      int                            not null,
   element_id                     int                            not null,
   schema_name                    varchar(64)                    not null,
   meta_tag_value                 longtext,
   enc_scheme_id                  int,
   linked_uri                     smallint                       not null default 0,
   language                       longtext,
   primary key (layout_id, element_id, schema_name)
)
comment = "This is the actual container of metadata values for the given layout. A webpage might contain multiple layouts, therefore the metadata to be entered for the page is the unique combination of all layout metadata elements.";

/*==============================================================*/
/* Index: "ax_layout_meta_data_FK"                                            */
/*==============================================================*/
create index ax_layout_meta_data_FK on ax_layout_metadata
(
   layout_id
);
/*==============================================================*/
/* Index: "ax_lay_metadata_elem_FK"                                            */
/*==============================================================*/
create index ax_lay_metadata_elem_FK on ax_layout_metadata
(
   element_id,
   schema_name
);
/*==============================================================*/
/* Index: "ax_lay_metadata_scheme_FK"                                            */
/*==============================================================*/
create index ax_lay_metadata_scheme_FK on ax_layout_metadata
(
   enc_scheme_id
);

/*==============================================================*/
/* Table: ax_layout_set                                         */
/*==============================================================*/
create table ax_layout_set
(
   layout_name                    varchar(64)                    not null,
   page_id                        int,
   primary key (layout_name)
);

/*==============================================================*/
/* Index: ax_layout_set_sitepage_FK                             */
/*==============================================================*/
create index ax_layout_set_sitepage_FK on ax_layout_set
(
   page_id
);

/*==============================================================*/
/* Table: ax_layout_set_group                                   */
/*==============================================================*/
create table ax_layout_set_group
(
   layout_name                    varchar(64)                    not null,
   cm_privilege                   varchar(16)                    not null,
   group_id                       int                            not null,
   primary key (layout_name, cm_privilege, group_id)
);

/*==============================================================*/
/* Index: "group_layout_set_FK"                                            */
/*==============================================================*/
create index group_layout_set_FK on ax_layout_set_group
(
   layout_name
);
/*==============================================================*/
/* Index: "layout_set_group_FK"                                            */
/*==============================================================*/
create index layout_set_group_FK on ax_layout_set_group
(
   group_id
);

/*==============================================================*/
/* Table: ax_menu                                               */
/*==============================================================*/
create table ax_menu
(
   menu_id                        int                            not null,
   menu_name                      longtext                       not null,
   lang_id                        int                            not null default 0,
   menu_desc                      longtext,
   menu_user_groups               longtext,
   active                         smallint                       not null default 1,
   last_modified                  datetime                       not null default 'now()',
   primary key (menu_id)
);

/*==============================================================*/
/* Index: "ax_menu_language_FK"                                            */
/*==============================================================*/
create index ax_menu_language_FK on ax_menu
(
   lang_id
);

/*==============================================================*/
/* Index: menu_language                                         */
/*==============================================================*/
create unique index menu_language on ax_menu
(
   menu_name,
   lang_id
);

/*==============================================================*/
/* Table: ax_menuoption                                         */
/*==============================================================*/
create table ax_menuoption
(
   menuoption_id                  int                            not null,
   menu_id                        int                            not null,
   parent_id                      int                            default 0,
   user_groups                    longtext,
   user_type                      longtext,
   menu_level                     int                            not null default 0,
   label                          longtext,
   description                    longtext,
   display_order                  int                            not null default 0,
   action                         longtext,
   sitepage                       longtext,
   sitepage_parms                 longtext,
   auth_code                      smallint                       not null default 0,
   active                         smallint                       not null default 1,
   width                          int                            not null default 80,
   height                         int                            not null default 20,
   is_parent                      smallint                       not null default 0,
   target                         longtext,
   last_modified                  datetime                       not null default 'now()',
   primary key (menuoption_id)
);

/*==============================================================*/
/* Index: ax_menuoption_menu_FK                                 */
/*==============================================================*/
create index ax_menuoption_menu_FK on ax_menuoption
(
   menu_id
);

/*==============================================================*/
/* Table: ax_meta_element                                       */
/*==============================================================*/
create table ax_meta_element
(
   element_id                     int                            not null,
   label                          longtext,
   tag_name                       longtext                       not null,
   definition                     longtext,
   parent_element                 int,
   parent_schema                  varchar(64),
   enabled                        smallint                       not null default 1,
   primary key (element_id)
)
comment = "A metadata element is the basic description of a template for an actual container of metadata. It is usually first 'born' in a particular meta schema, but can thenceforth be picked up and used as part of other schemas - this is the function of the foreign key field 'parent_schema'.";

/*==============================================================*/
/* Index: "ax_parent_element_FK"                                            */
/*==============================================================*/
create index ax_parent_element_FK on ax_meta_element
(
   parent_element
);
/*==============================================================*/
/* Index: "ax_meta_elem_parent_schema_FK"                                            */
/*==============================================================*/
create index ax_meta_elem_parent_schema_FK on ax_meta_element
(
   parent_schema
);

/*==============================================================*/
/* Table: ax_meta_element_set                                   */
/*==============================================================*/
create table ax_meta_element_set
(
   schema_name                    varchar(64)                    not null,
   element_id                     int                            not null,
   preferred_enc_scheme           int,
   comments                       longtext,
   obligation                     varchar(10)                    not null default 'o',
   default_value                  longtext,
   list_of_values                 longtext,
   display_order                  int                            not null default 999,
   enabled                        smallint                       not null default 1,
   primary key (schema_name, element_id)
)
comment = "This table represents a list of metadata elements which comprise the given schema. The elements might originate from other schemas, but all together they comprise a logical set for this schema. Each schema can also flag it's elements as either mandatory or not, and can define a default display (data entry) order.";

/*==============================================================*/
/* Index: "ax_meta_elem_set_elem_FK"                                            */
/*==============================================================*/
create index ax_meta_elem_set_elem_FK on ax_meta_element_set
(
   element_id
);
/*==============================================================*/
/* Index: "ax_meta_elem_set_schema_FK"                                            */
/*==============================================================*/
create index ax_meta_elem_set_schema_FK on ax_meta_element_set
(
   schema_name
);
/*==============================================================*/
/* Index: "ax_pref_enc_scheme_FK"                                            */
/*==============================================================*/
create index ax_pref_enc_scheme_FK on ax_meta_element_set
(
   preferred_enc_scheme
);

/*==============================================================*/
/* Table: ax_meta_schema                                        */
/*==============================================================*/
create table ax_meta_schema
(
   schema_name                    varchar(64)                    not null,
   description                    longtext,
   namespace                      longtext,
   namespace_uri                  longtext,
   primary key (schema_name)
)
comment = "A meta schema is simply an umbrella entity which describes a metadata element set. Examples would be 'Dublin Core', 'AGLS', or 'NZGLS'.";

/*==============================================================*/
/* Table: ax_microsite                                          */
/*==============================================================*/
create table ax_microsite
(
   microsite_name                 varchar(64)                    not null,
   menu_id                        int,
   microsite_desc                 longtext,
   microsite_domain               longtext,
   css                            longtext,
   css_ie                         longtext,
   css_ns                         longtext,
   req_microsite_publish          smallint                       not null default 0,
   req_microsite_remove           smallint                       not null default 0,
   currently_installed            smallint                       not null default 0,
   last_installed                 datetime,
   last_modified                  datetime                       not null default 'now()',
   primary key (microsite_name)
);

/*==============================================================*/
/* Index: "ax_microsite_menu_FK"                                            */
/*==============================================================*/
create index ax_microsite_menu_FK on ax_microsite
(
   menu_id
);

/*==============================================================*/
/* Table: ax_microsite_media                                    */
/*==============================================================*/
create table ax_microsite_media
(
   microsite_name                 varchar(64)                    not null,
   cat_id                         int                            not null,
   primary key (microsite_name, cat_id)
);

/*==============================================================*/
/* Index: "ax_microsite_media_page_FK"                                            */
/*==============================================================*/
create index ax_microsite_media_page_FK on ax_microsite_media
(
   microsite_name
);
/*==============================================================*/
/* Index: "ax_microsite_media_FK"                                            */
/*==============================================================*/
create index ax_microsite_media_FK on ax_microsite_media
(
   cat_id
);

/*==============================================================*/
/* Table: ax_microsite_page                                     */
/*==============================================================*/
create table ax_microsite_page
(
   microsite_page_id              int                            not null,
   microsite_name                 varchar(64)                    not null,
   page_id                        int,
   menuoption_id                  int,
   microsite_template_id          int,
   page_title                     longtext                       not null,
   corepage                       smallint                       not null default 0,
   microsite_homepage             smallint                       not null default 0,
   menuoption_label               longtext                       not null,
   display_order                  int                            not null default 0,
   cache_seconds                  int                            not null default 0,
   enabled                        smallint                       not null default 1,
   primary key (microsite_page_id)
);

/*==============================================================*/
/* Index: "ax_microsite_page_FK"                                            */
/*==============================================================*/
create index ax_microsite_page_FK on ax_microsite_page
(
   microsite_name
);
/*==============================================================*/
/* Index: "ax_microsite_sitepage_FK"                                            */
/*==============================================================*/
create index ax_microsite_sitepage_FK on ax_microsite_page
(
   page_id
);
/*==============================================================*/
/* Index: "microsite_page_menuoption_FK"                                            */
/*==============================================================*/
create index microsite_page_menuoption_FK on ax_microsite_page
(
   menuoption_id
);
/*==============================================================*/
/* Index: "ax_microsite_page_template_FK"                                            */
/*==============================================================*/
create index ax_microsite_page_template_FK on ax_microsite_page
(
   microsite_template_id
);

/*==============================================================*/
/* Table: ax_microsite_page_plugin                              */
/*==============================================================*/
create table ax_microsite_page_plugin
(
   plugin_id                      int                            not null,
   microsite_page_id              int                            not null,
   plugin_pattern                 longtext                       not null,
   plugin_content                 varchar(64)                    not null,
   primary key (plugin_id)
);

/*==============================================================*/
/* Index: "microsite_page_plugin_FK"                                            */
/*==============================================================*/
create index microsite_page_plugin_FK on ax_microsite_page_plugin
(
   microsite_page_id
);
/*==============================================================*/
/* Index: "plugin_area_FK"                                            */
/*==============================================================*/
create index plugin_area_FK on ax_microsite_page_plugin
(
   plugin_pattern
);
/*==============================================================*/
/* Index: "plugin_content_FK"                                            */
/*==============================================================*/
create index plugin_content_FK on ax_microsite_page_plugin
(
   plugin_content
);

/*==============================================================*/
/* Table: ax_microsite_story                                    */
/*==============================================================*/
create table ax_microsite_story
(
   microsite_name                 varchar(64)                    not null,
   story_id                       int                            not null,
   primary key (microsite_name, story_id)
);

/*==============================================================*/
/* Index: "story_microsite_FK"                                            */
/*==============================================================*/
create index story_microsite_FK on ax_microsite_story
(
   microsite_name
);
/*==============================================================*/
/* Index: "microsite_story_FK"                                            */
/*==============================================================*/
create index microsite_story_FK on ax_microsite_story
(
   story_id
);

/*==============================================================*/
/* Table: ax_microsite_template                                 */
/*==============================================================*/
create table ax_microsite_template
(
   microsite_template_id          int                            not null,
   microsite_name                 varchar(64)                    not null,
   template_name                  longtext                       not null,
   template_type                  longtext                       not null default 'html',
   template_content               longtext,
   primary key (microsite_template_id)
);

/*==============================================================*/
/* Index: "ax_microsite_template_FK"                                            */
/*==============================================================*/
create index ax_microsite_template_FK on ax_microsite_template
(
   microsite_name
);

/*==============================================================*/
/* Table: ax_organisation                                       */
/*==============================================================*/
create table ax_organisation
(
   org_id                         int                            not null,
   contactinfo_id                 int,
   org_name                       longtext                       not null,
   org_desc                       longtext,
   org_contact                    longtext,
   enabled                        smallint                       not null default 1,
   primary key (org_id)
);

/*==============================================================*/
/* Index: ax_org_contactinfo_FK                                 */
/*==============================================================*/
create index ax_org_contactinfo_FK on ax_organisation
(
   contactinfo_id
);

/*==============================================================*/
/* Table: ax_plugin_area                                        */
/*==============================================================*/
create table ax_plugin_area
(
   plugin_pattern                 longtext                       not null,
   plugin_desc                    longtext,
   primary key (plugin_pattern)
);

/*==============================================================*/
/* Table: ax_plugin_content                                     */
/*==============================================================*/
create table ax_plugin_content
(
   plugin_content                 varchar(64)                    not null,
   plugin_content_desc            longtext                       not null,
   generator                      longtext                       not null,
   generator_type                 TEXT                           not null default 'defer',
   replace_content                smallint                       not null default 0,
   primary key (plugin_content)
);

/*==============================================================*/
/* Table: ax_query_resource                                     */
/*==============================================================*/
create table ax_query_resource
(
   quid                           int                            not null,
   q_desc                         longtext,
   q_query                        longtext,
   q_script                       longtext,
   enabled                        smallint                       not null default 1,
   primary key (quid)
);

/*==============================================================*/
/* Table: ax_site_meta_element                                  */
/*==============================================================*/
create table ax_site_meta_element
(
   element_id                     int                            not null,
   schema_name                    varchar(64)                    not null,
   label                          longtext,
   description                    longtext,
   indexed                        smallint                       not null default 0,
   searchable                     smallint                       not null default 0,
   obligation                     varchar(10)                    not null default 'o',
   default_value                  longtext,
   list_of_values                 longtext,
   display_order                  int                            not null default 999,
   enabled                        smallint                       not null default 1,
   primary key (element_id, schema_name)
)
comment = "This table holds the list of metadata elements which are going to be used for the website. These can be assembled from any of the defined metadata elements.";

/*==============================================================*/
/* Index: "ax_site_meta_element_FK"                                            */
/*==============================================================*/
create index ax_site_meta_element_FK on ax_site_meta_element
(
   schema_name,
   element_id
);

/*==============================================================*/
/* Table: ax_sitepage                                           */
/*==============================================================*/
create table ax_sitepage
(
   page_id                        int                            not null,
   page_title                     longtext                       not null,
   page_path                      longtext                       not null,
   template_name                  longtext,
   managed                        smallint                       not null default 1,
   enabled                        smallint                       not null default 1,
   primary key (page_id)
);

/*==============================================================*/
/* Table: ax_sitepage_group                                     */
/*==============================================================*/
create table ax_sitepage_group
(
   group_id                       int                            not null,
   page_id                        int                            not null,
   primary key (group_id, page_id)
)
comment = "Indicates mandatory group membership for sitepage access.";

/*==============================================================*/
/* Index: "ax_sitepage_gp_group_FK"                                            */
/*==============================================================*/
create index ax_sitepage_gp_group_FK on ax_sitepage_group
(
   group_id
);
/*==============================================================*/
/* Index: "ax_sitepage_gp_page_FK"                                            */
/*==============================================================*/
create index ax_sitepage_gp_page_FK on ax_sitepage_group
(
   page_id
);

/*==============================================================*/
/* Table: ax_story                                              */
/*==============================================================*/
create table ax_story
(
   story_id                       int                            not null,
   lang_id                        int                            not null,
   category_id                    int,
   story_author                   varchar(64),
   story_icon                     int,
   story_icon_url                 longtext,
   story_headline                 longtext,
   story_precis                   longtext,
   story_content                  longtext,
   story_type                     longtext,
   story_url                      longtext,
   story_date                     datetime                       not null default 'now()',
   expiry_date                    datetime                       not null,
   last_modified                  datetime                       not null default 'now()',
   deleted                        smallint                       not null default 0,
   visible                        smallint                       not null default 1,
   primary key (story_id)
);

/*==============================================================*/
/* Index: "ax_story_language_FK"                                            */
/*==============================================================*/
create index ax_story_language_FK on ax_story
(
   lang_id
);
/*==============================================================*/
/* Index: "story_icon_FK"                                            */
/*==============================================================*/
create index story_icon_FK on ax_story
(
   story_icon
);
/*==============================================================*/
/* Index: "ax_story_category_FK"                                            */
/*==============================================================*/
create index ax_story_category_FK on ax_story
(
   category_id
);
/*==============================================================*/
/* Index: "ax_story_author_FK"                                            */
/*==============================================================*/
create index ax_story_author_FK on ax_story
(
   story_author
);

/*==============================================================*/
/* Table: ax_story_category                                     */
/*==============================================================*/
create table ax_story_category
(
   category_id                    int                            not null,
   category_desc                  longtext                       not null,
   has_media                      smallint                       not null default 0,
   has_precis                     smallint                       not null default 1,
   has_expiry                     smallint                       not null default 0,
   has_multilang                  smallint                       not null default 1,
   has_multimedia                 smallint                       not null default 0,
   primary key (category_id)
)
comment = "The story can be used to split stories into groups, or subject areas.";

/*==============================================================*/
/* Table: ax_story_category_locs                                */
/*==============================================================*/
create table ax_story_category_locs
(
   category_id                    int                            not null,
   location_id                    int                            not null,
   primary key (category_id, location_id)
)
comment = "The default content locations for a story category.";

/*==============================================================*/
/* Index: "ax_story_categ_loc_FK"                                            */
/*==============================================================*/
create index ax_story_categ_loc_FK on ax_story_category_locs
(
   category_id
);
/*==============================================================*/
/* Index: "ax_story_categ_loc_loc_FK"                                            */
/*==============================================================*/
create index ax_story_categ_loc_loc_FK on ax_story_category_locs
(
   location_id
);

/*==============================================================*/
/* Table: ax_story_location                                     */
/*==============================================================*/
create table ax_story_location
(
   story_id                       int                            not null,
   location_id                    int                            not null,
   display_order                  int                            not null default 0,
   primary key (story_id, location_id)
)
comment = "Contains lists of stories which should be displayed in a particular location on the website. Also determines the order that the stories should be displayed in.";

/*==============================================================*/
/* Index: "ax_story_location_FK"                                            */
/*==============================================================*/
create index ax_story_location_FK on ax_story_location
(
   story_id
);
/*==============================================================*/
/* Index: "ax_content_location_FK"                                            */
/*==============================================================*/
create index ax_content_location_FK on ax_story_location
(
   location_id
);

/*==============================================================*/
/* Table: ax_story_media                                        */
/*==============================================================*/
create table ax_story_media
(
   story_id                       int                            not null,
   cat_id                         int                            not null,
   caption                        longtext,
   width                          int                            not null default 0,
   height                         int                            not null default 0,
   justify                        varchar(10)                    not null default '',
   display_order                  int                            not null default 0,
   primary key (story_id, cat_id)
)
comment = "Media items associated with the story.";

/*==============================================================*/
/* Index: "ax_story_media_story_FK"                                            */
/*==============================================================*/
create index ax_story_media_story_FK on ax_story_media
(
   story_id
);
/*==============================================================*/
/* Index: "ax_story_media_cat_id_FK"                                            */
/*==============================================================*/
create index ax_story_media_cat_id_FK on ax_story_media
(
   cat_id
);

/*==============================================================*/
/* Table: ax_story_translation                                  */
/*==============================================================*/
create table ax_story_translation
(
   story_id                       int                            not null,
   translated_story_id            int                            not null,
   primary key (story_id, translated_story_id)
)
comment = "Used to link translations of the same story together.";

/*==============================================================*/
/* Index: "ax_original_story_FK"                                            */
/*==============================================================*/
create index ax_original_story_FK on ax_story_translation
(
   story_id
);
/*==============================================================*/
/* Index: "ax_translated_story_FK"                                            */
/*==============================================================*/
create index ax_translated_story_FK on ax_story_translation
(
   translated_story_id
);

/*==============================================================*/
/* Table: ax_user                                               */
/*==============================================================*/
create table ax_user
(
   user_id                        varchar(64)                    not null,
   org_id                         int                            not null default 0,
   password                       longtext,
   full_name                      longtext,
   honorific_prefix               longtext,
   first_name                     longtext,
   mid_names                      longtext,
   last_name                      longtext,
   user_type                      varchar(10)                    not null default 'user',
   email                          longtext,
   address                        longtext,
   phone                          longtext,
   fax                            longtext,
   mobile                         longtext,
   last_login                     datetime,
   total_logins                   int                            not null default 0,
   limit_logins                   int                            not null default 0,
   auth_code                      longtext,
   passwd_forever                 smallint                       not null default 0,
   passwd_expiry                  datetime                       not null,
   passwd_history                 longtext,
   passwd_failures                int                            not null default 0,
   locked                         smallint                       not null default 0,
   enabled                        smallint                       not null default 1,
   primary key (user_id)
);

/*==============================================================*/
/* Index: ax_user_org_FK                                        */
/*==============================================================*/
create index ax_user_org_FK on ax_user
(
   org_id
);

/*==============================================================*/
/* Table: ax_user_group                                         */
/*==============================================================*/
create table ax_user_group
(
   group_id                       int                            not null,
   user_id                        varchar(64)                    not null,
   primary key (group_id, user_id)
);

/*==============================================================*/
/* Index: ax_user_group_FK                                      */
/*==============================================================*/
create index ax_user_group_FK on ax_user_group
(
   group_id
);

/*==============================================================*/
/* Index: ax_user_group_FK2                                     */
/*==============================================================*/
create index ax_user_group_FK2 on ax_user_group
(
   user_id
);

/*==============================================================*/
/* Table: ax_user_ip                                            */
/*==============================================================*/
create table ax_user_ip
(
   user_id                        varchar(64)                    not null,
   ip                             varchar(32)                    not null,
   primary key (user_id, ip)
);

/*==============================================================*/
/* Index: ax_user_ip_user_FK                                    */
/*==============================================================*/
create index ax_user_ip_user_FK on ax_user_ip
(
   user_id
);

/*==============================================================*/
/* Table: ax_wwwsession                                         */
/*==============================================================*/
create table ax_wwwsession
(
   session_id                     varchar(64)                    not null,
   user_id                        varchar(64)                    not null,
   menuoption_id                  int,
   lang_id                        int                            not null default 0,
   menu_status                    longtext,
   user_groups                    longtext,
   login_type                     int                            not null default 0,
   login_datetime                 datetime                       not null default 'now()',
   primary key (session_id)
);

/*==============================================================*/
/* Index: "session_menuoption_FK"                                            */
/*==============================================================*/
create index session_menuoption_FK on ax_wwwsession
(
   menuoption_id
);
/*==============================================================*/
/* Index: "ax_session_language_FK"                                            */
/*==============================================================*/
create index ax_session_language_FK on ax_wwwsession
(
   lang_id
);

/*==============================================================*/
/* Index: ax_wwwsession_user_FK                                 */
/*==============================================================*/
create index ax_wwwsession_user_FK on ax_wwwsession
(
   user_id
);

alter table ax_block add constraint FK_ax_block_bg_image foreign key (background_img)
      references ax_catalog (cat_id) on delete set null on update restrict;

alter table ax_block add constraint fk_ax_block_language foreign key (lang_id)
      references ax_language (lang_id) on delete restrict on update restrict;

alter table ax_block add constraint ax_block_layout foreign key (layout_id)
      references ax_layout (layout_id) on delete cascade on update restrict;

alter table ax_block_blocklet add constraint ax_block_blocklet_block foreign key (block_id)
      references ax_block (block_id) on delete cascade on update restrict;

alter table ax_block_blocklet add constraint ax_block_blocklet_blocklet foreign key (blocklet_id)
      references ax_blocklet (blocklet_id) on delete cascade on update restrict;

alter table ax_configuration add constraint ax_configuration_config foreign key (config_name)
      references ax_config (config_name) on delete cascade on update restrict;

alter table ax_element_set_enc add constraint fk_ax_elemset_enc_enc foreign key (enc_scheme_id)
      references ax_enc_scheme (enc_scheme_id) on delete cascade on update restrict;

alter table ax_element_set_enc add constraint fk_ax_elemset_enc_set foreign key (schema_name, element_id)
      references ax_meta_element_set (schema_name, element_id) on delete cascade on update restrict;

alter table ax_enc_qualifier add constraint fk_ax_enc_qual_scheme foreign key (enc_scheme_id)
      references ax_enc_scheme (enc_scheme_id) on delete restrict on update restrict;

alter table ax_enc_value add constraint fk_ax_enc_schema_value foreign key (enc_scheme_id)
      references ax_enc_scheme (enc_scheme_id) on delete restrict on update restrict;

alter table ax_forum add constraint FK_AX_FORUM_MODERATOR foreign key (moderator)
      references ax_user (user_id) on delete restrict on update restrict;

alter table ax_forum_member add constraint ax_forum_mbr_forum foreign key (forum_id)
      references ax_forum (forum_id) on delete cascade on update restrict;

alter table ax_forum_member add constraint ax_forum_mbr_user foreign key (user_id)
      references ax_user (user_id) on delete cascade on update restrict;

alter table ax_forum_msg add constraint ax_forum_msg_forum foreign key (forum_id)
      references ax_forum (forum_id) on delete cascade on update restrict;

alter table ax_forum_msg add constraint FK_parent_thread foreign key (parent_thread_id)
      references ax_forum_msg (msg_id) on delete cascade on update cascade;

alter table ax_layout add constraint fk_ax_layout_language foreign key (lang_id)
      references ax_language (lang_id) on delete restrict on update restrict;

alter table ax_layout add constraint ax_layout_set_layout foreign key (layout_name)
      references ax_layout_set (layout_name) on delete cascade on update restrict;

alter table ax_layout_metadata add constraint fk_ax_lay_metadata_elem foreign key (element_id, schema_name)
      references ax_site_meta_element (element_id, schema_name) on delete restrict on update restrict;

alter table ax_layout_metadata add constraint fk_ax_lay_metadata_scheme foreign key (enc_scheme_id)
      references ax_enc_scheme (enc_scheme_id) on delete set null on update restrict;

alter table ax_layout_metadata add constraint fk_ax_layout_meta_data foreign key (layout_id)
      references ax_layout (layout_id) on delete cascade;

alter table ax_layout_set add constraint ax_layout_set_sitepage foreign key (page_id)
      references ax_sitepage (page_id) on delete set null on update restrict;

alter table ax_layout_set_group add constraint fk_group_layout_set foreign key (layout_name)
      references ax_layout_set (layout_name) on delete cascade on update restrict;

alter table ax_layout_set_group add constraint fk_layout_set_group foreign key (group_id)
      references ax_group (group_id) on delete cascade on update restrict;

alter table ax_menu add constraint fk_ax_menu_language foreign key (lang_id)
      references ax_language (lang_id) on delete restrict on update restrict;

alter table ax_menuoption add constraint fk_ax_menuoption_menu foreign key (menu_id)
      references ax_menu (menu_id) on delete cascade on update restrict;

alter table ax_meta_element add constraint fk_ax_meta_elem_parent_schema foreign key (parent_schema)
      references ax_meta_schema (schema_name) on delete restrict on update restrict;

alter table ax_meta_element add constraint fk_ax_parent_element foreign key (parent_element)
      references ax_meta_element (element_id) on delete cascade on update restrict;

alter table ax_meta_element_set add constraint fk_ax_meta_elem_set_elem foreign key (element_id)
      references ax_meta_element (element_id) on delete cascade on update restrict;

alter table ax_meta_element_set add constraint fk_ax_meta_elem_set_schema foreign key (schema_name)
      references ax_meta_schema (schema_name) on delete cascade on update restrict;

alter table ax_meta_element_set add constraint fk_ax_pref_enc_scheme foreign key (preferred_enc_scheme)
      references ax_enc_scheme (enc_scheme_id) on delete restrict on update restrict;

alter table ax_microsite add constraint fk_ax_microsite_menu foreign key (menu_id)
      references ax_menu (menu_id) on delete set null on update restrict;

alter table ax_microsite_media add constraint fk_ax_microsite_media foreign key (cat_id)
      references ax_catalog (cat_id) on delete cascade on update restrict;

alter table ax_microsite_media add constraint fk_ax_microsite_media_page foreign key (microsite_name)
      references ax_microsite (microsite_name) on delete restrict on update restrict;

alter table ax_microsite_page add constraint fk_ax_microsite_page foreign key (microsite_name)
      references ax_microsite (microsite_name) on delete restrict on update restrict;

alter table ax_microsite_page add constraint fk_ax_microsite_page_template foreign key (microsite_template_id)
      references ax_microsite_template (microsite_template_id) on delete set null on update restrict;

alter table ax_microsite_page add constraint fk_ax_microsite_sitepage foreign key (page_id)
      references ax_sitepage (page_id) on delete set null on update restrict;

alter table ax_microsite_page add constraint fk_microsite_page_menuoption foreign key (menuoption_id)
      references ax_menuoption (menuoption_id) on delete set null on update restrict;

alter table ax_microsite_page_plugin add constraint fk_microsite_page_plugin foreign key (microsite_page_id)
      references ax_microsite_page (microsite_page_id) on delete cascade on update restrict;

alter table ax_microsite_page_plugin add constraint fk_plugin_area foreign key (plugin_pattern)
      references ax_plugin_area (plugin_pattern) on delete cascade on update restrict;

alter table ax_microsite_page_plugin add constraint fk_plugin_content foreign key (plugin_content)
      references ax_plugin_content (plugin_content) on delete cascade on update restrict;

alter table ax_microsite_story add constraint fk_microsite_story foreign key (story_id)
      references ax_story (story_id) on delete cascade on update restrict;

alter table ax_microsite_story add constraint fk_story_microsite foreign key (microsite_name)
      references ax_microsite (microsite_name) on delete cascade on update restrict;

alter table ax_microsite_template add constraint fk_ax_microsite_template foreign key (microsite_name)
      references ax_microsite (microsite_name) on delete restrict on update restrict;

alter table ax_organisation add constraint ax_org_contactinfo foreign key (contactinfo_id)
      references ax_contactinfo (contactinfo_id) on delete restrict on update restrict;

alter table ax_site_meta_element add constraint fk_ax_site_meta_element foreign key (schema_name, element_id)
      references ax_meta_element_set (schema_name, element_id) on delete restrict on update restrict;

alter table ax_sitepage_group add constraint fk_ax_sitepage_gp_group foreign key (group_id)
      references ax_group (group_id) on delete cascade on update restrict;

alter table ax_sitepage_group add constraint fk_ax_sitepage_gp_page foreign key (page_id)
      references ax_sitepage (page_id) on delete cascade on update restrict;

alter table ax_story add constraint fk_ax_story_author foreign key (story_author)
      references ax_user (user_id) on delete set null on update restrict;

alter table ax_story add constraint fk_ax_story_category foreign key (category_id)
      references ax_story_category (category_id) on delete restrict on update restrict;

alter table ax_story add constraint fk_ax_story_language foreign key (lang_id)
      references ax_language (lang_id) on delete restrict on update restrict;

alter table ax_story add constraint fk_story_icon foreign key (story_icon)
      references ax_catalog (cat_id) on delete set null on update restrict;

alter table ax_story_category_locs add constraint fk_ax_story_categ_loc foreign key (category_id)
      references ax_story_category (category_id) on delete restrict on update restrict;

alter table ax_story_category_locs add constraint fk_ax_story_categ_loc_loc foreign key (location_id)
      references ax_content_location (location_id) on delete restrict on update restrict;

alter table ax_story_location add constraint fk_ax_content_location foreign key (location_id)
      references ax_content_location (location_id) on delete cascade on update restrict;

alter table ax_story_location add constraint fk_ax_story_location foreign key (story_id)
      references ax_story (story_id) on delete cascade on update restrict;

alter table ax_story_media add constraint fk_ax_story_media_cat_id foreign key (cat_id)
      references ax_catalog (cat_id) on delete cascade on update restrict;

alter table ax_story_media add constraint fk_ax_story_media_story foreign key (story_id)
      references ax_story (story_id) on delete cascade on update restrict;

alter table ax_story_translation add constraint fk_ax_original_story foreign key (story_id)
      references ax_story (story_id) on delete cascade on update restrict;

alter table ax_story_translation add constraint fk_ax_translated_story foreign key (translated_story_id)
      references ax_story (story_id) on delete cascade on update restrict;

alter table ax_user add constraint ax_user_organisation foreign key (org_id)
      references ax_organisation (org_id) on delete restrict on update restrict;

alter table ax_user_group add constraint ax_user_group_group foreign key (group_id)
      references ax_group (group_id) on delete cascade on update restrict;

alter table ax_user_group add constraint ax_user_group_user foreign key (user_id)
      references ax_user (user_id) on delete cascade on update restrict;

alter table ax_user_ip add constraint ax_user_ip_user foreign key (user_id)
      references ax_user (user_id) on delete cascade on update restrict;

alter table ax_wwwsession add constraint fk_ax_session_language foreign key (lang_id)
      references ax_language (lang_id) on delete restrict on update restrict;

alter table ax_wwwsession add constraint ax_wwwsession_user foreign key (user_id)
      references ax_user (user_id) on delete cascade on update restrict;

alter table ax_wwwsession add constraint FK_session_menuoption foreign key (menuoption_id)
      references ax_menuoption (menuoption_id) on delete set null on update set null;

