#
# 	Construction et gestion de la fenetre d'edition texte
# 	(c) 1995-7 Alexandre Burton & Jean Piche
# 	v. 1.80a (10/08/97)
#

proc toggleWin2 {target} {
	global path panelist toggleState
    	set which [string range [lindex [split $target .] 3] 0 end]
    	if {$toggleState($which) == 0} {
		if {[llength $panelist] == 1} {
		    	set toggleState($which) 1
		    	return
		} else {			
			deletePane .edit.panel.hand$which
		}	
    	} else {
		lappend panelist $which
		Placer
    	}	
}

proc cyclePanel {} {
	global panelist path tags
    	foreach p $panelist { if {[lsearch $tags $p] != "-1"} { lappend oklist $p } }
    	if [info exists oklist] {
    		set f [lindex [split [focus -lastfor .edit.panel] .] 3]
    		set g [lindex $oklist [expr ([lsearch $oklist $f] +1) % [llength $oklist]]]
 		focus $path(edit).panel.$g.t
 	}
}

proc dumpEditWindow { } {
    	global tags path
    	set stuff ""
    	foreach pane $tags {
		append stuff "<$pane>\n"
		append stuff "[$path(panel).$pane.t get 1.0 end]"
		append stuff "</$pane>\n"
    	}
    	return [string trim $stuff]
}

proc buildTaber {} {
    global path _tab
    $path(edit).rule delete all
    $path(edit).rule create rect 100 2 200 6 -fill blue -tags bloc
    set g [$path(edit).rule create rect 100 2 103 6 -fill white -tags gauche]
    set d [$path(edit).rule create rect 197 2 200 6 -fill white -tags droite]

    foreach i {gauche droite} {
	$path(edit).rule bind $i <Any-Enter> "hiliteTab $i black"
	$path(edit).rule bind $i <Any-Leave> "hiliteTab $i white"
	$path(edit).rule bind $i <Button-1>  "grabTab $i %x"
	$path(edit).rule bind $i <B1-Motion> "moveTab $i %x"
		$path(edit).rule bind $i <ButtonRelease-1>  "okTab"

    }
    $path(edit).rule bind bloc <ButtonRelease-1>  "okTab"
    $path(edit).rule bind bloc <Button-1> "grabTab bloc %x"
    $path(edit).rule bind bloc <B1-Motion> "moveTab bloc %x"
    
    set _tab(g) 100
    set _tab(d) 200

    okTab
}

proc grabTab {i x} {
    global _tab
    set _tab(x) $x

}
proc okTab {} {
    global _tab path prefs
    foreach p {mono stereo quad} {
	$path(panel).$p.t config -tabs "$_tab(g) $_tab(d) $prefs(tabs)"
    }
}

proc moveTab {i x} {
    global _tab path
    set dx [expr $x-$_tab(x)]
    $path(edit).rule move $i $dx 0
    set _tab(x) $x
    set that [$path(edit).rule coords bloc]
	
    switch $i {
	droite {
	    set this [lindex [$path(edit).rule coords $i] 2]
	    set _tab(d) $this
	    eval $path(edit).rule coords bloc [lreplace [concat $that] 2 2 $this]
	}
	gauche {
	    set this [lindex [$path(edit).rule coords $i] 0]
	    set _tab(g) $this
	    eval $path(edit).rule coords bloc [lreplace $that 0 0 $this]
	}
	bloc {
	    set _tab(d) [expr $_tab(d) +$dx]
	    set _tab(g) [expr $_tab(g) +$dx]
	    $path(edit).rule move gauche $dx 0
	    $path(edit).rule move droite $dx 0
	}
    }
    okTab
}

proc hiliteTab {i c} {
    global path
    $path(edit).rule itemconfig $i -fill $c
}

proc makeEditWindow {} {

	modebug "building editwindow:" ""

	global path tags  outtags color  cfont  prefs id cs  panelist _db
    set tags {info tk_interface mono stereo quad score}
    set outtags {orcOut scoreOut csoundOut}

    set path(editmenu) $path(edit)
    toplevel $path(edit) 
    wm withdraw $path(edit)
    wm title $path(edit) "Module Editor"
    wm iconname $path(edit) "Editor"
    wm protocol $path(edit) WM_DELETE_WINDOW {doCloseCheck;showEditWindow 0}  
    wm geometry .edit 700x500

    makeEditWindowMenu 


    set path(panel) $path(edit).panel
    pack [frame .edit.top -relief raised -bd 2 -bg gray90] -fill x
    pack [canvas .edit.rule -height 8] -fill x
    

    maketwinFrame $path(panel)

	modebug "building editwindow:" "menu (sections)"
    $path(edit).menu.section add separator
    $path(edit).menu.section add command -label "Save As Default" -command "doPanePrefs"
    $path(edit).menu.section add separator
    $path(edit).menu.section add command -label "Show All Panels" -command "showAll"
    $path(edit).menu.section add command -accelerator $_db(mod,a)-P -label "Hide Other Panels" -command "hideAll"
    $path(edit).menu.section add command -accelerator $_db(mod,a)-W -label "Hide Current Panel" -command "hideCurrent"
    $path(edit).menu.section add command -accelerator $_db(mod,a)-D -label "Cycle Panel Focus" -command "cyclePanel"
    $path(edit).menu.section add separator
    $path(edit).menu.section add check -label "Colorize On Parse" -variable prefs(colorize)

	frame $path(panel).mire -bg red
    bind $path(panel)     <Configure> {reconf}
        
    openPanes

#    wm withdraw $path(edit)
    
    frame $path(edit).help -relief groove -bd 2
    pack [label $path(editHelp)  -justify left -anchor w] -fill x -anchor w
    bindHelp $path(editHelp) LWinHelp
    
    if $prefs(assist) { pack $path(edit).help -side bottom -anchor sw -fill x}
    buildTaber
    
    bindedit
	modebug "building editwindow:" "...done"
    
}


proc reInit {} {
	global module env
	doCloseCheck
    	parseModule $module(path) 
}

proc makeEditWindowMenu {} {
    global path  lan tcl_platform _db prefs

    modebug "building editwindow:" "menu (bar)"
    set m [menu $path(edit).menu -tearoff 0 ]
    $m add cascade -menu [menu $m.file -tearoff 0] -label File
    $m add cascade -menu [menu $m.edit -tearoff 0] -label Edit 
    $m add cascade -menu .menubar.option -label Csound
    $m add cascade -menu [menu $m.font -tearoff 0] -label Font 
    $m add cascade -menu [menu $m.section -tearoff 0] -label Sections
    $m add cascade -menu $m.insert -label Manual
    $m add cascade -menu .menubar.wind -label Windows
    $m add cascade -menu [menu $m.help -tearoff 0] -label $lan(nom14a) 

    modebug "building editwindow:" "menu (file)"
    $m.file add cascade -label "New ..." -menu .menubar.file.c
    $m.file add separator 
    $m.file add command -label "Open..." -accelerator $_db(mod,a)-O -command openModule
    $m.file add command -label "Save Module" -accelerator $_db(mod,a)-S -command saveModule
    $m.file add command -label "Save Module as..." -command saveAsModule
    $m.file add separator 
    $m.file add command -label "Export as .orc/.sco ..." -command exportCsound
    $m.file add separator
    $m.file add command -label "Import score file..." -command {openScore}
    $m.file add command -label "Export score file as..." -command {saveScore}
    $m.file add separator
    $m.file add command -label "Import MidiFile score...       " -command {openMidi}
    $m.file add separator 
    $m.file add check -variable cs(preorc) -label "Use precompiled orchestra" 
    $m.file add check -variable cs(presco) -label "Use precompiled score" 
    $m.file add separator 
    $m.file add command  -accelerator $_db(mod,a)-I -label "Reinit Module"  -command "catch {reInit}"
    $m.file add separator 
    $m.file add command  -label "Preferences..."  -command preferences
    $m.file add separator 
    $m.file add command  -label Close  -accelerator $_db(mod,a)-Q -command "wm withdraw .edit" 
   
    modebug "building editwindow:" "menu (edit)"
    $m.edit add command -accelerator $_db(mod,a)-Z  -label $lan(nom27)  -command "catch { chooseText}"
    $m.edit add separator 
    $m.edit add command -accelerator $_db(mod,a)-X -label "Cut Text"  -command Tcut
    $m.edit add command -accelerator $_db(mod,a)-C -label "Copy Text" -command Tcopie
    $m.edit add command -accelerator $_db(mod,a)-V -label "Paste Text" -command Tpaste
    $m.edit add separator 
    $m.edit add command -accelerator $_db(mod,a)-A -label "Select All   " -command "catch {doSelectAll}"
    $m.edit add command -accelerator "$_db(mod,a)-;" -label $lan(nom24c)  -command "catch { doComments}"
    $m.edit add separator 
    $m.edit add command -accelerator $_db(mod,a)-G -label "Go to line..."  -command "catch {goTo}"
    $m.edit add command -accelerator $_db(mod,a)-F -label $lan(nom28bb)  -command "catch {selSearch f}"
    $m.edit add command -accelerator $_db(mod,a)-B -label $lan(nom28bc)  -command "catch {selSearch b}"
    $m.edit add command -accelerator $_db(mod,a)-R -label $lan(nom28c)  -command "catch { getReplaceName}"
    $m.edit add separator
    $m.edit add command -accelerator $_db(mod,a)-= -label "Higher Power of 2" -command "power u"
    $m.edit add command -accelerator $_db(mod,a)-- -label "Lower Power of 2" -command "power d"
    $m.edit add separator
    $m.edit add command -accelerator $_db(mod,a)-L -label "Colorize Syntax" -command colorit

    $m.edit add command -label "De-colorize Syntax" -command {
		foreach p {tk_interface mono stereo quad score} {clearcolor $path(panel).$p.t}
    }

    $m.edit add command -accelerator $_db(mod,a)-T -label "Tabulate Score" -command prettyprint
    $m.edit add separator 
    $m.edit add command -accelerator Help -label "Help with selected opcode"  -command "catch {helpOpcode}"

    modebug "building editwindow:" "menu (font)"
    $m.font add cascade -label "Tab Space"  -menu $m.font.tabs 
    $m.font add separator 
    $m.font add cascade -label "Font"  -menu $m.font.font
    $m.font add cascade -label "Size"  -menu $m.font.size
    $m.font add cascade -label "Style"  -menu $m.font.style

    menu $m.font.font  -tearoff 0 
    menu $m.font.size  -tearoff 0 
    menu $m.font.style -tearoff 0 
    menu $m.font.tabs  -tearoff 0 
    
    if ![file exists $prefs(font,path)] {
    	bug checking for fonts    
	switch -- $tcl_platform(os) {
	    "MacOS" { 
		set okfont {Times Chicago Helvetica Geneva} 
		foreach f [font families] { 
		    modebug "building editwindow:" "menu (font) trying <$f>"
		    if [font metrics \"$f\" -fixed] {lappend okfont $f}  
		}
	    }
	    "IRIX"      { 
		set okfont ""    
		foreach f [font families] {
		    set ff [font metrics \{$f\}]
		    if {[lindex $ff 1] > 0 && [lindex $ff 3] >0 && [lindex $ff 5] <21} {lappend okfont $f}
		    
		}
		set okfont [font families]
	    }
	    "Linux" {
		set okfont [font families]
	    }
	    default     { 
		set okfont {}
		foreach f [font families] { if [font metrics \"$f\" -fixed] {lappend okfont $f}   }	
	    }
	}
	
	set okfont [lsort $okfont]
	set f [open $prefs(font,path) w+] 
	puts $f $okfont
	close $f
	
	bug ------...fonts analysed
	
    } {
    	bug using font file
    	set f [open $prefs(font,path) r]
    	set okfont [read $f]
    	close $f
    	bug stuff
    }
    
    foreach tabspa {0.5c 1.0c 1.5c 2.0c 2.5c 3.0c 3.5c} {
	$m.font.tabs add radio  -label $tabspa -variable prefs(tabs)  -command "doTabs" 
    }	
    
    foreach fontt $okfont {
	$m.font.font add radio -label $fontt -variable prefs(font) -command "doFont" 
    }	
    
    if {$tcl_platform(platform) == "unix"} {
	foreach si {9 10 11 12 14 15 16 17 18 20 24} {
	    $m.font.size add radio -label $si -variable prefs(size) -command "doFont" 
	}
    } else {   	
	foreach si {9 10 12 14 16 18 24} {
	    $m.font.size add radio -label $si -variable prefs(size) -command "doFont" 
	}   
    }	
    
    foreach sty {bold normal} {
	$m.font.style add radio -label $sty -variable prefs(style) -command "doFont" 
    }   
    
    
    if {$tcl_platform(os) != "MacOS"} {
	modebug "building editwindow:" "menu (manual)"
	makeManuel $m
    }
    
    modebug "building editwindow:" "menu (help)"
    
    $m.help add command  -label "Cecilia Basics"  -state disabled	
    $m.help add command  -label "   Help Index"  -command "Helpme [file join html index.$_db(html)]" 	
    $m.help add command  -label "   Jumpstart"  -command "Helpme  [file join html jump.$_db(html)]" 	
    $m.help add command  -label "   Concepts"  -command "Helpme  [file join html main.$_db(html)]" 		
    $m.help add command  -label "   Text Editor" -command "Helpme  [file join html editor.$_db(html)]"
    $m.help add separator
    $m.help add command -label "The interface Syntax" -state disabled
    $m.help add command -label "   Sliders" -command "Helpme  [file join html cec_rsli.$_db(html)]"
    #	$m.help add command -label "   MidiSliders" -command "Helpme  [file join html midi.$_db(html)]"
    $m.help add command -label "   Graphs" -command "Helpme  [file join html cec_grap.$_db(html)]"
    $m.help add command -label "   Toggles" -command "Helpme  [file join html cec_togg.$_db(html)]"
    $m.help add command -label "   Popups" -command "Helpme  [file join html cec_popu.$_db(html)]"
    $m.help add command -label "   Fileins" -command "Helpme  [file join html cec_file.$_db(html)]"
    $m.help add command -label "   Separators" -command "Helpme  [file join html cec_sepa.$_db(html)]"
    $m.help add separator
    $m.help add command -label "What's Going On?" -state disabled
    $m.help add command -label "   Variable Substitution" -command "Helpme [file join html substitu.$_db(html)]"
    $m.help add command -label "   The Score" -command "Helpme [file join html score.$_db(html)]"
    $m.help add command -label "   The Cybil Language" -command "Helpme [file join html cybil.$_db(html)]"
    $m.help add separator
    $m.help add check -label "Assistance" -variable prefs(assist) -command toggleAssist
    $m.help add command  -label "About Cecilia..."  -command getAbout
   
    $path(edit) config -menu $m
    bind $path(edit).menu <Enter> windowsMenu
    bind $path(edit) <Leave> windowsMenu
 
 }

proc hideCurrent {} {
	global toggleState 
    set f [lindex [split [focus -lastfor .edit.panel] .] 3]
    if $toggleState($f) {
    	.edit.menu.section  invoke [.edit.menu.section index $f]
    	update
    	cyclePanel
    }
}

proc hideAll {} {
    global path toggleState
    set f [lindex [split [focus -lastfor .edit.panel] .] 3]
    set a 0
    foreach pane {info tk_interface mono stereo quad score  orcOut scoreOut csoundOut} {
    	if {$pane != $f} {
			if $toggleState($pane) {$path(edit).menu.section invoke $a}
		}
		incr a
    }
}

proc showAll {} {
    global path toggleState
    set a 0
    foreach pane {info tk_interface mono stereo quad score  orcOut scoreOut csoundOut} {
    	if !$toggleState($pane) {$path(edit).menu.section invoke $a}		
    	incr a
    }
}


proc clearOutPanes { } {
    global path outtags
    foreach pane $outtags {
	$path(panel).$pane.t config -state normal
	$path(panel).$pane.t delete 0.0 end
	$path(panel).$pane.t config -state disabled
    }
}

proc mcopie {} {
    global mclip
    set f [focus -lastfor .edit.panel]
    if {[$f tag ranges sel] == ""}  {return}
    set mclip [$f get sel.first sel.last]
}

proc mpaste {} {
	bug mpasting
   global mclip 
    set f [focus -lastfor .edit.panel]
    if {[$f tag ranges sel] == ""} {
    $f insert insert $mclip
    } else {
	$f delete sel.first sel.last
	$f insert insert $mclip
   }
}

proc mcut {} {
    global mclip 
    set f [focus -lastfor .edit.panel]
    if {[$f tag ranges sel] == ""} {return}
    set clip [$f get sel.first sel.last]
    $f delete sel.first sel.last
}

##########################################
#########CHOISI LE TEXTE CIBLE POUR UNDO 
proc chooseText {} {
	global id path
	textUndoer__undo $id([lindex [split  [focus -lastfor .edit.panel] .] 3])
}

##########################################
#########SELECT ALL DANS TEXTE COURRANT 
proc doSelectAll {} { 
    set f [focus -lastfor .edit.panel]
    $f tag add sel 1.0 end
}

##########################################
#########COPIE SELECTION
proc Tcopie {} {
    global clip 
    set f [focus -lastfor .edit.panel]
    if {[$f tag ranges sel] == ""} {return}
    set clip [$f get sel.first sel.last]
}

##########################################
#########COUPE SELECTION
proc Tcut {} {
    global clip
    set f [focus -lastfor .edit.panel]
    if {[$f tag ranges sel] == ""} {return}
    set clip [$f get sel.first sel.last]
    $f delete sel.first sel.last
}
##########################################
#########PASTE SELECTION AU CURSEUR
proc Tpaste {} {
#	debug Tpasting
   global clip 
    set f [focus -lastfor .edit.panel]
    catch {$f delete sel.first sel.last}
    catch {$f insert insert $clip}
}

##########################################
#########EFFACER SELECTION
proc clear {} {
    set f [focus -lastfor .edit.panel]
    $f delete sel.first sel.last
}  
	
##########################################
#########AFFICHE FENETRE POUR NOM DE RECHERCHE 
proc getSearchName {dir} {
 	global  color  lan find repl start end  find tsch
	if {$dir == "f"} {
	    set name "$lan(nom28b) $lan(nom28g)"
	} else {
	    set name "$lan(nom28b) $lan(nom28h)"    
	}
	set tsch [toplevel .$lan(nom28a)  -bd 0 ]
	wm geometry $tsch +200+200
	frame  $tsch.buttons   -relief ridge -bd 3
	frame  $tsch.buttons.ok -bd 1 -relief sunken 
	set labf [label $tsch.findl -text "$name:" ]
	set find [entry  $tsch.find -width 50 -relief  sunken -textvariable txtofind ]
	set wo [button $tsch.buttons.ok.b -text OK  \
		-command "doSearch $dir"]
	pack $labf -side top -anchor w -padx 5 -pady 4
	pack $find -side top -fill x -padx 5 -pady 4
	pack    $tsch.buttons $tsch.buttons.ok $wo  -side right -padx 4 -pady 4
	bind $tsch <Return> "$wo invoke"
	focus $find	
	grab set $tsch
} 
  
##########################################
#########EFFECTUE RECHERCHE AVANT ET ARRIERE par FENETRE
proc doSearch {dir} {
    global find scible tsch 
     set f [focus -lastfor .edit.panel]
     catch {$f tag remove sel sel.first sel.last}
     set schtick [$find get]
     if {$schtick == ""} {
		catch {destroy $tsch}
		return
		}
    catch {$f search -$dir  -- $schtick insert} ind1
    if {$ind1 == ""} {
		set scible $schtick
		grab release $tsch
		catch {destroy $tsch}
		return
		}
	catch {$f mark set insert $ind1}
    	$f tag add sel $ind1 "$ind1+[string length $schtick] chars"
	set scible $schtick
	grab release $tsch
	catch {destroy $tsch}
}

##########################################
#########EFFECTUE RECHERCHE AVANT ET ARRIERE par key
proc selSearch {dir} {  
    set f [focus -lastfor .edit.panel]
    if {[$f tag ranges sel] == ""} {
	getSearchName $dir
	if {[$f tag ranges sel] == ""} {
	    return
	    }
	}
	set first [string trimleft [file extension [$f index sel.first] ] . ]
	set last [string trimleft [file extension [$f index sel.last] ] . ]
	set many  [expr $last - $first ]
	if {$dir == "f"} {	
	set boo [$f search -forward  [$f get sel.first sel.last] [$f index "sel.last"] ]
	} else {
	set boo [$f search -backwards  [$f get sel.first sel.last] [$f index "sel.first"] ]
	}
	$f tag remove sel sel.first sel.last
	catch {$f mark set insert $boo}
	catch {$f tag add sel $boo "$boo + $many chars"}  
	$f see sel.last
}

##########################################
#########AFFICHE FENETRE DE REMPLACEMENT
proc getReplaceName {} {
 	global  color  lan rfind rep start end  find trch wo
	set trch [toplevel .$lan(nom28a)  -bd 0 ]
	wm geometry $trch +200+200
	frame  $trch.buttons   -relief ridge -bd 3
	frame  $trch.buttons.ok -bd 1 -relief sunken 
	set labf [label $trch.findl -text $lan(nom28b):  ]
	set rfind [entry  $trch.find -width 50 -relief  sunken -textvariable txtofind ]
	set labr [label $trch.repl -text $lan(nom28c):  ]
	set rep [entry  $trch.rep -width 50 -relief  sunken -textvariable txtorep ]
	set wo [button $trch.buttons.ok.b -text OK   \
		-command doReplaceAll]
	set wa [button $trch.buttons.can -text $lan(nom70)  \
		-command "destroy $trch"]

	pack $labf -side top -anchor w -padx 5 -pady 4
	pack $rfind -side top -fill x -padx 5 -pady 4
	pack $labr -side top -anchor w -padx 5 -pady 4
	pack $rep -side top -fill x -padx 5 -pady 4
	pack    $trch.buttons $trch.buttons.ok $wa $wo  -side right -padx 4 -pady 4
	bind $trch <Return> {focus $rep;rebind}
	focus $rfind	
	grab set $trch
} 

##########################################
#########EFFECTUE LE REMPLACEMENT DANS SELECTION OU TOUT 
proc doReplaceAll {} {
   global rfind rep trch 
    set f [focus -lastfor .edit.panel]
    set ind1 1   
    if {[$f tag ranges sel] != ""} { 
	set fir	 [$f index sel.first] 
	set sec	 [$f index sel.last] 
    } else {
	set fir	insert 
	set sec	end   
    }
    set schtick [$rfind get]
    set schtock [$rep get]
    if {$schtick == ""} {destroy $trch;return}
    while {$ind1 != ""} {
	set ind1 [$f search -forward  -- $schtick $fir $sec]
	if {$ind1 == ""} {destroy $trch;return}
	$f delete $ind1 "$ind1 + [string length $schtick] chars"
	$f see $ind1
	$f insert $ind1 $schtock
	set fir [$f index  "$ind1 + [string length $schtick] chars"]
    }
}

proc rebind {} {
       global wo trch
       bind $trch <Return> "$wo invoke"
}

##########################################
#########INSERER COMMENTAIRES DANS SELECTION
proc doComments {} {  
	set f [focus -lastfor .edit.panel]
	    if {[$f tag ranges sel] == ""}  {
		set beg [expr round(round([$f index insert]*10)/10)]
		set end [expr round(round([$f index insert]*10)/10)] 
	    } else {
		set beg [expr round(round([$f index sel.first]*10)/10)]
		set end [expr round(round([$f index "sel.last - 1c"]*10)/10)] 
	    }
		for {set i $beg} {$i <= $end} {incr i} {
		    if {[$f get $i.0] == ";"} {
			$f delete $i.0
		    } else {
			$f insert $i.0 ";"
		    }
		}
}
proc doOrcHead {type} {
global path
    switch $type {
    mono {$path(panel).mono.t insert 0.0 "\ninstr 1 \n\n\n\nout	ar\n	endin"}
    stereo {$path(panel).stereo.t insert 0.0 "\ninstr 1 \n\n\n\nouts	ar,ar\n	endin"}
    quad {$path(panel).quad.t insert 0.0 "\ninstr 1 \n\n\n\noutq	ar,ar,ar,ar\n	endin"}
    }
setBit
}

proc unixBout {path type tex} {
global color lan
    if {$type == "u"} {
	set bou	[frame $path.bout   -bd 2 -relief groove]
	frame $bou.can   -bd 2 -relief sunken
	button $bou.can.cancel -text $tex   -bd 3 -width 8 
	pack $bou.can.cancel -padx 2 -pady 2
	pack $bou.can  -padx 5 -pady 5
    } else {
	set bou	[frame $t.bout ]
	frame $bou.can  
	button $bou.can.cancel -text $tex -height 2  -width 8 		    
	pack $bou.can.cancel -pady 4
	pack $bou.can 
    }
    return $bou
}



proc makeInserter {} {
	global	path  tcl_platform opsDatabase ceclib cfont color 

    array set inserterTk {
		{Filein}		{
			{standard filein} {cfilein name -label}
		}
		{Sliders} {
			{slider options} 	{cslider name -label -rate -unit -orient -res -rel -min -max -init -color -width}
			{slider1}	 	{cslider data1 -res .01 -min 0 -max 1 -init .5}
			{slider10}	 	{cslider data10 -res .1 -min 0 -max 10 -init 5}
			{slider100} 		{cslider data100 -res .1 -min 0 -max 100 -init 50}
			{slider1000}        	{cslider data1000 -res .1 -min 0 -max 1000 -init 500}
			{sliderFreq}        	{cslider frequency -rel log -res .01 -min 10 -max 10000 -init 500}
			{sliderdB}          	{cslider ampdb -rel log  -res .1 -min 30 -max 80 -init 60}
			{slider total_time} 	{cslider total_time  -unit s -ori h -min 1 -res .01 -max 300 -init 30}
			{midi_slider}   	{cmidi name event channel  min max <init>}
			}
		{Graphs}	   {
			{graph options}    {cgraph name -label -unit -rel -min -max -gen -size -init -func}
			{graph freq}       {cgraph freq -unit Hz -rel lo -min 20 -max  15000 -init 500}
			{graph ampdb}      {cgraph amp -unit db -rel lo -min 30  -max 90  -init 65 }
			{graph envelope}   {cgraph env -unit x -rel lin  -min 0 -max 1 -func \"0 0 .1 1 .2 .7 .8 .7 1 0 \" }
			}
		{Toggle}	{
			{standard toggle} {ctoggle name -label -init}
		}
		{Popup}	    	{
			{standard popup} {cpopup name -label -value \"value1 value2 ...\"}
		}
		{Separator}	{
			{standard separator} {csepar}
		}
	}

	if [winfo exists .inserter] {destroy .inserter}
	
	    set t [toplevel .inserter -width 200 -cursor hand2 ]
	    if {$tcl_platform(platform) == "macintosh"} {
		    unsupported1 style .inserter floatProc
	    	wm title .inserter ""
	    } else {
			wm transient .inserter
			wm overrideredirect .inserter 1
			pack [frame .inserter.f -bg ${color}3] -fill x -anchor n
	   		pack [button .inserter.f.b -image closebox -bd 0 -command "wm withdraw .inserter"]  -side left
	    	pack [frame .inserter.f.f -bg ${color}3  -relief raised -bd 1 \
		    	-height [image height closebox] ] \
		    	-fill x -side left -padx 1 -expand t
	    	wm title .inserter Inserter
	    	wm minsize .inserter 160 360
		}	
		wm resizable .inserter 0 0
		
	    wm deiconify .inserter 
	    wm deiconify .edit 

	set where $t
	set i 0
	set licat ""

	foreach item [lsort -integer [array names opsDatabase]] {
		set cat [lindex [split [lindex $opsDatabase($item) 3] "/"] 0]
		if {[lsearch $licat $cat] == "-1"} {append licat $cat\n}
	}
	
	pack [label $where.orc -relief groove -height 2 -bd 2 -bg ${color}4 -text Orchestra  ] -fill x -expand 1
	foreach cate $licat {
	    set lab [string toupper [string range $cate 0 0]]
	    set res [string tolower $cate]
	    set do [menubutton $where.[string tolower $cate] -relief groove -bd 2 -direction right -text $cate  -menu $where.$res.$res]
	    menu   $where.$res.$res  -tearoff 0 -font $cfont(small) -relief raised 
	    pack $do -side top -fill x -expand 1
	}
	foreach men [lsort -integer [array names opsDatabase]] {
	    set cat [lindex [split [lindex $opsDatabase($men) 3] "/"] 0]
	    set adress [lindex [split [lindex $opsDatabase($men) 3] "/"] 1]
	    set name [lindex $opsDatabase($men) 0]
	    set res \{[lindex $opsDatabase($men) 1]\}
	    set syn \{[lindex $opsDatabase($men) 2]\}
	    set sub [lindex $opsDatabase($men) 4]
	    if {$cat == "Function"} {set line "sco $res $name $syn"} { set line "orc $res $name $syn"}
	       if {$sub == "-"} {
		$where.[string tolower $cat].[string tolower $cat] add command -label "$res $name"  \
		    -command "doPutItem  $line"
		} else {
		    if ![winfo exists $where.[string tolower $cat].[string tolower $cat].$sub] {
			$where.[string tolower $cat].[string tolower $cat] add cascade -label $sub  \
			    -menu $where.[string tolower $cat].[string tolower $cat].$sub
			    menu $where.[string tolower $cat].[string tolower $cat].$sub  \
				    -tearoff 0 -font $cfont(small) -tearoff 0 -relief raised 
			$where.[string tolower $cat].[string tolower $cat].$sub add command -label "$res $name"  \
			    -command  "doPutItem  $line"
		    } else {
			$where.[string tolower $cat].[string tolower $cat].$sub add command -label "$res $name"  \
			    -command "doPutItem  $line"
		    }

		}
	}
	
	pack [label $where.sco -relief groove -height 2 -bd 2  -bg ${color}4  -text Score  ] \
		 -before $where.function -fill x -expand 1

	pack [label $where.interf -relief groove -height 2 -bd 2  -bg ${color}4 -text Interface  ] \
		 -fill x -expand 1

	foreach int [array names inserterTk] {
	    if {[llength $inserterTk($int)] == "1"} {
		set line "interf [lindex $inserterTk($int) 0] "
		set do [button $where.[string tolower $int] -relief groove -bd 2  \
			-text $int -bg ${color}3 -command "doPutItem $line"]
		pack $do -side top -fill x -expand 1
	    } else {
		pack [menubutton $where.[string tolower $int] -relief groove -bd 2 -direction right \
			-text $int  -font $cfont(small) \
			-menu $where.[string tolower $int].[string tolower $int]] \
			-side top -fill x -expand 1
		menu   $where.[string tolower $int].[string tolower $int]  \
			-font $cfont(small) -tearoff 0 -relief raised 
		catch {unset temp}
		array set temp $inserterTk($int)
		foreach out [array names temp] {
		    set line "interf $temp($out)"
		    $where.[string tolower $int].[string tolower $int] add command -label $out  \
			-command "doPutItem  $line"
		}
	    }
	}
	
#	pack [button $where.done -relief raised -bd 2  \
#	    -text CLOSE -command "wm withdraw $where" ] -side top -fill x -expand 1

	    bind .inserter.f.f <Button-1> "setInOrig %x %y"
	    bind .inserter.f.f <B1-Motion> "inDrag %X %Y"
	    bind .inserter.f.f <ButtonRelease-1> "bug clear origin"

}
proc setInOrig {x y} {
    global insc
    set g [split [wm geometry .inserter] +]
    set insc(dX) [expr $x + [winfo x .inserter.f.f]]
    set insc(dY) $y
}
proc inDrag {x y} {
    global insc
    set g +[expr $x - $insc(dX)]+[expr $y - $insc(dY)]
    wm geometry .inserter $g
}




##########################################
#########INSERER UN OPCODE DANS LE TEXTE
# proc doInsert {} {
# 
# 	bug starting insertion
# 	global inserterOrc inserterSco inserterTk  color lan path tcl_platform opsDatabase cfont
# 
# 	### si quelque chose est selectionne, trouver de l'aide dessus
# 	set f [focus -lastfor .edit.panel]
# 	if ![catch {$f get sel.first sel.last} c] {
# 		helpOpcode
# 		return
# 	} 
# 	if [winfo exists .inserter] {
# 	    wm deiconify .inserter
# 	    wm deiconify .edit
# 	    raise .edit
# 	    raise .inserter
# 	    return
# 	} else {    
# 	    makeInserter
# 	}   
# }

   
##########################################
#########METS OPCODE DANS TEXTE
proc doPutItem {args} {
	global  prefs  ceclib inserterTk path opsDatabase
	set where [lindex $args 0]	
	set args [lrange $args 1 end]	

	switch $where {
	    orc     {set f [focus -lastfor .edit.panel]}
	    sco	    {set f  .edit.panel.score.t}
	    interf  {set f  .edit.panel.tk_interface.t}
	}
	regsub -all \{ $args "" args
	regsub -all \} $args "" args
	$f insert "insert linestart" ${args}\n
	setBit
}


proc helpOpcode {} {
	global path refHelp 
	set f [focus -lastfor .edit.panel]
	set opcode [$f get  sel.first sel.last]
	set boo $refHelp($opcode)
	Helpme  [file join csman $boo]
}



proc manFont {} {
global tman prefs

$tman config -font "-*-helvetica-$prefs(manstyle)-r-*--$prefs(mansize)-*-*-*-*-*-*-*"

	}

##########################################
#########METS OPCODE DANS TEXTE APARTIR DU MANUEL

proc makeNewTemplate {} {
	global env frbut3 path lan prefs user
	doCloseCheck
	wm deiconify $path(edit)
	raise $path(edit)
	$frbut3.file entryconfigure 3 -state disabled
	$frbut3.file entryconfigure 4 -state disabled
	$frbut3.wind entryconfigure 0 -label $lan(nom12c)
	set tempi [open [file join $prefs(TMPDIR) $user.untitled.cec] w+]

	puts $tempi "<info>
$user, [clock format [clock seconds]]
New Module

</info>
<tk_interface>

</tk_interface>
<mono>
; mono template

	instr 1 


	out	ar
	endin
</mono>
<stereo>
; stereo template

	instr 1 


	outs 	ar,ag
	endin
</stereo>
<quad>
; quad template

	instr 1
	

	outq 	a1,a2,a3,a4
	endin

</quad>
<score>
f1 0 8192 10 1
i1 0 10
e
</score>

"
	close $tempi
	parseModule [file join $prefs(TMPDIR) $user.untitled.cec]
	setBitbind on
}

##########################################
#########GESTION DU BIND POUR CHANGEMENT DANS TEXTE
proc setBitbind {what} {
global bitBind path tags
    if {$what == "on" } {
	set bitBind ""
	foreach tag $tags {	
	    append bitBind [.edit.panel.$tag.t get 0.0 end]
	}
	bind .edit   <Any-KeyRelease> "setBit"
    } else {
	bind .edit   <Any-KeyRelease>  ""
    }
}
#########################################
#########METS *** LORSQUE TEXTE CHANGE
proc setBit {} {
    global module bitBind frbut3 tags
	set boo ""
	foreach tag $tags {	
	    append boo [.edit.panel.$tag.t get 0.0 end]}
    if {[string compare $bitBind $boo] != "0"} {
	wm title .edit "Cecilia: Editor: $module(nom)***"
	setBitbind off 
    }
}

proc power {way} {
	set z 1073741824 ;# limite superieure
	set f [focus -lastfor .edit.panel]
	set c [$f get sel.first sel.last]
	if ![catch {format %i $c}] {
		if {$way == "u"} {
			if {$c < $z} { 
				set p 2 
				if {$c >= 2} {while {$p <= $c} {set p [expr $p*2]} } 
			} { bug too large to go up ; return }	
		} {
			if {$c > 0} { 
				set p $z
				if {$c <= $z} {while {$p >= $c} {set p [expr $p/2]} } 
			} { bug can't get lower than that ; return }	
		} 
		$f delete sel.first sel.last ; $f insert insert $p
		$f tag add sel "insert - 1c wordstart" "insert - 1c wordend"
	} { bug gimme something integer, please! } 
}

proc showEditWindow {what} {
    global path frbut3 lan prefs panelist
    if $what {
		wm deiconify $path(edit)
		$frbut3.wind entryconfigure 0 -label $lan(nom12c) -command "showEditWindow 0"
		focus $path(edit).panel.[lindex $panelist 0].t
		setBitbind on
		raise $path(edit)
	} else {
		wm withdraw $path(edit)
		$frbut3.wind entryconfigure 0 -label $lan(nom12b) -command "showEditWindow 1"
	}
}

proc doPanePrefs {} {
    global prefs  toggleState tags outtags
    set lisp ""
    foreach pane [concat $tags $outtags] {
	append lisp $toggleState($pane)
    }
    set prefs(edset) $lisp
}

proc openPanes {} {
    global prefs path toggleState tags outtags
    foreach pane {0 1 2 3 4 5 6 7 8} {
		if {[string range $prefs(edset) $pane $pane] == 1 } {
			$path(edit).menu.section invoke $pane
    	}
    }
}

proc bindOpcodeHelp {window tag message} {
	$window tag bind $tag <Enter> "showRef $message"
	return $window
}

proc checkLastWord {} {
    set f [focus -lastfor .edit.panel]
    set i [$f index "insert - 2c wordstart"]
    set w [$f get "$i wordstart" "$i wordend"]
    checkword $w $f $i
}

proc checkword {w f i} {
    global refLine 
    if [info exists refLine($w)] {
	showRef $w
	$f tag add blue $i "$i wordend"
	$f tag add $w $i "$i wordend"
	bindOpcodeHelp $f $w $w
	setcolor $f
    }
}

proc checkcomment {} { [focus -lastfor .edit.panel] tag add green "insert -1c" "insert lineend" }

proc clearcolor {f} { foreach t {red blue green purple orange yellow} {$f tag delete $t} }

proc setcolor {f} {
    global prefs tcl_platform
    if {$tcl_platform(os) == "IRIX"} {
   	$f tag configure orange -foreground black -background orange -font "\{$prefs(font)\} $prefs(size)"
   	$f tag configure yellow -foreground black -background \#c6ff70 -font "\{$prefs(font)\} $prefs(size)"
    	$f tag configure green -foreground forestgreen -font "-*-$prefs(font)-$prefs(style)-i-*-*-$prefs(size)-*-*-*-*-*-*-*"
    	$f tag configure red -foreground red -font "-*-$prefs(font)-bold-r-*-*-$prefs(size)-*-*-*-*-*-*-*"
    	$f tag configure blue -foreground blue -font "-*-$prefs(font)-bold-r-*-*-$prefs(size)-*-*-*-*-*-*-*"
    	$f tag configure purple -foreground purple -font "-*-$prefs(font)-bold-r-*-*-$prefs(size)-*-*-*-*-*-*-*"
   
    } else {
   	$f tag configure orange -foreground black -background orange -font "\{$prefs(font)\} $prefs(size)"
   	$f tag configure yellow -foreground black -background \#c6ff70 -font "\{$prefs(font)\} $prefs(size)"
   	$f tag configure green -foreground forestgreen -font "\{$prefs(font)\} $prefs(size) italic"
    	$f tag configure red -foreground red -font "\{$prefs(font)\} $prefs(size) bold"
    	$f tag configure blue -foreground blue -font "\{$prefs(font)\} $prefs(size) bold"
    	$f tag configure purple -foreground purple -font "\{$prefs(font)\} $prefs(size) bold"
    }
}

proc colorScore {} {}

proc superPrettyPring {} {
    destroy .spp
    toplevel .spp
    pack [text .spp.t]
    

}

proc colorize {f} {
    global refLine path _db textUndoer superFormat tkrefLine scorerefLine
    if ![info exists superFormat] { set superFormat 0}
	
    set _db(undo,disable) 1
    set prebinds [bindtags $path(panel).$f.t]
    bindtags $path(panel).$f.t ""
    
    switch -- $f {
	tk_interface {
	    set color purple
	    array set thisref [array get tkrefLine]
	}
	score {
	    set color red
	    array set thisref [array get scorerefLine]
	}
	default {
	    set color blue
	    array set thisref [array get refLine]
	}
    }
    
    # nettoyage des couleurs/styles
    clearcolor $path(panel).$f.t
 
    # nettoyage du whitespace
    if $superFormat {
	set stuff [$path(panel).$f.t get 0.0 e]
	regsub -all (\ |\t)+ $stuff \  stuff
	$path(panel).$f.t delete 0.0 e
	$path(panel).$f.t insert 0.0 $stuff
    }

    # analyse pour virgules 
    set i 0.0
    while {[set i [$path(panel).$f.t search -forward , $i end]] != "" } {
	if {[$path(panel).$f.t get "$i+1c"] != " "} { $path(panel).$f.t insert "$i+1c" " " }
	set i [$path(panel).$f.t index "$i + 1c"]
    }
    
    # analyse principale
    foreach w  [split [$path(panel).$f.t get 0.0 e]] {
	
	# on oublie le whitespace
	set w [string trim $w]
	if {$w != ""} {

	    # si $w n'a pas ete teste
	    if  ![info exists test($w)] {
		
		# si l'on travaille avec un opcode documente
		if [info exists thisref($w)] {
		    set i [$path(panel).$f.t search -regexp -forwards  -- (\ |\n)?$w 0.0 end]
		    
		    # tant qu'un mot correspondant est trouve
		    while {$i != "" } {
			
			# elimine les "gkbalance" et autres "koscil2"
			if {[$path(panel).$f.t get "$i wordstart" "$i wordend"] == $w} {   

			    # et si on est pas dans le score
			    if {$f != "score"} {		   
				
				# tag!
				$path(panel).$f.t tag add $color $i "$i wordend"
				$path(panel).$f.t tag add $w $i "$i wordend"

				if $superFormat {

				    # tab avant...				    
				    if {[$path(panel).$f.t get $i-1c $i] != "\t"} {
					if {[$path(panel).$f.t get $i-1c $i] != "\ "} {					 
					    $path(panel).$f.t insert "$i linestart" "\t"
					    set i [$path(panel).$f.t index "$i+1c"]
					} {
					    $path(panel).$f.t delete $i-1c
					    $path(panel).$f.t insert $i-1c \t
					}
				    }

				    # tab apres...
				    if {[$path(panel).$f.t get "$i wordend" "$i wordend + 1c"] == " "} {
					$path(panel).$f.t insert "$i wordend" "\t"
					$path(panel).$f.t delete "$i wordend+1c" "$i wordend +2c"

				    }
				}
				# note que $w a ete processe avec succes
				set ok($w) 1
			    }
			}
			
			# trouver le mot suivant
			set i [$path(panel).$f.t search -forwards -regexp -exact -- $w "$i wordend" end]
		    }	
		    
		    # do you bindingr thing if something was tagged!
		    if [info exists ok($w)] {
			if [info exists refLine($w)] {bindOpcodeHelp $path(panel).$f.t $w $w}
		    }
		} 
		
		# note que $w a ete teste
		set test($w) 1
	    }
	}
    }
    
    # analyse pour delimiteurs
    foreach del {instr endin} {
	set i 0.0
	while { [set i [$path(panel).$f.t  search -forward $del $i end]] != "" } { 
	    $path(panel).$f.t tag add red $i "$i lineend"
	    $path(panel).$f.t insert "$i linestart" "\t"

	    set i [$path(panel).$f.t index "$i + 2c"]
    	}	
    }
    
    # analyse pour commentaires
    set i 0.0
    while {[set i [$path(panel).$f.t search -forward ";" $i end]] != "" } {
	$path(panel).$f.t tag add green $i "$i lineend"
	set i [$path(panel).$f.t index "$i + 1c"]
    }
    
    
    # analyse pour labels
    set i 0.0
    set found {}
    
    while {[set i [$path(panel).$f.t search -forward -regexp \[a-z0-9\]*: $i end]] != "" } {	
	set word [$path(panel).$f.t get $i "$i wordend"]

	if {[string trim [$path(panel).$f.t get "$i linestart" "$i wordstart -1c"]] == ""} {
	    set tindex($word) $i
	    lappend found $word
	    $path(panel).$f.t tag add yellow $i "$i wordend +1c"
	}
	set i [$path(panel).$f.t index "$i wordend +1c"]

    }
    
    foreach tab $found {
	set i 0.0
	while {[set i [$path(panel).$f.t search -forward  $tab $i end]] != "" } {
	    if {[$path(panel).$f.t get "$i wordstart" "$i wordend"] == $tab} {
		$path(panel).$f.t tag add yellow $i "$i wordend"
	    }
	    set i [$path(panel).$f.t index "$i wordend"]
	}
    }
    
    # assignation des couleurs/styles
    setcolor $path(panel).$f.t
    
    set _db(undo,disable) 0
    bindtags $path(panel).$f.t $prebinds
}

proc colorit {} {
	foreach f {tk_interface mono stereo quad score} {colorize $f ; update}
	colorScore
}

proc goTo {} {
 	global  color  lan  liner
	set t [toplevel .goto  -bd 0 ]
	wm geometry $t +300+300
	pack [frame  $t.lab   -relief ridge -bd 0] -fill x -side top -padx 4 -pady 4
	pack [frame  $t.buttons   -relief ridge -bd 3] -side right -padx 4 -pady 4
	set labf [label $t.lab.findl -text "Line #:" ]
	set find [entry  $t.lab.find -width 8 -relief  sunken -textvariable liner ]
	pack $labf -side left -anchor w -padx 5 -pady 4 
	pack $find -side left -fill x -padx 5 -pady 4 -expand y
	$find delete 0 end
	button $t.buttons.ok -text OK   -command getThere
	bind $t <Return> "$t.buttons.ok invoke"
	pack $t.buttons.ok -side top -padx 4 -pady 4
 	focus $t.lab.find	
	grab set $t
	raise $t
}

proc getThere {} {
    global liner
    if {$liner != ""} {
	    set f [focus -lastfor .edit.panel]
	    $f tag remove sel 1.0 end
	    $f tag add sel $liner.0 "$liner.0 lineend"
	    $f yview $liner.0
	    destroy .goto
    }
}

proc prettyprint {} {
    global path
    
    set s [$path(panel).score.t get 0.0 e]
    regsub -all (\ |\t)*(\ |\t) $s \t s
    $path(panel).score.t delete 0.0 e
    $path(panel).score.t insert 0.0 $s
}


proc doFont {} {
    global tags outtags path  prefs tcl_platform
    if {$tcl_platform(os) == "IRIX"} {
	foreach pane [concat $tags $outtags] {
	    $path(panel).$pane.t config -font "-*-$prefs(font)-$prefs(style)-r-*-*-$prefs(size)-*-*-*-*-*-*-*"
	}
    } {
	foreach pane [concat $tags $outtags] {
	    $path(panel).$pane.t config -font "\{$prefs(font)\} $prefs(size) $prefs(style)"
	}
    }
    if $prefs(colorize) {colorit} {
	foreach p {tk_interface mono stereo quad score} {clearcolor $path(panel).$p.t}
    }   
}

proc doTabs {} {
    global tags outtags path  prefs
    foreach pane [concat $tags $outtags] {
	$path(panel).$pane.t config -tabs $prefs(tabs)
    }
}


proc makeManuel {where} {
    global	path  tcl_platform opsDatabase ceclib
    set frbut3 $where
    menu $where.insert -tearoff 1 -relief raised
    
    set i 0
    set licat ""
    foreach item [lsort -integer [array names opsDatabase]] {
	set cat [lindex [split [lindex $opsDatabase($item) 3] "/"] 0]
	if {[lsearch $licat $cat] == "-1"} {append licat $cat\n}
    }
	
	foreach cate [string tolower $licat] {
	    set lab	[string toupper [string range $cate 0 0]]
	    set res [string range $cate 1 end]
	    $where.insert add cascade -label  $lab$res  -menu $where.insert.$cate
	    menu  $where.insert.$cate  -tearoff 1 -relief raised 
	}
	set names ""
	foreach men [lsort -integer [array names opsDatabase]] {
	    set cat [lindex [split [lindex $opsDatabase($men) 3] "/"] 0]
	    set adress [lindex [split [lindex $opsDatabase($men) 3] "/"] 1]
	    set name [lindex $opsDatabase($men) 0]
	    set sub [lindex $opsDatabase($men) 4]
	    if {[lsearch $names $name] == "-1"} {	    
	       if {$sub == "-"} {
		$where.insert.[string tolower $cat] add command -label $name  \
		    -command "Helpme  [file join csman $cat $adress]"
		append names $name\n
		} else {
		    if ![winfo exists $where.insert.[string tolower $cat].$sub] {
			$where.insert.[string tolower $cat] add cascade -label $sub  \
			    -menu $where.insert.[string tolower $cat].$sub
			    menu $where.insert.[string tolower $cat].$sub  -tearoff 1 -relief raised 
			$where.insert.[string tolower $cat].$sub add command -label $name  \
			    -command "Helpme  [file join csman $cat $adress]"
			append names $name\n
		    } else {
			$where.insert.[string tolower $cat].$sub add command -label $name  \
			    -command "Helpme  [file join csman $cat $adress]"
			append names $name\n		
		    
		    }

		}
	    }
	
	}
}

