/*
  File autogenerated by gengetopt version 2.14
  generated with the following command:
  gengetopt -C 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "getopt.h"

#include "cmdline.h"

static
void clear_given (struct gengetopt_args_info *args_info);
static
void clear_args (struct gengetopt_args_info *args_info);

static int
cmdline_parser_internal (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required, const char *additional_error);

struct line_list
{
  char * string_arg;
  struct line_list * next;
};

struct line_list *cmd_line_list = 0;
struct line_list *cmd_line_list_tmp = 0;


struct uamallowed_list
{
  char * uamallowed_arg;
  char *uamallowed_orig;
  struct uamallowed_list * next;
};

struct macallowed_list
{
  char * macallowed_arg;
  char *macallowed_orig;
  struct macallowed_list * next;
};

static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct gengetopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->fg_given = 0 ;
  args_info->debug_given = 0 ;
  args_info->debugfacility_given = 0 ;
  args_info->conf_given = 0 ;
  args_info->interval_given = 0 ;
  args_info->pidfile_given = 0 ;
  args_info->statedir_given = 0 ;
  args_info->net_given = 0 ;
  args_info->dynip_given = 0 ;
  args_info->statip_given = 0 ;
  args_info->dns1_given = 0 ;
  args_info->dns2_given = 0 ;
  args_info->domain_given = 0 ;
  args_info->ipup_given = 0 ;
  args_info->ipdown_given = 0 ;
  args_info->radiuslisten_given = 0 ;
  args_info->radiusserver1_given = 0 ;
  args_info->radiusserver2_given = 0 ;
  args_info->radiusauthport_given = 0 ;
  args_info->radiusacctport_given = 0 ;
  args_info->radiussecret_given = 0 ;
  args_info->radiusnasid_given = 0 ;
  args_info->radiuslocationid_given = 0 ;
  args_info->radiuslocationname_given = 0 ;
  args_info->radiusnasporttype_given = 0 ;
  args_info->coaport_given = 0 ;
  args_info->coanoipcheck_given = 0 ;
  args_info->proxylisten_given = 0 ;
  args_info->proxyport_given = 0 ;
  args_info->proxyclient_given = 0 ;
  args_info->proxysecret_given = 0 ;
  args_info->dhcpif_given = 0 ;
  args_info->dhcpmac_given = 0 ;
  args_info->lease_given = 0 ;
  args_info->eapolenable_given = 0 ;
  args_info->uamserver_given = 0 ;
  args_info->uamhomepage_given = 0 ;
  args_info->uamsecret_given = 0 ;
  args_info->uamlisten_given = 0 ;
  args_info->uamport_given = 0 ;
  args_info->uamallowed_given = 0 ;
  args_info->uamanydns_given = 0 ;
  args_info->macauth_given = 0 ;
  args_info->macallowed_given = 0 ;
  args_info->macsuffix_given = 0 ;
  args_info->macpasswd_given = 0 ;
}

static
void clear_args (struct gengetopt_args_info *args_info)
{
  args_info->fg_flag = 0;
  args_info->debug_flag = 0;
  args_info->debugfacility_arg = 1;
  args_info->debugfacility_orig = NULL;
  args_info->conf_arg = gengetopt_strdup ("/etc/chilli.conf");
  args_info->conf_orig = NULL;
  args_info->interval_arg = 3600;
  args_info->interval_orig = NULL;
  args_info->pidfile_arg = gengetopt_strdup ("/var/run/chilli.pid");
  args_info->pidfile_orig = NULL;
  args_info->statedir_arg = gengetopt_strdup ("/var/lib/chilli/");
  args_info->statedir_orig = NULL;
  args_info->net_arg = gengetopt_strdup ("192.168.182.0/24");
  args_info->net_orig = NULL;
  args_info->dynip_arg = NULL;
  args_info->dynip_orig = NULL;
  args_info->statip_arg = NULL;
  args_info->statip_orig = NULL;
  args_info->dns1_arg = NULL;
  args_info->dns1_orig = NULL;
  args_info->dns2_arg = NULL;
  args_info->dns2_orig = NULL;
  args_info->domain_arg = gengetopt_strdup ("key.chillispot.org");
  args_info->domain_orig = NULL;
  args_info->ipup_arg = NULL;
  args_info->ipup_orig = NULL;
  args_info->ipdown_arg = NULL;
  args_info->ipdown_orig = NULL;
  args_info->radiuslisten_arg = NULL;
  args_info->radiuslisten_orig = NULL;
  args_info->radiusserver1_arg = gengetopt_strdup ("rad01.hotradius.com");
  args_info->radiusserver1_orig = NULL;
  args_info->radiusserver2_arg = gengetopt_strdup ("rad02.hotradius.com");
  args_info->radiusserver2_orig = NULL;
  args_info->radiusauthport_arg = 1812;
  args_info->radiusauthport_orig = NULL;
  args_info->radiusacctport_arg = 1813;
  args_info->radiusacctport_orig = NULL;
  args_info->radiussecret_arg = NULL;
  args_info->radiussecret_orig = NULL;
  args_info->radiusnasid_arg = gengetopt_strdup ("nas01");
  args_info->radiusnasid_orig = NULL;
  args_info->radiuslocationid_arg = NULL;
  args_info->radiuslocationid_orig = NULL;
  args_info->radiuslocationname_arg = NULL;
  args_info->radiuslocationname_orig = NULL;
  args_info->radiusnasporttype_arg = 19;
  args_info->radiusnasporttype_orig = NULL;
  args_info->coaport_arg = 0;
  args_info->coaport_orig = NULL;
  args_info->coanoipcheck_flag = 0;
  args_info->proxylisten_arg = NULL;
  args_info->proxylisten_orig = NULL;
  args_info->proxyport_arg = 0;
  args_info->proxyport_orig = NULL;
  args_info->proxyclient_arg = NULL;
  args_info->proxyclient_orig = NULL;
  args_info->proxysecret_arg = NULL;
  args_info->proxysecret_orig = NULL;
  args_info->dhcpif_arg = NULL;
  args_info->dhcpif_orig = NULL;
  args_info->dhcpmac_arg = NULL;
  args_info->dhcpmac_orig = NULL;
  args_info->lease_arg = 600;
  args_info->lease_orig = NULL;
  args_info->eapolenable_flag = 0;
  args_info->uamserver_arg = gengetopt_strdup ("https://login.hotradius.com");
  args_info->uamserver_orig = NULL;
  args_info->uamhomepage_arg = NULL;
  args_info->uamhomepage_orig = NULL;
  args_info->uamsecret_arg = NULL;
  args_info->uamsecret_orig = NULL;
  args_info->uamlisten_arg = NULL;
  args_info->uamlisten_orig = NULL;
  args_info->uamport_arg = 3990;
  args_info->uamport_orig = NULL;
  args_info->uamallowed_arg = NULL;
  args_info->uamallowed_orig = NULL;
  args_info->uamanydns_flag = 0;
  args_info->macauth_flag = 0;
  args_info->macallowed_arg = NULL;
  args_info->macallowed_orig = NULL;
  args_info->macsuffix_arg = NULL;
  args_info->macsuffix_orig = NULL;
  args_info->macpasswd_arg = gengetopt_strdup ("password");
  args_info->macpasswd_orig = NULL;
  
}

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n", CMDLINE_PARSER_PACKAGE, CMDLINE_PARSER_VERSION);
}

void
cmdline_parser_print_help (void)
{
  cmdline_parser_print_version ();
  printf("\n%s\n", "Copyright 2002-2005 Mondru AB\nChilliSpot is an Open Source captive portal or wireless LAN access point\ncontroller developed by the community at chillispot.org and licensed under\nthe GPL. ChilliSpot acknowledges all community members, especially\nthose mentioned at http://www.chillispot.org/credits.html.");
  printf("\nUsage: %s [OPTIONS]...\n\n", CMDLINE_PARSER_PACKAGE);
  printf("%s\n","  -h, --help                    Print help and exit");
  printf("%s\n","  -V, --version                 Print version and exit");
  printf("%s\n","  -f, --fg                      Run in foreground  (default=off)");
  printf("%s\n","  -d, --debug                   Run in debug mode  (default=off)");
  printf("%s\n","      --debugfacility=INT       Which modules to print debug messages for  \n                                  (default=`1')");
  printf("%s\n","  -c, --conf=STRING             Read configuration file  \n                                  (default=`/etc/chilli.conf')");
  printf("%s\n","      --interval=INT            Re-read configuration file at this interval  \n                                  (default=`3600')");
  printf("%s\n","      --pidfile=STRING          Filename of process id file  \n                                  (default=`/var/run/chilli.pid')");
  printf("%s\n","      --statedir=STRING         Directory of nonvolatile data  \n                                  (default=`/var/lib/chilli/')");
  printf("%s\n","  -n, --net=STRING              Network  (default=`192.168.182.0/24')");
  printf("%s\n","      --dynip=STRING            Dynamic IP address pool");
  printf("%s\n","      --statip=STRING           Static IP address pool");
  printf("%s\n","      --dns1=STRING             Primary DNS server IP address");
  printf("%s\n","      --dns2=STRING             Secondary DNS server IP address");
  printf("%s\n","      --domain=STRING           Domain to use for DNS lookups  \n                                  (default=`key.chillispot.org')");
  printf("%s\n","      --ipup=STRING             Script to run after link-up");
  printf("%s\n","      --ipdown=STRING           Script to run after link-down");
  printf("%s\n","      --radiuslisten=STRING     IP address to send from");
  printf("%s\n","      --radiusserver1=STRING    IP address of radius server 1  \n                                  (default=`rad01.hotradius.com')");
  printf("%s\n","      --radiusserver2=STRING    IP address of radius server 2  \n                                  (default=`rad02.hotradius.com')");
  printf("%s\n","      --radiusauthport=INT      Authentication UDP port of radius server  \n                                  (default=`1812')");
  printf("%s\n","      --radiusacctport=INT      Accounting UDP port of radius server  \n                                  (default=`1813')");
  printf("%s\n","      --radiussecret=STRING     Radius shared secret");
  printf("%s\n","      --radiusnasid=STRING      Radius NAS-Identifier  (default=`nas01')");
  printf("%s\n","      --radiuslocationid=STRING WISPr Location ID");
  printf("%s\n","      --radiuslocationname=STRING\n                                WISPr Location Name");
  printf("%s\n","      --radiusnasporttype=INT   Radius NAS-Port-Type  (default=`19')");
  printf("%s\n","      --coaport=INT             Radius disconnect port to listen to  \n                                  (default=`0')");
  printf("%s\n","      --coanoipcheck            Allow radius disconnect from any IP  \n                                  (default=off)");
  printf("%s\n","      --proxylisten=STRING      IP address to listen to");
  printf("%s\n","      --proxyport=INT           UDP port to listen to  (default=`0')");
  printf("%s\n","      --proxyclient=STRING      IP address of proxy client(s)");
  printf("%s\n","      --proxysecret=STRING      Radius proxy shared secret");
  printf("%s\n","      --dhcpif=STRING           Local Ethernet interface");
  printf("%s\n","      --dhcpmac=STRING          Interface MAC address");
  printf("%s\n","      --lease=INT               Lease time to allocate to clients  \n                                  (default=`600')");
  printf("%s\n","      --eapolenable             Enable IEEE 802.1x authentication  \n                                  (default=off)");
  printf("%s\n","      --uamserver=STRING        URL of authentication web server  \n                                  (default=`https://login.hotradius.com')");
  printf("%s\n","      --uamhomepage=STRING      URL of homepage to redirect unauthenticated \n                                  users to");
  printf("%s\n","      --uamsecret=STRING        Shared secret between uamserver and chilli");
  printf("%s\n","      --uamlisten=STRING        IP address to listen to for authentication \n                                  requests");
  printf("%s\n","      --uamport=INT             TCP port to bind to for authentication requests \n                                   (default=`3990')");
  printf("%s\n","      --uamallowed=STRING       Domain names exempt from access check ");
  printf("%s\n","      --uamanydns               Allow client to use any DNS server  \n                                  (default=off)");
  printf("%s\n","      --macauth                 Authenticate based on MAC address  \n                                  (default=off)");
  printf("%s\n","      --macallowed=STRING       List of allowed MAC addresses");
  printf("%s\n","      --macsuffix=STRING        Suffix to add to the MAC address");
  printf("%s\n","      --macpasswd=STRING        Password used when performing MAC \n                                  authentication  (default=`password')");
  
}

void
cmdline_parser_init (struct gengetopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
}

static void
cmdline_parser_release (struct gengetopt_args_info *args_info)
{
  
  unsigned int i;
  if (args_info->debugfacility_orig)
    {
      free (args_info->debugfacility_orig); /* free previous argument */
      args_info->debugfacility_orig = 0;
    }
  if (args_info->conf_arg)
    {
      free (args_info->conf_arg); /* free previous argument */
      args_info->conf_arg = 0;
    }
  if (args_info->conf_orig)
    {
      free (args_info->conf_orig); /* free previous argument */
      args_info->conf_orig = 0;
    }
  if (args_info->interval_orig)
    {
      free (args_info->interval_orig); /* free previous argument */
      args_info->interval_orig = 0;
    }
  if (args_info->pidfile_arg)
    {
      free (args_info->pidfile_arg); /* free previous argument */
      args_info->pidfile_arg = 0;
    }
  if (args_info->pidfile_orig)
    {
      free (args_info->pidfile_orig); /* free previous argument */
      args_info->pidfile_orig = 0;
    }
  if (args_info->statedir_arg)
    {
      free (args_info->statedir_arg); /* free previous argument */
      args_info->statedir_arg = 0;
    }
  if (args_info->statedir_orig)
    {
      free (args_info->statedir_orig); /* free previous argument */
      args_info->statedir_orig = 0;
    }
  if (args_info->net_arg)
    {
      free (args_info->net_arg); /* free previous argument */
      args_info->net_arg = 0;
    }
  if (args_info->net_orig)
    {
      free (args_info->net_orig); /* free previous argument */
      args_info->net_orig = 0;
    }
  if (args_info->dynip_arg)
    {
      free (args_info->dynip_arg); /* free previous argument */
      args_info->dynip_arg = 0;
    }
  if (args_info->dynip_orig)
    {
      free (args_info->dynip_orig); /* free previous argument */
      args_info->dynip_orig = 0;
    }
  if (args_info->statip_arg)
    {
      free (args_info->statip_arg); /* free previous argument */
      args_info->statip_arg = 0;
    }
  if (args_info->statip_orig)
    {
      free (args_info->statip_orig); /* free previous argument */
      args_info->statip_orig = 0;
    }
  if (args_info->dns1_arg)
    {
      free (args_info->dns1_arg); /* free previous argument */
      args_info->dns1_arg = 0;
    }
  if (args_info->dns1_orig)
    {
      free (args_info->dns1_orig); /* free previous argument */
      args_info->dns1_orig = 0;
    }
  if (args_info->dns2_arg)
    {
      free (args_info->dns2_arg); /* free previous argument */
      args_info->dns2_arg = 0;
    }
  if (args_info->dns2_orig)
    {
      free (args_info->dns2_orig); /* free previous argument */
      args_info->dns2_orig = 0;
    }
  if (args_info->domain_arg)
    {
      free (args_info->domain_arg); /* free previous argument */
      args_info->domain_arg = 0;
    }
  if (args_info->domain_orig)
    {
      free (args_info->domain_orig); /* free previous argument */
      args_info->domain_orig = 0;
    }
  if (args_info->ipup_arg)
    {
      free (args_info->ipup_arg); /* free previous argument */
      args_info->ipup_arg = 0;
    }
  if (args_info->ipup_orig)
    {
      free (args_info->ipup_orig); /* free previous argument */
      args_info->ipup_orig = 0;
    }
  if (args_info->ipdown_arg)
    {
      free (args_info->ipdown_arg); /* free previous argument */
      args_info->ipdown_arg = 0;
    }
  if (args_info->ipdown_orig)
    {
      free (args_info->ipdown_orig); /* free previous argument */
      args_info->ipdown_orig = 0;
    }
  if (args_info->radiuslisten_arg)
    {
      free (args_info->radiuslisten_arg); /* free previous argument */
      args_info->radiuslisten_arg = 0;
    }
  if (args_info->radiuslisten_orig)
    {
      free (args_info->radiuslisten_orig); /* free previous argument */
      args_info->radiuslisten_orig = 0;
    }
  if (args_info->radiusserver1_arg)
    {
      free (args_info->radiusserver1_arg); /* free previous argument */
      args_info->radiusserver1_arg = 0;
    }
  if (args_info->radiusserver1_orig)
    {
      free (args_info->radiusserver1_orig); /* free previous argument */
      args_info->radiusserver1_orig = 0;
    }
  if (args_info->radiusserver2_arg)
    {
      free (args_info->radiusserver2_arg); /* free previous argument */
      args_info->radiusserver2_arg = 0;
    }
  if (args_info->radiusserver2_orig)
    {
      free (args_info->radiusserver2_orig); /* free previous argument */
      args_info->radiusserver2_orig = 0;
    }
  if (args_info->radiusauthport_orig)
    {
      free (args_info->radiusauthport_orig); /* free previous argument */
      args_info->radiusauthport_orig = 0;
    }
  if (args_info->radiusacctport_orig)
    {
      free (args_info->radiusacctport_orig); /* free previous argument */
      args_info->radiusacctport_orig = 0;
    }
  if (args_info->radiussecret_arg)
    {
      free (args_info->radiussecret_arg); /* free previous argument */
      args_info->radiussecret_arg = 0;
    }
  if (args_info->radiussecret_orig)
    {
      free (args_info->radiussecret_orig); /* free previous argument */
      args_info->radiussecret_orig = 0;
    }
  if (args_info->radiusnasid_arg)
    {
      free (args_info->radiusnasid_arg); /* free previous argument */
      args_info->radiusnasid_arg = 0;
    }
  if (args_info->radiusnasid_orig)
    {
      free (args_info->radiusnasid_orig); /* free previous argument */
      args_info->radiusnasid_orig = 0;
    }
  if (args_info->radiuslocationid_arg)
    {
      free (args_info->radiuslocationid_arg); /* free previous argument */
      args_info->radiuslocationid_arg = 0;
    }
  if (args_info->radiuslocationid_orig)
    {
      free (args_info->radiuslocationid_orig); /* free previous argument */
      args_info->radiuslocationid_orig = 0;
    }
  if (args_info->radiuslocationname_arg)
    {
      free (args_info->radiuslocationname_arg); /* free previous argument */
      args_info->radiuslocationname_arg = 0;
    }
  if (args_info->radiuslocationname_orig)
    {
      free (args_info->radiuslocationname_orig); /* free previous argument */
      args_info->radiuslocationname_orig = 0;
    }
  if (args_info->radiusnasporttype_orig)
    {
      free (args_info->radiusnasporttype_orig); /* free previous argument */
      args_info->radiusnasporttype_orig = 0;
    }
  if (args_info->coaport_orig)
    {
      free (args_info->coaport_orig); /* free previous argument */
      args_info->coaport_orig = 0;
    }
  if (args_info->proxylisten_arg)
    {
      free (args_info->proxylisten_arg); /* free previous argument */
      args_info->proxylisten_arg = 0;
    }
  if (args_info->proxylisten_orig)
    {
      free (args_info->proxylisten_orig); /* free previous argument */
      args_info->proxylisten_orig = 0;
    }
  if (args_info->proxyport_orig)
    {
      free (args_info->proxyport_orig); /* free previous argument */
      args_info->proxyport_orig = 0;
    }
  if (args_info->proxyclient_arg)
    {
      free (args_info->proxyclient_arg); /* free previous argument */
      args_info->proxyclient_arg = 0;
    }
  if (args_info->proxyclient_orig)
    {
      free (args_info->proxyclient_orig); /* free previous argument */
      args_info->proxyclient_orig = 0;
    }
  if (args_info->proxysecret_arg)
    {
      free (args_info->proxysecret_arg); /* free previous argument */
      args_info->proxysecret_arg = 0;
    }
  if (args_info->proxysecret_orig)
    {
      free (args_info->proxysecret_orig); /* free previous argument */
      args_info->proxysecret_orig = 0;
    }
  if (args_info->dhcpif_arg)
    {
      free (args_info->dhcpif_arg); /* free previous argument */
      args_info->dhcpif_arg = 0;
    }
  if (args_info->dhcpif_orig)
    {
      free (args_info->dhcpif_orig); /* free previous argument */
      args_info->dhcpif_orig = 0;
    }
  if (args_info->dhcpmac_arg)
    {
      free (args_info->dhcpmac_arg); /* free previous argument */
      args_info->dhcpmac_arg = 0;
    }
  if (args_info->dhcpmac_orig)
    {
      free (args_info->dhcpmac_orig); /* free previous argument */
      args_info->dhcpmac_orig = 0;
    }
  if (args_info->lease_orig)
    {
      free (args_info->lease_orig); /* free previous argument */
      args_info->lease_orig = 0;
    }
  if (args_info->uamserver_arg)
    {
      free (args_info->uamserver_arg); /* free previous argument */
      args_info->uamserver_arg = 0;
    }
  if (args_info->uamserver_orig)
    {
      free (args_info->uamserver_orig); /* free previous argument */
      args_info->uamserver_orig = 0;
    }
  if (args_info->uamhomepage_arg)
    {
      free (args_info->uamhomepage_arg); /* free previous argument */
      args_info->uamhomepage_arg = 0;
    }
  if (args_info->uamhomepage_orig)
    {
      free (args_info->uamhomepage_orig); /* free previous argument */
      args_info->uamhomepage_orig = 0;
    }
  if (args_info->uamsecret_arg)
    {
      free (args_info->uamsecret_arg); /* free previous argument */
      args_info->uamsecret_arg = 0;
    }
  if (args_info->uamsecret_orig)
    {
      free (args_info->uamsecret_orig); /* free previous argument */
      args_info->uamsecret_orig = 0;
    }
  if (args_info->uamlisten_arg)
    {
      free (args_info->uamlisten_arg); /* free previous argument */
      args_info->uamlisten_arg = 0;
    }
  if (args_info->uamlisten_orig)
    {
      free (args_info->uamlisten_orig); /* free previous argument */
      args_info->uamlisten_orig = 0;
    }
  if (args_info->uamport_orig)
    {
      free (args_info->uamport_orig); /* free previous argument */
      args_info->uamport_orig = 0;
    }
  if (args_info->uamallowed_arg)
    {
      for (i = 0; i < args_info->uamallowed_given; ++i)
        {
          if (args_info->uamallowed_arg [i])
            {
              free (args_info->uamallowed_arg [i]); /* free previous argument */
              args_info->uamallowed_arg [i] = 0;
            }
          if (args_info->uamallowed_orig [i])
            {
              free (args_info->uamallowed_orig [i]); /* free previous argument */
              args_info->uamallowed_orig [i] = 0;
            }
        }
      if (args_info->uamallowed_arg [0])
        free (args_info->uamallowed_arg [0]); /* free default string */
      free (args_info->uamallowed_arg); /* free previous argument */
      args_info->uamallowed_arg = 0;
      free (args_info->uamallowed_orig); /* free previous argument */
      args_info->uamallowed_orig = 0;
    }
  if (args_info->macallowed_arg)
    {
      for (i = 0; i < args_info->macallowed_given; ++i)
        {
          if (args_info->macallowed_arg [i])
            {
              free (args_info->macallowed_arg [i]); /* free previous argument */
              args_info->macallowed_arg [i] = 0;
            }
          if (args_info->macallowed_orig [i])
            {
              free (args_info->macallowed_orig [i]); /* free previous argument */
              args_info->macallowed_orig [i] = 0;
            }
        }
      if (args_info->macallowed_arg [0])
        free (args_info->macallowed_arg [0]); /* free default string */
      free (args_info->macallowed_arg); /* free previous argument */
      args_info->macallowed_arg = 0;
      free (args_info->macallowed_orig); /* free previous argument */
      args_info->macallowed_orig = 0;
    }
  if (args_info->macsuffix_arg)
    {
      free (args_info->macsuffix_arg); /* free previous argument */
      args_info->macsuffix_arg = 0;
    }
  if (args_info->macsuffix_orig)
    {
      free (args_info->macsuffix_orig); /* free previous argument */
      args_info->macsuffix_orig = 0;
    }
  if (args_info->macpasswd_arg)
    {
      free (args_info->macpasswd_arg); /* free previous argument */
      args_info->macpasswd_arg = 0;
    }
  if (args_info->macpasswd_orig)
    {
      free (args_info->macpasswd_orig); /* free previous argument */
      args_info->macpasswd_orig = 0;
    }
  
  clear_given (args_info);
}

int
cmdline_parser_file_save(const char *filename, struct gengetopt_args_info *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  if (args_info->help_given) {
    fprintf(outfile, "%s\n", "help");
  }
  if (args_info->version_given) {
    fprintf(outfile, "%s\n", "version");
  }
  if (args_info->fg_given) {
    fprintf(outfile, "%s\n", "fg");
  }
  if (args_info->debug_given) {
    fprintf(outfile, "%s\n", "debug");
  }
  if (args_info->debugfacility_given) {
    if (args_info->debugfacility_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "debugfacility", args_info->debugfacility_orig);
    } else {
      fprintf(outfile, "%s\n", "debugfacility");
    }
  }
  if (args_info->conf_given) {
    if (args_info->conf_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "conf", args_info->conf_orig);
    } else {
      fprintf(outfile, "%s\n", "conf");
    }
  }
  if (args_info->interval_given) {
    if (args_info->interval_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "interval", args_info->interval_orig);
    } else {
      fprintf(outfile, "%s\n", "interval");
    }
  }
  if (args_info->pidfile_given) {
    if (args_info->pidfile_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "pidfile", args_info->pidfile_orig);
    } else {
      fprintf(outfile, "%s\n", "pidfile");
    }
  }
  if (args_info->statedir_given) {
    if (args_info->statedir_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "statedir", args_info->statedir_orig);
    } else {
      fprintf(outfile, "%s\n", "statedir");
    }
  }
  if (args_info->net_given) {
    if (args_info->net_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "net", args_info->net_orig);
    } else {
      fprintf(outfile, "%s\n", "net");
    }
  }
  if (args_info->dynip_given) {
    if (args_info->dynip_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "dynip", args_info->dynip_orig);
    } else {
      fprintf(outfile, "%s\n", "dynip");
    }
  }
  if (args_info->statip_given) {
    if (args_info->statip_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "statip", args_info->statip_orig);
    } else {
      fprintf(outfile, "%s\n", "statip");
    }
  }
  if (args_info->dns1_given) {
    if (args_info->dns1_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "dns1", args_info->dns1_orig);
    } else {
      fprintf(outfile, "%s\n", "dns1");
    }
  }
  if (args_info->dns2_given) {
    if (args_info->dns2_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "dns2", args_info->dns2_orig);
    } else {
      fprintf(outfile, "%s\n", "dns2");
    }
  }
  if (args_info->domain_given) {
    if (args_info->domain_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "domain", args_info->domain_orig);
    } else {
      fprintf(outfile, "%s\n", "domain");
    }
  }
  if (args_info->ipup_given) {
    if (args_info->ipup_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "ipup", args_info->ipup_orig);
    } else {
      fprintf(outfile, "%s\n", "ipup");
    }
  }
  if (args_info->ipdown_given) {
    if (args_info->ipdown_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "ipdown", args_info->ipdown_orig);
    } else {
      fprintf(outfile, "%s\n", "ipdown");
    }
  }
  if (args_info->radiuslisten_given) {
    if (args_info->radiuslisten_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "radiuslisten", args_info->radiuslisten_orig);
    } else {
      fprintf(outfile, "%s\n", "radiuslisten");
    }
  }
  if (args_info->radiusserver1_given) {
    if (args_info->radiusserver1_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "radiusserver1", args_info->radiusserver1_orig);
    } else {
      fprintf(outfile, "%s\n", "radiusserver1");
    }
  }
  if (args_info->radiusserver2_given) {
    if (args_info->radiusserver2_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "radiusserver2", args_info->radiusserver2_orig);
    } else {
      fprintf(outfile, "%s\n", "radiusserver2");
    }
  }
  if (args_info->radiusauthport_given) {
    if (args_info->radiusauthport_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "radiusauthport", args_info->radiusauthport_orig);
    } else {
      fprintf(outfile, "%s\n", "radiusauthport");
    }
  }
  if (args_info->radiusacctport_given) {
    if (args_info->radiusacctport_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "radiusacctport", args_info->radiusacctport_orig);
    } else {
      fprintf(outfile, "%s\n", "radiusacctport");
    }
  }
  if (args_info->radiussecret_given) {
    if (args_info->radiussecret_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "radiussecret", args_info->radiussecret_orig);
    } else {
      fprintf(outfile, "%s\n", "radiussecret");
    }
  }
  if (args_info->radiusnasid_given) {
    if (args_info->radiusnasid_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "radiusnasid", args_info->radiusnasid_orig);
    } else {
      fprintf(outfile, "%s\n", "radiusnasid");
    }
  }
  if (args_info->radiuslocationid_given) {
    if (args_info->radiuslocationid_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "radiuslocationid", args_info->radiuslocationid_orig);
    } else {
      fprintf(outfile, "%s\n", "radiuslocationid");
    }
  }
  if (args_info->radiuslocationname_given) {
    if (args_info->radiuslocationname_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "radiuslocationname", args_info->radiuslocationname_orig);
    } else {
      fprintf(outfile, "%s\n", "radiuslocationname");
    }
  }
  if (args_info->radiusnasporttype_given) {
    if (args_info->radiusnasporttype_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "radiusnasporttype", args_info->radiusnasporttype_orig);
    } else {
      fprintf(outfile, "%s\n", "radiusnasporttype");
    }
  }
  if (args_info->coaport_given) {
    if (args_info->coaport_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "coaport", args_info->coaport_orig);
    } else {
      fprintf(outfile, "%s\n", "coaport");
    }
  }
  if (args_info->coanoipcheck_given) {
    fprintf(outfile, "%s\n", "coanoipcheck");
  }
  if (args_info->proxylisten_given) {
    if (args_info->proxylisten_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "proxylisten", args_info->proxylisten_orig);
    } else {
      fprintf(outfile, "%s\n", "proxylisten");
    }
  }
  if (args_info->proxyport_given) {
    if (args_info->proxyport_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "proxyport", args_info->proxyport_orig);
    } else {
      fprintf(outfile, "%s\n", "proxyport");
    }
  }
  if (args_info->proxyclient_given) {
    if (args_info->proxyclient_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "proxyclient", args_info->proxyclient_orig);
    } else {
      fprintf(outfile, "%s\n", "proxyclient");
    }
  }
  if (args_info->proxysecret_given) {
    if (args_info->proxysecret_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "proxysecret", args_info->proxysecret_orig);
    } else {
      fprintf(outfile, "%s\n", "proxysecret");
    }
  }
  if (args_info->dhcpif_given) {
    if (args_info->dhcpif_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "dhcpif", args_info->dhcpif_orig);
    } else {
      fprintf(outfile, "%s\n", "dhcpif");
    }
  }
  if (args_info->dhcpmac_given) {
    if (args_info->dhcpmac_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "dhcpmac", args_info->dhcpmac_orig);
    } else {
      fprintf(outfile, "%s\n", "dhcpmac");
    }
  }
  if (args_info->lease_given) {
    if (args_info->lease_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "lease", args_info->lease_orig);
    } else {
      fprintf(outfile, "%s\n", "lease");
    }
  }
  if (args_info->eapolenable_given) {
    fprintf(outfile, "%s\n", "eapolenable");
  }
  if (args_info->uamserver_given) {
    if (args_info->uamserver_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "uamserver", args_info->uamserver_orig);
    } else {
      fprintf(outfile, "%s\n", "uamserver");
    }
  }
  if (args_info->uamhomepage_given) {
    if (args_info->uamhomepage_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "uamhomepage", args_info->uamhomepage_orig);
    } else {
      fprintf(outfile, "%s\n", "uamhomepage");
    }
  }
  if (args_info->uamsecret_given) {
    if (args_info->uamsecret_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "uamsecret", args_info->uamsecret_orig);
    } else {
      fprintf(outfile, "%s\n", "uamsecret");
    }
  }
  if (args_info->uamlisten_given) {
    if (args_info->uamlisten_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "uamlisten", args_info->uamlisten_orig);
    } else {
      fprintf(outfile, "%s\n", "uamlisten");
    }
  }
  if (args_info->uamport_given) {
    if (args_info->uamport_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "uamport", args_info->uamport_orig);
    } else {
      fprintf(outfile, "%s\n", "uamport");
    }
  }
  if (args_info->uamallowed_orig)
    {
      for (i = 0; i < args_info->uamallowed_given; ++i)
        {
          if (args_info->uamallowed_orig [i])
            {
              fprintf(outfile, "%s=\"%s\"\n", "uamallowed", args_info->uamallowed_orig [i]);
            }
        }
    }
  if (args_info->uamanydns_given) {
    fprintf(outfile, "%s\n", "uamanydns");
  }
  if (args_info->macauth_given) {
    fprintf(outfile, "%s\n", "macauth");
  }
  if (args_info->macallowed_orig)
    {
      for (i = 0; i < args_info->macallowed_given; ++i)
        {
          if (args_info->macallowed_orig [i])
            {
              fprintf(outfile, "%s=\"%s\"\n", "macallowed", args_info->macallowed_orig [i]);
            }
        }
    }
  if (args_info->macsuffix_given) {
    if (args_info->macsuffix_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "macsuffix", args_info->macsuffix_orig);
    } else {
      fprintf(outfile, "%s\n", "macsuffix");
    }
  }
  if (args_info->macpasswd_given) {
    if (args_info->macpasswd_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "macpasswd", args_info->macpasswd_orig);
    } else {
      fprintf(outfile, "%s\n", "macpasswd");
    }
  }
  
  fclose (outfile);

  i = EXIT_SUCCESS;
  return i;
}

void
cmdline_parser_free (struct gengetopt_args_info *args_info)
{
  cmdline_parser_release (args_info);
  if (cmd_line_list)
    {
      /* free the list of a previous call */
      while (cmd_line_list) {
        cmd_line_list_tmp = cmd_line_list;
        cmd_line_list = cmd_line_list->next;
        free (cmd_line_list_tmp->string_arg);
        free (cmd_line_list_tmp);
      }
    }
}


/* gengetopt_strdup() */
/* strdup.c replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = NULL;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

static char *
get_multiple_arg_token(const char *arg)
{
  char *tok, *ret;
  size_t len;

  if (!arg)
    return NULL;

  tok = strchr (arg, ',');

  if (tok)
    len = (size_t)(tok - arg + 1);
  else
    len = strlen (arg) + 1;

  ret = (char *) malloc (len);
  strncpy (ret, arg, len-1);
  ret[len-1] = '\0';

  return ret;
}

static char *
get_multiple_arg_token_next(const char *arg)
{
  char *tok;

  if (!arg)
    return NULL;

  tok = strchr (arg, ',');

  if (! tok || strlen(tok) == 1)
    return 0;

  return tok+1;
}

int
cmdline_parser (int argc, char * const *argv, struct gengetopt_args_info *args_info)
{
  return cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
cmdline_parser2 (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;

  result = cmdline_parser_internal (argc, argv, args_info, override, initialize, check_required, NULL);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser_required (struct gengetopt_args_info *args_info, const char *prog_name)
{
  return EXIT_SUCCESS;
}

int
cmdline_parser_internal (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */
  char *multi_token, *multi_next; /* for multiple options */

  int i;        /* Counter */

  struct uamallowed_list * uamallowed_list = NULL,* uamallowed_new = NULL;
  struct macallowed_list * macallowed_list = NULL,* macallowed_new = NULL;
  int error = 0;
  struct gengetopt_args_info local_args_info;

  if (initialize)
    cmdline_parser_init (args_info);

  cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 1;
  opterr = 1;
  optopt = '?';

  while (1)
    {
      int option_index = 0;
      char *stop_char;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "fg",	0, NULL, 'f' },
        { "debug",	0, NULL, 'd' },
        { "debugfacility",	1, NULL, 0 },
        { "conf",	1, NULL, 'c' },
        { "interval",	1, NULL, 0 },
        { "pidfile",	1, NULL, 0 },
        { "statedir",	1, NULL, 0 },
        { "net",	1, NULL, 'n' },
        { "dynip",	1, NULL, 0 },
        { "statip",	1, NULL, 0 },
        { "dns1",	1, NULL, 0 },
        { "dns2",	1, NULL, 0 },
        { "domain",	1, NULL, 0 },
        { "ipup",	1, NULL, 0 },
        { "ipdown",	1, NULL, 0 },
        { "radiuslisten",	1, NULL, 0 },
        { "radiusserver1",	1, NULL, 0 },
        { "radiusserver2",	1, NULL, 0 },
        { "radiusauthport",	1, NULL, 0 },
        { "radiusacctport",	1, NULL, 0 },
        { "radiussecret",	1, NULL, 0 },
        { "radiusnasid",	1, NULL, 0 },
        { "radiuslocationid",	1, NULL, 0 },
        { "radiuslocationname",	1, NULL, 0 },
        { "radiusnasporttype",	1, NULL, 0 },
        { "coaport",	1, NULL, 0 },
        { "coanoipcheck",	0, NULL, 0 },
        { "proxylisten",	1, NULL, 0 },
        { "proxyport",	1, NULL, 0 },
        { "proxyclient",	1, NULL, 0 },
        { "proxysecret",	1, NULL, 0 },
        { "dhcpif",	1, NULL, 0 },
        { "dhcpmac",	1, NULL, 0 },
        { "lease",	1, NULL, 0 },
        { "eapolenable",	0, NULL, 0 },
        { "uamserver",	1, NULL, 0 },
        { "uamhomepage",	1, NULL, 0 },
        { "uamsecret",	1, NULL, 0 },
        { "uamlisten",	1, NULL, 0 },
        { "uamport",	1, NULL, 0 },
        { "uamallowed",	1, NULL, 0 },
        { "uamanydns",	0, NULL, 0 },
        { "macauth",	0, NULL, 0 },
        { "macallowed",	1, NULL, 0 },
        { "macsuffix",	1, NULL, 0 },
        { "macpasswd",	1, NULL, 0 },
        { NULL,	0, NULL, 0 }
      };

      stop_char = 0;
      c = getopt_long (argc, argv, "hVfdc:n:", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          cmdline_parser_print_help ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          cmdline_parser_print_version ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'f':	/* Run in foreground.  */
          if (local_args_info.fg_given)
            {
              fprintf (stderr, "%s: `--fg' (`-f') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->fg_given && ! override)
            continue;
          local_args_info.fg_given = 1;
          args_info->fg_given = 1;
          args_info->fg_flag = !(args_info->fg_flag);
          break;

        case 'd':	/* Run in debug mode.  */
          if (local_args_info.debug_given)
            {
              fprintf (stderr, "%s: `--debug' (`-d') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->debug_given && ! override)
            continue;
          local_args_info.debug_given = 1;
          args_info->debug_given = 1;
          args_info->debug_flag = !(args_info->debug_flag);
          break;

        case 'c':	/* Read configuration file.  */
          if (local_args_info.conf_given)
            {
              fprintf (stderr, "%s: `--conf' (`-c') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->conf_given && ! override)
            continue;
          local_args_info.conf_given = 1;
          args_info->conf_given = 1;
          if (args_info->conf_arg)
            free (args_info->conf_arg); /* free previous string */
          args_info->conf_arg = gengetopt_strdup (optarg);
          if (args_info->conf_orig)
            free (args_info->conf_orig); /* free previous string */
          args_info->conf_orig = gengetopt_strdup (optarg);
          break;

        case 'n':	/* Network.  */
          if (local_args_info.net_given)
            {
              fprintf (stderr, "%s: `--net' (`-n') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->net_given && ! override)
            continue;
          local_args_info.net_given = 1;
          args_info->net_given = 1;
          if (args_info->net_arg)
            free (args_info->net_arg); /* free previous string */
          args_info->net_arg = gengetopt_strdup (optarg);
          if (args_info->net_orig)
            free (args_info->net_orig); /* free previous string */
          args_info->net_orig = gengetopt_strdup (optarg);
          break;


        case 0:	/* Long option with no short option */
          /* Which modules to print debug messages for.  */
          if (strcmp (long_options[option_index].name, "debugfacility") == 0)
          {
            if (local_args_info.debugfacility_given)
              {
                fprintf (stderr, "%s: `--debugfacility' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->debugfacility_given && ! override)
              continue;
            local_args_info.debugfacility_given = 1;
            args_info->debugfacility_given = 1;
            args_info->debugfacility_arg = strtol (optarg,&stop_char,0);
            if (args_info->debugfacility_orig)
              free (args_info->debugfacility_orig); /* free previous string */
            args_info->debugfacility_orig = gengetopt_strdup (optarg);
          }
          /* Re-read configuration file at this interval.  */
          else if (strcmp (long_options[option_index].name, "interval") == 0)
          {
            if (local_args_info.interval_given)
              {
                fprintf (stderr, "%s: `--interval' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->interval_given && ! override)
              continue;
            local_args_info.interval_given = 1;
            args_info->interval_given = 1;
            args_info->interval_arg = strtol (optarg,&stop_char,0);
            if (args_info->interval_orig)
              free (args_info->interval_orig); /* free previous string */
            args_info->interval_orig = gengetopt_strdup (optarg);
          }
          /* Filename of process id file.  */
          else if (strcmp (long_options[option_index].name, "pidfile") == 0)
          {
            if (local_args_info.pidfile_given)
              {
                fprintf (stderr, "%s: `--pidfile' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->pidfile_given && ! override)
              continue;
            local_args_info.pidfile_given = 1;
            args_info->pidfile_given = 1;
            if (args_info->pidfile_arg)
              free (args_info->pidfile_arg); /* free previous string */
            args_info->pidfile_arg = gengetopt_strdup (optarg);
            if (args_info->pidfile_orig)
              free (args_info->pidfile_orig); /* free previous string */
            args_info->pidfile_orig = gengetopt_strdup (optarg);
          }
          /* Directory of nonvolatile data.  */
          else if (strcmp (long_options[option_index].name, "statedir") == 0)
          {
            if (local_args_info.statedir_given)
              {
                fprintf (stderr, "%s: `--statedir' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->statedir_given && ! override)
              continue;
            local_args_info.statedir_given = 1;
            args_info->statedir_given = 1;
            if (args_info->statedir_arg)
              free (args_info->statedir_arg); /* free previous string */
            args_info->statedir_arg = gengetopt_strdup (optarg);
            if (args_info->statedir_orig)
              free (args_info->statedir_orig); /* free previous string */
            args_info->statedir_orig = gengetopt_strdup (optarg);
          }
          /* Dynamic IP address pool.  */
          else if (strcmp (long_options[option_index].name, "dynip") == 0)
          {
            if (local_args_info.dynip_given)
              {
                fprintf (stderr, "%s: `--dynip' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->dynip_given && ! override)
              continue;
            local_args_info.dynip_given = 1;
            args_info->dynip_given = 1;
            if (args_info->dynip_arg)
              free (args_info->dynip_arg); /* free previous string */
            args_info->dynip_arg = gengetopt_strdup (optarg);
            if (args_info->dynip_orig)
              free (args_info->dynip_orig); /* free previous string */
            args_info->dynip_orig = gengetopt_strdup (optarg);
          }
          /* Static IP address pool.  */
          else if (strcmp (long_options[option_index].name, "statip") == 0)
          {
            if (local_args_info.statip_given)
              {
                fprintf (stderr, "%s: `--statip' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->statip_given && ! override)
              continue;
            local_args_info.statip_given = 1;
            args_info->statip_given = 1;
            if (args_info->statip_arg)
              free (args_info->statip_arg); /* free previous string */
            args_info->statip_arg = gengetopt_strdup (optarg);
            if (args_info->statip_orig)
              free (args_info->statip_orig); /* free previous string */
            args_info->statip_orig = gengetopt_strdup (optarg);
          }
          /* Primary DNS server IP address.  */
          else if (strcmp (long_options[option_index].name, "dns1") == 0)
          {
            if (local_args_info.dns1_given)
              {
                fprintf (stderr, "%s: `--dns1' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->dns1_given && ! override)
              continue;
            local_args_info.dns1_given = 1;
            args_info->dns1_given = 1;
            if (args_info->dns1_arg)
              free (args_info->dns1_arg); /* free previous string */
            args_info->dns1_arg = gengetopt_strdup (optarg);
            if (args_info->dns1_orig)
              free (args_info->dns1_orig); /* free previous string */
            args_info->dns1_orig = gengetopt_strdup (optarg);
          }
          /* Secondary DNS server IP address.  */
          else if (strcmp (long_options[option_index].name, "dns2") == 0)
          {
            if (local_args_info.dns2_given)
              {
                fprintf (stderr, "%s: `--dns2' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->dns2_given && ! override)
              continue;
            local_args_info.dns2_given = 1;
            args_info->dns2_given = 1;
            if (args_info->dns2_arg)
              free (args_info->dns2_arg); /* free previous string */
            args_info->dns2_arg = gengetopt_strdup (optarg);
            if (args_info->dns2_orig)
              free (args_info->dns2_orig); /* free previous string */
            args_info->dns2_orig = gengetopt_strdup (optarg);
          }
          /* Domain to use for DNS lookups.  */
          else if (strcmp (long_options[option_index].name, "domain") == 0)
          {
            if (local_args_info.domain_given)
              {
                fprintf (stderr, "%s: `--domain' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->domain_given && ! override)
              continue;
            local_args_info.domain_given = 1;
            args_info->domain_given = 1;
            if (args_info->domain_arg)
              free (args_info->domain_arg); /* free previous string */
            args_info->domain_arg = gengetopt_strdup (optarg);
            if (args_info->domain_orig)
              free (args_info->domain_orig); /* free previous string */
            args_info->domain_orig = gengetopt_strdup (optarg);
          }
          /* Script to run after link-up.  */
          else if (strcmp (long_options[option_index].name, "ipup") == 0)
          {
            if (local_args_info.ipup_given)
              {
                fprintf (stderr, "%s: `--ipup' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->ipup_given && ! override)
              continue;
            local_args_info.ipup_given = 1;
            args_info->ipup_given = 1;
            if (args_info->ipup_arg)
              free (args_info->ipup_arg); /* free previous string */
            args_info->ipup_arg = gengetopt_strdup (optarg);
            if (args_info->ipup_orig)
              free (args_info->ipup_orig); /* free previous string */
            args_info->ipup_orig = gengetopt_strdup (optarg);
          }
          /* Script to run after link-down.  */
          else if (strcmp (long_options[option_index].name, "ipdown") == 0)
          {
            if (local_args_info.ipdown_given)
              {
                fprintf (stderr, "%s: `--ipdown' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->ipdown_given && ! override)
              continue;
            local_args_info.ipdown_given = 1;
            args_info->ipdown_given = 1;
            if (args_info->ipdown_arg)
              free (args_info->ipdown_arg); /* free previous string */
            args_info->ipdown_arg = gengetopt_strdup (optarg);
            if (args_info->ipdown_orig)
              free (args_info->ipdown_orig); /* free previous string */
            args_info->ipdown_orig = gengetopt_strdup (optarg);
          }
          /* IP address to send from.  */
          else if (strcmp (long_options[option_index].name, "radiuslisten") == 0)
          {
            if (local_args_info.radiuslisten_given)
              {
                fprintf (stderr, "%s: `--radiuslisten' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->radiuslisten_given && ! override)
              continue;
            local_args_info.radiuslisten_given = 1;
            args_info->radiuslisten_given = 1;
            if (args_info->radiuslisten_arg)
              free (args_info->radiuslisten_arg); /* free previous string */
            args_info->radiuslisten_arg = gengetopt_strdup (optarg);
            if (args_info->radiuslisten_orig)
              free (args_info->radiuslisten_orig); /* free previous string */
            args_info->radiuslisten_orig = gengetopt_strdup (optarg);
          }
          /* IP address of radius server 1.  */
          else if (strcmp (long_options[option_index].name, "radiusserver1") == 0)
          {
            if (local_args_info.radiusserver1_given)
              {
                fprintf (stderr, "%s: `--radiusserver1' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->radiusserver1_given && ! override)
              continue;
            local_args_info.radiusserver1_given = 1;
            args_info->radiusserver1_given = 1;
            if (args_info->radiusserver1_arg)
              free (args_info->radiusserver1_arg); /* free previous string */
            args_info->radiusserver1_arg = gengetopt_strdup (optarg);
            if (args_info->radiusserver1_orig)
              free (args_info->radiusserver1_orig); /* free previous string */
            args_info->radiusserver1_orig = gengetopt_strdup (optarg);
          }
          /* IP address of radius server 2.  */
          else if (strcmp (long_options[option_index].name, "radiusserver2") == 0)
          {
            if (local_args_info.radiusserver2_given)
              {
                fprintf (stderr, "%s: `--radiusserver2' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->radiusserver2_given && ! override)
              continue;
            local_args_info.radiusserver2_given = 1;
            args_info->radiusserver2_given = 1;
            if (args_info->radiusserver2_arg)
              free (args_info->radiusserver2_arg); /* free previous string */
            args_info->radiusserver2_arg = gengetopt_strdup (optarg);
            if (args_info->radiusserver2_orig)
              free (args_info->radiusserver2_orig); /* free previous string */
            args_info->radiusserver2_orig = gengetopt_strdup (optarg);
          }
          /* Authentication UDP port of radius server.  */
          else if (strcmp (long_options[option_index].name, "radiusauthport") == 0)
          {
            if (local_args_info.radiusauthport_given)
              {
                fprintf (stderr, "%s: `--radiusauthport' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->radiusauthport_given && ! override)
              continue;
            local_args_info.radiusauthport_given = 1;
            args_info->radiusauthport_given = 1;
            args_info->radiusauthport_arg = strtol (optarg,&stop_char,0);
            if (args_info->radiusauthport_orig)
              free (args_info->radiusauthport_orig); /* free previous string */
            args_info->radiusauthport_orig = gengetopt_strdup (optarg);
          }
          /* Accounting UDP port of radius server.  */
          else if (strcmp (long_options[option_index].name, "radiusacctport") == 0)
          {
            if (local_args_info.radiusacctport_given)
              {
                fprintf (stderr, "%s: `--radiusacctport' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->radiusacctport_given && ! override)
              continue;
            local_args_info.radiusacctport_given = 1;
            args_info->radiusacctport_given = 1;
            args_info->radiusacctport_arg = strtol (optarg,&stop_char,0);
            if (args_info->radiusacctport_orig)
              free (args_info->radiusacctport_orig); /* free previous string */
            args_info->radiusacctport_orig = gengetopt_strdup (optarg);
          }
          /* Radius shared secret.  */
          else if (strcmp (long_options[option_index].name, "radiussecret") == 0)
          {
            if (local_args_info.radiussecret_given)
              {
                fprintf (stderr, "%s: `--radiussecret' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->radiussecret_given && ! override)
              continue;
            local_args_info.radiussecret_given = 1;
            args_info->radiussecret_given = 1;
            if (args_info->radiussecret_arg)
              free (args_info->radiussecret_arg); /* free previous string */
            args_info->radiussecret_arg = gengetopt_strdup (optarg);
            if (args_info->radiussecret_orig)
              free (args_info->radiussecret_orig); /* free previous string */
            args_info->radiussecret_orig = gengetopt_strdup (optarg);
          }
          /* Radius NAS-Identifier.  */
          else if (strcmp (long_options[option_index].name, "radiusnasid") == 0)
          {
            if (local_args_info.radiusnasid_given)
              {
                fprintf (stderr, "%s: `--radiusnasid' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->radiusnasid_given && ! override)
              continue;
            local_args_info.radiusnasid_given = 1;
            args_info->radiusnasid_given = 1;
            if (args_info->radiusnasid_arg)
              free (args_info->radiusnasid_arg); /* free previous string */
            args_info->radiusnasid_arg = gengetopt_strdup (optarg);
            if (args_info->radiusnasid_orig)
              free (args_info->radiusnasid_orig); /* free previous string */
            args_info->radiusnasid_orig = gengetopt_strdup (optarg);
          }
          /* WISPr Location ID.  */
          else if (strcmp (long_options[option_index].name, "radiuslocationid") == 0)
          {
            if (local_args_info.radiuslocationid_given)
              {
                fprintf (stderr, "%s: `--radiuslocationid' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->radiuslocationid_given && ! override)
              continue;
            local_args_info.radiuslocationid_given = 1;
            args_info->radiuslocationid_given = 1;
            if (args_info->radiuslocationid_arg)
              free (args_info->radiuslocationid_arg); /* free previous string */
            args_info->radiuslocationid_arg = gengetopt_strdup (optarg);
            if (args_info->radiuslocationid_orig)
              free (args_info->radiuslocationid_orig); /* free previous string */
            args_info->radiuslocationid_orig = gengetopt_strdup (optarg);
          }
          /* WISPr Location Name.  */
          else if (strcmp (long_options[option_index].name, "radiuslocationname") == 0)
          {
            if (local_args_info.radiuslocationname_given)
              {
                fprintf (stderr, "%s: `--radiuslocationname' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->radiuslocationname_given && ! override)
              continue;
            local_args_info.radiuslocationname_given = 1;
            args_info->radiuslocationname_given = 1;
            if (args_info->radiuslocationname_arg)
              free (args_info->radiuslocationname_arg); /* free previous string */
            args_info->radiuslocationname_arg = gengetopt_strdup (optarg);
            if (args_info->radiuslocationname_orig)
              free (args_info->radiuslocationname_orig); /* free previous string */
            args_info->radiuslocationname_orig = gengetopt_strdup (optarg);
          }
          /* Radius NAS-Port-Type.  */
          else if (strcmp (long_options[option_index].name, "radiusnasporttype") == 0)
          {
            if (local_args_info.radiusnasporttype_given)
              {
                fprintf (stderr, "%s: `--radiusnasporttype' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->radiusnasporttype_given && ! override)
              continue;
            local_args_info.radiusnasporttype_given = 1;
            args_info->radiusnasporttype_given = 1;
            args_info->radiusnasporttype_arg = strtol (optarg,&stop_char,0);
            if (args_info->radiusnasporttype_orig)
              free (args_info->radiusnasporttype_orig); /* free previous string */
            args_info->radiusnasporttype_orig = gengetopt_strdup (optarg);
          }
          /* Radius disconnect port to listen to.  */
          else if (strcmp (long_options[option_index].name, "coaport") == 0)
          {
            if (local_args_info.coaport_given)
              {
                fprintf (stderr, "%s: `--coaport' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->coaport_given && ! override)
              continue;
            local_args_info.coaport_given = 1;
            args_info->coaport_given = 1;
            args_info->coaport_arg = strtol (optarg,&stop_char,0);
            if (args_info->coaport_orig)
              free (args_info->coaport_orig); /* free previous string */
            args_info->coaport_orig = gengetopt_strdup (optarg);
          }
          /* Allow radius disconnect from any IP.  */
          else if (strcmp (long_options[option_index].name, "coanoipcheck") == 0)
          {
            if (local_args_info.coanoipcheck_given)
              {
                fprintf (stderr, "%s: `--coanoipcheck' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->coanoipcheck_given && ! override)
              continue;
            local_args_info.coanoipcheck_given = 1;
            args_info->coanoipcheck_given = 1;
            args_info->coanoipcheck_flag = !(args_info->coanoipcheck_flag);
          }
          /* IP address to listen to.  */
          else if (strcmp (long_options[option_index].name, "proxylisten") == 0)
          {
            if (local_args_info.proxylisten_given)
              {
                fprintf (stderr, "%s: `--proxylisten' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->proxylisten_given && ! override)
              continue;
            local_args_info.proxylisten_given = 1;
            args_info->proxylisten_given = 1;
            if (args_info->proxylisten_arg)
              free (args_info->proxylisten_arg); /* free previous string */
            args_info->proxylisten_arg = gengetopt_strdup (optarg);
            if (args_info->proxylisten_orig)
              free (args_info->proxylisten_orig); /* free previous string */
            args_info->proxylisten_orig = gengetopt_strdup (optarg);
          }
          /* UDP port to listen to.  */
          else if (strcmp (long_options[option_index].name, "proxyport") == 0)
          {
            if (local_args_info.proxyport_given)
              {
                fprintf (stderr, "%s: `--proxyport' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->proxyport_given && ! override)
              continue;
            local_args_info.proxyport_given = 1;
            args_info->proxyport_given = 1;
            args_info->proxyport_arg = strtol (optarg,&stop_char,0);
            if (args_info->proxyport_orig)
              free (args_info->proxyport_orig); /* free previous string */
            args_info->proxyport_orig = gengetopt_strdup (optarg);
          }
          /* IP address of proxy client(s).  */
          else if (strcmp (long_options[option_index].name, "proxyclient") == 0)
          {
            if (local_args_info.proxyclient_given)
              {
                fprintf (stderr, "%s: `--proxyclient' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->proxyclient_given && ! override)
              continue;
            local_args_info.proxyclient_given = 1;
            args_info->proxyclient_given = 1;
            if (args_info->proxyclient_arg)
              free (args_info->proxyclient_arg); /* free previous string */
            args_info->proxyclient_arg = gengetopt_strdup (optarg);
            if (args_info->proxyclient_orig)
              free (args_info->proxyclient_orig); /* free previous string */
            args_info->proxyclient_orig = gengetopt_strdup (optarg);
          }
          /* Radius proxy shared secret.  */
          else if (strcmp (long_options[option_index].name, "proxysecret") == 0)
          {
            if (local_args_info.proxysecret_given)
              {
                fprintf (stderr, "%s: `--proxysecret' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->proxysecret_given && ! override)
              continue;
            local_args_info.proxysecret_given = 1;
            args_info->proxysecret_given = 1;
            if (args_info->proxysecret_arg)
              free (args_info->proxysecret_arg); /* free previous string */
            args_info->proxysecret_arg = gengetopt_strdup (optarg);
            if (args_info->proxysecret_orig)
              free (args_info->proxysecret_orig); /* free previous string */
            args_info->proxysecret_orig = gengetopt_strdup (optarg);
          }
          /* Local Ethernet interface.  */
          else if (strcmp (long_options[option_index].name, "dhcpif") == 0)
          {
            if (local_args_info.dhcpif_given)
              {
                fprintf (stderr, "%s: `--dhcpif' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->dhcpif_given && ! override)
              continue;
            local_args_info.dhcpif_given = 1;
            args_info->dhcpif_given = 1;
            if (args_info->dhcpif_arg)
              free (args_info->dhcpif_arg); /* free previous string */
            args_info->dhcpif_arg = gengetopt_strdup (optarg);
            if (args_info->dhcpif_orig)
              free (args_info->dhcpif_orig); /* free previous string */
            args_info->dhcpif_orig = gengetopt_strdup (optarg);
          }
          /* Interface MAC address.  */
          else if (strcmp (long_options[option_index].name, "dhcpmac") == 0)
          {
            if (local_args_info.dhcpmac_given)
              {
                fprintf (stderr, "%s: `--dhcpmac' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->dhcpmac_given && ! override)
              continue;
            local_args_info.dhcpmac_given = 1;
            args_info->dhcpmac_given = 1;
            if (args_info->dhcpmac_arg)
              free (args_info->dhcpmac_arg); /* free previous string */
            args_info->dhcpmac_arg = gengetopt_strdup (optarg);
            if (args_info->dhcpmac_orig)
              free (args_info->dhcpmac_orig); /* free previous string */
            args_info->dhcpmac_orig = gengetopt_strdup (optarg);
          }
          /* Lease time to allocate to clients.  */
          else if (strcmp (long_options[option_index].name, "lease") == 0)
          {
            if (local_args_info.lease_given)
              {
                fprintf (stderr, "%s: `--lease' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->lease_given && ! override)
              continue;
            local_args_info.lease_given = 1;
            args_info->lease_given = 1;
            args_info->lease_arg = strtol (optarg,&stop_char,0);
            if (args_info->lease_orig)
              free (args_info->lease_orig); /* free previous string */
            args_info->lease_orig = gengetopt_strdup (optarg);
          }
          /* Enable IEEE 802.1x authentication.  */
          else if (strcmp (long_options[option_index].name, "eapolenable") == 0)
          {
            if (local_args_info.eapolenable_given)
              {
                fprintf (stderr, "%s: `--eapolenable' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->eapolenable_given && ! override)
              continue;
            local_args_info.eapolenable_given = 1;
            args_info->eapolenable_given = 1;
            args_info->eapolenable_flag = !(args_info->eapolenable_flag);
          }
          /* URL of authentication web server.  */
          else if (strcmp (long_options[option_index].name, "uamserver") == 0)
          {
            if (local_args_info.uamserver_given)
              {
                fprintf (stderr, "%s: `--uamserver' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->uamserver_given && ! override)
              continue;
            local_args_info.uamserver_given = 1;
            args_info->uamserver_given = 1;
            if (args_info->uamserver_arg)
              free (args_info->uamserver_arg); /* free previous string */
            args_info->uamserver_arg = gengetopt_strdup (optarg);
            if (args_info->uamserver_orig)
              free (args_info->uamserver_orig); /* free previous string */
            args_info->uamserver_orig = gengetopt_strdup (optarg);
          }
          /* URL of homepage to redirect unauthenticated users to.  */
          else if (strcmp (long_options[option_index].name, "uamhomepage") == 0)
          {
            if (local_args_info.uamhomepage_given)
              {
                fprintf (stderr, "%s: `--uamhomepage' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->uamhomepage_given && ! override)
              continue;
            local_args_info.uamhomepage_given = 1;
            args_info->uamhomepage_given = 1;
            if (args_info->uamhomepage_arg)
              free (args_info->uamhomepage_arg); /* free previous string */
            args_info->uamhomepage_arg = gengetopt_strdup (optarg);
            if (args_info->uamhomepage_orig)
              free (args_info->uamhomepage_orig); /* free previous string */
            args_info->uamhomepage_orig = gengetopt_strdup (optarg);
          }
          /* Shared secret between uamserver and chilli.  */
          else if (strcmp (long_options[option_index].name, "uamsecret") == 0)
          {
            if (local_args_info.uamsecret_given)
              {
                fprintf (stderr, "%s: `--uamsecret' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->uamsecret_given && ! override)
              continue;
            local_args_info.uamsecret_given = 1;
            args_info->uamsecret_given = 1;
            if (args_info->uamsecret_arg)
              free (args_info->uamsecret_arg); /* free previous string */
            args_info->uamsecret_arg = gengetopt_strdup (optarg);
            if (args_info->uamsecret_orig)
              free (args_info->uamsecret_orig); /* free previous string */
            args_info->uamsecret_orig = gengetopt_strdup (optarg);
          }
          /* IP address to listen to for authentication requests.  */
          else if (strcmp (long_options[option_index].name, "uamlisten") == 0)
          {
            if (local_args_info.uamlisten_given)
              {
                fprintf (stderr, "%s: `--uamlisten' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->uamlisten_given && ! override)
              continue;
            local_args_info.uamlisten_given = 1;
            args_info->uamlisten_given = 1;
            if (args_info->uamlisten_arg)
              free (args_info->uamlisten_arg); /* free previous string */
            args_info->uamlisten_arg = gengetopt_strdup (optarg);
            if (args_info->uamlisten_orig)
              free (args_info->uamlisten_orig); /* free previous string */
            args_info->uamlisten_orig = gengetopt_strdup (optarg);
          }
          /* TCP port to bind to for authentication requests.  */
          else if (strcmp (long_options[option_index].name, "uamport") == 0)
          {
            if (local_args_info.uamport_given)
              {
                fprintf (stderr, "%s: `--uamport' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->uamport_given && ! override)
              continue;
            local_args_info.uamport_given = 1;
            args_info->uamport_given = 1;
            args_info->uamport_arg = strtol (optarg,&stop_char,0);
            if (args_info->uamport_orig)
              free (args_info->uamport_orig); /* free previous string */
            args_info->uamport_orig = gengetopt_strdup (optarg);
          }
          /* Domain names exempt from access check .  */
          else if (strcmp (long_options[option_index].name, "uamallowed") == 0)
          {
            local_args_info.uamallowed_given++;
          
            multi_token = get_multiple_arg_token(optarg);
            multi_next = get_multiple_arg_token_next (optarg);
          
            while (1)
              {
                uamallowed_new = (struct uamallowed_list *) malloc (sizeof (struct uamallowed_list));
                uamallowed_new->next = uamallowed_list;
                uamallowed_list = uamallowed_new;
                uamallowed_new->uamallowed_arg = multi_token;
                uamallowed_new->uamallowed_orig = gengetopt_strdup (multi_token);
          
                if (multi_next)
                  {
                    multi_token = get_multiple_arg_token(multi_next);
                    multi_next = get_multiple_arg_token_next (multi_next);
                    local_args_info.uamallowed_given++;
                  }
                else
                  break;
              }
            break;
          }
          /* Allow client to use any DNS server.  */
          else if (strcmp (long_options[option_index].name, "uamanydns") == 0)
          {
            if (local_args_info.uamanydns_given)
              {
                fprintf (stderr, "%s: `--uamanydns' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->uamanydns_given && ! override)
              continue;
            local_args_info.uamanydns_given = 1;
            args_info->uamanydns_given = 1;
            args_info->uamanydns_flag = !(args_info->uamanydns_flag);
          }
          /* Authenticate based on MAC address.  */
          else if (strcmp (long_options[option_index].name, "macauth") == 0)
          {
            if (local_args_info.macauth_given)
              {
                fprintf (stderr, "%s: `--macauth' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->macauth_given && ! override)
              continue;
            local_args_info.macauth_given = 1;
            args_info->macauth_given = 1;
            args_info->macauth_flag = !(args_info->macauth_flag);
          }
          /* List of allowed MAC addresses.  */
          else if (strcmp (long_options[option_index].name, "macallowed") == 0)
          {
            local_args_info.macallowed_given++;
          
            multi_token = get_multiple_arg_token(optarg);
            multi_next = get_multiple_arg_token_next (optarg);
          
            while (1)
              {
                macallowed_new = (struct macallowed_list *) malloc (sizeof (struct macallowed_list));
                macallowed_new->next = macallowed_list;
                macallowed_list = macallowed_new;
                macallowed_new->macallowed_arg = multi_token;
                macallowed_new->macallowed_orig = gengetopt_strdup (multi_token);
          
                if (multi_next)
                  {
                    multi_token = get_multiple_arg_token(multi_next);
                    multi_next = get_multiple_arg_token_next (multi_next);
                    local_args_info.macallowed_given++;
                  }
                else
                  break;
              }
            break;
          }
          /* Suffix to add to the MAC address.  */
          else if (strcmp (long_options[option_index].name, "macsuffix") == 0)
          {
            if (local_args_info.macsuffix_given)
              {
                fprintf (stderr, "%s: `--macsuffix' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->macsuffix_given && ! override)
              continue;
            local_args_info.macsuffix_given = 1;
            args_info->macsuffix_given = 1;
            if (args_info->macsuffix_arg)
              free (args_info->macsuffix_arg); /* free previous string */
            args_info->macsuffix_arg = gengetopt_strdup (optarg);
            if (args_info->macsuffix_orig)
              free (args_info->macsuffix_orig); /* free previous string */
            args_info->macsuffix_orig = gengetopt_strdup (optarg);
          }
          /* Password used when performing MAC authentication.  */
          else if (strcmp (long_options[option_index].name, "macpasswd") == 0)
          {
            if (local_args_info.macpasswd_given)
              {
                fprintf (stderr, "%s: `--macpasswd' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->macpasswd_given && ! override)
              continue;
            local_args_info.macpasswd_given = 1;
            args_info->macpasswd_given = 1;
            if (args_info->macpasswd_arg)
              free (args_info->macpasswd_arg); /* free previous string */
            args_info->macpasswd_arg = gengetopt_strdup (optarg);
            if (args_info->macpasswd_orig)
              free (args_info->macpasswd_orig); /* free previous string */
            args_info->macpasswd_orig = gengetopt_strdup (optarg);
          }
          
          break;
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */


  if (local_args_info.uamallowed_given && uamallowed_list)
    {
      struct uamallowed_list *tmp;
      args_info->uamallowed_arg = (char * *) realloc (args_info->uamallowed_arg, (args_info->uamallowed_given + local_args_info.uamallowed_given) * sizeof (char *));
      args_info->uamallowed_orig = (char **) realloc (args_info->uamallowed_orig, (args_info->uamallowed_given + local_args_info.uamallowed_given) * sizeof (char *));
      for (i = (local_args_info.uamallowed_given - 1); i >= 0; --i)
        {
          tmp = uamallowed_list;
          args_info->uamallowed_arg [i + args_info->uamallowed_given] = uamallowed_list->uamallowed_arg;
          args_info->uamallowed_orig [i + args_info->uamallowed_given] = uamallowed_list->uamallowed_orig;
          uamallowed_list = uamallowed_list->next;
          free (tmp);
        }
    }
  
  if (local_args_info.macallowed_given && macallowed_list)
    {
      struct macallowed_list *tmp;
      args_info->macallowed_arg = (char * *) realloc (args_info->macallowed_arg, (args_info->macallowed_given + local_args_info.macallowed_given) * sizeof (char *));
      args_info->macallowed_orig = (char **) realloc (args_info->macallowed_orig, (args_info->macallowed_given + local_args_info.macallowed_given) * sizeof (char *));
      for (i = (local_args_info.macallowed_given - 1); i >= 0; --i)
        {
          tmp = macallowed_list;
          args_info->macallowed_arg [i + args_info->macallowed_given] = macallowed_list->macallowed_arg;
          args_info->macallowed_orig [i + args_info->macallowed_given] = macallowed_list->macallowed_orig;
          macallowed_list = macallowed_list->next;
          free (tmp);
        }
    }
  

  args_info->uamallowed_given += local_args_info.uamallowed_given;
  local_args_info.uamallowed_given = 0;
  args_info->macallowed_given += local_args_info.macallowed_given;
  local_args_info.macallowed_given = 0;
  

  cmdline_parser_release (&local_args_info);

  if ( error )
    return (EXIT_FAILURE);

  return 0;

failure:
  if (uamallowed_list)
    {
      struct uamallowed_list *tmp;
      while (uamallowed_list)
        {
          tmp = uamallowed_list;
          free (uamallowed_list->uamallowed_arg);
          free (uamallowed_list->uamallowed_orig);
          uamallowed_list = uamallowed_list->next;
          free (tmp);
        }
    }
  if (macallowed_list)
    {
      struct macallowed_list *tmp;
      while (macallowed_list)
        {
          tmp = macallowed_list;
          free (macallowed_list->macallowed_arg);
          free (macallowed_list->macallowed_orig);
          macallowed_list = macallowed_list->next;
          free (tmp);
        }
    }
  
  cmdline_parser_release (&local_args_info);
  return (EXIT_FAILURE);
}

#ifndef CONFIG_FILE_LINE_SIZE
#define CONFIG_FILE_LINE_SIZE 2048
#endif
#define ADDITIONAL_ERROR " in configuration file "

#define CONFIG_FILE_LINE_BUFFER_SIZE (CONFIG_FILE_LINE_SIZE+3)
/* 3 is for "--" and "=" */

char my_argv[CONFIG_FILE_LINE_BUFFER_SIZE+1];

int
cmdline_parser_configfile (char * const filename, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  FILE* file;
  char linebuf[CONFIG_FILE_LINE_SIZE];
  int line_num = 0;
  int i, result, equal;
  char *fopt, *farg;
  char *str_index;
  size_t len, next_token;
  char delimiter;
  int my_argc = 0;
  char **my_argv_arg;
  char *additional_error;

  /* store the program name */
  cmd_line_list_tmp = (struct line_list *) malloc (sizeof (struct line_list));
  cmd_line_list_tmp->next = cmd_line_list;
  cmd_line_list = cmd_line_list_tmp;
  cmd_line_list->string_arg = gengetopt_strdup (CMDLINE_PARSER_PACKAGE);

  if ((file = fopen(filename, "r")) == NULL)
    {
      fprintf (stderr, "%s: Error opening configuration file '%s'\n",
               CMDLINE_PARSER_PACKAGE, filename);
      result = EXIT_FAILURE;
      goto conf_failure;
    }

  while ((fgets(linebuf, CONFIG_FILE_LINE_SIZE, file)) != NULL)
    {
      ++line_num;
      my_argv[0] = '\0';
      len = strlen(linebuf);
      if (len > (CONFIG_FILE_LINE_BUFFER_SIZE-1))
        {
          fprintf (stderr, "%s:%s:%d: Line too long in configuration file\n",
                   CMDLINE_PARSER_PACKAGE, filename, line_num);
          result = EXIT_FAILURE;
          goto conf_failure;
        }

      /* find first non-whitespace character in the line */
      next_token = strspn ( linebuf, " \t\r\n");
      str_index  = linebuf + next_token;

      if ( str_index[0] == '\0' || str_index[0] == '#')
        continue; /* empty line or comment line is skipped */

      fopt = str_index;

      /* truncate fopt at the end of the first non-valid character */
      next_token = strcspn (fopt, " \t\r\n=");

      if (fopt[next_token] == '\0') /* the line is over */
        {
          farg  = NULL;
          equal = 0;
          goto noarg;
        }

      /* remember if equal sign is present */
      equal = (fopt[next_token] == '=');
      fopt[next_token++] = '\0';

      /* advance pointers to the next token after the end of fopt */
      next_token += strspn (fopt + next_token, " \t\r\n");
      /* check for the presence of equal sign, and if so, skip it */
      if ( !equal )
        if ((equal = (fopt[next_token] == '=')))
          {
            next_token++;
            next_token += strspn (fopt + next_token, " \t\r\n");
          }
      str_index  += next_token;

      /* find argument */
      farg = str_index;
      if ( farg[0] == '\"' || farg[0] == '\'' )
        { /* quoted argument */
          str_index = strchr (++farg, str_index[0] ); /* skip opening quote */
          if (! str_index)
            {
              fprintf
                (stderr,
                 "%s:%s:%d: unterminated string in configuration file\n",
                 CMDLINE_PARSER_PACKAGE, filename, line_num);
              result = EXIT_FAILURE;
              goto conf_failure;
            }
        }
      else
        { /* read up the remaining part up to a delimiter */
          next_token = strcspn (farg, " \t\r\n#\'\"");
          str_index += next_token;
        }

      /* truncate farg at the delimiter and store it for further check */
      delimiter = *str_index, *str_index++ = '\0';

      /* everything but comment is illegal at the end of line */
      if (delimiter != '\0' && delimiter != '#')
        {
          str_index += strspn(str_index, " \t\r\n");
          if (*str_index != '\0' && *str_index != '#')
            {
              fprintf
                (stderr,
                 "%s:%s:%d: malformed string in configuration file\n",
                 CMDLINE_PARSER_PACKAGE, filename, line_num);
              result = EXIT_FAILURE;
              goto conf_failure;
            }
        }

    noarg:
      ++my_argc;
      len = strlen(fopt);

      strcat (my_argv, len > 1 ? "--" : "-");
      strcat (my_argv, fopt);
      if (len > 1 && ((farg &&*farg) || equal))
          strcat (my_argv, "=");
      if (farg && *farg)
          strcat (my_argv, farg);

      cmd_line_list_tmp = (struct line_list *) malloc (sizeof (struct line_list));
      cmd_line_list_tmp->next = cmd_line_list;
      cmd_line_list = cmd_line_list_tmp;
      cmd_line_list->string_arg = gengetopt_strdup(my_argv);
    } /* while */

  ++my_argc; /* for program name */
  my_argv_arg = (char **) malloc((my_argc+1) * sizeof(char *));
  cmd_line_list_tmp = cmd_line_list;
  for (i = my_argc - 1; i >= 0; --i) {
    my_argv_arg[i] = cmd_line_list_tmp->string_arg;
    cmd_line_list_tmp = cmd_line_list_tmp->next;
  }
  my_argv_arg[my_argc] = 0;

  additional_error = (char *)malloc(strlen(filename) + strlen(ADDITIONAL_ERROR) + 1);
  strcpy (additional_error, ADDITIONAL_ERROR);
  strcat (additional_error, filename);
  result =
    cmdline_parser_internal (my_argc, my_argv_arg, args_info, override, initialize, check_required, additional_error);

  free (additional_error);
  free (my_argv_arg);

conf_failure:
  if (file)
    fclose(file);
  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}
