/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * Copyright 2009 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of either or both of the following licenses:
 *
 * 1) the GNU Lesser General Public License version 3, as published by the
 * Free Software Foundation; and/or
 * 2) the GNU Lesser General Public License version 2.1, as published by
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the applicable version of the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of both the GNU Lesser General Public
 * License version 3 and version 2.1 along with this program.  If not, see
 * <http://www.gnu.org/licenses/>
 *
 * Authored by: Gordon Allott <gord.allott@canonical.com>
 *
 */
#ifndef _CTK_IMAGE_MENU_ITEM_H_
#define _CTK_IMAGE_MENU_ITEM_H_

#include <glib-object.h>

G_BEGIN_DECLS

#define CTK_TYPE_IMAGE_MENU_ITEM             (ctk_image_menu_item_get_type ())
#define CTK_IMAGE_MENU_ITEM(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), CTK_TYPE_IMAGE_MENU_ITEM, CtkImageMenuItem))
#define CTK_IMAGE_MENU_ITEM_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), CTK_TYPE_IMAGE_MENU_ITEM, CtkImageMenuItemClass))
#define CTK_IS_IMAGE_MENU_ITEM(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CTK_TYPE_IMAGE_MENU_ITEM))
#define CTK_IS_IMAGE_MENU_ITEM_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), CTK_TYPE_IMAGE_MENU_ITEM))
#define CTK_IMAGE_MENU_ITEM_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), CTK_TYPE_IMAGE_MENU_ITEM, CtkImageMenuItemClass))

typedef struct _CtkImageMenuItemClass CtkImageMenuItemClass;
typedef struct _CtkImageMenuItem CtkImageMenuItem;
typedef struct _CtkImageMenuItemPrivate CtkImageMenuItemPrivate;

struct _CtkImageMenuItemClass
{
  CtkMenuItemClass parent_class;
  CtkImageMenuItemPrivate *priv;
};

struct _CtkImageMenuItem
{
  CtkMenuItem parent_instance;
};

GType ctk_image_menu_item_get_type (void) G_GNUC_CONST;
CtkImageMenuItem * ctk_image_menu_item_new (void);
CtkImageMenuItem * ctk_image_menu_item_new_with_label (const gchar *label);
void ctk_image_menu_item_set_image (CtkImageMenuItem *menuitem, GdkPixbuf *pixbuf);
GdkPixbuf *ctk_image_menu_item_get_image (CtkImageMenuItem *menuitem);

G_END_DECLS

#endif /* _CTK_IMAGE_MENU_ITEM_H_ */
