/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * clutk.menu
 * Copyright (C) Gordon Allott 2009 <gord.allott@canonical.com>
 * 
 * clutk.menu is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * clutk.menu is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _CTK_MENU_ITEM_H_
#define _CTK_MENU_ITEM_H_

#include <glib.h>
#include <clutk/ctk-bin.h>

G_BEGIN_DECLS

#define CTK_TYPE_MENU_ITEM (ctk_menu_item_get_type ())

#define CTK_MENU_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
  CTK_TYPE_MENU_ITEM, CtkMenuItem))

#define CTK_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
  CTK_TYPE_MENU_ITEM, CtkMenuItemClass))

#define CTK_IS_MENU_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
  CTK_TYPE_MENU_ITEM))

#define CTK_IS_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
  CTK_TYPE_MENU_ITEM))

#define CTK_MENU_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
  CTK_TYPE_MENU_ITEM, CtkmMenuItemClass))

typedef struct _CtkMenuItem CtkMenuItem;
typedef struct _CtkMenuItemClass CtkMenuItemClass;
typedef struct _CtkMenuItemPrivate CtkMenuItemPrivate;

struct _CtkMenuItem
{
  CtkBin parent_instance;
  
  CtkMenuItemPrivate *priv;
};

struct _CtkMenuItemClass
{
  CtkBinClass parent_class;
  
  /* Signals */
  void(* activated) (CtkMenuItem *self);  
};



GType          ctk_menu_item_get_type (void) G_GNUC_CONST;

CtkMenuItem *ctk_menu_item_new            (void);
CtkMenuItem *ctk_menu_item_new_with_label (const gchar *label);

void ctk_menu_item_set_label              (CtkMenuItem *item, const 
                                           gchar *label);
const gchar *ctk_menu_item_get_label      (CtkMenuItem *item);

G_END_DECLS

#endif /* _CTK_MENU_ITEM_H_ */
