/*
 * Copyright 2009 Canonical Ltd.
 * 
 * This program is free software: you can redistribute it and/or modify it 
 * under the terms of either or both of the following licenses:
 *
 * 1) the GNU Lesser General Public License version 3, as published by the 
 * Free Software Foundation; and/or
 * 2) the GNU Lesser General Public License version 2.1, as published by 
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranties of 
 * MERCHANTABILITY, SATISFACTORY QUALITY or FITNESS FOR A PARTICULAR 
 * PURPOSE.  See the applicable version of the GNU Lesser General Public 
 * License for more details.
 * 
 * You should have received a copy of both the GNU Lesser General Public 
 * License version 3 and version 2.1 along with this program.  If not, see 
 * <http://www.gnu.org/licenses/>
 *
 * Authored by: Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _CTK_ACTOR_H_
#define _CTK_ACTOR_H_

#include <glib.h>
#include <clutter-gtk/clutter-gtk.h>
#include <ctk/ctk-types.h>

G_BEGIN_DECLS

#define CTK_TYPE_ACTOR (ctk_actor_get_type ())

#define CTK_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	CTK_TYPE_ACTOR, CtkActor))

#define CTK_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
	CTK_TYPE_ACTOR, CtkActorClass))

#define CTK_IS_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
	CTK_TYPE_ACTOR))

#define CTK_IS_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
	CTK_TYPE_ACTOR))

#define CTK_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
	CTK_TYPE_ACTOR, CtkActorClass))

typedef struct _CtkActor        CtkActor;
typedef struct _CtkActorClass   CtkActorClass;
typedef struct _CtkActorPrivate CtkActorPrivate;
 
struct _CtkActor
{
  ClutterActor parent;	

  CtkActorPrivate *priv;
};

struct _CtkActorClass
{
  /*< private >*/
  ClutterActorClass  parent_class;

  /*< public >*/
  /* signals, not vfuncs */

  /* vtable */

  /*< private >*/
  /* padding */
  void (*_ctk_padding1) (void);
  void (*_ctk_padding2) (void);
  void (*_ctk_padding3) (void);
  void (*_ctk_padding4) (void);
  void (*_ctk_padding5) (void);
  void (*_ctk_padding6) (void);
};

GType ctk_actor_get_type (void) G_GNUC_CONST;

void             ctk_actor_set_state                (CtkActor     *actor,
                                                     CtkActorState state);

CtkActorState    ctk_actor_get_state                (CtkActor     *actor);

void             ctk_actor_set_padding              (CtkActor    *actor, 
                                                     CtkPadding  *padding);

void             ctk_actor_get_padding              (CtkActor    *actor, 
                                                     CtkPadding  *padding);

GtkTextDirection ctk_actor_get_default_direction    (void);

void             ctk_actor_set_default_direction    (GtkTextDirection  dir);

void             ctk_actor_set_background           (CtkActor     *actor,
                                                     ClutterActor *bg);

ClutterActor   * ctk_actor_get_background           (CtkActor     *actor);

void             ctk_actor_set_background_for_state (CtkActor     *actor,
                                                     CtkActorState state,
                                                     ClutterActor *bg);

ClutterActor   * ctk_actor_get_background_for_state (CtkActor     *actor,
                                                     CtkActorState state);
void             ctk_actor_set_tooltip_text         (CtkActor     *actor,
                                                     const gchar  *self);

const gchar    * ctk_actor_get_tooltip_text         (CtkActor     *actor);

G_END_DECLS

#endif /* _CTK_ACTOR_H_ */

