/*
 *  Copyright (C) 2010 Canonical Ltd
 *
 *  Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 * valac --vapidir ../vapi --pkg glib-2.0 --pkg gtk+-2.0 --pkg dbusmodel master-model.vala -o master-model-vala -X -I../dbusmodel
 */

using GLib;
using Dbus;

public class Master
{
  private Model model;

  public Master ()
  {
    this.model = new Model ("com.canonical.Dbus.Model.Example",
                            2,
                            typeof (int),
                            typeof (string));
    this.model.row_added.connect (this.on_row_added);
    this.model.connect ();
  }

  private void on_row_added (ModelIter iter)
  {
    int    i;
    string s;

    this.model.get (iter, 0, out i, 1, out s, -1);
  
    i = this.model.get_int (iter, 0);
    var ss = this.model.get_string (iter, 1);

    print (@"Mastr: $i $ss\n");
  }
}

public static int main (string[] args)
{
  Gtk.init (ref args);

  Master master;
  
  master = new Master ();

  Gtk.main ();

  return 0;
}
