/* OperationRestore.c generated by valac, the Vala compiler
 * generated from OperationRestore.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    Déjà Dup
    © 2008,2009 Michael Terry <mike@mterry.name>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <glib/gstdio.h>


#define DEJA_DUP_TYPE_OPERATION (deja_dup_operation_get_type ())
#define DEJA_DUP_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_OPERATION, DejaDupOperation))
#define DEJA_DUP_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_OPERATION, DejaDupOperationClass))
#define DEJA_DUP_IS_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_OPERATION))
#define DEJA_DUP_IS_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_OPERATION))
#define DEJA_DUP_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_OPERATION, DejaDupOperationClass))

typedef struct _DejaDupOperation DejaDupOperation;
typedef struct _DejaDupOperationClass DejaDupOperationClass;
typedef struct _DejaDupOperationPrivate DejaDupOperationPrivate;

#define DEJA_DUP_TYPE_DUPLICITY (deja_dup_duplicity_get_type ())
#define DEJA_DUP_DUPLICITY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_DUPLICITY, DejaDupDuplicity))
#define DEJA_DUP_DUPLICITY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_DUPLICITY, DejaDupDuplicityClass))
#define DEJA_DUP_IS_DUPLICITY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_DUPLICITY))
#define DEJA_DUP_IS_DUPLICITY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_DUPLICITY))
#define DEJA_DUP_DUPLICITY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_DUPLICITY, DejaDupDuplicityClass))

typedef struct _DejaDupDuplicity DejaDupDuplicity;
typedef struct _DejaDupDuplicityClass DejaDupDuplicityClass;

#define DEJA_DUP_TYPE_BACKEND (deja_dup_backend_get_type ())
#define DEJA_DUP_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_BACKEND, DejaDupBackend))
#define DEJA_DUP_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_BACKEND, DejaDupBackendClass))
#define DEJA_DUP_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_BACKEND))
#define DEJA_DUP_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_BACKEND))
#define DEJA_DUP_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_BACKEND, DejaDupBackendClass))

typedef struct _DejaDupBackend DejaDupBackend;
typedef struct _DejaDupBackendClass DejaDupBackendClass;

#define DEJA_DUP_TYPE_OPERATION_RESTORE (deja_dup_operation_restore_get_type ())
#define DEJA_DUP_OPERATION_RESTORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_OPERATION_RESTORE, DejaDupOperationRestore))
#define DEJA_DUP_OPERATION_RESTORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_OPERATION_RESTORE, DejaDupOperationRestoreClass))
#define DEJA_DUP_IS_OPERATION_RESTORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_OPERATION_RESTORE))
#define DEJA_DUP_IS_OPERATION_RESTORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_OPERATION_RESTORE))
#define DEJA_DUP_OPERATION_RESTORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_OPERATION_RESTORE, DejaDupOperationRestoreClass))

typedef struct _DejaDupOperationRestore DejaDupOperationRestore;
typedef struct _DejaDupOperationRestoreClass DejaDupOperationRestoreClass;
typedef struct _DejaDupOperationRestorePrivate DejaDupOperationRestorePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free_g_free0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_free (var), NULL)))
#define __g_list_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_object_unref (var), NULL)))

#define DEJA_DUP_OPERATION_TYPE_MODE (deja_dup_operation_mode_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define DEJA_DUP_TYPE_RECURSIVE_OP (deja_dup_recursive_op_get_type ())
#define DEJA_DUP_RECURSIVE_OP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_RECURSIVE_OP, DejaDupRecursiveOp))
#define DEJA_DUP_RECURSIVE_OP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_RECURSIVE_OP, DejaDupRecursiveOpClass))
#define DEJA_DUP_IS_RECURSIVE_OP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_RECURSIVE_OP))
#define DEJA_DUP_IS_RECURSIVE_OP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_RECURSIVE_OP))
#define DEJA_DUP_RECURSIVE_OP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_RECURSIVE_OP, DejaDupRecursiveOpClass))

typedef struct _DejaDupRecursiveOp DejaDupRecursiveOp;
typedef struct _DejaDupRecursiveOpClass DejaDupRecursiveOpClass;

#define DEJA_DUP_TYPE_RECURSIVE_MOVE (deja_dup_recursive_move_get_type ())
#define DEJA_DUP_RECURSIVE_MOVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_RECURSIVE_MOVE, DejaDupRecursiveMove))
#define DEJA_DUP_RECURSIVE_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_RECURSIVE_MOVE, DejaDupRecursiveMoveClass))
#define DEJA_DUP_IS_RECURSIVE_MOVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_RECURSIVE_MOVE))
#define DEJA_DUP_IS_RECURSIVE_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_RECURSIVE_MOVE))
#define DEJA_DUP_RECURSIVE_MOVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_RECURSIVE_MOVE, DejaDupRecursiveMoveClass))

typedef struct _DejaDupRecursiveMove DejaDupRecursiveMove;
typedef struct _DejaDupRecursiveMoveClass DejaDupRecursiveMoveClass;

#define DEJA_DUP_TYPE_RECURSIVE_DELETE (deja_dup_recursive_delete_get_type ())
#define DEJA_DUP_RECURSIVE_DELETE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_RECURSIVE_DELETE, DejaDupRecursiveDelete))
#define DEJA_DUP_RECURSIVE_DELETE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_RECURSIVE_DELETE, DejaDupRecursiveDeleteClass))
#define DEJA_DUP_IS_RECURSIVE_DELETE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_RECURSIVE_DELETE))
#define DEJA_DUP_IS_RECURSIVE_DELETE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_RECURSIVE_DELETE))
#define DEJA_DUP_RECURSIVE_DELETE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_RECURSIVE_DELETE, DejaDupRecursiveDeleteClass))

typedef struct _DejaDupRecursiveDelete DejaDupRecursiveDelete;
typedef struct _DejaDupRecursiveDeleteClass DejaDupRecursiveDeleteClass;

struct _DejaDupOperation {
	GObject parent_instance;
	DejaDupOperationPrivate * priv;
	DejaDupDuplicity* dup;
	DejaDupBackend* backend;
	char* passphrase;
};

struct _DejaDupOperationClass {
	GObjectClass parent_class;
	void (*start) (DejaDupOperation* self, GError** error);
	void (*connect_to_dup) (DejaDupOperation* self);
	void (*operation_finished) (DejaDupOperation* self, DejaDupDuplicity* dup, gboolean success, gboolean cancelled);
	GList* (*make_argv) (DejaDupOperation* self, GError** error);
};

struct _DejaDupOperationRestore {
	DejaDupOperation parent_instance;
	DejaDupOperationRestorePrivate * priv;
};

struct _DejaDupOperationRestoreClass {
	DejaDupOperationClass parent_class;
};

struct _DejaDupOperationRestorePrivate {
	char* _dest;
	char* _time;
	char* source;
	GList* errors;
	GList* _restore_files;
};

typedef enum  {
	DEJA_DUP_OPERATION_MODE_INVALID,
	DEJA_DUP_OPERATION_MODE_BACKUP,
	DEJA_DUP_OPERATION_MODE_RESTORE,
	DEJA_DUP_OPERATION_MODE_STATUS
} DejaDupOperationMode;


static gpointer deja_dup_operation_restore_parent_class = NULL;

GType deja_dup_operation_get_type (void);
GType deja_dup_duplicity_get_type (void);
GType deja_dup_backend_get_type (void);
GType deja_dup_operation_restore_get_type (void);
#define DEJA_DUP_OPERATION_RESTORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DEJA_DUP_TYPE_OPERATION_RESTORE, DejaDupOperationRestorePrivate))
enum  {
	DEJA_DUP_OPERATION_RESTORE_DUMMY_PROPERTY,
	DEJA_DUP_OPERATION_RESTORE_DEST,
	DEJA_DUP_OPERATION_RESTORE_TIME,
	DEJA_DUP_OPERATION_RESTORE_RESTORE_FILES
};
static void _g_list_free_g_free (GList* self);
static void _g_list_free_g_object_unref (GList* self);
static void deja_dup_operation_set_toplevel (DejaDupOperation* self, GtkWindow* value);
static void deja_dup_operation_set_uppermost_xid (DejaDupOperation* self, guint value);
static void deja_dup_operation_restore_set_dest (DejaDupOperationRestore* self, const char* value);
static void deja_dup_operation_restore_set_time (DejaDupOperationRestore* self, const char* value);
static void deja_dup_operation_restore_set_restore_files (DejaDupOperationRestore* self, GList* value);
GType deja_dup_operation_mode_get_type (void);
static void deja_dup_operation_set_mode (DejaDupOperation* self, DejaDupOperationMode value);
DejaDupOperationRestore* deja_dup_operation_restore_new (GtkWindow* win, const char* dest_in, const char* time_in, GList* files_in, guint xid);
DejaDupOperationRestore* deja_dup_operation_restore_construct (GType object_type, GtkWindow* win, const char* dest_in, const char* time_in, GList* files_in, guint xid);
void deja_dup_operation_start (DejaDupOperation* self, GError** error);
static void deja_dup_operation_restore_real_start (DejaDupOperation* base, GError** error);
const char* deja_dup_operation_restore_get_time (DejaDupOperationRestore* self);
void deja_dup_duplicity_set_local (DejaDupDuplicity* self, const char* value);
static GList* deja_dup_operation_restore_real_make_argv (DejaDupOperation* base, GError** error);
static void deja_dup_operation_restore_fixup_home_dir (DejaDupOperationRestore* self);
static gboolean deja_dup_operation_restore_mv_source_to_dest (DejaDupOperationRestore* self);
void deja_dup_update_last_run_timestamp (GError** error);
static void deja_dup_operation_restore_cleanup_source (DejaDupOperationRestore* self);
void deja_dup_operation_operation_finished (DejaDupOperation* self, DejaDupDuplicity* dup, gboolean success, gboolean cancelled);
static void deja_dup_operation_restore_real_operation_finished (DejaDupOperation* base, DejaDupDuplicity* dup, gboolean success, gboolean cancelled);
static void deja_dup_operation_restore_show_errors (DejaDupOperationRestore* self);
static void deja_dup_operation_restore_add_error (DejaDupOperationRestore* self, const char* relpath, const char* errstr);
const char* deja_dup_operation_restore_get_dest (DejaDupOperationRestore* self);
GType deja_dup_recursive_op_get_type (void);
static void deja_dup_operation_restore_mv_error (DejaDupOperationRestore* self, DejaDupRecursiveOp* move, GFile* src, GFile* dst, const char* errstr);
GList* deja_dup_operation_restore_get_restore_files (DejaDupOperationRestore* self);
DejaDupRecursiveMove* deja_dup_recursive_move_new (GFile* source, GFile* dest);
DejaDupRecursiveMove* deja_dup_recursive_move_construct (GType object_type, GFile* source, GFile* dest);
GType deja_dup_recursive_move_get_type (void);
static void _deja_dup_operation_restore_mv_error_deja_dup_recursive_op_raise_error (DejaDupRecursiveOp* _sender, GFile* src, GFile* dst, const char* errstr, gpointer self);
void deja_dup_recursive_op_start (DejaDupRecursiveOp* self);
DejaDupRecursiveDelete* deja_dup_recursive_delete_new (GFile* source);
DejaDupRecursiveDelete* deja_dup_recursive_delete_construct (GType object_type, GFile* source);
GType deja_dup_recursive_delete_get_type (void);
void deja_dup_duplicity_set_restore_files (DejaDupDuplicity* self, GList* value);
static void deja_dup_operation_restore_finalize (GObject* obj);
static void deja_dup_operation_restore_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void deja_dup_operation_restore_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);



static void _g_list_free_g_free (GList* self) {
	g_list_foreach (self, (GFunc) g_free, NULL);
	g_list_free (self);
}


static void _g_list_free_g_object_unref (GList* self) {
	g_list_foreach (self, (GFunc) g_object_unref, NULL);
	g_list_free (self);
}


DejaDupOperationRestore* deja_dup_operation_restore_construct (GType object_type, GtkWindow* win, const char* dest_in, const char* time_in, GList* files_in, guint xid) {
	GParameter * __params;
	GParameter * __params_it;
	DejaDupOperationRestore * self;
	g_return_val_if_fail (dest_in != NULL, NULL);
	__params = g_new0 (GParameter, 6);
	__params_it = __params;
	__params_it->name = "toplevel";
	g_value_init (&__params_it->value, GTK_TYPE_WINDOW);
	g_value_set_object (&__params_it->value, win);
	__params_it++;
	__params_it->name = "uppermost-xid";
	g_value_init (&__params_it->value, G_TYPE_UINT);
	g_value_set_uint (&__params_it->value, xid);
	__params_it++;
	__params_it->name = "dest";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, dest_in);
	__params_it++;
	__params_it->name = "time";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, time_in);
	__params_it++;
	__params_it->name = "restore-files";
	g_value_init (&__params_it->value, G_TYPE_POINTER);
	g_value_set_pointer (&__params_it->value, files_in);
	__params_it++;
	__params_it->name = "mode";
	g_value_init (&__params_it->value, DEJA_DUP_OPERATION_TYPE_MODE);
	g_value_set_enum (&__params_it->value, DEJA_DUP_OPERATION_MODE_RESTORE);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


DejaDupOperationRestore* deja_dup_operation_restore_new (GtkWindow* win, const char* dest_in, const char* time_in, GList* files_in, guint xid) {
	return deja_dup_operation_restore_construct (DEJA_DUP_TYPE_OPERATION_RESTORE, win, dest_in, time_in, files_in, xid);
}


static void deja_dup_operation_restore_real_start (DejaDupOperation* base, GError** error) {
	DejaDupOperationRestore * self;
	GError * _inner_error_;
	self = (DejaDupOperationRestore*) base;
	_inner_error_ = NULL;
	g_signal_emit_by_name ((DejaDupOperation*) self, "action-desc-changed", _ ("Restoring files..."));
	DEJA_DUP_OPERATION_CLASS (deja_dup_operation_restore_parent_class)->start (DEJA_DUP_OPERATION (self), &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


static GList* deja_dup_operation_restore_real_make_argv (DejaDupOperation* base, GError** error) {
	DejaDupOperationRestore * self;
	GList* result;
	char* _tmp0_;
	char* _tmp1_;
	GList* argv;
	self = (DejaDupOperationRestore*) base;
	self->priv->source = (_tmp0_ = g_build_filename (g_get_tmp_dir (), "deja-dup-XXXXXX", NULL), _g_free0 (self->priv->source), _tmp0_);
	self->priv->source = (_tmp1_ = g_strdup (mkdtemp (self->priv->source)), _g_free0 (self->priv->source), _tmp1_);
	argv = NULL;
	if (self->priv->_time != NULL) {
		argv = g_list_append (argv, g_strdup_printf ("--restore-time=%s", self->priv->_time));
	}
	deja_dup_duplicity_set_local (((DejaDupOperation*) self)->dup, self->priv->source);
	result = argv;
	return result;
}


static void deja_dup_operation_restore_real_operation_finished (DejaDupOperation* base, DejaDupDuplicity* dup, gboolean success, gboolean cancelled) {
	DejaDupOperationRestore * self;
	GError * _inner_error_;
	self = (DejaDupOperationRestore*) base;
	g_return_if_fail (dup != NULL);
	_inner_error_ = NULL;
	if (success) {
	}
	if (success) {
		deja_dup_operation_restore_fixup_home_dir (self);
		if (!deja_dup_operation_restore_mv_source_to_dest (self)) {
			success = FALSE;
		} else {
			{
				deja_dup_update_last_run_timestamp (&_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch49_g_error;
					goto __finally49;
				}
			}
			goto __finally49;
			__catch49_g_error:
			{
				GError * e;
				e = _inner_error_;
				_inner_error_ = NULL;
				{
					g_warning ("OperationRestore.vala:89: %s\n", e->message);
					_g_error_free0 (e);
				}
			}
			__finally49:
			if (_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	} else {
		if (!cancelled) {
		} else {
			deja_dup_operation_restore_cleanup_source (self);
		}
	}
	DEJA_DUP_OPERATION_CLASS (deja_dup_operation_restore_parent_class)->operation_finished (DEJA_DUP_OPERATION (self), dup, success, cancelled);
}


static void deja_dup_operation_restore_fixup_home_dir (DejaDupOperationRestore* self) {
	GError * _inner_error_;
	char* ideal_home;
	char* current_home;
	char* strd;
	GDir* d;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	ideal_home = g_build_filename (self->priv->source, g_get_home_dir (), NULL);
	if (g_file_test (ideal_home, G_FILE_TEST_EXISTS | G_FILE_TEST_IS_DIR)) {
		_g_free0 (ideal_home);
		return;
	}
	current_home = NULL;
	strd = g_build_filename (self->priv->source, "home", NULL);
	d = NULL;
	{
		GDir* _tmp0_;
		GDir* _tmp1_;
		_tmp0_ = g_dir_open (strd, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch50_g_file_error;
			}
			goto __finally50;
		}
		d = (_tmp1_ = _tmp0_, _g_dir_close0 (d), _tmp1_);
	}
	goto __finally50;
	__catch50_g_file_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			GDir* _tmp2_;
			d = (_tmp2_ = NULL, _g_dir_close0 (d), _tmp2_);
			_g_error_free0 (e);
		}
	}
	__finally50:
	if (_inner_error_ != NULL) {
		_g_free0 (ideal_home);
		_g_free0 (current_home);
		_g_free0 (strd);
		_g_dir_close0 (d);
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return;
	}
	if (d != NULL) {
		char* child;
		const char* end;
		child = g_strdup (g_dir_read_name (d));
		end = g_dir_read_name (d);
		if (end != NULL) {
			_g_free0 (child);
			_g_free0 (ideal_home);
			_g_free0 (current_home);
			_g_free0 (strd);
			_g_dir_close0 (d);
			return;
		}
		if (child != NULL) {
			char* _tmp3_;
			current_home = (_tmp3_ = g_build_filename (strd, child, NULL), _g_free0 (current_home), _tmp3_);
			if (!g_file_test (current_home, G_FILE_TEST_IS_DIR)) {
				char* _tmp4_;
				current_home = (_tmp4_ = NULL, _g_free0 (current_home), _tmp4_);
			}
		}
		_g_free0 (child);
	}
	if (current_home == NULL) {
		char* _tmp5_;
		current_home = (_tmp5_ = g_build_filename (self->priv->source, "root", NULL), _g_free0 (current_home), _tmp5_);
		if (!g_file_test (current_home, G_FILE_TEST_EXISTS | G_FILE_TEST_IS_DIR)) {
			char* _tmp6_;
			current_home = (_tmp6_ = NULL, _g_free0 (current_home), _tmp6_);
		}
	}
	if (current_home != NULL) {
		char* dirname;
		dirname = g_path_get_dirname (ideal_home);
		g_mkdir_with_parents (dirname, 0755);
		g_rename (current_home, ideal_home);
		_g_free0 (dirname);
	}
	_g_free0 (ideal_home);
	_g_free0 (current_home);
	_g_free0 (strd);
	_g_dir_close0 (d);
}


static void deja_dup_operation_restore_show_errors (DejaDupOperationRestore* self) {
	guint len;
	char* detail;
	char* error_text;
	g_return_if_fail (self != NULL);
	len = g_list_length (self->priv->errors);
	detail = NULL;
	if (len > 1) {
		char** _tmp0_;
		gint error_array_size;
		gint error_array_length1;
		char** error_array;
		gint i;
		char* _tmp3_;
		char* _tmp4_;
		error_array = (_tmp0_ = g_new0 (char*, (len + 1) + 1), error_array_length1 = len + 1, error_array_size = error_array_length1, _tmp0_);
		i = 0;
		{
			GList* err_collection;
			GList* err_it;
			err_collection = self->priv->errors;
			for (err_it = err_collection; err_it != NULL; err_it = err_it->next) {
				char* err;
				err = g_strdup ((const char*) err_it->data);
				{
					char* _tmp2_;
					char* *_tmp1_;
					_tmp1_ = &error_array[i++];
					(*_tmp1_) = (_tmp2_ = g_strdup (err), _g_free0 ((*_tmp1_)), _tmp2_);
					_g_free0 (err);
				}
			}
		}
		error_array[i] = (_tmp3_ = NULL, _g_free0 (error_array[i]), _tmp3_);
		detail = (_tmp4_ = g_strjoinv ("\n\n", error_array), _g_free0 (detail), _tmp4_);
		error_array = (_vala_array_free (error_array, error_array_length1, (GDestroyNotify) g_free), NULL);
	}
	error_text = g_strdup_printf (_ ("Not all files could be restored. Any files that could not be restored may still be found in %s."), self->priv->source);
	if (detail == NULL) {
		char* _tmp6_;
		char* _tmp5_;
		error_text = (_tmp6_ = g_strconcat (error_text, _tmp5_ = g_strconcat ("\n\n", (const char*) self->priv->errors->data, NULL), NULL), _g_free0 (error_text), _tmp6_);
		_g_free0 (_tmp5_);
	}
	g_signal_emit_by_name ((DejaDupOperation*) self, "raise-error", error_text, detail);
	_g_free0 (detail);
	_g_free0 (error_text);
}


static void deja_dup_operation_restore_add_error (DejaDupOperationRestore* self, const char* relpath, const char* errstr) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (relpath != NULL);
	g_return_if_fail (errstr != NULL);
	self->priv->errors = g_list_append (self->priv->errors, g_strdup_printf (_ ("Could not restore %s: %s"), relpath, errstr));
}


static void deja_dup_operation_restore_mv_error (DejaDupOperationRestore* self, DejaDupRecursiveOp* move, GFile* src, GFile* dst, const char* errstr) {
	GFile* dest_top;
	char* relative_dst;
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (move != NULL);
	g_return_if_fail (src != NULL);
	g_return_if_fail (dst != NULL);
	g_return_if_fail (errstr != NULL);
	dest_top = g_file_new_for_path (self->priv->_dest);
	relative_dst = g_file_get_relative_path (dest_top, dst);
	if (relative_dst == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = _vala_strcmp0 (relative_dst, "") == 0;
	}
	if (_tmp0_) {
		char* _tmp1_;
		relative_dst = (_tmp1_ = g_strdup (self->priv->_dest), _g_free0 (relative_dst), _tmp1_);
	}
	deja_dup_operation_restore_add_error (self, relative_dst, errstr);
	_g_object_unref0 (dest_top);
	_g_free0 (relative_dst);
}


static void _deja_dup_operation_restore_mv_error_deja_dup_recursive_op_raise_error (DejaDupRecursiveOp* _sender, GFile* src, GFile* dst, const char* errstr, gpointer self) {
	deja_dup_operation_restore_mv_error (self, _sender, src, dst, errstr);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean deja_dup_operation_restore_mv_source_to_dest (DejaDupOperationRestore* self) {
	gboolean result;
	GList* _tmp0_;
	GFile* destf;
	GFile* sourcef;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->errors = (_tmp0_ = NULL, __g_list_free_g_free0 (self->priv->errors), _tmp0_);
	destf = g_file_new_for_path (self->priv->_dest);
	sourcef = g_file_new_for_path (self->priv->source);
	if (deja_dup_operation_restore_get_restore_files (self) == NULL) {
		DejaDupRecursiveMove* move;
		move = deja_dup_recursive_move_new (sourcef, destf);
		g_signal_connect_object ((DejaDupRecursiveOp*) move, "raise-error", (GCallback) _deja_dup_operation_restore_mv_error_deja_dup_recursive_op_raise_error, self, 0);
		deja_dup_recursive_op_start ((DejaDupRecursiveOp*) move);
		_g_object_unref0 (move);
	} else {
		GFile* root;
		root = g_file_new_for_path ("/");
		{
			GList* f_collection;
			GList* f_it;
			f_collection = deja_dup_operation_restore_get_restore_files (self);
			for (f_it = f_collection; f_it != NULL; f_it = f_it->next) {
				GFile* f;
				f = _g_object_ref0 ((GFile*) f_it->data);
				{
					char* rel_file_path;
					GFile* full_source;
					GFile* full_dest;
					DejaDupRecursiveMove* move;
					rel_file_path = g_file_get_relative_path (root, f);
					full_source = g_file_resolve_relative_path (sourcef, rel_file_path);
					full_dest = g_file_resolve_relative_path (destf, rel_file_path);
					move = deja_dup_recursive_move_new (full_source, full_dest);
					g_signal_connect_object ((DejaDupRecursiveOp*) move, "raise-error", (GCallback) _deja_dup_operation_restore_mv_error_deja_dup_recursive_op_raise_error, self, 0);
					deja_dup_recursive_op_start ((DejaDupRecursiveOp*) move);
					_g_object_unref0 (f);
					_g_free0 (rel_file_path);
					_g_object_unref0 (full_source);
					_g_object_unref0 (full_dest);
					_g_object_unref0 (move);
				}
			}
		}
		_g_object_unref0 (root);
	}
	if (self->priv->errors != NULL) {
		deja_dup_operation_restore_show_errors (self);
		result = FALSE;
		_g_object_unref0 (destf);
		_g_object_unref0 (sourcef);
		return result;
	} else {
		result = TRUE;
		_g_object_unref0 (destf);
		_g_object_unref0 (sourcef);
		return result;
	}
	_g_object_unref0 (destf);
	_g_object_unref0 (sourcef);
}


static void deja_dup_operation_restore_cleanup_source (DejaDupOperationRestore* self) {
	GFile* sourcef;
	DejaDupRecursiveDelete* move;
	g_return_if_fail (self != NULL);
	sourcef = g_file_new_for_path (self->priv->source);
	move = deja_dup_recursive_delete_new (sourcef);
	deja_dup_recursive_op_start ((DejaDupRecursiveOp*) move);
	_g_object_unref0 (sourcef);
	_g_object_unref0 (move);
}


const char* deja_dup_operation_restore_get_dest (DejaDupOperationRestore* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_dest;
	return result;
}


static void deja_dup_operation_restore_set_dest (DejaDupOperationRestore* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_dest = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_dest), _tmp0_);
	g_object_notify ((GObject *) self, "dest");
}


const char* deja_dup_operation_restore_get_time (DejaDupOperationRestore* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_time;
	return result;
}


static void deja_dup_operation_restore_set_time (DejaDupOperationRestore* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_time = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_time), _tmp0_);
	g_object_notify ((GObject *) self, "time");
}


GList* deja_dup_operation_restore_get_restore_files (DejaDupOperationRestore* self) {
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_restore_files;
	return result;
}


static void deja_dup_operation_restore_set_restore_files (DejaDupOperationRestore* self, GList* value) {
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	{
		GList* f_collection;
		GList* f_it;
		f_collection = self->priv->_restore_files;
		for (f_it = f_collection; f_it != NULL; f_it = f_it->next) {
			GFile* f;
			f = _g_object_ref0 ((GFile*) f_it->data);
			{
				g_object_unref ((GObject*) f);
				_g_object_unref0 (f);
			}
		}
	}
	self->priv->_restore_files = (_tmp0_ = g_list_copy (value), __g_list_free_g_object_unref0 (self->priv->_restore_files), _tmp0_);
	{
		GList* f_collection;
		GList* f_it;
		f_collection = self->priv->_restore_files;
		for (f_it = f_collection; f_it != NULL; f_it = f_it->next) {
			GFile* f;
			f = _g_object_ref0 ((GFile*) f_it->data);
			{
				g_object_ref ((GObject*) f);
				_g_object_unref0 (f);
			}
		}
	}
	if (((DejaDupOperation*) self)->dup != NULL) {
		deja_dup_duplicity_set_restore_files (((DejaDupOperation*) self)->dup, deja_dup_operation_restore_get_restore_files (self));
	}
	g_object_notify ((GObject *) self, "restore-files");
}


static void deja_dup_operation_restore_class_init (DejaDupOperationRestoreClass * klass) {
	deja_dup_operation_restore_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DejaDupOperationRestorePrivate));
	DEJA_DUP_OPERATION_CLASS (klass)->start = deja_dup_operation_restore_real_start;
	DEJA_DUP_OPERATION_CLASS (klass)->make_argv = deja_dup_operation_restore_real_make_argv;
	DEJA_DUP_OPERATION_CLASS (klass)->operation_finished = deja_dup_operation_restore_real_operation_finished;
	G_OBJECT_CLASS (klass)->get_property = deja_dup_operation_restore_get_property;
	G_OBJECT_CLASS (klass)->set_property = deja_dup_operation_restore_set_property;
	G_OBJECT_CLASS (klass)->finalize = deja_dup_operation_restore_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_OPERATION_RESTORE_DEST, g_param_spec_string ("dest", "dest", "dest", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_OPERATION_RESTORE_TIME, g_param_spec_string ("time", "time", "time", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_OPERATION_RESTORE_RESTORE_FILES, g_param_spec_pointer ("restore-files", "restore-files", "restore-files", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void deja_dup_operation_restore_instance_init (DejaDupOperationRestore * self) {
	self->priv = DEJA_DUP_OPERATION_RESTORE_GET_PRIVATE (self);
}


static void deja_dup_operation_restore_finalize (GObject* obj) {
	DejaDupOperationRestore * self;
	self = DEJA_DUP_OPERATION_RESTORE (obj);
	_g_free0 (self->priv->_dest);
	_g_free0 (self->priv->_time);
	_g_free0 (self->priv->source);
	__g_list_free_g_free0 (self->priv->errors);
	__g_list_free_g_object_unref0 (self->priv->_restore_files);
	G_OBJECT_CLASS (deja_dup_operation_restore_parent_class)->finalize (obj);
}


GType deja_dup_operation_restore_get_type (void) {
	static GType deja_dup_operation_restore_type_id = 0;
	if (deja_dup_operation_restore_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DejaDupOperationRestoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_operation_restore_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupOperationRestore), 0, (GInstanceInitFunc) deja_dup_operation_restore_instance_init, NULL };
		deja_dup_operation_restore_type_id = g_type_register_static (DEJA_DUP_TYPE_OPERATION, "DejaDupOperationRestore", &g_define_type_info, 0);
	}
	return deja_dup_operation_restore_type_id;
}


static void deja_dup_operation_restore_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DejaDupOperationRestore * self;
	self = DEJA_DUP_OPERATION_RESTORE (object);
	switch (property_id) {
		case DEJA_DUP_OPERATION_RESTORE_DEST:
		g_value_set_string (value, deja_dup_operation_restore_get_dest (self));
		break;
		case DEJA_DUP_OPERATION_RESTORE_TIME:
		g_value_set_string (value, deja_dup_operation_restore_get_time (self));
		break;
		case DEJA_DUP_OPERATION_RESTORE_RESTORE_FILES:
		g_value_set_pointer (value, deja_dup_operation_restore_get_restore_files (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void deja_dup_operation_restore_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DejaDupOperationRestore * self;
	self = DEJA_DUP_OPERATION_RESTORE (object);
	switch (property_id) {
		case DEJA_DUP_OPERATION_RESTORE_DEST:
		deja_dup_operation_restore_set_dest (self, g_value_get_string (value));
		break;
		case DEJA_DUP_OPERATION_RESTORE_TIME:
		deja_dup_operation_restore_set_time (self, g_value_get_string (value));
		break;
		case DEJA_DUP_OPERATION_RESTORE_RESTORE_FILES:
		deja_dup_operation_restore_set_restore_files (self, g_value_get_pointer (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




