/* AssistantRestore.c generated by valac, the Vala compiler
 * generated from AssistantRestore.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    © 2008,2009 Michael Terry <mike@mterry.name>

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <common.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <widgets.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdkx.h>
#include <gdk/gdk.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xregion.h>
#include <time.h>
#include <float.h>
#include <math.h>


#define TYPE_ASSISTANT (assistant_get_type ())
#define ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT, Assistant))
#define ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT, AssistantClass))
#define IS_ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT))
#define IS_ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT))
#define ASSISTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT, AssistantClass))

typedef struct _Assistant Assistant;
typedef struct _AssistantClass AssistantClass;
typedef struct _AssistantPrivate AssistantPrivate;

#define TYPE_ASSISTANT_OPERATION (assistant_operation_get_type ())
#define ASSISTANT_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT_OPERATION, AssistantOperation))
#define ASSISTANT_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT_OPERATION, AssistantOperationClass))
#define IS_ASSISTANT_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT_OPERATION))
#define IS_ASSISTANT_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT_OPERATION))
#define ASSISTANT_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT_OPERATION, AssistantOperationClass))

typedef struct _AssistantOperation AssistantOperation;
typedef struct _AssistantOperationClass AssistantOperationClass;
typedef struct _AssistantOperationPrivate AssistantOperationPrivate;

#define TYPE_ASSISTANT_RESTORE (assistant_restore_get_type ())
#define ASSISTANT_RESTORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT_RESTORE, AssistantRestore))
#define ASSISTANT_RESTORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT_RESTORE, AssistantRestoreClass))
#define IS_ASSISTANT_RESTORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT_RESTORE))
#define IS_ASSISTANT_RESTORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT_RESTORE))
#define ASSISTANT_RESTORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT_RESTORE, AssistantRestoreClass))

typedef struct _AssistantRestore AssistantRestore;
typedef struct _AssistantRestoreClass AssistantRestoreClass;
typedef struct _AssistantRestorePrivate AssistantRestorePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_object_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _deja_dup_operation_state_unref0(var) ((var == NULL) ? NULL : (var = (deja_dup_operation_state_unref (var), NULL)))

#define ASSISTANT_TYPE_TYPE (assistant_type_get_type ())

#define TYPE_MOUNT_OPERATION_ASSISTANT (mount_operation_assistant_get_type ())
#define MOUNT_OPERATION_ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOUNT_OPERATION_ASSISTANT, MountOperationAssistant))
#define MOUNT_OPERATION_ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOUNT_OPERATION_ASSISTANT, MountOperationAssistantClass))
#define IS_MOUNT_OPERATION_ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOUNT_OPERATION_ASSISTANT))
#define IS_MOUNT_OPERATION_ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOUNT_OPERATION_ASSISTANT))
#define MOUNT_OPERATION_ASSISTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOUNT_OPERATION_ASSISTANT, MountOperationAssistantClass))

typedef struct _MountOperationAssistant MountOperationAssistant;
typedef struct _MountOperationAssistantClass MountOperationAssistantClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _Assistant {
	GtkDialog parent_instance;
	AssistantPrivate * priv;
	GtkImage* header_icon;
	GtkEventBox* page_box;
};

struct _AssistantClass {
	GtkDialogClass parent_class;
};

struct _AssistantOperation {
	Assistant parent_instance;
	AssistantOperationPrivate * priv;
	gboolean succeeded;
	GtkLabel* summary_label;
	DejaDupOperation* op;
	GMountOperation* mount_op;
};

struct _AssistantOperationClass {
	AssistantClass parent_class;
	GtkWidget* (*make_confirm_page) (AssistantOperation* self);
	void (*add_setup_pages) (AssistantOperation* self);
	void (*add_custom_config_pages) (AssistantOperation* self);
	DejaDupOperation* (*create_op) (AssistantOperation* self);
	char* (*get_progress_file_prefix) (AssistantOperation* self);
	void (*set_op_icon_name) (AssistantOperation* self);
	GtkWidget* (*make_progress_page) (AssistantOperation* self);
	void (*show_error) (AssistantOperation* self, const char* _error_, const char* detail);
	GtkWidget* (*make_summary_page) (AssistantOperation* self);
	void (*do_prepare) (AssistantOperation* self, Assistant* assist, GtkWidget* page);
	void (*do_close) (AssistantOperation* self);
};

struct _AssistantRestore {
	AssistantOperation parent_instance;
	AssistantRestorePrivate * priv;
};

struct _AssistantRestoreClass {
	AssistantOperationClass parent_class;
};

struct _AssistantRestorePrivate {
	char* _restore_location;
	GList* _restore_files;
	DejaDupOperationStatus* query_op;
	DejaDupOperationState* op_state;
	GtkProgressBar* query_progress_bar;
	guint query_timeout_id;
	GtkComboBox* date_combo;
	GtkListStore* date_store;
	GtkHBox* cust_box;
	GtkFileChooserButton* cust_button;
	GtkTable* confirm_table;
	gint confirm_location_row;
	GtkLabel* confirm_location_label;
	GtkLabel* confirm_location;
	gint confirm_date_row;
	GtkLabel* confirm_date_label;
	GtkLabel* confirm_date;
	gint confirm_files_row;
	GtkLabel* confirm_files_label;
	GtkVBox* confirm_files;
	GtkWidget* query_progress_page;
	GtkWidget* date_page;
	GtkWidget* restore_dest_page;
	gboolean got_dates;
};

typedef enum  {
	ASSISTANT_TYPE_NORMAL,
	ASSISTANT_TYPE_INTERRUPT,
	ASSISTANT_TYPE_SUMMARY,
	ASSISTANT_TYPE_PROGRESS,
	ASSISTANT_TYPE_FINISH
} AssistantType;


static gpointer assistant_restore_parent_class = NULL;

GType assistant_get_type (void);
GType assistant_operation_get_type (void);
GType assistant_restore_get_type (void);
#define ASSISTANT_RESTORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ASSISTANT_RESTORE, AssistantRestorePrivate))
enum  {
	ASSISTANT_RESTORE_DUMMY_PROPERTY,
	ASSISTANT_RESTORE_RESTORE_LOCATION,
	ASSISTANT_RESTORE_RESTORE_FILES
};
static void _g_list_free_g_object_unref (GList* self);
void assistant_restore_set_restore_files (AssistantRestore* self, GList* value);
AssistantRestore* assistant_restore_new_with_files (GList* files);
AssistantRestore* assistant_restore_construct_with_files (GType object_type, GList* files);
static void assistant_restore_add_query_backend_page (AssistantRestore* self);
static void assistant_restore_add_date_page (AssistantRestore* self);
static void assistant_restore_add_restore_dest_page (AssistantRestore* self);
static void assistant_restore_real_add_setup_pages (AssistantOperation* base);
static GtkWidget* assistant_restore_make_backup_location_page (AssistantRestore* self);
GType assistant_type_get_type (void);
void assistant_append_page (Assistant* self, GtkWidget* page, AssistantType type);
void assistant_set_page_title (Assistant* self, GtkWidget* page, const char* title);
static void assistant_restore_real_add_custom_config_pages (AssistantOperation* base);
static GtkWidget* assistant_restore_make_query_backend_page (AssistantRestore* self);
static GtkWidget* assistant_restore_make_date_page (AssistantRestore* self);
void assistant_restore_set_restore_location (AssistantRestore* self, const char* value);
static void _lambda18_ (GtkToggleButton* r, AssistantRestore* self);
static void __lambda18__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void _lambda19_ (GtkToggleButton* r, AssistantRestore* self);
static void __lambda19__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void _lambda20_ (GtkFileChooser* b, AssistantRestore* self);
static void __lambda20__gtk_file_chooser_selection_changed (GtkFileChooser* _sender, gpointer self);
static GtkWidget* assistant_restore_make_restore_dest_page (AssistantRestore* self);
static GtkWidget* assistant_restore_real_make_confirm_page (AssistantOperation* base);
const char* assistant_restore_get_restore_location (AssistantRestore* self);
GList* assistant_restore_get_restore_files (AssistantRestore* self);
static DejaDupOperation* assistant_restore_real_create_op (AssistantOperation* base);
static char* assistant_restore_real_get_progress_file_prefix (AssistantOperation* base);
static void assistant_restore_real_set_op_icon_name (AssistantOperation* base);
void assistant_operation_show_error (AssistantOperation* self, const char* _error_, const char* detail);
void assistant_restore_handle_collection_dates (AssistantRestore* self, DejaDupOperationStatus* op, GList* dates);
void assistant_operation_do_close (AssistantOperation* self);
void assistant_go_forward (Assistant* self);
void assistant_restore_query_finished (AssistantRestore* self, DejaDupOperation* op, gboolean success, gboolean cancelled);
static gboolean assistant_restore_query_pulse (AssistantRestore* self);
MountOperationAssistant* mount_operation_assistant_new (AssistantOperation* assist);
MountOperationAssistant* mount_operation_assistant_construct (GType object_type, AssistantOperation* assist);
GType mount_operation_assistant_get_type (void);
static void _assistant_restore_handle_collection_dates_deja_dup_operation_status_collection_dates (DejaDupOperationStatus* _sender, GList* dates, gpointer self);
static void _assistant_restore_query_finished_deja_dup_operation_done (DejaDupOperation* _sender, gboolean success, gboolean cancelled, gpointer self);
void assistant_operation_get_passphrase (AssistantOperation* self);
static void _assistant_operation_get_passphrase_deja_dup_operation_passphrase_required (DejaDupOperation* _sender, gpointer self);
static void _lambda21_ (DejaDupOperation* o, const char* e, const char* d, AssistantRestore* self);
static void __lambda21__deja_dup_operation_raise_error (DejaDupOperation* _sender, const char* errstr, const char* detail, gpointer self);
void assistant_restore_do_query (AssistantRestore* self);
void assistant_operation_do_prepare (AssistantOperation* self, Assistant* assist, GtkWidget* page);
GtkWidget* assistant_operation_get_confirm_page (AssistantOperation* self);
GtkWidget* assistant_operation_get_summary_page (AssistantOperation* self);
gboolean assistant_operation_get_error_occurred (AssistantOperation* self);
GtkWidget* assistant_operation_get_progress_page (AssistantOperation* self);
static gboolean _assistant_restore_query_pulse_gsource_func (gpointer self);
void assistant_operation_provide_password (AssistantOperation* self);
static void assistant_restore_real_do_prepare (AssistantOperation* base, Assistant* assist, GtkWidget* page);
static void assistant_restore_real_do_close (AssistantOperation* base);
AssistantRestore* assistant_restore_new (void);
AssistantRestore* assistant_restore_construct (GType object_type);
void assistant_set_apply_text (Assistant* self, const char* value);
static GObject * assistant_restore_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void assistant_restore_finalize (GObject* obj);
static void assistant_restore_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void assistant_restore_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);



static void _g_list_free_g_object_unref (GList* self) {
	g_list_foreach (self, (GFunc) g_object_unref, NULL);
	g_list_free (self);
}


AssistantRestore* assistant_restore_construct_with_files (GType object_type, GList* files) {
	AssistantRestore * self;
	self = g_object_newv (object_type, 0, NULL);
	assistant_restore_set_restore_files (self, files);
	return self;
}


AssistantRestore* assistant_restore_new_with_files (GList* files) {
	return assistant_restore_construct_with_files (TYPE_ASSISTANT_RESTORE, files);
}


static void assistant_restore_real_add_setup_pages (AssistantOperation* base) {
	AssistantRestore * self;
	self = (AssistantRestore*) base;
	assistant_restore_add_query_backend_page (self);
	assistant_restore_add_date_page (self);
	assistant_restore_add_restore_dest_page (self);
}


static GtkWidget* assistant_restore_make_backup_location_page (AssistantRestore* self) {
	GtkWidget* result = NULL;
	gint rows;
	GtkWidget* w;
	GtkWidget* label;
	GtkTable* page;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	rows = 0;
	w = NULL;
	label = NULL;
	page = g_object_ref_sink ((GtkTable*) gtk_table_new ((guint) rows, (guint) 2, FALSE));
	g_object_set ((GObject*) page, "row-spacing", 6, "column-spacing", 6, "border-width", 12, NULL);
	w = (_tmp0_ = (GtkWidget*) g_object_ref_sink (deja_dup_config_location_new ()), _g_object_unref0 (w), _tmp0_);
	label = (_tmp1_ = (GtkWidget*) g_object_ref_sink ((GtkLabel*) gtk_label_new_with_mnemonic (_ ("_Backup location:"))), _g_object_unref0 (label), _tmp1_);
	g_object_set ((GObject*) label, "xalign", 0.0f, "mnemonic-widget", w, NULL);
	gtk_table_attach (page, label, (guint) 0, (guint) 1, (guint) rows, (guint) (rows + 1), GTK_FILL, 0, (guint) 0, (guint) 0);
	gtk_table_attach (page, w, (guint) 1, (guint) 2, (guint) rows, (guint) (rows + 1), GTK_FILL | GTK_EXPAND, 0, (guint) 0, (guint) 0);
	rows = rows + 1;
	w = (_tmp2_ = (GtkWidget*) g_object_ref_sink (deja_dup_config_bool_new (DEJA_DUP_ENCRYPT_KEY, _ ("Backup files are _encrypted"))), _g_object_unref0 (w), _tmp2_);
	gtk_table_attach (page, w, (guint) 0, (guint) 2, (guint) rows, (guint) (rows + 1), GTK_FILL | GTK_EXPAND, GTK_FILL, (guint) 0, (guint) 0);
	rows = rows + 1;
	result = (GtkWidget*) page;
	_g_object_unref0 (w);
	_g_object_unref0 (label);
	return result;
}


static void assistant_restore_real_add_custom_config_pages (AssistantOperation* base) {
	AssistantRestore * self;
	GtkWidget* page;
	self = (AssistantRestore*) base;
	page = assistant_restore_make_backup_location_page (self);
	assistant_append_page ((Assistant*) self, page, ASSISTANT_TYPE_NORMAL);
	assistant_set_page_title ((Assistant*) self, page, _ ("Preferences"));
	_g_object_unref0 (page);
}


static GtkWidget* assistant_restore_make_query_backend_page (AssistantRestore* self) {
	GtkWidget* result = NULL;
	GtkProgressBar* _tmp0_;
	GtkVBox* page;
	g_return_val_if_fail (self != NULL, NULL);
	self->priv->query_progress_bar = (_tmp0_ = g_object_ref_sink ((GtkProgressBar*) gtk_progress_bar_new ()), _g_object_unref0 (self->priv->query_progress_bar), _tmp0_);
	page = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 6));
	g_object_set ((GObject*) page, "child", self->priv->query_progress_bar, "border-width", 12, NULL);
	gtk_container_child_set ((GtkContainer*) page, (GtkWidget*) self->priv->query_progress_bar, "expand", FALSE, NULL);
	result = (GtkWidget*) page;
	return result;
}


static GtkWidget* assistant_restore_make_date_page (AssistantRestore* self) {
	GtkWidget* result = NULL;
	GtkListStore* _tmp0_;
	GtkComboBox* _tmp1_;
	GtkLabel* date_label;
	GtkHBox* hbox;
	GtkVBox* page;
	g_return_val_if_fail (self != NULL, NULL);
	self->priv->date_store = (_tmp0_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING, NULL), _g_object_unref0 (self->priv->date_store), _tmp0_);
	self->priv->date_combo = (_tmp1_ = g_object_ref_sink ((GtkComboBox*) gtk_combo_box_new_text ()), _g_object_unref0 (self->priv->date_combo), _tmp1_);
	gtk_combo_box_set_model (self->priv->date_combo, (GtkTreeModel*) self->priv->date_store);
	date_label = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("_Date:")));
	g_object_set ((GObject*) date_label, "mnemonic-widget", self->priv->date_combo, "use-underline", TRUE, "xalign", 0.0f, NULL);
	hbox = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 6));
	g_object_set ((GObject*) hbox, "child", date_label, "child", self->priv->date_combo, NULL);
	page = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 6));
	g_object_set ((GObject*) page, "child", hbox, "border-width", 12, NULL);
	gtk_container_child_set ((GtkContainer*) hbox, (GtkWidget*) date_label, "expand", FALSE, NULL);
	gtk_container_child_set ((GtkContainer*) hbox, (GtkWidget*) self->priv->date_combo, "expand", FALSE, NULL);
	gtk_container_child_set ((GtkContainer*) page, (GtkWidget*) hbox, "expand", FALSE, NULL);
	result = (GtkWidget*) page;
	_g_object_unref0 (date_label);
	_g_object_unref0 (hbox);
	return result;
}


static void _lambda18_ (GtkToggleButton* r, AssistantRestore* self) {
	g_return_if_fail (r != NULL);
	if (gtk_toggle_button_get_active (r)) {
		assistant_restore_set_restore_location (self, "/");
	}
}


static void __lambda18__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	_lambda18_ (_sender, self);
}


static void _lambda19_ (GtkToggleButton* r, AssistantRestore* self) {
	g_return_if_fail (r != NULL);
	if (gtk_toggle_button_get_active (r)) {
		char* _tmp0_;
		assistant_restore_set_restore_location (self, _tmp0_ = gtk_file_chooser_get_filename ((GtkFileChooser*) self->priv->cust_button));
		_g_free0 (_tmp0_);
	}
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->cust_box, gtk_toggle_button_get_active (r));
}


static void __lambda19__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	_lambda19_ (_sender, self);
}


static void _lambda20_ (GtkFileChooser* b, AssistantRestore* self) {
	char* _tmp0_;
	g_return_if_fail (b != NULL);
	assistant_restore_set_restore_location (self, _tmp0_ = gtk_file_chooser_get_filename (b));
	_g_free0 (_tmp0_);
}


static void __lambda20__gtk_file_chooser_selection_changed (GtkFileChooser* _sender, gpointer self) {
	_lambda20_ (_sender, self);
}


static GtkWidget* assistant_restore_make_restore_dest_page (AssistantRestore* self) {
	GtkWidget* result = NULL;
	GtkRadioButton* orig_radio;
	GtkRadioButton* cust_radio;
	GtkFileChooserButton* _tmp0_;
	char* _tmp1_;
	GtkLabel* _tmp2_;
	GtkLabel* cust_label;
	GtkHBox* _tmp3_;
	GtkVBox* page;
	g_return_val_if_fail (self != NULL, NULL);
	orig_radio = g_object_ref_sink ((GtkRadioButton*) gtk_radio_button_new (NULL));
	g_object_set ((GObject*) orig_radio, "label", _ ("Restore files to _original locations"), "use-underline", TRUE, NULL);
	g_signal_connect_object ((GtkToggleButton*) orig_radio, "toggled", (GCallback) __lambda18__gtk_toggle_button_toggled, self, 0);
	cust_radio = g_object_ref_sink ((GtkRadioButton*) gtk_radio_button_new (NULL));
	g_object_set ((GObject*) cust_radio, "label", _ ("Restore to _specific folder"), "use-underline", TRUE, "group", orig_radio, NULL);
	g_signal_connect_object ((GtkToggleButton*) cust_radio, "toggled", (GCallback) __lambda19__gtk_toggle_button_toggled, self, 0);
	self->priv->cust_button = (_tmp0_ = g_object_ref_sink ((GtkFileChooserButton*) gtk_file_chooser_button_new (_ ("Choose destination for restored files"), GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER)), _g_object_unref0 (self->priv->cust_button), _tmp0_);
	g_signal_connect_object ((GtkFileChooser*) self->priv->cust_button, "selection-changed", (GCallback) __lambda20__gtk_file_chooser_selection_changed, self, 0);
	cust_label = (_tmp2_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (_tmp1_ = g_strconcat ("    ", _ ("Restore _folder:"), NULL))), _g_free0 (_tmp1_), _tmp2_);
	g_object_set ((GObject*) cust_label, "mnemonic-widget", self->priv->cust_button, "use-underline", TRUE, "xalign", 0.0f, NULL);
	self->priv->cust_box = (_tmp3_ = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 6)), _g_object_unref0 (self->priv->cust_box), _tmp3_);
	g_object_set ((GObject*) self->priv->cust_box, "child", cust_label, "child", self->priv->cust_button, "sensitive", FALSE, NULL);
	page = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 6));
	g_object_set ((GObject*) page, "child", orig_radio, "child", cust_radio, "child", self->priv->cust_box, "border-width", 12, NULL);
	gtk_container_child_set ((GtkContainer*) page, (GtkWidget*) orig_radio, "expand", FALSE, NULL);
	gtk_container_child_set ((GtkContainer*) page, (GtkWidget*) cust_radio, "expand", FALSE, NULL);
	gtk_container_child_set ((GtkContainer*) page, (GtkWidget*) self->priv->cust_box, "expand", FALSE, NULL);
	result = (GtkWidget*) page;
	_g_object_unref0 (orig_radio);
	_g_object_unref0 (cust_radio);
	_g_object_unref0 (cust_label);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GtkWidget* assistant_restore_real_make_confirm_page (AssistantOperation* base) {
	AssistantRestore * self;
	GtkWidget* result = NULL;
	gint rows;
	GtkWidget* label;
	GtkWidget* w;
	GtkTable* _tmp0_;
	GtkTable* page;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	GtkWidget* _tmp4_;
	GtkLabel* _tmp5_;
	GtkLabel* _tmp6_;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	GtkLabel* _tmp9_;
	GtkVBox* _tmp10_;
	self = (AssistantRestore*) base;
	rows = 0;
	label = NULL;
	w = NULL;
	self->priv->confirm_table = (_tmp0_ = g_object_ref_sink ((GtkTable*) gtk_table_new ((guint) rows, (guint) 3, FALSE)), _g_object_unref0 (self->priv->confirm_table), _tmp0_);
	page = _g_object_ref0 (self->priv->confirm_table);
	g_object_set ((GObject*) page, "row-spacing", 6, "column-spacing", 6, "border-width", 12, NULL);
	label = (_tmp1_ = (GtkWidget*) g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("Backup location:"))), _g_object_unref0 (label), _tmp1_);
	g_object_set ((GObject*) label, "xalign", 0.0f, NULL);
	w = (_tmp2_ = (GtkWidget*) g_object_ref_sink (deja_dup_config_label_location_new ()), _g_object_unref0 (w), _tmp2_);
	gtk_table_attach (page, label, (guint) 0, (guint) 1, (guint) rows, (guint) (rows + 1), GTK_FILL, 0, (guint) 0, (guint) 0);
	gtk_table_attach (page, w, (guint) 1, (guint) 2, (guint) rows, (guint) (rows + 1), GTK_FILL, 0, (guint) 0, (guint) 0);
	rows = rows + 1;
	label = (_tmp3_ = (GtkWidget*) g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("Encrypted:"))), _g_object_unref0 (label), _tmp3_);
	g_object_set ((GObject*) label, "xalign", 0.0f, NULL);
	w = (_tmp4_ = (GtkWidget*) g_object_ref_sink (deja_dup_config_label_bool_new (DEJA_DUP_ENCRYPT_KEY)), _g_object_unref0 (w), _tmp4_);
	gtk_table_attach (page, label, (guint) 0, (guint) 1, (guint) rows, (guint) (rows + 1), GTK_FILL, 0, (guint) 0, (guint) 0);
	gtk_table_attach (page, w, (guint) 1, (guint) 2, (guint) rows, (guint) (rows + 1), GTK_FILL, 0, (guint) 0, (guint) 0);
	rows = rows + 1;
	self->priv->confirm_date_label = (_tmp5_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("Restore date:"))), _g_object_unref0 (self->priv->confirm_date_label), _tmp5_);
	g_object_set ((GObject*) self->priv->confirm_date_label, "xalign", 0.0f, NULL);
	self->priv->confirm_date = (_tmp6_ = g_object_ref_sink ((GtkLabel*) gtk_label_new ("")), _g_object_unref0 (self->priv->confirm_date), _tmp6_);
	g_object_set ((GObject*) self->priv->confirm_date, "xalign", 0.0f, NULL);
	self->priv->confirm_date_row = rows;
	gtk_table_attach (page, (GtkWidget*) self->priv->confirm_date_label, (guint) 0, (guint) 1, (guint) rows, (guint) (rows + 1), GTK_FILL, 0, (guint) 0, (guint) 0);
	gtk_table_attach (page, (GtkWidget*) self->priv->confirm_date, (guint) 1, (guint) 2, (guint) rows, (guint) (rows + 1), GTK_FILL, 0, (guint) 0, (guint) 0);
	rows = rows + 1;
	self->priv->confirm_location_label = (_tmp7_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("Restore folder:"))), _g_object_unref0 (self->priv->confirm_location_label), _tmp7_);
	g_object_set ((GObject*) self->priv->confirm_location_label, "xalign", 0.0f, NULL);
	self->priv->confirm_location = (_tmp8_ = g_object_ref_sink ((GtkLabel*) gtk_label_new ("")), _g_object_unref0 (self->priv->confirm_location), _tmp8_);
	g_object_set ((GObject*) self->priv->confirm_location, "xalign", 0.0f, NULL);
	self->priv->confirm_location_row = rows;
	gtk_table_attach (page, (GtkWidget*) self->priv->confirm_location_label, (guint) 0, (guint) 1, (guint) rows, (guint) (rows + 1), GTK_FILL, 0, (guint) 0, (guint) 0);
	gtk_table_attach (page, (GtkWidget*) self->priv->confirm_location, (guint) 1, (guint) 2, (guint) rows, (guint) (rows + 1), GTK_FILL, 0, (guint) 0, (guint) 0);
	rows = rows + 1;
	self->priv->confirm_files_label = (_tmp9_ = g_object_ref_sink ((GtkLabel*) gtk_label_new ("")), _g_object_unref0 (self->priv->confirm_files_label), _tmp9_);
	g_object_set ((GObject*) self->priv->confirm_files_label, "xalign", 0.0f, "yalign", 0.0f, NULL);
	self->priv->confirm_files = (_tmp10_ = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (TRUE, 6)), _g_object_unref0 (self->priv->confirm_files), _tmp10_);
	self->priv->confirm_files_row = rows;
	gtk_table_attach (page, (GtkWidget*) self->priv->confirm_files_label, (guint) 0, (guint) 1, (guint) rows, (guint) (rows + 1), GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
	gtk_table_attach (page, (GtkWidget*) self->priv->confirm_files, (guint) 1, (guint) 2, (guint) rows, (guint) (rows + 1), GTK_FILL, 0, (guint) 0, (guint) 0);
	rows = rows + 1;
	result = (GtkWidget*) page;
	_g_object_unref0 (label);
	_g_object_unref0 (w);
	return result;
}


static void assistant_restore_add_query_backend_page (AssistantRestore* self) {
	GtkWidget* page;
	GtkWidget* _tmp0_;
	g_return_if_fail (self != NULL);
	page = assistant_restore_make_query_backend_page (self);
	assistant_append_page ((Assistant*) self, page, ASSISTANT_TYPE_PROGRESS);
	assistant_set_page_title ((Assistant*) self, page, _ ("Checking for Backups"));
	self->priv->query_progress_page = (_tmp0_ = _g_object_ref0 (page), _g_object_unref0 (self->priv->query_progress_page), _tmp0_);
	_g_object_unref0 (page);
}


static void assistant_restore_add_date_page (AssistantRestore* self) {
	GtkWidget* page;
	GtkWidget* _tmp0_;
	g_return_if_fail (self != NULL);
	page = assistant_restore_make_date_page (self);
	assistant_append_page ((Assistant*) self, page, ASSISTANT_TYPE_NORMAL);
	assistant_set_page_title ((Assistant*) self, page, _ ("Restore from When?"));
	self->priv->date_page = (_tmp0_ = _g_object_ref0 (page), _g_object_unref0 (self->priv->date_page), _tmp0_);
	_g_object_unref0 (page);
}


static void assistant_restore_add_restore_dest_page (AssistantRestore* self) {
	GtkWidget* page;
	GtkWidget* _tmp0_;
	g_return_if_fail (self != NULL);
	page = assistant_restore_make_restore_dest_page (self);
	assistant_append_page ((Assistant*) self, page, ASSISTANT_TYPE_NORMAL);
	assistant_set_page_title ((Assistant*) self, page, _ ("Restore to Where?"));
	self->priv->restore_dest_page = (_tmp0_ = _g_object_ref0 (page), _g_object_unref0 (self->priv->restore_dest_page), _tmp0_);
	_g_object_unref0 (page);
}


static DejaDupOperation* assistant_restore_real_create_op (AssistantOperation* base) {
	AssistantRestore * self;
	DejaDupOperation* result = NULL;
	char* date;
	XID xid;
	DejaDupOperationRestore* rest_op;
	self = (AssistantRestore*) base;
	date = NULL;
	if (self->priv->got_dates) {
		GtkTreeIter iter = {0};
		if (gtk_combo_box_get_active_iter (self->priv->date_combo, &iter)) {
			gtk_tree_model_get ((GtkTreeModel*) self->priv->date_store, &iter, 1, &date, -1);
		}
	}
	gtk_widget_realize ((GtkWidget*) self);
	xid = gdk_x11_drawable_get_xid ((GdkDrawable*) ((GtkWidget*) self)->window);
	rest_op = deja_dup_operation_restore_new (self->priv->_restore_location, date, assistant_restore_get_restore_files (self), (guint) xid);
	if (self->priv->op_state != NULL) {
		deja_dup_operation_set_state ((DejaDupOperation*) rest_op, self->priv->op_state);
	}
	result = (DejaDupOperation*) rest_op;
	_g_free0 (date);
	return result;
}


static char* assistant_restore_real_get_progress_file_prefix (AssistantOperation* base) {
	AssistantRestore * self;
	char* result = NULL;
	self = (AssistantRestore*) base;
	result = g_strdup (_ ("Restoring:"));
	return result;
}


static void assistant_restore_real_set_op_icon_name (AssistantOperation* base) {
	AssistantRestore * self;
	self = (AssistantRestore*) base;
	gtk_window_set_icon_name ((GtkWindow*) self, "deja-dup-restore");
}


static void g_time_local (time_t time, struct tm* result) {
	struct tm _result_ = {0};
	localtime_r (&time, &_result_);
	*result = _result_;
	return;
}


static char* g_time_format (struct tm *self, const char* format) {
	char* result = NULL;
	gchar* _tmp0_;
	gint _buffer_size_;
	gint buffer_length1;
	gchar* buffer;
	g_return_val_if_fail (format != NULL, NULL);
	buffer = (_tmp0_ = g_new0 (gchar, 64), buffer_length1 = 64, _buffer_size_ = buffer_length1, _tmp0_);
	strftime (buffer, buffer_length1, format, &(*self));
	result = g_strdup ((const char*) buffer);
	buffer = (g_free (buffer), NULL);
	return result;
}


void assistant_restore_handle_collection_dates (AssistantRestore* self, DejaDupOperationStatus* op, GList* dates) {
	GTimeVal tv = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	g_get_current_time (&tv);
	self->priv->got_dates = TRUE;
	gtk_list_store_clear (self->priv->date_store);
	{
		GList* date_collection;
		GList* date_it;
		date_collection = dates;
		for (date_it = date_collection; date_it != NULL; date_it = date_it->next) {
			char* date;
			date = g_strdup ((const char*) date_it->data);
			{
				if (g_time_val_from_iso8601 (date, &tv)) {
					struct tm _tmp0_ = {0};
					struct tm t;
					char* user_str;
					GtkTreeIter iter = {0};
					t = (g_time_local ((time_t) tv.tv_sec, &_tmp0_), _tmp0_);
					user_str = g_time_format (&t, "%c");
					gtk_list_store_prepend (self->priv->date_store, &iter);
					gtk_list_store_set (self->priv->date_store, &iter, 0, user_str, 1, date, -1);
					gtk_combo_box_set_active_iter (self->priv->date_combo, &iter);
					_g_free0 (user_str);
				}
				_g_free0 (date);
			}
		}
	}
	if (gtk_tree_model_iter_n_children ((GtkTreeModel*) self->priv->date_store, NULL) == 0) {
		assistant_operation_show_error ((AssistantOperation*) self, _ ("No backups to restore"), NULL);
	}
}


void assistant_restore_query_finished (AssistantRestore* self, DejaDupOperation* op, gboolean success, gboolean cancelled) {
	DejaDupOperationState* _tmp0_;
	DejaDupOperationStatus* _tmp1_;
	DejaDupOperation* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	self->priv->op_state = (_tmp0_ = deja_dup_operation_get_state (op), _deja_dup_operation_state_unref0 (self->priv->op_state), _tmp0_);
	self->priv->query_op = (_tmp1_ = NULL, _g_object_unref0 (self->priv->query_op), _tmp1_);
	((AssistantOperation*) self)->op = (_tmp2_ = NULL, _g_object_unref0 (((AssistantOperation*) self)->op), _tmp2_);
	if (cancelled) {
		assistant_operation_do_close ((AssistantOperation*) self);
	} else {
		if (success) {
			assistant_go_forward ((Assistant*) self);
		}
	}
}


static gboolean assistant_restore_query_pulse (AssistantRestore* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	gtk_progress_bar_pulse (self->priv->query_progress_bar);
	result = TRUE;
	return result;
}


static void _assistant_restore_handle_collection_dates_deja_dup_operation_status_collection_dates (DejaDupOperationStatus* _sender, GList* dates, gpointer self) {
	assistant_restore_handle_collection_dates (self, _sender, dates);
}


static void _assistant_restore_query_finished_deja_dup_operation_done (DejaDupOperation* _sender, gboolean success, gboolean cancelled, gpointer self) {
	assistant_restore_query_finished (self, _sender, success, cancelled);
}


static void _assistant_operation_get_passphrase_deja_dup_operation_passphrase_required (DejaDupOperation* _sender, gpointer self) {
	assistant_operation_get_passphrase (self);
}


static void _lambda21_ (DejaDupOperation* o, const char* e, const char* d, AssistantRestore* self) {
	g_return_if_fail (o != NULL);
	g_return_if_fail (e != NULL);
	assistant_operation_show_error ((AssistantOperation*) self, e, d);
}


static void __lambda21__deja_dup_operation_raise_error (DejaDupOperation* _sender, const char* errstr, const char* detail, gpointer self) {
	_lambda21_ (_sender, errstr, detail, self);
}


void assistant_restore_do_query (AssistantRestore* self) {
	GError * _inner_error_;
	XID xid;
	DejaDupOperationStatus* _tmp1_;
	DejaDupOperation* _tmp2_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	if (((AssistantOperation*) self)->mount_op == NULL) {
		GMountOperation* _tmp0_;
		((AssistantOperation*) self)->mount_op = (_tmp0_ = (GMountOperation*) mount_operation_assistant_new ((AssistantOperation*) self), _g_object_unref0 (((AssistantOperation*) self)->mount_op), _tmp0_);
	}
	gtk_widget_realize ((GtkWidget*) self);
	xid = gdk_x11_drawable_get_xid ((GdkDrawable*) ((GtkWidget*) self)->window);
	self->priv->query_op = (_tmp1_ = deja_dup_operation_status_new ((guint) xid), _g_object_unref0 (self->priv->query_op), _tmp1_);
	g_signal_connect_object (self->priv->query_op, "collection-dates", (GCallback) _assistant_restore_handle_collection_dates_deja_dup_operation_status_collection_dates, self, 0);
	g_signal_connect_object ((DejaDupOperation*) self->priv->query_op, "done", (GCallback) _assistant_restore_query_finished_deja_dup_operation_done, self, 0);
	((AssistantOperation*) self)->op = (_tmp2_ = _g_object_ref0 ((DejaDupOperation*) self->priv->query_op), _g_object_unref0 (((AssistantOperation*) self)->op), _tmp2_);
	deja_dup_backend_set_mount_op (deja_dup_operation_get_backend (((AssistantOperation*) self)->op), ((AssistantOperation*) self)->mount_op);
	g_signal_connect_object (((AssistantOperation*) self)->op, "passphrase-required", (GCallback) _assistant_operation_get_passphrase_deja_dup_operation_passphrase_required, (AssistantOperation*) self, 0);
	g_signal_connect_object (((AssistantOperation*) self)->op, "raise-error", (GCallback) __lambda21__deja_dup_operation_raise_error, self, 0);
	{
		deja_dup_operation_start ((DejaDupOperation*) self->priv->query_op, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("AssistantRestore.vala:369: %s\n", e->message);
			assistant_operation_show_error ((AssistantOperation*) self, e->message, NULL);
			assistant_restore_query_finished (self, (DejaDupOperation*) self->priv->query_op, FALSE, FALSE);
			_g_error_free0 (e);
		}
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static gboolean _assistant_restore_query_pulse_gsource_func (gpointer self) {
	return assistant_restore_query_pulse (self);
}


static void assistant_restore_real_do_prepare (AssistantOperation* base, Assistant* assist, GtkWidget* page) {
	AssistantRestore * self;
	self = (AssistantRestore*) base;
	g_return_if_fail (assist != NULL);
	g_return_if_fail (page != NULL);
	ASSISTANT_OPERATION_CLASS (assistant_restore_parent_class)->do_prepare (ASSISTANT_OPERATION (self), assist, page);
	if (self->priv->query_timeout_id > 0) {
		g_source_remove (self->priv->query_timeout_id);
		self->priv->query_timeout_id = (guint) 0;
	}
	if (page == self->priv->date_page) {
		if (!self->priv->got_dates) {
			assistant_go_forward ((Assistant*) self);
		}
	} else {
		if (page == self->priv->restore_dest_page) {
			if (assistant_restore_get_restore_files (self) != NULL) {
				assistant_go_forward ((Assistant*) self);
			}
		} else {
			if (page == assistant_operation_get_confirm_page ((AssistantOperation*) self)) {
				if (self->priv->got_dates) {
					gtk_label_set_label (self->priv->confirm_date, gtk_combo_box_get_active_text (self->priv->date_combo));
					gtk_widget_show ((GtkWidget*) self->priv->confirm_date_label);
					gtk_widget_show ((GtkWidget*) self->priv->confirm_date);
					gtk_table_set_row_spacing (self->priv->confirm_table, (guint) self->priv->confirm_date_row, gtk_table_get_default_row_spacing (self->priv->confirm_table));
				} else {
					gtk_widget_hide ((GtkWidget*) self->priv->confirm_date_label);
					gtk_widget_hide ((GtkWidget*) self->priv->confirm_date);
					gtk_table_set_row_spacing (self->priv->confirm_table, (guint) self->priv->confirm_date_row, (guint) 0);
				}
				if (assistant_restore_get_restore_files (self) == NULL) {
					if (_vala_strcmp0 (self->priv->_restore_location, "/") == 0) {
						gtk_label_set_label (self->priv->confirm_location, _ ("Original location"));
					} else {
						char* _tmp1_;
						GFile* _tmp0_;
						gtk_label_set_label (self->priv->confirm_location, _tmp1_ = deja_dup_get_file_desc (_tmp0_ = g_file_new_for_path (self->priv->_restore_location)));
						_g_free0 (_tmp1_);
						_g_object_unref0 (_tmp0_);
					}
					gtk_widget_show ((GtkWidget*) self->priv->confirm_location_label);
					gtk_widget_show ((GtkWidget*) self->priv->confirm_location);
					gtk_table_set_row_spacing (self->priv->confirm_table, (guint) self->priv->confirm_location_row, gtk_table_get_default_row_spacing (self->priv->confirm_table));
					gtk_widget_hide ((GtkWidget*) self->priv->confirm_files_label);
					gtk_widget_hide ((GtkWidget*) self->priv->confirm_files);
					gtk_table_set_row_spacing (self->priv->confirm_table, (guint) self->priv->confirm_files_row, (guint) 0);
				} else {
					gtk_label_set_label (self->priv->confirm_files_label, ngettext ("File to restore:", "Files to restore:", (gulong) g_list_length (assistant_restore_get_restore_files (self))));
					{
						GList* f_collection;
						GList* f_it;
						f_collection = assistant_restore_get_restore_files (self);
						for (f_it = f_collection; f_it != NULL; f_it = f_it->next) {
							GFile* f;
							f = _g_object_ref0 ((GFile*) f_it->data);
							{
								char* parse_name;
								char* _tmp2_;
								GtkLabel* _tmp3_;
								GtkLabel* file_label;
								parse_name = g_file_get_parse_name (f);
								file_label = (_tmp3_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (_tmp2_ = g_path_get_basename (parse_name))), _g_free0 (_tmp2_), _tmp3_);
								gtk_widget_set_tooltip_text ((GtkWidget*) file_label, parse_name);
								g_object_set ((GObject*) file_label, "xalign", 0.0f, NULL);
								gtk_container_add ((GtkContainer*) self->priv->confirm_files, (GtkWidget*) file_label);
								_g_object_unref0 (f);
								_g_free0 (parse_name);
								_g_object_unref0 (file_label);
							}
						}
					}
					gtk_widget_hide ((GtkWidget*) self->priv->confirm_location_label);
					gtk_widget_hide ((GtkWidget*) self->priv->confirm_location);
					gtk_table_set_row_spacing (self->priv->confirm_table, (guint) self->priv->confirm_location_row, (guint) 0);
					gtk_widget_show ((GtkWidget*) self->priv->confirm_files_label);
					gtk_widget_show_all ((GtkWidget*) self->priv->confirm_files);
					gtk_table_set_row_spacing (self->priv->confirm_table, (guint) self->priv->confirm_files_row, gtk_table_get_default_row_spacing (self->priv->confirm_table));
				}
			} else {
				if (page == assistant_operation_get_summary_page ((AssistantOperation*) self)) {
					if (assistant_operation_get_error_occurred ((AssistantOperation*) self)) {
						assistant_set_page_title ((Assistant*) self, page, _ ("Restore Failed"));
					} else {
						assistant_set_page_title ((Assistant*) self, page, _ ("Restore Finished"));
						gtk_label_set_label (((AssistantOperation*) self)->summary_label, _ ("Your files were successfully restored."));
					}
				} else {
					if (page == assistant_operation_get_progress_page ((AssistantOperation*) self)) {
						assistant_set_page_title ((Assistant*) self, page, _ ("Restoring…"));
					} else {
						if (page == self->priv->query_progress_page) {
							gboolean _tmp4_ = FALSE;
							gtk_progress_bar_set_fraction (self->priv->query_progress_bar, (double) 0);
							self->priv->query_timeout_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 250, _assistant_restore_query_pulse_gsource_func, g_object_ref (self), g_object_unref);
							if (self->priv->query_op != NULL) {
								_tmp4_ = deja_dup_operation_get_needs_password ((DejaDupOperation*) self->priv->query_op);
							} else {
								_tmp4_ = FALSE;
							}
							if (_tmp4_) {
								assistant_operation_provide_password ((AssistantOperation*) self);
							} else {
								if (self->priv->query_op == NULL) {
									assistant_restore_do_query (self);
								}
							}
						}
					}
				}
			}
		}
	}
}


static void assistant_restore_real_do_close (AssistantOperation* base) {
	AssistantRestore * self;
	self = (AssistantRestore*) base;
	if (self->priv->query_timeout_id > 0) {
		g_source_remove (self->priv->query_timeout_id);
		self->priv->query_timeout_id = (guint) 0;
	}
	ASSISTANT_OPERATION_CLASS (assistant_restore_parent_class)->do_close (ASSISTANT_OPERATION (self));
}


AssistantRestore* assistant_restore_construct (GType object_type) {
	AssistantRestore * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


AssistantRestore* assistant_restore_new (void) {
	return assistant_restore_construct (TYPE_ASSISTANT_RESTORE);
}


const char* assistant_restore_get_restore_location (AssistantRestore* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_restore_location;
	return result;
}


void assistant_restore_set_restore_location (AssistantRestore* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_restore_location = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_restore_location), _tmp0_);
	g_object_notify ((GObject *) self, "restore-location");
}


GList* assistant_restore_get_restore_files (AssistantRestore* self) {
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_restore_files;
	return result;
}


void assistant_restore_set_restore_files (AssistantRestore* self, GList* value) {
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	{
		GList* f_collection;
		GList* f_it;
		f_collection = self->priv->_restore_files;
		for (f_it = f_collection; f_it != NULL; f_it = f_it->next) {
			GFile* f;
			f = _g_object_ref0 ((GFile*) f_it->data);
			{
				g_object_unref ((GObject*) f);
				_g_object_unref0 (f);
			}
		}
	}
	self->priv->_restore_files = (_tmp0_ = g_list_copy (value), __g_list_free_g_object_unref0 (self->priv->_restore_files), _tmp0_);
	{
		GList* f_collection;
		GList* f_it;
		f_collection = self->priv->_restore_files;
		for (f_it = f_collection; f_it != NULL; f_it = f_it->next) {
			GFile* f;
			f = _g_object_ref0 ((GFile*) f_it->data);
			{
				g_object_ref ((GObject*) f);
				_g_object_unref0 (f);
			}
		}
	}
	g_object_notify ((GObject *) self, "restore-files");
}


static GObject * assistant_restore_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	AssistantRestore * self;
	parent_class = G_OBJECT_CLASS (assistant_restore_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = ASSISTANT_RESTORE (obj);
	{
		gtk_window_set_title ((GtkWindow*) self, _ ("Restore"));
		assistant_set_apply_text ((Assistant*) self, _ ("_Restore"));
	}
	return obj;
}


static void assistant_restore_class_init (AssistantRestoreClass * klass) {
	assistant_restore_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AssistantRestorePrivate));
	ASSISTANT_OPERATION_CLASS (klass)->add_setup_pages = assistant_restore_real_add_setup_pages;
	ASSISTANT_OPERATION_CLASS (klass)->add_custom_config_pages = assistant_restore_real_add_custom_config_pages;
	ASSISTANT_OPERATION_CLASS (klass)->make_confirm_page = assistant_restore_real_make_confirm_page;
	ASSISTANT_OPERATION_CLASS (klass)->create_op = assistant_restore_real_create_op;
	ASSISTANT_OPERATION_CLASS (klass)->get_progress_file_prefix = assistant_restore_real_get_progress_file_prefix;
	ASSISTANT_OPERATION_CLASS (klass)->set_op_icon_name = assistant_restore_real_set_op_icon_name;
	ASSISTANT_OPERATION_CLASS (klass)->do_prepare = assistant_restore_real_do_prepare;
	ASSISTANT_OPERATION_CLASS (klass)->do_close = assistant_restore_real_do_close;
	G_OBJECT_CLASS (klass)->get_property = assistant_restore_get_property;
	G_OBJECT_CLASS (klass)->set_property = assistant_restore_set_property;
	G_OBJECT_CLASS (klass)->constructor = assistant_restore_constructor;
	G_OBJECT_CLASS (klass)->finalize = assistant_restore_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_RESTORE_RESTORE_LOCATION, g_param_spec_string ("restore-location", "restore-location", "restore-location", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_RESTORE_RESTORE_FILES, g_param_spec_pointer ("restore-files", "restore-files", "restore-files", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void assistant_restore_instance_init (AssistantRestore * self) {
	self->priv = ASSISTANT_RESTORE_GET_PRIVATE (self);
	self->priv->_restore_location = g_strdup ("/");
}


static void assistant_restore_finalize (GObject* obj) {
	AssistantRestore * self;
	self = ASSISTANT_RESTORE (obj);
	_g_free0 (self->priv->_restore_location);
	__g_list_free_g_object_unref0 (self->priv->_restore_files);
	_g_object_unref0 (self->priv->query_op);
	_deja_dup_operation_state_unref0 (self->priv->op_state);
	_g_object_unref0 (self->priv->query_progress_bar);
	_g_object_unref0 (self->priv->date_combo);
	_g_object_unref0 (self->priv->date_store);
	_g_object_unref0 (self->priv->cust_box);
	_g_object_unref0 (self->priv->cust_button);
	_g_object_unref0 (self->priv->confirm_table);
	_g_object_unref0 (self->priv->confirm_location_label);
	_g_object_unref0 (self->priv->confirm_location);
	_g_object_unref0 (self->priv->confirm_date_label);
	_g_object_unref0 (self->priv->confirm_date);
	_g_object_unref0 (self->priv->confirm_files_label);
	_g_object_unref0 (self->priv->confirm_files);
	_g_object_unref0 (self->priv->query_progress_page);
	_g_object_unref0 (self->priv->date_page);
	_g_object_unref0 (self->priv->restore_dest_page);
	G_OBJECT_CLASS (assistant_restore_parent_class)->finalize (obj);
}


GType assistant_restore_get_type (void) {
	static volatile gsize assistant_restore_type_id__volatile = 0;
	if (g_once_init_enter (&assistant_restore_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AssistantRestoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) assistant_restore_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AssistantRestore), 0, (GInstanceInitFunc) assistant_restore_instance_init, NULL };
		GType assistant_restore_type_id;
		assistant_restore_type_id = g_type_register_static (TYPE_ASSISTANT_OPERATION, "AssistantRestore", &g_define_type_info, 0);
		g_once_init_leave (&assistant_restore_type_id__volatile, assistant_restore_type_id);
	}
	return assistant_restore_type_id__volatile;
}


static void assistant_restore_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	AssistantRestore * self;
	self = ASSISTANT_RESTORE (object);
	switch (property_id) {
		case ASSISTANT_RESTORE_RESTORE_LOCATION:
		g_value_set_string (value, assistant_restore_get_restore_location (self));
		break;
		case ASSISTANT_RESTORE_RESTORE_FILES:
		g_value_set_pointer (value, assistant_restore_get_restore_files (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void assistant_restore_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	AssistantRestore * self;
	self = ASSISTANT_RESTORE (object);
	switch (property_id) {
		case ASSISTANT_RESTORE_RESTORE_LOCATION:
		assistant_restore_set_restore_location (self, g_value_get_string (value));
		break;
		case ASSISTANT_RESTORE_RESTORE_FILES:
		assistant_restore_set_restore_files (self, g_value_get_pointer (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




