/****************************************************************************

Copyright (c) Intel Corporation (2008).

DISCLAIMER OF WARRANTY
NEITHER INTEL NOR ITS SUPPLIERS MAKE ANY REPRESENTATION OR WARRANTY OR
CONDITION OF ANY KIND WHETHER EXPRESS OR IMPLIED (EITHER IN FACT OR BY
OPERATION OF LAW) WITH RESPECT TO THE SOURCE CODE.  INTEL AND ITS SUPPLIERS
EXPRESSLY DISCLAIM ALL WARRANTIES OR CONDITIONS OF MERCHANTABILITY OR
FITNESS FOR A PARTICULAR PURPOSE.  INTEL AND ITS SUPPLIERS DO NOT WARRANT
THAT THE SOURCE CODE IS ERROR-FREE OR THAT OPERATION OF THE SOURCE CODE WILL
BE SECURE OR UNINTERRUPTED AND HEREBY DISCLAIM ANY AND ALL LIABILITY ON
ACCOUNT THEREOF.  THERE IS ALSO NO IMPLIED WARRANTY OF NON-INFRINGEMENT.
SOURCE CODE IS LICENSED TO LICENSEE ON AN "AS IS" BASIS AND NEITHER INTEL
NOR ITS SUPPLIERS WILL PROVIDE ANY SUPPORT, ASSISTANCE, INSTALLATION,
TRAINING OR OTHER SERVICES.  INTEL AND ITS SUPPLIERS WILL NOT PROVIDE ANY
UPDATES, ENHANCEMENTS OR EXTENSIONS.

File Name:          PMDriver.h

Description:

    This file defines some interface for operating Power Management driver.

Environment (opt):

    OS: Ubuntu
    SE: Code::Block

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                         Deng Jing 2008-7-20

  =====================================================================

****************************************************************************/

#ifndef PMDRIVER_H
#define PMDRIVER_H

#include <fcntl.h>
#define ACPI_MAX_STRING 80
#define DEVICE "/dev/ipml_pm"

#ifdef __cplusplus
extern "C" {
#endif

void get_path(int fd, char *path, int *entries, int level, char *pRetPath);

int get_brightness(int fd, char* path);
int set_brightness(int fd, char* path, int value);
int get_wireless(int fd, char* path);
int set_wireless(int fd, char* path, int value);
int get_landevice(int fd, char* path);
int set_landevice(int fd, char* path, int value);

#ifdef __cplusplus
}
#endif /** __cplusplus */

#endif
