/*
 * Copyright (C) 2008  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License, version 2.1, as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#include "AccelApi.h"
#include "ReqMgmt.h"
#include "accel/AccelPlugin.h"
#include "accel/AccelDef.h"
extern int DCS_WaitResponse(DCS_Response* pResponse, int, int);
extern DCS_Return_Code DCS_DispatchEvent();
extern int DCS_Lock();
extern int DCS_Unlock();
static int GetModuleID()
{
	return DCS_ACCELEROMETER;
}

DCS_Return_Code DCS_GetAccelForGravity(CHAR *pValue)
{//add one lock, DCS_Initialize to init one critical section
	DCS_Lock();
    DCS_Return_Code ret = DCS_SUCCESS;
    ReqMgmt* pReqMgmt = ReqMgmt::Instance();
	ret = pReqMgmt->GenFuncReq(GetModuleID(),ACCEL_GET_MEASUREMENT, 0, NULL);
	if (ret) 
    {
         DCS_Unlock();
         return ret;
    }
	DCS_Response response;
	
	memset(&response, 0, sizeof(response));
	DCS_DispatchEvent();
	
	DCS_WaitResponse(&response, GetModuleID(), ACCEL_GET_MEASUREMENT);
	if (response.returnCode == DCS_SUCCESS && response.data != NULL)
		*pValue = *(response.data);
//release one lock	
    DCS_Unlock();

	if (response.data != NULL)
	{
		delete[]response.data;
		response.data = NULL;
	}

	return response.returnCode;
}

/** Gets acceleration data from driver */
DCS_Return_Code DCS_GetAccelData(PDCS_Accel_Data pData)
{
	DCS_Lock();
    DCS_Return_Code ret = DCS_SUCCESS;
    ReqMgmt* pReqMgmt = ReqMgmt::Instance();
	ret = pReqMgmt->GenFuncReq(GetModuleID(),ACCEL_GET_DATA, 0, NULL);
	if (ret) 
    {
         DCS_Unlock();
         return ret;
    }
	DCS_Response response;
	
	memset(&response, 0, sizeof(response));
	DCS_DispatchEvent();
	
	DCS_WaitResponse(&response,  GetModuleID(), ACCEL_GET_DATA);
	
	if (response.data != NULL )//&& response.dataLen == sizeof(DCS_Accel_Data))
		*pData = *((PDCS_Accel_Data )(response.data));
	DCS_Unlock();

	if (response.data != NULL)
	{
		delete[]response.data;
		response.data = NULL;
	}

	return response.returnCode;
}

/** Registers the callback function to receive acceleration data change. */
DCS_Return_Code DCS_RegisterAccelCallback(DCS_Accel_Callback pCallback)
{
	DCS_Lock();
    DCS_Return_Code ret = DCS_SUCCESS;
	ReqMgmt* pReqMgmt = ReqMgmt::Instance();
	ret = pReqMgmt->GenEventReq(GetModuleID(), ACCEL_DATA_CHANGED, (DCS_Callback)pCallback);
	if (ret) {
         DCS_Unlock();
         return ret;
    }
	DCS_DispatchEvent();
    DCS_Unlock();
	return DCS_SUCCESS;	
}

/** Unregisters the callback function to receive acceleration data change. */
DCS_Return_Code DCS_UnregisterAccelCallback()
{
	DCS_Lock();
    ReqMgmt* pReqMgmt = ReqMgmt::Instance();
	DCS_Return_Code ret =  pReqMgmt->GenUnregisterEventReq(GetModuleID(),ACCEL_DATA_CHANGED);
	//DCS_Return_Code ret =  pReqMgmt->GenEventReq(GetModuleID(),ACCEL_UNREGISTER_CALLBACK, NULL);
    DCS_Unlock();
    return ret;
}

/** Registers callback function to be notified when the system orientation is changed. */
DCS_Return_Code DCS_RegisterSystemOrientationCallback(DCS_SystemOrientation_Callback pCallback)
{
	DCS_Lock();
    DCS_Return_Code ret = DCS_SUCCESS;
	ReqMgmt* pReqMgmt = ReqMgmt::Instance();
	ret = pReqMgmt->GenEventReq(GetModuleID(), ACCEL_SYSTEM_ORIENTATION_CHANGED, (DCS_Callback)pCallback);
	if (ret) {
         DCS_Unlock();
         return ret;
    }
	DCS_DispatchEvent();
	DCS_Unlock();
    return DCS_SUCCESS;	
}

/** Unregisters and stop being notified if the system orientation is changed. */
DCS_Return_Code DCS_UnregisterSystemOrientationCallback()
{
	DCS_Lock();
    ReqMgmt* pReqMgmt = ReqMgmt::Instance();
	DCS_Return_Code ret =  pReqMgmt->GenUnregisterEventReq(GetModuleID(),ACCEL_SYSTEM_ORIENTATION_CHANGED);
	//DCS_Return_Code ret =  pReqMgmt->GenEventReq(GetModuleID(),ACCEL_SCREEN_ROTATION_UNREGISTER_CALLBACK, NULL);
    DCS_Unlock();
    return ret;

}

/**
 * Enables the system orientation change event to make desktop
 * auto-rotation possible.  This notification event is sent whenever the
 * accelerometer detects a big system orientation change so that a
 * desktop auto-rotation should occur.
 * <p>Normal application should NOT use this API.  This API will reverse
 * the effect of all previous #DCS_DisableDesktopAutoRotation calls from
 * all clients, and re-enable the desktop auto-rotation unconditionally.
 * It may be harmful and cause unwanted effects.
 */
DCSAPI DCS_Return_Code DCS_EnableDesktopAutoRotation(void)
{
	DCS_Lock();
    ReqMgmt* pReqMgmt = ReqMgmt::Instance();
	DCS_Response response;
	memset(&response, 0, sizeof(response));
	
	//DCS_DesktopAutoRotationStatus status = DCS_DESKTOP_AUTOROTATION_STATUS_ENABLE;
	DCS_Return_Code ret = pReqMgmt->GenFuncReq(GetModuleID(),ACCEL_ENABLE_DESKTOP_AUTOROTATION, 0, NULL);
	if (ret) {
         DCS_Unlock();
         return ret;
    }
    DCS_DispatchEvent();
	
	DCS_WaitResponse(&response,  GetModuleID(), ACCEL_ENABLE_DESKTOP_AUTOROTATION);
	DCS_Unlock();
    return response.returnCode;
}

/**
 * Disables the system orientation change event to make desktop
 * auto-rotation possible.  It can be undone by
 * #DCS_UnDisableDesktopAutoRotation.
 */
DCSAPI DCS_Return_Code DCS_DisableDesktopAutoRotation(void)
{
	DCS_Lock();
    ReqMgmt* pReqMgmt = ReqMgmt::Instance();
	DCS_Response response;
	memset(&response, 0, sizeof(response));
	
	//DCS_DesktopAutoRotationStatus status = DCS_DESKTOP_AUTOROTATION_STATUS_DISABLE;
	DCS_Return_Code ret = pReqMgmt->GenFuncReq(GetModuleID(),ACCEL_DISABLE_DESKTOP_AUTOROTATION, 0, NULL);
	if (ret) {
         DCS_Unlock();
         return ret;
    }
    DCS_DispatchEvent();
	
	DCS_WaitResponse(&response,  GetModuleID(), ACCEL_DISABLE_DESKTOP_AUTOROTATION);
	DCS_Unlock();
    return response.returnCode;
}

/**
 * Undoes the previous #DCS_DisableDesktopAutoRotation calls from the
 * current client.  If other clients have disabled desktop
 * auto-rotation, the system desktop auto-rotation status will remain
 * disabled.  Normally, applications should use this API to disable
 * desktop auto-rotation temporarily.
 */
DCSAPI DCS_Return_Code DCS_UnDisableDesktopAutoRotation(void)
{
	DCS_Lock();
	ReqMgmt* pReqMgmt = ReqMgmt::Instance();
	DCS_Response response;
	memset(&response, 0, sizeof(response));
	
	//DCS_DesktopAutoRotationStatus status = DCS_DESKTOP_AUTOROTATION_STATUS_UNDISABLE;
	DCS_Return_Code ret = pReqMgmt->GenFuncReq(GetModuleID(),ACCEL_UNDISABLE_DESKTOP_AUTOROTATION, 0, NULL);
	if (ret) {
         DCS_Unlock();
         return ret;
    }
    DCS_DispatchEvent();
	
	DCS_WaitResponse(&response,  GetModuleID(), ACCEL_UNDISABLE_DESKTOP_AUTOROTATION);
	DCS_Unlock();
    return response.returnCode;
}

/** Get the enabled/disabled status of the notification when system orientation changes. */
DCS_Return_Code DCS_GetDesktopAutoRotationStatus(BOOL* pEnabled)
{
	DCS_Lock();
    	ReqMgmt* pReqMgmt = ReqMgmt::Instance();
	DCS_Response response;
	memset(&response, 0, sizeof(response));
	
	DCS_Return_Code ret = pReqMgmt->GenFuncReq(GetModuleID(),ACCEL_GET_DESKTOP_AUTOROTATION_STATUS, 0, NULL);
    if (ret) {
         DCS_Unlock();
         return ret;
    }

	DCS_DispatchEvent();
	
	DCS_WaitResponse(&response,  GetModuleID(), ACCEL_GET_DESKTOP_AUTOROTATION_STATUS);
	DCS_Unlock();

	if (response.data != NULL && response.dataLen == sizeof(BOOL))
		*pEnabled = *(response.data);
	else
		pEnabled = NULL;

	if (response.data != NULL )
	{
		delete[] response.data;
		response.data=NULL;
	}
   
	return response.returnCode;
}


/**

 * Gets the system orientatio.

 */

DCSAPI DCS_Return_Code DCS_GetSystemOrientation(DCS_SystemOrientation *pData)
{
	DCS_Lock();
    DCS_Return_Code ret = DCS_SUCCESS;
    ReqMgmt* pReqMgmt = ReqMgmt::Instance();
	ret = pReqMgmt->GenFuncReq(GetModuleID(),ACCEL_GET_SYSTEM_ORIENTATION, 0, NULL);
	if (ret) 
    {
         DCS_Unlock();
         return ret;
    }
	DCS_Response response;
	
	memset(&response, 0, sizeof(response));
	DCS_DispatchEvent();
	
	DCS_WaitResponse(&response, GetModuleID(), ACCEL_GET_SYSTEM_ORIENTATION);
	if (response.returnCode == DCS_SUCCESS && response.data != NULL)
		*pData = *((DCS_SystemOrientation* )response.data);
//release one lock	
    DCS_Unlock();

	if (response.data != NULL)
	{
		delete[]response.data;
		response.data = NULL;
	}

	return response.returnCode;
}

 
