/*
 * Copyright (C) 2008  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License, version 2.1, as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef DCS_POWERMANAGEMENT_PLUGIN_H
#define DCS_POWERMANAGEMENT_PLUGIN_H

#include "DCSCommon.h"
/** DCS Power Management operations exposed to clients. */
typedef enum DCS_PM_Operation_E {
	PM_GET_CPU_SPEED,
  PM_GET_MAX_LCD_BRIGHTNESS,
	PM_GET_LCD_BRIGHTNESS,
	PM_SET_LCD_BRIGHTNESS,
	PM_GET_LAN_STATUS,
	PM_SET_LAN_STATUS,
	PM_GET_WIRELESS_STATUS,
	PM_SET_WIRELESS_STATUS,
	PM_GET_LAN_SPEED,
	PM_GET_DPST_LEVEL,
	PM_SET_DPST_LEVEL,
	PM_GET_BATTERY_INFO,
	PM_ADD_SCHEME,
	PM_EDIT_SCHEME,
	PM_DELETE_SCHEME,
	PM_QUERY_SCHEME,
	PM_GET_BATTERY_COUNT,
	PM_GET_SCHEME_NAME,
	PM_GET_ACTIVE_SCHEME,
	PM_POST_DOWN_INTERFACE,
	PM_GET_USERID,
	PM_GET_POWER_INFO,
	PM_GET_SCHEME_VAR_COUNT,
	PM_GET_SCHEME_VAR_OPT_VALUE,
	PM_ENUM_SCHEME,
	PM_INIT_CFG_FILE,
	PM_GET_INT_FROM_CONFIG,
	PM_GET_STR_FROM_CONFIG,
	PM_PUT_INT_INTO_CONFIG,
	PM_PUT_STR_INTO_CONFIG
} DCS_PM_Operation;

/** DCS Power Management events dispatchable to clients. */
typedef enum DCS_PM_Event_E {
	PM_CPU_SPEED_CHANGED=DCS_EVENT_NUM_START,
	PM_LAN_SPEED_CHANGED,
	PM_LCD_BRIGHTNESS_CHANGED,
    	PM_WLAN_CHANGED,
	PM_APPLY_SCHEME,
	PM_LAN_CHANGED,
	PM_DOWN_INTERFACE_REQ
} DCS_PM_Event;

#endif /* DCS_POWERMANAGEMENT_DEF_H */
