/*
 * Easy Network Plugin API
 * Copyright (C) 2008  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License, version 2.1, as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */
#ifndef __LINUXNETWORKAPI_H__
#define __LINUXNETWORKAPI_H__

#include "./ENMDef.h"
#include <string>
#include <wx/arrstr.h>
#include <wx/thread.h>
using namespace std;
class SearchThread;
class LinuxNetworkAPI
{
public:
    LinuxNetworkAPI();

    ~LinuxNetworkAPI();

    int OpenSockets();

    void CloseSockets(const int socketID);

    bool ConnectAP(const string adapterName, const string key, const string ssid, const int auth);

    bool ScanNetwork(const string adapterName,const  string userPath, AccessPointList& apList);

    bool CloseWlanConnection(const string adpterName) ;

    bool ShutdownInterface(const wxArrayString& interfaceList);

    bool DispatchDisableEvent(const wxArrayString& interfaceList);

    string GetIPAddressHLAN(const string adapterName, const string userPath);

    string GetConnectTypeHLAN(const string adapterName, const string userPath);

    string StartupInterface(const wxArrayString& interfaceList, const string path);

    void GetNetInfo(const string path,wxArrayString& wiredInterfaceList,wxArrayString& wirelessInterfaceList);

    bool IfWiredUp(const wxArrayString& wiredInterfaceList);

    bool IfWiredLink(const wxArrayString& wiredInterfaceList);

    bool IfWirelessUp(const wxArrayString& wirelessInterfaceList);

    bool IfWirelessLink(const wxArrayString& wirelessInterfaceList);

    bool IfConnect(const string adapterName);

    string GetSsid(const string userPath);

    void DhAllocateIP(const string adapterName);

    bool UpdateCurrentAP(const string adapterName, const string userPath,APStatus& apStatus);

    bool StringToMacAddress(unsigned char* mac, const char* str, size_t strLen);

    bool IfUp(const wxArrayString& wxaAdapterList, string& currentAdapter);

    bool IfLink(ENM_ADAPTER_TYPE adapterType, const wxArrayString& wxaAdapterList, const string userPath);

    bool Enable8021xAuthentication(bool enable);

    bool EnableInternetSharing(bool enable);

    bool OverwriteHomePage(ENM_String pStrHomePage, const string userPath);

    bool OverwriteProxy(ENM_ProxyInfo pProxyInfo, const string userPath);

    bool ChangeAddress(ENM_AddressInfo pAddressInfo);

    wxString GetFirefoxConfigFile(const string userPath);

    void ExecSmbtree();

    void ExecNmblookup(ENM_String strHomePage, const string adapterName);

    string GetIP(string ifname);

    FILE* linuxAPI;

    string m_currentEssid;

private:

    class SearchThread : public wxThread
    {
        public:
            SearchThread(string name);

            // thread execution starts here
            virtual void *Entry();

            // called when the thread exits - whether it terminates normally or is
            // stopped with Delete() (but not when it is Kill()ed!)
            virtual void OnExit();

        public:
            string interface;
    };

    SearchThread* m_pSearchThread;
};
bool operator == (const WlanSsid& ssid1, const WlanSsid& ssid2);

#endif // __LINUXNETWORKAPI_H__
