# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Benjamin Kampmann <benjamin@fluendo.com>'

from twisted.internet.defer import Deferred
from twisted.internet.protocol import ProcessProtocol
from twisted.internet import error

import os

class ProcessObserver(ProcessProtocol):
    """
    This is a very simple Process Observer. It is a ProcessProtocol for
    twisted. The ProcessObserver is simply calling its deferred, when the
    Process ended. This does not necessarly mean, that the program is not
    running anymore but it has detachted from the console.

    The result of the callback is 0, if the process terminated smoothly or 1
    if it had another termination value.

    # FIXME: a bit more enhanced: use callback and errback?
    """

    def __init__(self):
        self.reset()

    def reset(self):
        self.deferred = Deferred()

    def processEnded(self, status):
        ProcessProtocol.processEnded(self, status)
        if isinstance(status.value, error.ProcessDone):
            self.deferred.callback(0)
        else:
            self.deferred.callback(1)
        
        return self.deferred



