/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "BitmapDialog.h"

wxBitmapDialog::wxBitmapDialog(wxBitmap bitmap, wxWindow* parent, wxWindowID id, const wxString& title)
        : wxDialog(parent, id, title, wxDefaultPosition, wxDefaultSize, wxFRAME_SHAPED | wxNO_BORDER | wxFRAME_NO_TASKBAR | wxSTAY_ON_TOP)
        , m_bitmap(bitmap)
{
    Init();
}

wxBitmapDialog::wxBitmapDialog(const wxBitmap& bitmap, wxWindow* parent, const wxString& title)
        : wxDialog(parent, wxID_ANY, title, wxDefaultPosition, wxDefaultSize, wxFRAME_SHAPED | wxNO_BORDER | wxFRAME_NO_TASKBAR | wxSTAY_ON_TOP)
        , m_bitmap(bitmap)
{
    Init();
}

wxBitmapDialog::~wxBitmapDialog()
{
    //dtor
}

BEGIN_EVENT_TABLE(wxBitmapDialog, wxDialog)
//    EVT_ERASE_BACKGROUND(wxBitmapDialog::OnEraseBackground)
//    EVT_LEFT_DOWN(wxBitmapDialog::OnMouseLeftDown)
//    EVT_LEFT_UP(wxBitmapDialog::OnMouseLeftUp)
//    EVT_MOTION(wxBitmapDialog::OnMouseMove)
    EVT_PAINT(wxBitmapDialog::OnPaint)
#ifdef __WXGTK__
    EVT_WINDOW_CREATE(wxBitmapDialog::OnWindowCreate)
#endif
END_EVENT_TABLE()

void wxBitmapDialog::Init()
{
    m_hasShape = FALSE;
    SetSize(wxSize(m_bitmap.GetWidth(), m_bitmap.GetHeight()));
#ifndef __WXGTK__
    SetWindowShape();
#endif
}

void wxBitmapDialog::OnEraseBackground(wxEraseEvent&  event)
{
    wxDC* pDC = event.GetDC();
    if (pDC)
    {
        if (m_bitmap.Ok())
        {
            pDC->DrawBitmap(m_bitmap,0,0,true);
        }
    }
    else
    {
        wxClientDC dc(this);
        if (m_bitmap.Ok())
        {
            dc.DrawBitmap(m_bitmap,0,0,true);
        }
    }
}

void wxBitmapDialog::OnPaint(wxPaintEvent& event)
 {
    wxPaintDC dc(this);
    dc.DrawBitmap(m_bitmap, 0, 0, TRUE);
}

void wxBitmapDialog::OnMouseLeftDown(wxMouseEvent& event)
{
    CaptureMouse();
    wxPoint pos = ClientToScreen(event.GetPosition());
    wxPoint origin = GetPosition();
    int dx =  pos.x - origin.x;
    int dy = pos.y - origin.y;
    m_diff = wxPoint(dx, dy);
}

void wxBitmapDialog::OnMouseLeftUp(wxMouseEvent& event)
{
    if ( HasCapture() )
    {
        ReleaseMouse();
    }
}

void wxBitmapDialog::OnMouseMove(wxMouseEvent& event)
{
    wxPoint mousePos = event.GetPosition();
    if ( event.Dragging() && event.LeftIsDown() )
    {
        wxPoint pos = ClientToScreen(mousePos);
        Move(wxPoint(pos.x - m_diff.x, pos.y - m_diff.y));
    }
}

void wxBitmapDialog::SetWindowShape()
{
    wxRegion region(m_bitmap, *wxBLACK);
    m_hasShape = SetShape(region);
}

void wxBitmapDialog::OnWindowCreate(wxWindowCreateEvent& event)
{
    SetWindowShape();
}
