/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "GaugeDialog.h"
#include <wx/intl.h>
#include <wx/string.h>
#include <wx/frame.h>
#include "CustomStaticText.h"
#include "ENMApp.h"

const long GaugeDialog::ID_GAUGE = wxNewId();
const long GaugeDialog::ID_STATICTEXT_LABEL = wxNewId();
const int GaugeDialog::ID_TIMER = wxNewId();

BEGIN_EVENT_TABLE(GaugeDialog, wxBitmapDialog)
	EVT_INIT_DIALOG(GaugeDialog::OnInit)
	EVT_TIMER(ID_TIMER, GaugeDialog::OnTimer)
END_EVENT_TABLE()

GaugeDialog::GaugeDialog(wxWindow* parent, wxWindowID id)
        : wxBitmapDialog(wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic/gauge.png"))), parent, wxEmptyString)

        , m_timer(this, ID_TIMER)
{
	Move(wxDefaultPosition);
	m_gauge = new wxGauge(this, ID_GAUGE, 100, wxPoint(15,32), wxSize(240,16), 0, wxDefaultValidator, _T("ID_GAUGE"));

	m_stxLabel = new wxStaticText(this, ID_STATICTEXT_LABEL, wxEmptyString, wxPoint(15,8), wxSize(240,14), 0, _T("ID_STATICTEXT_LABEL"));
}

GaugeDialog::~GaugeDialog()
{
}

void GaugeDialog::SetProcessLabel(const wxString& label)
{
    m_stxLabel->SetLabel(label);
}

bool GaugeDialog::Show(bool show)
{
    if ( !show )
    {
        if ( HasCapture() )
        {
            ReleaseMouse();
        }
        m_timer.Stop();
    }
    return wxDialog::Show(show);
}

void GaugeDialog::OnInit(wxInitDialogEvent& event)
{

    Center();
    m_gauge->SetValue(0);
    m_timer.Start(500, wxTIMER_CONTINUOUS);
}

void GaugeDialog::OnTimer(wxTimerEvent& event)
{
    int value = m_gauge->GetValue();
    value = value >= m_gauge->GetRange() ? 0 : value + 10;
    m_gauge->SetValue(value);
}

