/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "MeshConfigurationDlg.h"
#include <wx/bitmap.h>
#include <wx/intl.h>
#include <wx/image.h>
#include <wx/string.h>
#include "MeshConfigurationEntity.h"
#include "ENMDef.h"
#include "ENMUtil.h"
#include "MeshInfoManager.h"
#include <sdk/ENMApi.h>
#include <wx/wx.h>
#include "ENMApp.h"
#include "ipv4.h"

const long MeshConfigurationDlg::ID_STATICTEXT1 = wxNewId();
const long MeshConfigurationDlg::ID_STATICTEXT3 = wxNewId();
const long MeshConfigurationDlg::ID_STATICTEXT4 = wxNewId();
const long MeshConfigurationDlg::ID_STATICTEXT5 = wxNewId();
const long MeshConfigurationDlg::ID_STATICTEXT6 = wxNewId();
const long MeshConfigurationDlg::ID_TEXTCTRL_LOCAL_HOST_NAME = wxNewId();
const long MeshConfigurationDlg::ID_TEXTCTRL_MESH_CHANNEL = wxNewId();
const long MeshConfigurationDlg::ID_BUTTON_OK = wxNewId();
const long MeshConfigurationDlg::ID_BUTTON_CANCEL = wxNewId();
const long MeshConfigurationDlg::ID_STATICBITMAP1 = wxNewId();
const long MeshConfigurationDlg::ID_PANEL1 = wxNewId();


BEGIN_EVENT_TABLE(MeshConfigurationDlg,wxDialog)

	EVT_CLOSE(MeshConfigurationDlg::OnCloseClicked)
END_EVENT_TABLE()

MeshConfigurationDlg::MeshConfigurationDlg(wxWindow* parent,wxWindowID id,const wxPoint& pos,const wxSize& size)
{

    wxString  wxStrImagepath(::wxGetApp().strAppPath + wxT("pic/MeshConfiguration.png"));

	//(*Initialize(MeshConfigurationDlg)
	Create(parent, wxID_ANY, _("Mesh Network Configuration"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("wxID_ANY"));
	SetClientSize(wxSize(425,290));
	Panel1 = new wxPanel(this, ID_PANEL1, wxPoint(0,0), wxSize(425,290), wxTAB_TRAVERSAL, _T("ID_PANEL1"));
	StaticText1 = new wxStaticText(Panel1, ID_STATICTEXT1, _("You can set Mesh network configuration as follows:"), wxPoint(60,20), wxSize(322,36), 0, _T("ID_STATICTEXT1"));
	StaticText3 = new wxStaticText(Panel1, ID_STATICTEXT3, _("Example:Matin, David_Teacher..."), wxPoint(176,92), wxSize(240,32), 0, _T("ID_STATICTEXT3"));
	StaticText4 = new wxStaticText(Panel1, ID_STATICTEXT4, _("Default Mesh Channel:"), wxPoint(16,136), wxSize(145,40), 0, _T("ID_STATICTEXT4"));
	StaticText5 = new wxStaticText(Panel1, ID_STATICTEXT5, _("Local Hostname:"), wxPoint(16,64), wxSize(109,32), 0, _T("ID_STATICTEXT5"));
	StaticText6 = new wxStaticText(Panel1, ID_STATICTEXT6, _("Mesh channel ranges from 1 to 11. Actual scope refers to UserManual."), wxPoint(176,164), wxSize(248,60), 0, _T("ID_STATICTEXT6"));
	TextCtrlLocalHostName = new wxTextCtrl(Panel1, ID_TEXTCTRL_LOCAL_HOST_NAME, wxEmptyString, wxPoint(176,64), wxSize(232,27), 0, wxDefaultValidator, _T("ID_TEXTCTRL_LOCAL_HOST_NAME"));
	TextCtrlLocalHostName->SetMaxLength(24);
	TextCtrlLocalHostName->SetFocus();
	TextCtrlMeshChannel = new wxTextCtrl(Panel1, ID_TEXTCTRL_MESH_CHANNEL, wxEmptyString, wxPoint(176,136), wxSize(232,27), 0, wxDefaultValidator, _T("ID_TEXTCTRL_MESH_CHANNEL"));
	ButtonOK = new wxButton(Panel1, ID_BUTTON_OK, _("OK"), wxPoint(216,232), wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON_OK"));
	ButtonCancel = new wxButton(Panel1, ID_BUTTON_CANCEL, _("Cancel"), wxPoint(320,232), wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON_CANCEL"));
	StaticBitmap1 = new wxStaticBitmap(Panel1, ID_STATICBITMAP1, wxBitmap(wxImage(wxStrImagepath).Rescale(wxSize(48,48).GetWidth(),wxSize(48,48).GetHeight())), wxPoint(8,8), wxSize(48,48), 0, _T("ID_STATICBITMAP1"));

	Connect(ID_BUTTON_OK,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&MeshConfigurationDlg::OnButtonOKClick);
	Connect(ID_BUTTON_CANCEL,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&MeshConfigurationDlg::OnButtonCancelClick);
	Connect(wxID_ANY,wxEVT_INIT_DIALOG,(wxObjectEventFunction)&MeshConfigurationDlg::OnInit);
	//*)

    wxIcon icon;
    wxBitmap bitmap(wxStrImagepath, wxBITMAP_TYPE_PNG);
    icon.CopyFromBitmap(bitmap);
    SetIcon(icon);

}

MeshConfigurationDlg::~MeshConfigurationDlg()
{
	//(*Destroy(MeshConfigurationDlg)
	//*)
}


void MeshConfigurationDlg::OnInit(wxInitDialogEvent& event)
{

    ENM_String* sHostName = new ENM_String();
    memset(sHostName, 0, sizeof(ENM_String));
    int MeshChannel;

    DCS_GetMeshHostName(sHostName);
    DCS_GetMeshChannel(&MeshChannel);

    char* strHostNameAll = (char *)(sHostName->dcsString);
    printf("[MeshConfiguration] dcs_gethostname = %s \n", (char *)(sHostName->dcsString));
    printf("[MeshConfiguration] dcs_get channel = %d\n", MeshChannel);

    //just for unexpected situation
    int iNameLen = strlen(strHostNameAll);
    if ( MESHSTATUS_MESHSERVER!=::wxGetApp().m_nMeshStatus &&  strHostNameAll[iNameLen-1] == '?' )
    {
        strHostNameAll +=12;
        wxString wxTemp = ENMUtil::StringToWxString(strHostNameAll);
        if ( 0==wxTemp.Right(1).Cmp(wxT("?")) )
        {
            wxString wxHostName = wxTemp.Left(wxTemp.Length()-1);
            ENM_String* sHostName = new ENM_String();
            memset(sHostName, 0, sizeof(ENM_String));
            strcpy((char*)sHostName->dcsString, ENMUtil::WxStringToString(wxHostName).c_str());
            DCS_SetMeshHostName(sHostName);
        }
    }

    wxString strHostName;
    //if mesh server
    if ( MESHSTATUS_MESHSERVER==::wxGetApp().m_nMeshStatus )
    {
        strHostNameAll += 12;
        printf(" strHostNameAll += 12 =%s\n ", strHostNameAll);
        wxString wxTemp = ENMUtil::StringToWxString(strHostNameAll);
        strHostName = wxTemp.Left(wxTemp.Length()-1);
        printf("[MeshConfiguration] mesh server hostname = %s \n", ENMUtil::WxStringToString(strHostName).c_str());
    }
    else
    {

        strHostName = ENMUtil::StringToWxString( (char *)(sHostName->dcsString));
        printf("[MeshConfiguration] mesh other hostname = %s \n", ENMUtil::WxStringToString(strHostName).c_str());
    }


    if (strHostName.IsEmpty())
    {
        meshConfigurationEntity.SetMeshLocalHostName(wxT("mesh"));
        meshConfigurationEntity.SetMeshChannel(1);
    }
    else
    {
        meshConfigurationEntity.SetMeshLocalHostName(strHostName);
        meshConfigurationEntity.SetMeshChannel(MeshChannel);
    }

    wxString strMeshHostName, strMeshChannel, strMeshAdvertiseTime;
    strMeshHostName = meshConfigurationEntity.GetMeshLocalHostName();
    int nMeshChannel = meshConfigurationEntity.GetMeshChannel();


    strMeshChannel = wxString::Format(_T("%d"), nMeshChannel);

    TextCtrlLocalHostName->SetValue(strMeshHostName);
    TextCtrlMeshChannel->SetValue(strMeshChannel);
}

void MeshConfigurationDlg::OnButtonOKClick(wxCommandEvent& event)
{
    //if resume from suspend, mesh0 will dispear
    if ( !MeshInfoManager::GetInstance()->MeshHaveOpen() )
    {
        wxMessageBox(_("There is no mesh interface, please try again"));
        Show(false);
        return;
    }

    if ( !CheckMeshSettings() )
    {
        return;
    }
    long lMeshChannel = 0;
    TextCtrlMeshChannel->GetValue().ToLong(&lMeshChannel);

    int nMeshChannel =lMeshChannel;

    ENM_String* sHostName = new ENM_String();
    memset(sHostName, 0, sizeof(ENM_String));
    if ( MESHSTATUS_MESHSERVER==::wxGetApp().m_nMeshStatus )
    {
        printf("Local mesh server\n");
        MESH_GATEWAY_INFO meshGatewayInfo;
        memset(&meshGatewayInfo, 0, sizeof(MESH_GATEWAY_INFO));
        DCS_GetMeshGatewayInfo(&meshGatewayInfo);
        char shHostName[64] = {'\0'};

        Inetv4Address ip;
        if ( IPv4AddressUtil::StringToInetAddress((char *)meshGatewayInfo.IPAddr, &ip) != INET_OK )
            memcpy(shHostName, "0000", 4);
        else
        {
            memcpy(shHostName, &ip, 4);
        }

        Inetv4Address DNS1;
        char* tempHostName = shHostName;
        tempHostName += 4;
        if ( IPv4AddressUtil::StringToInetAddress((char *)meshGatewayInfo.DNS1, &DNS1) != INET_OK )
            memcpy(tempHostName, "0000", 4);
        else
        {
            memcpy(tempHostName, &DNS1, 4);
        }

        Inetv4Address DNS2;
        tempHostName += 4;
        if ( IPv4AddressUtil::StringToInetAddress((char *)meshGatewayInfo.DNS2, &DNS2) != INET_OK )
            memcpy(tempHostName, "0000", 4);
        else
        {
            memcpy(tempHostName, &DNS2, 4);
        }
        strcat(shHostName, ENMUtil::WxStringToString(TextCtrlLocalHostName->GetValue()).c_str());
        strcat(shHostName, "?");

        memcpy((char*)sHostName->dcsString, shHostName, sizeof(shHostName));
    }
    else
    {
        strcpy((char*)sHostName->dcsString, ENMUtil::WxStringToString(TextCtrlLocalHostName->GetValue()).c_str());
    }
    DCS_SetMeshHostName(sHostName);
    DCS_SetMeshChannel(nMeshChannel);


    SetReturnCode(wxID_OK);
    EndModal(wxID_OK);
    Show(false);
}

void MeshConfigurationDlg::OnCloseClicked(wxCloseEvent& event)
{
    SetReturnCode(wxID_CANCEL);
    Show(false);
}

void MeshConfigurationDlg::OnButtonCancelClick(wxCommandEvent& event)
{
    SetReturnCode(wxID_CANCEL);

    Show(false);
}

bool MeshConfigurationDlg::CheckMeshSettings()
{
    wxString LocalHostName = TextCtrlLocalHostName->GetValue();
    wxString MeshChannel = TextCtrlMeshChannel->GetValue();

    long lMeshChannel = 0;
    MeshChannel.ToLong(&lMeshChannel);



    if ( 0 == LocalHostName.Len() )
    {
        wxString msg = _("Please input HostName");
        wxMessageDialog dlg(this, msg, _("Message"), wxOK | wxICON_EXCLAMATION);
        dlg.ShowModal();

        TextCtrlLocalHostName->SetFocus();
        return false;
    }

    else if ( 0 == LocalHostName.Cmp(wxT("CMPC_GW")) )
    {
        wxString msg = _("CMPC_GW is not allowed, please input another name");
        wxMessageDialog dlg(this, msg, _("Message"), wxOK | wxICON_EXCLAMATION);
        dlg.ShowModal();
        TextCtrlLocalHostName->Clear();
        TextCtrlLocalHostName->SetFocus();
        return false;
    }
    else if ( ENMUtil::CHECK_ILLEGAL == ENMUtil::CheckValide(LocalHostName) )
    {
        wxMessageDialog msg(this, _("HostName cannot contain any of the following characters\n \\ / : * ? \" ' < > |"), _("Message"), wxOK | wxICON_INFORMATION);
        msg.ShowModal();

        TextCtrlLocalHostName->Clear();
        TextCtrlLocalHostName->SetFocus();
        return false;
    }
    else if ( 0 == MeshChannel.Len() )
    {
        wxString msg = _("Please input mesh channel");
        wxMessageDialog dlg(this, msg, _("Message"), wxOK | wxICON_EXCLAMATION);
        dlg.ShowModal();

        TextCtrlMeshChannel->SetFocus();
        return false;
    }
    else if ( !(MeshChannel.IsNumber() && lMeshChannel <=11 && lMeshChannel >=1) )
    {
        wxString msg = _("Invalid mesh channel!\n\nMust contain only numbers 1-11");
        wxMessageDialog dlg(this, msg, _("Message"), wxOK | wxICON_EXCLAMATION);
        dlg.ShowModal();

        TextCtrlMeshChannel->Clear();
        TextCtrlMeshChannel->SetFocus();
        return false;
    }

    return true;
}


