/****************************************************************************
 *                                                                          *
 * Copyright 1999-2005 ATI Technologies Inc., Markham, Ontario, CANADA.     *
 * All Rights Reserved.                                                     *
 *                                                                          *
 * Your use and or redistribution of this software in source and \ or       *
 * binary form, with or without modification, is subject to: (i) your       *
 * ongoing acceptance of and compliance with the terms and conditions of    *
 * the ATI Technologies Inc. software End User License Agreement; and (ii)  *
 * your inclusion of this notice in any version of this software that you   *
 * use or redistribute.  A copy of the ATI Technologies Inc. software End   *
 * User License Agreement is included with this software and is also        *
 * available by contacting ATI Technologies Inc. at http://www.ati.com      *
 *                                                                          *
 ****************************************************************************/

/** \brief KCL ACPI interface declarations */

#ifndef KCL_ACPI_H
#define KCL_ACPI_H

typedef void *KCL_ACPI_DevHandle;
typedef void *KCL_ACPI_CallbackHandle;
typedef void *KCL_ACPI_ContextHandle;

#define KCL_ACPI_OK                 0x0000
#define KCL_ACPI_ERROR              0x0001
#define KCL_ACPI_NOT_AVAILABLE      0xffff
// KCL_ACPI_AC_NOTIFY_STATUS here is defined as the same value as ACPI_AC_NOTIFY_STATUS 0x80 in kernel
#define KCL_ACPI_AC_NOTIFY_STATUS   0x80

#define KCL_ACPI_FIELD_METHOD_NAME                      0x00000001
#define KCL_ACPI_FIELD_INPUT_ARGUMENT_COUNT             0x00000002

struct KCL_ACPI_MethodArgument
{
    unsigned int type;
    unsigned int methodLength;    
    unsigned int dataLength;
    union{
        unsigned int value;
        void *pointer;
    };
};

struct KCL_ACPI_MethodInputInfo
{
    unsigned int size;
    unsigned int field;
    unsigned int name;
    unsigned int inputCount;
    struct KCL_ACPI_MethodArgument *pInputArgument;
    unsigned int outputCount;
    struct KCL_ACPI_MethodArgument *pOutputArgument;
    unsigned int padding[9];
};

extern unsigned int ATI_API_CALL KCL_ACPI_GetDevHandle(KCL_ACPI_DevHandle parent,
                                                       const char *pathname,
                                                       KCL_ACPI_DevHandle *ret_handle);

extern unsigned int ATI_API_CALL KCL_ACPI_GetDevices(KCL_ACPI_CallbackHandle callback,
                                                     KCL_ACPI_ContextHandle context);

extern unsigned int ATI_API_CALL KCL_ACPI_EvalObject(KCL_ACPI_DevHandle handle,
                                                     struct KCL_ACPI_MethodInputInfo *info);

extern unsigned int ATI_API_CALL KCL_ACPI_InstallHandler(KCL_ACPI_DevHandle device,
                                                         unsigned int handler_type,
                                                         KCL_ACPI_CallbackHandle handler,
                                                         KCL_ACPI_ContextHandle context);

extern unsigned int ATI_API_CALL KCL_ACPI_RemoveHandler(KCL_ACPI_DevHandle device,
                                                        unsigned int handler_type,
                                                        KCL_ACPI_CallbackHandle handler);

extern int ATI_API_CALL KCL_ACPI_Disabled(void);
extern void ATI_API_CALL KCL_ACPI_ExecHandler(KCL_ACPI_CallbackHandle handler, KCL_ACPI_DevHandle handle, unsigned int event, KCL_ACPI_ContextHandle data);
extern KCL_ACPI_CallbackHandle ATI_API_CALL KCL_ACPI_GetNotifyHandler(KCL_ACPI_DevHandle handle);
extern KCL_ACPI_ContextHandle ATI_API_CALL KCL_ACPI_GetNotifyContext(KCL_ACPI_DevHandle handle);
extern void ATI_API_CALL KCL_ACPI_UpdateNotifyHandler(KCL_ACPI_DevHandle handle, KCL_ACPI_CallbackHandle handler);
extern void ATI_API_CALL KCL_ACPI_UpdateNotifyContext(KCL_ACPI_DevHandle handle, KCL_ACPI_ContextHandle context);

// Callback functions called by kernel
extern unsigned int KCL_ACPI_GetAcpiHandles(KCL_ACPI_DevHandle handle, unsigned int level, KCL_ACPI_ContextHandle context, void **retval);
extern void KCL_ACPI_AcNotify(KCL_ACPI_DevHandle handle, unsigned int event, KCL_ACPI_ContextHandle data);

// libip functions
extern unsigned int ATI_API_CALL libip_get_acpi_handles(KCL_ACPI_DevHandle handle, unsigned int level, KCL_ACPI_ContextHandle context);
extern void ATI_API_CALL libip_ac_notify(KCL_ACPI_DevHandle handle, unsigned int event, KCL_ACPI_ContextHandle data);

#endif
