#ifndef NSICONTENTWRAPPER_H
#define NSICONTENTWRAPPER_H

#include "nsIContent.h"
#include "nsIDOMElement.h"

class nsIContentWrapper {
public:
  nsIContentWrapper() { };
  nsIContentWrapper(nsIContent *aContent) : mContent(aContent) { };
  ~nsIContentWrapper() { };

  nsIContentWrapper& operator=(nsIContent *rhs) {
    mContent = rhs;
    return *this;
  }

  nsIContentWrapper& operator=(const nsQueryInterface qi) {
    mContent = qi;
    return *this;
  }

  nsIContent* operator->() const {
    return mContent;
  }

  operator nsIContent*() const {
    return mContent;
  }

  operator nsCOMPtr<nsIContent>&() {
    return mContent;
  }

  nsIDOMElement* AsElement() const {
    return ElementHelper(mContent);
  }

private:

  class ElementHelper {
  public:
    ElementHelper(nsIContent *aSrc) : mElem(do_QueryInterface(aSrc)) { };
    ~ElementHelper() { };

    nsIDOMElement* operator->() const {
      return mElem;
    }

    operator nsIDOMElement*() const {
      return mElem;
    }

  private:
    nsCOMPtr<nsIDOMElement> mElem;
  };

  nsCOMPtr<nsIContent> mContent;
};

#endif
