/*
 * Hornsey - Moblin Media Player.
 * Copyright © 2007, 2008, 2009 Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef _HRN_SWITCHER_H
#define _HRN_SWITCHER_H

#include <clutter/clutter.h>

G_BEGIN_DECLS

#define HRN_TYPE_SWITCHER    hrn_switcher_get_type ()

#define HRN_SWITCHER(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), HRN_TYPE_SWITCHER, HrnSwitcher))

#define HRN_SWITCHER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), HRN_TYPE_SWITCHER, HrnSwitcherClass))

#define HRN_IS_SWITCHER(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), HRN_TYPE_SWITCHER))

#define HRN_IS_SWITCHER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), HRN_TYPE_SWITCHER))

#define HRN_SWITCHER_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), HRN_TYPE_SWITCHER, HrnSwitcherClass))

typedef struct _HrnSwitcher HrnSwitcher;
typedef struct _HrnSwitcherClass HrnSwitcherClass;
typedef struct _HrnSwitcherPrivate HrnSwitcherPrivate;

struct _HrnSwitcher
{
  ClutterActor        parent_instance;
  HrnSwitcherPrivate *priv;
};

struct _HrnSwitcherClass
{
  /*< private >*/
  ClutterGroupClass parent_class;
};


GType        hrn_switcher_get_type  (void) G_GNUC_CONST;
HrnSwitcher *hrn_switcher_new       (gint width,
                                     gint height);
void         hrn_switcher_add_state (HrnSwitcher  *switcher,
                                     ClutterActor *state,
                                     gdouble       min_scale,
                                     gdouble       max_scale);
void         hrn_switcher_add_state_full (
                      HrnSwitcher     *self,
                      ClutterActor    *child,
                      gdouble          min_scale,
                      gdouble          max_scale,
                      ClutterActor * (*constructor)(HrnSwitcher * switcher,
                                                   guint         state_no,
                                                   gpointer      userdata),
                      gpointer         constructor_data,

                      void          ( *adapt)(HrnSwitcher  *switcher,
                                              guint         state_no,
                                              ClutterActor *child,
                                              gdouble        position,
                                              gpointer       userdata),
                      gpointer adapt_data
                      );


ClutterActor *hrn_switcher_get_current  (HrnSwitcher *switcher);
gint          hrn_switcher_get_state    (HrnSwitcher *switcher);
gdouble       hrn_actor_get_abs_scale   (ClutterActor *actor);
/* force adapting */
void          hrn_switcher_adapt        (HrnSwitcher *switcher);

/* force setting of a state (can be used if setting
 * a specified state has needed side effects)
 */
void
              hrn_switcher_set_state_no (HrnSwitcher *switcher,
                                         gint         state_no);

G_END_DECLS

#endif
