/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGLengthList.h"

#include "JSSVGLength.h"
#include "SVGLength.h"
#include "SVGLengthList.h"
#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGLengthList);

/* Hash table */

static const HashTableValue JSSVGLengthListTableValues[2] =
{
    { "numberOfItems", DontDelete|ReadOnly, (intptr_t)jsSVGLengthListNumberOfItems, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGLengthListTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSSVGLengthListTableValues, 0 };
#else
    { 2, 1, JSSVGLengthListTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSSVGLengthListPrototypeTableValues[8] =
{
    { "clear", DontDelete|Function, (intptr_t)jsSVGLengthListPrototypeFunctionClear, (intptr_t)0 },
    { "initialize", DontDelete|Function, (intptr_t)jsSVGLengthListPrototypeFunctionInitialize, (intptr_t)1 },
    { "getItem", DontDelete|Function, (intptr_t)jsSVGLengthListPrototypeFunctionGetItem, (intptr_t)1 },
    { "insertItemBefore", DontDelete|Function, (intptr_t)jsSVGLengthListPrototypeFunctionInsertItemBefore, (intptr_t)2 },
    { "replaceItem", DontDelete|Function, (intptr_t)jsSVGLengthListPrototypeFunctionReplaceItem, (intptr_t)2 },
    { "removeItem", DontDelete|Function, (intptr_t)jsSVGLengthListPrototypeFunctionRemoveItem, (intptr_t)1 },
    { "appendItem", DontDelete|Function, (intptr_t)jsSVGLengthListPrototypeFunctionAppendItem, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGLengthListPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 63, JSSVGLengthListPrototypeTableValues, 0 };
#else
    { 18, 15, JSSVGLengthListPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGLengthListPrototype::s_info = { "SVGLengthListPrototype", 0, &JSSVGLengthListPrototypeTable, 0 };

JSObject* JSSVGLengthListPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGLengthList>(exec, globalObject);
}

bool JSSVGLengthListPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGLengthListPrototypeTable, this, propertyName, slot);
}

bool JSSVGLengthListPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGLengthListPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSSVGLengthList::s_info = { "SVGLengthList", 0, &JSSVGLengthListTable, 0 };

JSSVGLengthList::JSSVGLengthList(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGLengthList> impl, SVGElement* context)
    : DOMObjectWithSVGContext(structure, globalObject, context)
    , m_impl(impl)
{
}

JSSVGLengthList::~JSSVGLengthList()
{
    forgetDOMObject(this, impl());
}

JSObject* JSSVGLengthList::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGLengthListPrototype(JSSVGLengthListPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSSVGLengthList::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGLengthList, Base>(exec, &JSSVGLengthListTable, this, propertyName, slot);
}

bool JSSVGLengthList::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGLengthList, Base>(exec, &JSSVGLengthListTable, this, propertyName, descriptor);
}

JSValue jsSVGLengthListNumberOfItems(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGLengthList* castedThis = static_cast<JSSVGLengthList*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGLengthList* imp = static_cast<SVGLengthList*>(castedThis->impl());
    return jsNumber(exec, imp->numberOfItems());
}

JSValue JSC_HOST_CALL jsSVGLengthListPrototypeFunctionClear(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGLengthList::s_info))
        return throwError(exec, TypeError);
    JSSVGLengthList* castedThisObj = static_cast<JSSVGLengthList*>(asObject(thisValue));
    SVGLengthList* imp = static_cast<SVGLengthList*>(castedThisObj->impl());
    ExceptionCode ec = 0;

    imp->clear(ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsSVGLengthListPrototypeFunctionInitialize(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGLengthList::s_info))
        return throwError(exec, TypeError);
    JSSVGLengthList* castedThisObj = static_cast<JSSVGLengthList*>(asObject(thisValue));
    SVGLengthList* imp = static_cast<SVGLengthList*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    SVGLength item = toSVGLength(args.at(0));


    JSC::JSValue result = toJS(exec, deprecatedGlobalObjectForPrototype(exec), JSSVGStaticPODTypeWrapper<SVGLength>::create(imp->initialize(item, ec)).get(), castedThisObj->context());
    setDOMException(exec, ec);
    return result;
}

JSValue JSC_HOST_CALL jsSVGLengthListPrototypeFunctionGetItem(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGLengthList::s_info))
        return throwError(exec, TypeError);
    JSSVGLengthList* castedThisObj = static_cast<JSSVGLengthList*>(asObject(thisValue));
    SVGLengthList* imp = static_cast<SVGLengthList*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    unsigned index = args.at(0).toInt32(exec);


    JSC::JSValue result = toJS(exec, deprecatedGlobalObjectForPrototype(exec), JSSVGStaticPODTypeWrapper<SVGLength>::create(imp->getItem(index, ec)).get(), castedThisObj->context());
    setDOMException(exec, ec);
    return result;
}

JSValue JSC_HOST_CALL jsSVGLengthListPrototypeFunctionInsertItemBefore(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGLengthList::s_info))
        return throwError(exec, TypeError);
    JSSVGLengthList* castedThisObj = static_cast<JSSVGLengthList*>(asObject(thisValue));
    SVGLengthList* imp = static_cast<SVGLengthList*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    SVGLength item = toSVGLength(args.at(0));
    unsigned index = args.at(1).toInt32(exec);


    JSC::JSValue result = toJS(exec, deprecatedGlobalObjectForPrototype(exec), JSSVGStaticPODTypeWrapper<SVGLength>::create(imp->insertItemBefore(item, index, ec)).get(), castedThisObj->context());
    setDOMException(exec, ec);
    return result;
}

JSValue JSC_HOST_CALL jsSVGLengthListPrototypeFunctionReplaceItem(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGLengthList::s_info))
        return throwError(exec, TypeError);
    JSSVGLengthList* castedThisObj = static_cast<JSSVGLengthList*>(asObject(thisValue));
    SVGLengthList* imp = static_cast<SVGLengthList*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    SVGLength item = toSVGLength(args.at(0));
    unsigned index = args.at(1).toInt32(exec);


    JSC::JSValue result = toJS(exec, deprecatedGlobalObjectForPrototype(exec), JSSVGStaticPODTypeWrapper<SVGLength>::create(imp->replaceItem(item, index, ec)).get(), castedThisObj->context());
    setDOMException(exec, ec);
    return result;
}

JSValue JSC_HOST_CALL jsSVGLengthListPrototypeFunctionRemoveItem(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGLengthList::s_info))
        return throwError(exec, TypeError);
    JSSVGLengthList* castedThisObj = static_cast<JSSVGLengthList*>(asObject(thisValue));
    SVGLengthList* imp = static_cast<SVGLengthList*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    unsigned index = args.at(0).toInt32(exec);


    JSC::JSValue result = toJS(exec, deprecatedGlobalObjectForPrototype(exec), JSSVGStaticPODTypeWrapper<SVGLength>::create(imp->removeItem(index, ec)).get(), castedThisObj->context());
    setDOMException(exec, ec);
    return result;
}

JSValue JSC_HOST_CALL jsSVGLengthListPrototypeFunctionAppendItem(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGLengthList::s_info))
        return throwError(exec, TypeError);
    JSSVGLengthList* castedThisObj = static_cast<JSSVGLengthList*>(asObject(thisValue));
    SVGLengthList* imp = static_cast<SVGLengthList*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    SVGLength item = toSVGLength(args.at(0));


    JSC::JSValue result = toJS(exec, deprecatedGlobalObjectForPrototype(exec), JSSVGStaticPODTypeWrapper<SVGLength>::create(imp->appendItem(item, ec)).get(), castedThisObj->context());
    setDOMException(exec, ec);
    return result;
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, SVGLengthList* object, SVGElement* context)
{
    return getDOMObjectWrapper<JSSVGLengthList>(exec, globalObject, object, context);
}
SVGLengthList* toSVGLengthList(JSC::JSValue value)
{
    return value.inherits(&JSSVGLengthList::s_info) ? static_cast<JSSVGLengthList*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
