#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2011-2012 Canonical, Ltd.
#
# Authors:
#  Ugo Riboni <ugo.riboni@canonical.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 3.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import json
import os
from os import path

WHITELIST_FILE = "/etc/js-dbus-bridge.whitelist.json"

class WhitelistManager(object):
   def __init__(self):
      self.whitelist = {}

   def load(self):
      if not path.isfile(WHITELIST_FILE):
         print "Whitelist file doesn't exist: %s" % WHITELIST_FILE
         return

      with open(WHITELIST_FILE, "r") as whitelist_file:
         try:
            self.whitelist = json.loads(whitelist_file.read())
         except Exception as e:
            print "Failed to load or parse whitelist file %s: %s" % (WHITELIST_FILE, e)

      self.whitelist.setdefault('exportable-names', [])
      self.whitelist.setdefault('callable-methods', {})

   def check_registrable(self, bus_name):
      return unicode(bus_name) in self.whitelist['exportable-names']

   def check_callable(self, bus_name, object_name, interface, method):
      objects = self.whitelist['callable-methods'].get(bus_name)
      if type(objects) is not dict:
         return False

      interfaces = objects.get(object_name)
      if type(interfaces) is not dict:
         return False

      methods = interfaces.get(interface)
      if type(methods) is not list:
         return False

      return method in methods

# Export "singleton" instance from module
whitelist = WhitelistManager()
whitelist.load()