/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2004 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  $Id: kz-gtk-webcore.h 3033 2007-03-26 23:31:29Z ikezoe $
 */

#ifndef __KZ_GTK_WEBCORE_H__
#define __KZ_GTK_WEBCORE_H__

#include <gtk/gtk.h>
#include <webi.h>

G_BEGIN_DECLS

#define KZ_TYPE_GTK_WEBCORE		(kz_gtk_webcore_get_type ())
#define KZ_GTK_WEBCORE(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_GTK_WEBCORE, KzGtkWebcore))
#define KZ_GTK_WEBCORE_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_GTK_WEBCORE, KzGtkWebcoreClass))
#define KZ_IS_GTK_WEBCORE(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_GTK_WEBCORE))
#define KZ_IS_GTK_WEBCORE_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), KZ_TYPE_GTK_WEBCORE))
#define KZ_GTK_WEBCORE_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), KZ_TYPE_GTK_WEBCORE, KzGtkWebcoreClass))

typedef struct _KzGtkWebcore		KzGtkWebcore;
typedef struct _KzGtkWebcoreClass	KzGtkWebcoreClass;

struct _KzGtkWebcore
{
	/* embedding widget */
	Webi parent;
};

struct _KzGtkWebcoreClass
{
	WebiClass parent_class;
};


GType        kz_gtk_webcore_get_type              (void) G_GNUC_CONST;
void         kz_gtk_webcore_register_type         (GTypeModule *module);

G_END_DECLS

#endif /* __KZ_GTK_WEBCORE_H__ */
