namespace LaunchpadIntegration
{
    using Gtk;
    using System;
    using System.Runtime.InteropServices;

    public static class LaunchpadIntegration
    {
        [DllImport("liblaunchpad-integration.so")]
        static extern void launchpad_integration_set_sourcepackagename(string name);
    
        public static void SetSourcePackageName(string name)
        {
            launchpad_integration_set_sourcepackagename(name);
        }
    
        [DllImport("liblaunchpad-integration.so")]
        static extern void launchpad_integration_add_ui(IntPtr ui, string path);
    
        public static void AddUI(Gtk.UIManager ui, string path)
        {
            launchpad_integration_add_ui(ui.Handle, path);
        }
    
        [DllImport("liblaunchpad-integration.so")]
        static extern void launchpad_integration_add_ui_with_separators(IntPtr ui, string path, bool separator_before, bool separator_after);
    
        public static void AddUIWithSeparators(Gtk.UIManager ui, string path, bool separator_before, bool separator_after)
        {
            launchpad_integration_add_ui_with_separators(ui.Handle, path, separator_before, separator_after);
        }
    
        [DllImport("liblaunchpad-integration.so")]
        static extern void launchpad_integration_add_items(IntPtr helpmenu, int position, bool separator_before, bool separator_after);

        public static void AddItems(Gtk.Widget helpmenu, int position, bool separator_before, bool separator_after)
        {
            launchpad_integration_add_items(helpmenu.Handle, position, separator_before, separator_after);
        }
    }
}
