#ifndef __MACH_MX25_H__
#define __MACH_MX25_H__

/*
 * IRAM
 */
#define MX25_IRAM_BASE_ADDR       0x78000000	/* internal ram */
#define MX25_IRAM_SIZE            SZ_128K
#define IRAM_SIZE MX25_IRAM_SIZE

#ifdef CONFIG_SND_MXC_SOC_IRAM
#define SND_RAM_SIZE 0x10000
#else
#define SND_RAM_SIZE 0
#endif

#if defined(CONFIG_USB_STATIC_IRAM) \
    || defined(CONFIG_USB_STATIC_IRAM_PPH)
#define USB_IRAM_SIZE	SZ_8K
#else
#define USB_IRAM_SIZE 0
#endif

#define MX25_AIPS1_BASE_ADDR		0x43f00000
#define MX25_AIPS1_BASE_ADDR_VIRT	0xfc000000
#define MX25_AIPS1_SIZE			SZ_1M
#define MX25_AIPS2_BASE_ADDR		0x53f00000
#define MX25_AIPS2_BASE_ADDR_VIRT	0xfc200000
#define MX25_AIPS2_SIZE			SZ_1M
#define MX25_AVIC_BASE_ADDR		0x68000000
#define MX25_AVIC_BASE_ADDR_VIRT	0xfc400000
#define MX25_AVIC_SIZE			SZ_1M

#define MX25_MAX_BASE_ADDR		(MX25_AIPS1_BASE_ADDR + 0x04000)
#define MX25_CLKCTL_BASE_ADDR		(MX25_AIPS1_BASE_ADDR + 0x08000)
#define MX25_ETB_SLOT4_BASE_ADDR	(MX25_AIPS1_BASE_ADDR + 0x0c000)
#define MX25_ETB_SLOT5_BASE_ADDR	(MX25_AIPS1_BASE_ADDR + 0x10000)
#define MX25_AAPE_BASE_ADDR		(MX25_AIPS1_BASE_ADDR + 0x14000)
#define MX25_I2C_BASE_ADDR		(MX25_AIPS1_BASE_ADDR + 0x80000)
#define MX25_I2C3_BASE_ADDR		(MX25_AIPS1_BASE_ADDR + 0x84000)
#define MX25_CAN1_BASE_ADDR		(MX25_AIPS1_BASE_ADDR + 0x88000)
#define MX25_CAN3_BASE_ADDR		(MX25_AIPS1_BASE_ADDR + 0x8c000)
#define MX25_I2C2_BASE_ADDR		(MX25_AIPS1_BASE_ADDR + 0x98000)
#define MX25_OWIRE_BASE_ADDR		(MX25_AIPS1_BASE_ADDR + 0x9c000)
#define MX25_ATA_BASE_ADDR		(MX25_AIPS1_BASE_ADDR + 0xa0000)
#define MX25_CSPI1_BASE_ADDR		(MX25_AIPS1_BASE_ADDR + 0xa4000)
#define MX25_KPP_BASE_ADDR		(MX25_AIPS1_BASE_ADDR + 0xa8000)
#define MX25_IOMUXC_BASE_ADDR		(MX25_AIPS1_BASE_ADDR + 0xac000)
#define MX25_AUDMUX_BASE_ADDR		(MX25_AIPS1_BASE_ADDR + 0xb0000)
#define MX25_ECT_A_BASE_ADDR		(MX25_AIPS1_BASE_ADDR + 0xb8000)
#define MX25_ECT_B_BASE_ADDR		(MX25_AIPS1_BASE_ADDR + 0xbc000)

#define MX25_CCM_BASE_ADDR		(MX25_AIPS2_BASE_ADDR + 0x80000)
#define MX25_CRM_BASE_ADDR		(MX25_AIPS2_BASE_ADDR + 0x80000)
#define MX25_GPT4_BASE_ADDR		(MX25_AIPS2_BASE_ADDR + 0x84000)
#define MX25_GPT3_BASE_ADDR		(MX25_AIPS2_BASE_ADDR + 0x88000)
#define MX25_GPT2_BASE_ADDR		(MX25_AIPS2_BASE_ADDR + 0x8c000)
#define MX25_GPT1_BASE_ADDR		(MX25_AIPS2_BASE_ADDR + 0x90000)
#define MX25_EPIT1_BASE_ADDR		(MX25_AIPS2_BASE_ADDR + 0x94000)
#define MX25_EPIT2_BASE_ADDR		(MX25_AIPS2_BASE_ADDR + 0x98000)
#define MX25_GPIO4_BASE_ADDR		(MX25_AIPS2_BASE_ADDR + 0x9c000)
#define MX25_PWM2_BASE_ADDR		(MX25_AIPS2_BASE_ADDR + 0xa0000)
#define MX25_GPIO3_BASE_ADDR		(MX25_AIPS2_BASE_ADDR + 0xa4000)
#define MX25_PWM3_BASE_ADDR		(MX25_AIPS2_BASE_ADDR + 0xa8000)
#define MX25_SCC_BASE_ADDR		(MX25_AIPS2_BASE_ADDR + 0xac000)
#define MX25_RNGB_BASE_ADDR		(MX25_AIPS2_BASE_ADDR + 0xb0000)
#define MX25_MMC_SDHC1_BASE_ADDR	(MX25_AIPS2_BASE_ADDR + 0xb4000)
#define MX25_MMC_SDHC2_BASE_ADDR	(MX25_AIPS2_BASE_ADDR + 0xb8000)
#define MX25_SLCDC_BASE_ADDR		(MX25_AIPS2_BASE_ADDR + 0xc0000)
#define MX25_PWM4_BASE_ADDR		(MX25_AIPS2_BASE_ADDR + 0xc8000)
#define MX25_GPIO1_BASE_ADDR		(MX25_AIPS2_BASE_ADDR + 0xcc000)
#define MX25_GPIO2_BASE_ADDR		(MX25_AIPS2_BASE_ADDR + 0xd0000)
#define MX25_SDMA_BASE_ADDR		(MX25_AIPS2_BASE_ADDR + 0xd4000)
#define MX25_WDOG_BASE_ADDR		(MX25_AIPS2_BASE_ADDR + 0xdc000)
#define MX25_PWM1_BASE_ADDR		(MX25_AIPS2_BASE_ADDR + 0xe0000)
#define MX25_RTIC_BASE_ADDR		(MX25_AIPS2_BASE_ADDR + 0xec000)
#define MX25_IIM_BASE_ADDR		(MX25_AIPS2_BASE_ADDR + 0xf0000)
#define MX25_USBOTG_BASE_ADDR		(MX25_AIPS2_BASE_ADDR + 0xf4000)
#define OTG_BASE_ADDR			MX25_USBOTG_BASE_ADDR
#define MX25_CSI_BASE_ADDR		(MX25_AIPS2_BASE_ADDR + 0xf8000)
#define MX25_SRTC_BASE_ADDR		(DRYICE_BASE_ADDR)

#define MX25_GPIO1_BASE_ADDR_VIRT	(MX25_AIPS2_BASE_ADDR_VIRT + 0xcc000)
#define MX25_GPIO2_BASE_ADDR_VIRT	(MX25_AIPS2_BASE_ADDR_VIRT + 0xd0000)
#define MX25_GPIO3_BASE_ADDR_VIRT	(MX25_AIPS2_BASE_ADDR_VIRT + 0xa4000)
#define MX25_GPIO4_BASE_ADDR_VIRT	(MX25_AIPS2_BASE_ADDR_VIRT + 0x9c000)

#define MX25_IO_ADDRESS(x) (					\
	IMX_IO_ADDRESS(x, MX25_AIPS1) ?:			\
	IMX_IO_ADDRESS(x, MX25_AIPS2) ?:			\
	IMX_IO_ADDRESS(x, MX25_AVIC))

#define IO_ADDRESS MX25_IO_ADDRESS

#define MX25_UART1_BASE_ADDR		0x43f90000
#define MX25_UART2_BASE_ADDR		0x43f94000

#define MX25_FEC_BASE_ADDR		0x50038000
#define MX25_NFC_BASE_ADDR		0xbb000000
#define MX25_DRYICE_BASE_ADDR		0x53ffc000
#define MX25_LCDC_BASE_ADDR		0x53fbc000
#define LCDC_BASE_ADDR			MX25_LCDC_BASE_ADDR

#define MX25_SPBA0_BASE_ADDR		0x50000000
#define MX25_SPBA0_BASE_ADDR_VIRT	0xfc100000
#define MX25_SPBA0_SIZE			SZ_1M

#define MX25_CSPI3_BASE_ADDR		(MX25_SPBA0_BASE_ADDR + 0x04000)
#define MX25_UART4_BASE_ADDR		(MX25_SPBA0_BASE_ADDR + 0x08000)
#define MX25_UART3_BASE_ADDR		(MX25_SPBA0_BASE_ADDR + 0x0c000)
#define MX25_CSPI2_BASE_ADDR		(MX25_SPBA0_BASE_ADDR + 0x10000)
#define MX25_SSI2_BASE_ADDR		(MX25_SPBA0_BASE_ADDR + 0x14000)
#define MX25_ESAI_BASE_ADDR		(MX25_SPBA0_BASE_ADDR + 0x18000)
#define MX25_ATA_DMA_BASE_ADDR		(MX25_SPBA0_BASE_ADDR + 0x20000)
#define MX25_SIM1_BASE_ADDR		(MX25_SPBA0_BASE_ADDR + 0x24000)
#define MX25_SIM2_BASE_ADDR		(MX25_SPBA0_BASE_ADDR + 0x28000)
#define MX25_UART5_BASE_ADDR		(MX25_SPBA0_BASE_ADDR + 0x2c000)
#define MX25_TSC_BASE_ADDR		(MX25_SPBA0_BASE_ADDR + 0x30000)
#define MX25_SSI1_BASE_ADDR		(MX25_SPBA0_BASE_ADDR + 0x34000)
#define MX25_SPBA_CTRL_BASE_ADDR	(MX25_SPBA0_BASE_ADDR + 0x3c000)

/*
 *  Interrupt numbers
 */

#define MX25_INT_CSPI3		0
#define MX25_INT_GPT4		1
#define MX25_INT_OWIRE		2
#define MX25_INT_I2C		3
#define MX25_INT_I2C2		4
#define MX25_INT_UART4		5
#define MX25_INT_RTIC		6
#define MX25_INT_ESAI		7
#define MX25_INT_SDHC2		8
#define MX25_INT_SDHC1		9
#define MX25_INT_I2C3		10
#define MX25_INT_SSI2		11
#define MX25_INT_SSI1		12
#define MX25_INT_CSPI2		13
#define MX25_INT_CSPI1		14
#define MX25_INT_ATA		15
#define MX25_INT_GPIO3		16
#define MX25_INT_CSI		17
#define MX25_INT_UART3		18
#define MX25_INT_IIM		19
#define MX25_INT_SIM1		20
#define MX25_INT_SIM2		21
#define MX25_INT_RNG		22
#define MX25_INT_GPIO4		23
#define MX25_INT_KPP		24
#define MX25_INT_DRYICE	25
#define MX25_INT_PWM		26
#define MX25_INT_EPIT2		27
#define MX25_INT_EPIT1		28
#define MX25_INT_GPT3		29
#define MX25_INT_POWER_FAIL	30
#define MX25_INT_CRM		31
#define MX25_INT_UART2		32
#define MX25_INT_NANDFC	33
#define MX25_INT_SDMA		34
#define MX25_INT_USB_HTG	35
#define MX25_INT_PWM2		36
#define MX25_INT_USB_OTG	37
#define MX25_INT_SLCDC		38
#define MX25_INT_LCDC	39
#define MX25_INT_UART5		40
#define MX25_INT_PWM3		41
#define MX25_INT_PWM4		42
#define MX25_INT_CAN1		43
#define MX25_INT_CAN2		44
#define MX25_INT_UART1		45
#define MX25_INT_TSC		46
#define MX25_INT_ECT		48
#define MX25_INT_SCC_SCM	49
#define MX25_INT_SCC_SMN	50
#define MX25_INT_GPIO2		51
#define MX25_INT_GPIO1		52
#define MX25_INT_GPT2		53
#define MX25_INT_GPT1		54
#define MX25_INT_WDOG		55
#define MX25_INT_DRYICE_SEC	56
#define MX25_INT_FEC		57
#define MX25_INT_EXT_INT5	58
#define MX25_INT_EXT_INT4	59
#define MX25_INT_EXT_INT3	60
#define MX25_INT_EXT_INT2	61
#define MX25_INT_EXT_INT1	62
#define MX25_INT_EXT_INT0	63

#define MXC_INT_LCDC		MX25_INT_LCDC
#define MXC_INT_GPT		MX25_INT_GPT1
#define MXC_INT_CSI		MX25_INT_CSI

/*!
 * Defines for modules using static and dynamic DMA channels
 */
#define MXC_DMA_CHANNEL_IRAM         30
#define MXC_DMA_CHANNEL_UART1_RX     MXC_DMA_DYNAMIC_CHANNEL
#define MXC_DMA_CHANNEL_UART1_TX     MXC_DMA_DYNAMIC_CHANNEL
#define MXC_DMA_CHANNEL_UART2_RX     MXC_DMA_DYNAMIC_CHANNEL
#define MXC_DMA_CHANNEL_UART2_TX     MXC_DMA_DYNAMIC_CHANNEL
#define MXC_DMA_CHANNEL_UART3_RX     MXC_DMA_DYNAMIC_CHANNEL
#define MXC_DMA_CHANNEL_UART3_TX     MXC_DMA_DYNAMIC_CHANNEL
#define MXC_DMA_CHANNEL_UART4_RX     MXC_DMA_DYNAMIC_CHANNEL
#define MXC_DMA_CHANNEL_UART4_TX     MXC_DMA_DYNAMIC_CHANNEL
#define MXC_DMA_CHANNEL_UART5_RX     MXC_DMA_DYNAMIC_CHANNEL
#define MXC_DMA_CHANNEL_UART5_TX     MXC_DMA_DYNAMIC_CHANNEL
#define MXC_DMA_CHANNEL_MMC1         MXC_DMA_DYNAMIC_CHANNEL
#define MXC_DMA_CHANNEL_SSI1_RX      MXC_DMA_DYNAMIC_CHANNEL
#ifdef CONFIG_SDMA_IRAM
#define MXC_DMA_CHANNEL_SSI1_TX      (MXC_DMA_CHANNEL_IRAM + 1)
#else
#define MXC_DMA_CHANNEL_SSI1_TX      MXC_DMA_DYNAMIC_CHANNEL
#endif
#define MXC_DMA_CHANNEL_SSI2_RX      MXC_DMA_DYNAMIC_CHANNEL
#define MXC_DMA_CHANNEL_SSI2_TX      MXC_DMA_DYNAMIC_CHANNEL
#define MXC_DMA_CHANNEL_CSPI1_RX     MXC_DMA_DYNAMIC_CHANNEL
#define MXC_DMA_CHANNEL_CSPI1_TX     MXC_DMA_DYNAMIC_CHANNEL
#define MXC_DMA_CHANNEL_CSPI2_RX     MXC_DMA_DYNAMIC_CHANNEL
#define MXC_DMA_CHANNEL_CSPI2_TX     MXC_DMA_DYNAMIC_CHANNEL
#define MXC_DMA_CHANNEL_CSPI3_RX     MXC_DMA_DYNAMIC_CHANNEL
#define MXC_DMA_CHANNEL_CSPI3_TX     MXC_DMA_DYNAMIC_CHANNEL
#define MXC_DMA_CHANNEL_ATA_RX       MXC_DMA_DYNAMIC_CHANNEL
#define MXC_DMA_CHANNEL_ATA_TX       MXC_DMA_DYNAMIC_CHANNEL
#define MXC_DMA_CHANNEL_MEMORY       MXC_DMA_DYNAMIC_CHANNEL
#define MXC_DMA_CHANNEL_ESAI_RX      MXC_DMA_DYNAMIC_CHANNEL
#define MXC_DMA_CHANNEL_ESAI_TX      MXC_DMA_DYNAMIC_CHANNEL

/*
 * DMA request assignments
 */
#define DMA_REQ_EXTREQ0    0
#define DMA_REQ_CCM        1
#define DMA_REQ_ATA_TX_END 2
#define DMA_REQ_ATA_TX     3
#define DMA_REQ_ATA_RX     4
#define DMA_REQ_CSPI2_RX   6
#define DMA_REQ_CSPI2_TX   7
#define DMA_REQ_CSPI1_RX   8
#define DMA_REQ_CSPI1_TX   9
#define DMA_REQ_UART3_RX   10
#define DMA_REQ_UART3_TX   11
#define DMA_REQ_UART4_RX   12
#define DMA_REQ_UART4_TX   13
#define DMA_REQ_EXTREQ1    14
#define DMA_REQ_EXTREQ2    15
#define DMA_REQ_UART2_RX   16
#define DMA_REQ_UART2_TX   17
#define DMA_REQ_UART1_RX   18
#define DMA_REQ_UART1_TX   19
#define DMA_REQ_SSI2_RX1   22
#define DMA_REQ_SSI2_TX1   23
#define DMA_REQ_SSI2_RX0   24
#define DMA_REQ_SSI2_TX0   25
#define DMA_REQ_SSI1_RX1   26
#define DMA_REQ_SSI1_TX1   27
#define DMA_REQ_SSI1_RX0   28
#define DMA_REQ_SSI1_TX0   29
#define DMA_REQ_NFC        30
#define DMA_REQ_ECT        31
#define DMA_REQ_ESAI_RX    32
#define DMA_REQ_ESAI_TX    33
#define DMA_REQ_CSPI3_RX   34
#define DMA_REQ_CSPI3_TX   35
#define DMA_REQ_SIM2_RX    36
#define DMA_REQ_SIM2_TX    37
#define DMA_REQ_SIM1_RX    38
#define DMA_REQ_SIM1_TX    39
#define DMA_REQ_TSC_GCQ    44
#define DMA_REQ_TSC_TCQ    45
#define DMA_REQ_UART5_RX   46
#define DMA_REQ_UART5_TX   47

#define IS_MEM_DEVICE_NONSHARED(x)	0

/*!
 * NFMS bit in RCSR register for pagesize of nandflash
 */
#define NFMS (*((volatile u32 *)IO_ADDRESS(MX25_CCM_BASE_ADDR + 0x28)))
#define NFMS_NF_DWIDTH		14
#define NFMS_NF_PG_SZ		8

#if defined(IMX_NEEDS_DEPRECATED_SYMBOLS)
#define UART1_BASE_ADDR			MX25_UART1_BASE_ADDR
#define UART2_BASE_ADDR			MX25_UART2_BASE_ADDR
#endif

#define CSI_BASE_ADDR			MX25_CSI_BASE_ADDR
#define AUDMUX_BASE_ADDR		MX25_AUDMUX_BASE_ADDR
#define MXC_INT_ESAI			MX25_INT_ESAI
#define SDMA_BASE_ADDR			MX25_SDMA_BASE_ADDR
#define SCC_BASE_ADDR			MX25_SCC_BASE_ADDR
#define MXC_INT_SCC_SCM		MX25_INT_SCC_SCM
#define MXC_INT_SCC_SMN		MX25_INT_SCC_SMN
#define DRYICE_BASE_ADDR		MX25_DRYICE_BASE_ADDR
#define MXC_INT_DRYICE_NORM	MX25_INT_DRYICE
#define MXC_INT_DRYICE_SEC		MX25_INT_DRYICE_SEC
#define RNGB_BASE_ADDR			MX25_RNGB_BASE_ADDR
#define MXC_INT_RNG				MX25_INT_RNG
#define MXC_INT_USB_OTG			MX25_INT_USB_OTG

#endif /* ifndef __MACH_MX25_H__ */
