/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import java.awt.Point;
import java.awt.event.MouseEvent;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureAttributeConstant;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.standard.AbstractTool;
import org.jhotdraw.util.Undoable;
import org.jhotdraw.util.UndoableAdapter;

public class DragTracker
extends AbstractTool {
    private Figure fAnchorFigure;
    private int fLastX;
    private int fLastY;
    private boolean fMoved = false;

    public DragTracker(DrawingEditor drawingEditor, Figure figure) {
        super(drawingEditor);
        this.setAnchorFigure(figure);
    }

    public void mouseDown(MouseEvent mouseEvent, int n, int n2) {
        super.mouseDown(mouseEvent, n, n2);
        this.setLastMouseX(n);
        this.setLastMouseY(n2);
        if (mouseEvent.isShiftDown()) {
            this.getActiveView().toggleSelection(this.getAnchorFigure());
            this.setAnchorFigure(null);
        } else if (!this.getActiveView().isFigureSelected(this.getAnchorFigure())) {
            this.getActiveView().clearSelection();
            this.getActiveView().addToSelection(this.getAnchorFigure());
        }
        this.setUndoActivity(this.createUndoActivity());
        this.getUndoActivity().setAffectedFigures(this.getActiveView().selection());
    }

    public void mouseDrag(MouseEvent mouseEvent, int n, int n2) {
        super.mouseDrag(mouseEvent, n, n2);
        this.setHasMoved(Math.abs(n - this.getAnchorX()) > 4 || Math.abs(n2 - this.getAnchorY()) > 4);
        if (this.hasMoved()) {
            FigureEnumeration figureEnumeration = this.getUndoActivity().getAffectedFigures();
            while (figureEnumeration.hasNextFigure()) {
                Figure figure = figureEnumeration.nextFigure();
                Figure figure2 = (Figure)figure.getAttribute(FigureAttributeConstant.OBSERVED_FIGURE);
                if (figure2 != null && figureEnumeration.contains(figure2)) continue;
                figure.moveBy(n - this.getLastMouseX(), n2 - this.getLastMouseY());
            }
        }
        this.setLastMouseX(n);
        this.setLastMouseY(n2);
    }

    protected void setAnchorFigure(Figure figure) {
        this.fAnchorFigure = figure;
    }

    public Figure getAnchorFigure() {
        return this.fAnchorFigure;
    }

    protected void setLastMouseX(int n) {
        this.fLastX = n;
    }

    protected int getLastMouseX() {
        return this.fLastX;
    }

    protected void setLastMouseY(int n) {
        this.fLastY = n;
    }

    protected int getLastMouseY() {
        return this.fLastY;
    }

    public boolean hasMoved() {
        return this.fMoved;
    }

    protected void setHasMoved(boolean bl) {
        this.fMoved = bl;
    }

    public void activate() {
    }

    public void deactivate() {
        if (this.hasMoved()) {
            ((UndoActivity)this.getUndoActivity()).setBackupPoint(new Point(this.getLastMouseX(), this.getLastMouseY()));
        } else {
            this.setUndoActivity(null);
        }
    }

    protected Undoable createUndoActivity() {
        return new UndoActivity(this.getActiveView(), new Point(this.getLastMouseX(), this.getLastMouseY()));
    }

    public static class UndoActivity
    extends UndoableAdapter {
        private Point myOriginalPoint;
        private Point myBackupPoint;

        public UndoActivity(DrawingView drawingView, Point point) {
            super(drawingView);
            this.setOriginalPoint(point);
            this.setUndoable(true);
            this.setRedoable(true);
        }

        public boolean undo() {
            if (!super.undo()) {
                return false;
            }
            this.moveAffectedFigures(this.getBackupPoint(), this.getOriginalPoint());
            return true;
        }

        public boolean redo() {
            if (!super.redo()) {
                return false;
            }
            this.moveAffectedFigures(this.getOriginalPoint(), this.getBackupPoint());
            return true;
        }

        public void setBackupPoint(Point point) {
            this.myBackupPoint = point;
        }

        public Point getBackupPoint() {
            return this.myBackupPoint;
        }

        public void setOriginalPoint(Point point) {
            this.myOriginalPoint = point;
        }

        public Point getOriginalPoint() {
            return this.myOriginalPoint;
        }

        public void moveAffectedFigures(Point point, Point point2) {
            FigureEnumeration figureEnumeration = this.getAffectedFigures();
            while (figureEnumeration.hasNextFigure()) {
                figureEnumeration.nextFigure().moveBy(point2.x - point.x, point2.y - point.y);
            }
        }
    }
}

