#include "mojito-service-ginterface.h"

#include "mojito-marshals.h"

static const DBusGObjectInfo _mojito_service_iface_object_info;

struct _MojitoServiceIfaceClass {
    GTypeInterface parent_class;
    mojito_service_iface_get_persona_icon_impl get_persona_icon;
    mojito_service_iface_update_status_impl update_status;
    mojito_service_iface_get_static_capabilities_impl get_static_capabilities;
    mojito_service_iface_get_dynamic_capabilities_impl get_dynamic_capabilities;
    mojito_service_iface_request_avatar_impl request_avatar;
};

enum {
    SIGNAL_SERVICE_IFACE_CapabilitiesChanged,
    SIGNAL_SERVICE_IFACE_AvatarRetrieved,
    SIGNAL_SERVICE_IFACE_UserChanged,
    N_SERVICE_IFACE_SIGNALS
};
static guint service_iface_signals[N_SERVICE_IFACE_SIGNALS] = {0};

static void mojito_service_iface_base_init (gpointer klass);

GType
mojito_service_iface_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (MojitoServiceIfaceClass),
        mojito_service_iface_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "MojitoServiceIface", &info, 0);
    }

  return type;
}

/**
 * mojito_service_iface_get_persona_icon_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetPersonaIcon on interface com.intel.Mojito.Service.
 */
static void
mojito_service_iface_get_persona_icon (MojitoServiceIface *self,
    DBusGMethodInvocation *context)
{
  mojito_service_iface_get_persona_icon_impl impl = (MOJITO_SERVICE_IFACE_GET_CLASS (self)->get_persona_icon);

  if (impl != NULL)
    {
      (impl) (self,
        context);
    }
  else
    {
      GError e = { DBUS_GERROR, 
           DBUS_GERROR_UNKNOWN_METHOD,
           "Method not implemented" };

      dbus_g_method_return_error (context, &e);
    }
}

/**
 * mojito_service_iface_implement_get_persona_icon:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetPersonaIcon D-Bus method
 *
 * Register an implementation for the GetPersonaIcon method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
mojito_service_iface_implement_get_persona_icon (MojitoServiceIfaceClass *klass, mojito_service_iface_get_persona_icon_impl impl)
{
  klass->get_persona_icon = impl;
}

/**
 * mojito_service_iface_update_status_impl:
 * @self: The object implementing this interface
 * @in_status_message: const gchar * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * UpdateStatus on interface com.intel.Mojito.Service.
 */
static void
mojito_service_iface_update_status (MojitoServiceIface *self,
    const gchar *in_status_message,
    DBusGMethodInvocation *context)
{
  mojito_service_iface_update_status_impl impl = (MOJITO_SERVICE_IFACE_GET_CLASS (self)->update_status);

  if (impl != NULL)
    {
      (impl) (self,
        in_status_message,
        context);
    }
  else
    {
      GError e = { DBUS_GERROR, 
           DBUS_GERROR_UNKNOWN_METHOD,
           "Method not implemented" };

      dbus_g_method_return_error (context, &e);
    }
}

/**
 * mojito_service_iface_implement_update_status:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the UpdateStatus D-Bus method
 *
 * Register an implementation for the UpdateStatus method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
mojito_service_iface_implement_update_status (MojitoServiceIfaceClass *klass, mojito_service_iface_update_status_impl impl)
{
  klass->update_status = impl;
}

/**
 * mojito_service_iface_get_static_capabilities_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetStaticCapabilities on interface com.intel.Mojito.Service.
 */
static void
mojito_service_iface_get_static_capabilities (MojitoServiceIface *self,
    DBusGMethodInvocation *context)
{
  mojito_service_iface_get_static_capabilities_impl impl = (MOJITO_SERVICE_IFACE_GET_CLASS (self)->get_static_capabilities);

  if (impl != NULL)
    {
      (impl) (self,
        context);
    }
  else
    {
      GError e = { DBUS_GERROR, 
           DBUS_GERROR_UNKNOWN_METHOD,
           "Method not implemented" };

      dbus_g_method_return_error (context, &e);
    }
}

/**
 * mojito_service_iface_implement_get_static_capabilities:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetStaticCapabilities D-Bus method
 *
 * Register an implementation for the GetStaticCapabilities method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
mojito_service_iface_implement_get_static_capabilities (MojitoServiceIfaceClass *klass, mojito_service_iface_get_static_capabilities_impl impl)
{
  klass->get_static_capabilities = impl;
}

/**
 * mojito_service_iface_get_dynamic_capabilities_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetDynamicCapabilities on interface com.intel.Mojito.Service.
 */
static void
mojito_service_iface_get_dynamic_capabilities (MojitoServiceIface *self,
    DBusGMethodInvocation *context)
{
  mojito_service_iface_get_dynamic_capabilities_impl impl = (MOJITO_SERVICE_IFACE_GET_CLASS (self)->get_dynamic_capabilities);

  if (impl != NULL)
    {
      (impl) (self,
        context);
    }
  else
    {
      GError e = { DBUS_GERROR, 
           DBUS_GERROR_UNKNOWN_METHOD,
           "Method not implemented" };

      dbus_g_method_return_error (context, &e);
    }
}

/**
 * mojito_service_iface_implement_get_dynamic_capabilities:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetDynamicCapabilities D-Bus method
 *
 * Register an implementation for the GetDynamicCapabilities method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
mojito_service_iface_implement_get_dynamic_capabilities (MojitoServiceIfaceClass *klass, mojito_service_iface_get_dynamic_capabilities_impl impl)
{
  klass->get_dynamic_capabilities = impl;
}

/**
 * mojito_service_iface_request_avatar_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * RequestAvatar on interface com.intel.Mojito.Service.
 */
static void
mojito_service_iface_request_avatar (MojitoServiceIface *self,
    DBusGMethodInvocation *context)
{
  mojito_service_iface_request_avatar_impl impl = (MOJITO_SERVICE_IFACE_GET_CLASS (self)->request_avatar);

  if (impl != NULL)
    {
      (impl) (self,
        context);
    }
  else
    {
      GError e = { DBUS_GERROR, 
           DBUS_GERROR_UNKNOWN_METHOD,
           "Method not implemented" };

      dbus_g_method_return_error (context, &e);
    }
}

/**
 * mojito_service_iface_implement_request_avatar:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the RequestAvatar D-Bus method
 *
 * Register an implementation for the RequestAvatar method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
mojito_service_iface_implement_request_avatar (MojitoServiceIfaceClass *klass, mojito_service_iface_request_avatar_impl impl)
{
  klass->request_avatar = impl;
}

/**
 * mojito_service_iface_emit_capabilities_changed:
 * @instance: The object implementing this interface
 * @arg_caps: const gchar ** (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * CapabilitiesChanged signal on interface com.intel.Mojito.Service.
 */
void
mojito_service_iface_emit_capabilities_changed (gpointer instance,
    const gchar **arg_caps)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, MOJITO_TYPE_SERVICE_IFACE));
  g_signal_emit (instance,
      service_iface_signals[SIGNAL_SERVICE_IFACE_CapabilitiesChanged],
      0,
      arg_caps);
}

/**
 * mojito_service_iface_emit_avatar_retrieved:
 * @instance: The object implementing this interface
 * @arg_path: const gchar * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * AvatarRetrieved signal on interface com.intel.Mojito.Service.
 */
void
mojito_service_iface_emit_avatar_retrieved (gpointer instance,
    const gchar *arg_path)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, MOJITO_TYPE_SERVICE_IFACE));
  g_signal_emit (instance,
      service_iface_signals[SIGNAL_SERVICE_IFACE_AvatarRetrieved],
      0,
      arg_path);
}

/**
 * mojito_service_iface_emit_user_changed:
 * @instance: The object implementing this interface
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * UserChanged signal on interface com.intel.Mojito.Service.
 */
void
mojito_service_iface_emit_user_changed (gpointer instance)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, MOJITO_TYPE_SERVICE_IFACE));
  g_signal_emit (instance,
      service_iface_signals[SIGNAL_SERVICE_IFACE_UserChanged],
      0);
}

static inline void
mojito_service_iface_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  dbus_g_object_type_install_info (mojito_service_iface_get_type (),
      &_mojito_service_iface_object_info);

  /**
   * MojitoServiceIface::capabilities-changed:
   * @arg_caps: const gchar ** (FIXME, generate documentation)
   *
   * The CapabilitiesChanged D-Bus signal is emitted whenever this GObject signal is.
   */
  service_iface_signals[SIGNAL_SERVICE_IFACE_CapabilitiesChanged] =
  g_signal_new ("capabilities-changed",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      g_cclosure_marshal_VOID__BOXED,
      G_TYPE_NONE,
      1,
      G_TYPE_STRV);

  /**
   * MojitoServiceIface::avatar-retrieved:
   * @arg_path: const gchar * (FIXME, generate documentation)
   *
   * The AvatarRetrieved D-Bus signal is emitted whenever this GObject signal is.
   */
  service_iface_signals[SIGNAL_SERVICE_IFACE_AvatarRetrieved] =
  g_signal_new ("avatar-retrieved",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      g_cclosure_marshal_VOID__STRING,
      G_TYPE_NONE,
      1,
      G_TYPE_STRING);

  /**
   * MojitoServiceIface::user-changed:
   *
   * The UserChanged D-Bus signal is emitted whenever this GObject signal is.
   */
  service_iface_signals[SIGNAL_SERVICE_IFACE_UserChanged] =
  g_signal_new ("user-changed",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      g_cclosure_marshal_VOID__VOID,
      G_TYPE_NONE,
      0);

}
static void
mojito_service_iface_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      mojito_service_iface_base_init_once (klass);
    }
}
static const DBusGMethodInfo _mojito_service_iface_methods[] = {
  { (GCallback) mojito_service_iface_get_persona_icon, g_cclosure_marshal_VOID__POINTER, 0 },
  { (GCallback) mojito_service_iface_update_status, mojito_marshal_VOID__STRING_POINTER, 55 },
  { (GCallback) mojito_service_iface_get_static_capabilities, g_cclosure_marshal_VOID__POINTER, 131 },
  { (GCallback) mojito_service_iface_get_dynamic_capabilities, g_cclosure_marshal_VOID__POINTER, 195 },
  { (GCallback) mojito_service_iface_request_avatar, g_cclosure_marshal_VOID__POINTER, 260 },
};

static const DBusGObjectInfo _mojito_service_iface_object_info = {
  0,
  _mojito_service_iface_methods,
  5,
"com.intel.Mojito.Service\0GetPersonaIcon\0A\0uri\0O\0F\0N\0s\0\0com.intel.Mojito.Service\0UpdateStatus\0A\0status_message\0I\0s\0success\0O\0F\0N\0b\0\0com.intel.Mojito.Service\0GetStaticCapabilities\0A\0caps\0O\0F\0N\0as\0\0com.intel.Mojito.Service\0GetDynamicCapabilities\0A\0caps\0O\0F\0N\0as\0\0com.intel.Mojito.Service\0RequestAvatar\0A\0\0\0",
"com.intel.Mojito.Service\0CapabilitiesChanged\0com.intel.Mojito.Service\0AvatarRetrieved\0com.intel.Mojito.Service\0UserChanged\0\0",
"\0\0",
};


