/* mhs: A GObject wrapper for the Mozilla Mhs API
 *
 * Copyright (C) 2009  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __MHS_PREFS_H__
#define __MHS_PREFS_H__

#include <glib-object.h>

G_BEGIN_DECLS

#define MHS_TYPE_PREFS                                             \
  (mhs_prefs_get_type())
#define MHS_PREFS(obj)                                             \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj),                              \
                               MHS_TYPE_PREFS,                     \
                               MhsPrefs))
#define MHS_PREFS_CLASS(klass)                                     \
  (G_TYPE_CHECK_CLASS_CAST ((klass),                               \
                            MHS_TYPE_PREFS,                        \
                            MhsPrefsClass))
#define MHS_IS_PREFS(obj)                                          \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj),                              \
                               MHS_TYPE_PREFS))
#define MHS_IS_PREFS_CLASS(klass)                                  \
  (G_TYPE_CHECK_CLASS_TYPE ((klass),                               \
                            MHS_TYPE_PREFS))
#define MHS_PREFS_GET_CLASS(obj)                                   \
  (G_TYPE_INSTANCE_GET_CLASS ((obj),                               \
                              MHS_TYPE_PREFS,                      \
                              MhsPrefsClass))

typedef struct _MhsPrefs         MhsPrefs;
typedef struct _MhsPrefsClass    MhsPrefsClass;
typedef struct _MhsPrefsPrivate  MhsPrefsPrivate;

struct _MhsPrefsClass
{
  GObjectClass parent_class;

  void (* read)           (MhsPrefs    *prefs);
  void (* reset)          (MhsPrefs    *prefs);
  void (* app_defaults)   (MhsPrefs    *prefs);
  void (* branch_changed) (MhsPrefs    *prefs,
                           gint         id,
                           const gchar *domain);
};

struct _MhsPrefs
{
  GObject parent;

  MhsPrefsPrivate *priv;
};

GType mhs_prefs_get_type (void) G_GNUC_CONST;

MhsPrefs *mhs_prefs_new (void);

gboolean mhs_prefs_read_user (MhsPrefs  *self,
                              const gchar  *path,
                              GError      **error);

gboolean mhs_prefs_reset (MhsPrefs  *self,
                          GError      **error);

gboolean mhs_prefs_reset_user (MhsPrefs  *self,
                               GError      **error);

gboolean mhs_prefs_save_pref_file (MhsPrefs  *self,
                                   const gchar  *path,
                                   GError      **error);

gboolean mhs_prefs_get_branch (MhsPrefs  *self,
                               const gchar  *root,
                               gint         *id,
                               GError      **error);

gboolean mhs_prefs_get_default_branch (MhsPrefs  *self,
                                       const gchar  *root,
                                       gint         *id,
                                       GError      **error);

gboolean mhs_prefs_release_branch (MhsPrefs  *self,
                                   gint          id,
                                   GError      **error);

gboolean mhs_prefs_branch_get_type (MhsPrefs  *self,
                                    gint          id,
                                    const gchar  *name,
                                    gint         *type,
                                    GError      **error);

gboolean mhs_prefs_branch_get_bool (MhsPrefs  *self,
                                    gint          id,
                                    const gchar  *name,
                                    gboolean     *value,
                                    GError      **error);

gboolean mhs_prefs_branch_set_bool (MhsPrefs  *self,
                                    gint          id,
                                    const gchar  *name,
                                    gboolean      value,
                                    GError      **error);

gboolean mhs_prefs_branch_get_int (MhsPrefs  *self,
                                   gint          id,
                                   const gchar  *name,
                                   gint         *value,
                                   GError      **error);

gboolean mhs_prefs_branch_set_int (MhsPrefs  *self,
                                   gint          id,
                                   const gchar  *name,
                                   gint          value,
                                   GError      **error);

gboolean mhs_prefs_branch_get_char (MhsPrefs  *self,
                                    gint          id,
                                    const gchar  *name,
                                    gchar       **value,
                                    GError      **error);

gboolean mhs_prefs_branch_set_char (MhsPrefs  *self,
                                    gint          id,
                                    const gchar  *name,
                                    const gchar  *value,
                                    GError      **error);

gboolean mhs_prefs_branch_has_user_value (MhsPrefs  *self,
                                          gint          id,
                                          const gchar  *name,
                                          gboolean     *result,
                                          GError      **error);

gboolean mhs_prefs_branch_lock (MhsPrefs  *self,
                                gint          id,
                                const gchar  *name,
                                GError      **error);

gboolean mhs_prefs_branch_is_locked (MhsPrefs  *self,
                                     gint          id,
                                     const gchar  *name,
                                     gboolean     *result,
                                     GError      **error);

gboolean mhs_prefs_branch_unlock (MhsPrefs  *self,
                                  gint          id,
                                  const gchar  *name,
                                  GError      **error);

gboolean mhs_prefs_branch_get_child_list (MhsPrefs   *self,
                                          gint           id,
                                          const gchar   *start,
                                          guint         *len,
                                          gchar       ***array,
                                          GError       **error);

gboolean mhs_prefs_branch_add_observer (MhsPrefs  *self,
                                        gint          id,
                                        const gchar  *domain,
                                        GError      **error);

gboolean mhs_prefs_branch_remove_observer (MhsPrefs  *self,
                                           gint          id,
                                           const gchar  *domain,
                                           GError      **error);

G_END_DECLS

#endif /* __MHS_PREFS_H__ */
