/*
 * Decompiled with CFR 0.152.
 */
package org.cdavies.itunes;

import java.io.InputStream;
import org.cdavies.itunes.ItunesConnection;
import org.cdavies.itunes.Track;
import org.cdavies.itunes.hash.ItunesHash;
import org.cdavies.itunes.request.LegacyTrackRequest;
import org.cdavies.itunes.request.NoServerPermissionException;

public class Itunes4Track
implements Track {
    private int _trackId = -1;
    private String _trackName = null;
    private String _albumName = null;
    private String _artistName = null;
    private int _trackNum = -1;
    private String _genre = null;
    private int _rating = -1;
    private String _format = null;
    private int _length = -1;
    private int _dbId;
    private ItunesConnection _conn;
    private ItunesHash _hash;

    public int getTrackId() {
        return this._trackId;
    }

    public void setTrackId(int n) {
        this._trackId = n;
    }

    public String getTrackName() {
        return this._trackName;
    }

    public void setTrackName(String string) {
        this._trackName = string;
    }

    public String getAlbumName() {
        return this._albumName;
    }

    public void setAlbumName(String string) {
        this._albumName = string;
    }

    public String getArtistName() {
        return this._artistName;
    }

    public void setArtistName(String string) {
        this._artistName = string;
    }

    public int getTrackNumber() {
        return this._trackNum;
    }

    public void setTrackNumber(int n) {
        this._trackNum = n;
    }

    public String getGenre() {
        return this._genre;
    }

    public void setGenre(String string) {
        this._genre = string;
    }

    public int getRating() {
        return this._rating;
    }

    public void setRating(int n) {
        this._rating = n;
    }

    public String getFormat() {
        return this._format;
    }

    public void setFormat(String string) {
        this._format = string;
    }

    public int getLength() {
        return this._length;
    }

    public void setLength(int n) {
        this._length = n;
    }

    public void setDatabaseId(int n) {
        this._dbId = n;
    }

    public int getDatabaseId() {
        return this._dbId;
    }

    public void setItunesConnection(ItunesConnection itunesConnection) {
        this._conn = itunesConnection;
    }

    public void setItunesHash(ItunesHash itunesHash) {
        this._hash = itunesHash;
    }

    public InputStream getInputStream() throws NoServerPermissionException {
        if (!this._conn.isConnected()) {
            this._conn.connect();
        }
        LegacyTrackRequest legacyTrackRequest = new LegacyTrackRequest(this._conn.getServerName(), this._conn.getPort(), this._conn.getSessionId(), this.getDatabaseId(), this.getTrackId(), this.getFormat());
        legacyTrackRequest.setHash(this._hash);
        legacyTrackRequest.constructQuery();
        legacyTrackRequest.runQuery();
        legacyTrackRequest.process();
        return legacyTrackRequest.getInputStream();
    }

    public boolean equals(Track track) {
        return this.getTrackId() == track.getTrackId() && this.getTrackName().equals(track.getTrackName()) && this.getAlbumName().equals(track.getAlbumName()) && this.getArtistName().equals(track.getAlbumName()) && this.getTrackNumber() == track.getTrackNumber() && this.getGenre().equals(track.getGenre()) && this.getRating() == track.getRating() && this.getFormat().equals(track.getFormat()) && this.getLength() == track.getLength();
    }

    public String toString() {
        return this.getTrackName() + " - " + this.getArtistName();
    }
}

