#!/usr/bin/python
import os
from ubiquity.plugin import *
import locale
import gettext
import subprocess

# Plugin settings
NAME='optin'
AFTER='eula'
WEIGHT=30


class PageGtk(PluginUI):
    plugin_prefix = 'optin'

    def __init__(self, controller, *args, **kwargs):
        import gtk
        self.builder = gtk.Builder()
        self.builder.add_from_file("/usr/lib/ubiquity/plugins/optin.glade")
        self.builder.connect_signals(self)
        self.controller = controller
        self.controller.add_builder(self.builder)
        self.checkbutton1 = self.builder.get_object("checkbutton1")
        self.checkbutton1.connect("toggled", self.pkg_setup)
        self.page = self.builder.get_object("vbox1")
        self.page.set_name("optin")
        self.plugin_widgets = self.page
        self.done_already = False

    def pkg_setup(self, widget):

# if the check box to enable proprietary software is on and this function has not been run before,
# copy to hook script to language-installer hook dir, which will result in l-i installing it
# if the check box is off, rm the script from the l-i dir
# and set the done_already flag to False
        if widget.get_active():
            # don't copy script if already done
            if not self.done_already:
                self.already_done = True
                cmd = [
                    'cp',
                    'usr/share/nanjing-natty-config/oemconfigplugins-addproprietary',
                    'usr/share/language-installer/pkg-hooks/',
                    ]
                subprocess.call(cmd)
        else:
            self.done_already = False
            cmd = [
                'rm',
                '-f',
                'usr/share/language-installer/pkg-hooks/oemconfigplugins-addproprietary',
                ]
            subprocess.call(cmd)

    # Custom controls
    def get_mode(self):
        return
    def set_mode(self, on):
        return

class Page(Plugin):
    def prepare(self, unfiltered=False):
        # self.ui is PageGtk above
        mode = self.db.get('optin/optin')
        self.ui.set_mode(mode == 'true')

# reset locale and gettext on each prepare and then show translations since the user can
# can back to languages page and select a new language
        locale.setlocale(locale.LC_ALL, '')
        gettext.install("oemconfigplugins", "/usr/share/locale")
        self.ui.optin_label= self.ui.builder.get_object("optin_label")
        self.ui.optin_label.set_label(_("Would you like to install additional proprietary software that may improve your experience?"))
        self.ui.label1 = self.ui.builder.get_object("label1")
        self.ui.label1.set_markup(_("<b>Install Proprietary Software</b>"))
        self.ui.checkbutton1 = self.ui.builder.get_object("checkbutton1")
        self.ui.checkbutton1.set_label(_("Install"))

        return Plugin.prepare(self, unfiltered=unfiltered)

    def ok_handler(self):
        mode = self.ui.get_mode()
        self.preseed_bool('optin/optin', mode)
        Plugin.ok_handler(self)
