#!/bin/sh
# $Id: netams-linux-startup.sh,v 1.2 2008-01-03 12:44:53 anton Exp $
# netams        Startup shell script for NeTAMS 
# 
# chkconfig: - 70 30 
# description:  NeTAMS (Network Traffic Accounting and Management Software) 
#               Daemon for accounting network traffic data. 
#
# V.N. Chernenko <vnc@vnc.org.ua>
#
# Source function library.
. /etc/init.d/functions

DAEMONDIR=/usr/sbin
CONFIG=/etc/netams.conf
PID_FILE=/var/run/netams.pid

RETVAL=0


start() {
        echo -n "Starting Netams services:"
        if [ ! -f $PID_FILE ]; then
            daemon $DAEMONDIR/netams -lf $CONFIG
            RETVAL=$?
            echo
        else        
            RETVAL=1
            echo -e '\t\t\t\t[ \033[0;31mIt is loaded\033[0;0m ]'
        fi
        return $RETVAL
}       
stop() {
        echo -n "Stopping Netams services:"
        killproc netams
        RETVAL=$?
        echo
        return $RETVAL
}

case "$1" in
    start)
        start
        ;;
    stop)
        stop
        ;;
    restart)
        stop
        start
        RETVAL=$?
        ;;
    *)
        echo $"Usage: $0 {start|stop|restart}"
        exit 1

esac

exit $RETVAL
