
#include "AutoRunSettings.h"
#include <wx/intl.h>
#include <wx/string.h>
#include <wx/filedlg.h>
#include <wx/msgdlg.h>

const long AutoRunSettings::ID_LIST_APP = wxNewId();
const long AutoRunSettings::ID_BTN_ADD = wxNewId();
const long AutoRunSettings::ID_BTN_DELETE = wxNewId();
const long AutoRunSettings::ID_BTN_OK = wxNewId();
const long AutoRunSettings::ID_BTN_CANCEL = wxNewId();

BEGIN_EVENT_TABLE(AutoRunSettings,wxDialog)
	EVT_BUTTON(ID_BTN_ADD, AutoRunSettings::OnButtonAdd)
	EVT_BUTTON(ID_BTN_DELETE, AutoRunSettings::OnButtonDelete)
	EVT_BUTTON(ID_BTN_OK, AutoRunSettings::OnButtonOK)
	EVT_BUTTON(ID_BTN_CANCEL, AutoRunSettings::OnButtonCancel)
	EVT_LISTBOX(ID_LIST_APP, AutoRunSettings::OnListApplicationSelected)
END_EVENT_TABLE()

AutoRunSettings::AutoRunSettings(wxWindow* parent, wxWindowID id)
        : wxDialog(parent, id, _("Enable Applications"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("wxID_ANY"))
{
	SetClientSize(wxSize(400,300));
	m_listApp = new wxListBox(this, ID_LIST_APP, wxPoint(15,16), wxSize(370,224), 0, 0, wxLB_EXTENDED|wxLB_HSCROLL|wxSTATIC_BORDER, wxDefaultValidator, _T("ID_LIST_APP"));
	m_btnAdd = new wxButton(this, ID_BTN_ADD, _("Add"), wxPoint(15,256), wxSize(80,27), 0, wxDefaultValidator, _T("ID_BTN_ADD"));
	m_btnDelete = new wxButton(this, ID_BTN_DELETE, _("Delete"), wxPoint(110,256), wxSize(80,27), 0, wxDefaultValidator, _T("ID_BTN_DELETE"));
	m_btnOK = new wxButton(this, ID_BTN_OK, _("OK"), wxPoint(215,256), wxSize(80,27), 0, wxDefaultValidator, _T("ID_BTN_OK"));
	m_btnOK->SetDefault();
	m_btnCancel = new wxButton(this, ID_BTN_CANCEL, _("Cancel"), wxPoint(305,256), wxSize(80,27), 0, wxDefaultValidator, _T("ID_BTN_CANCEL"));
	m_btnDelete->Enable(false);
}

AutoRunSettings::~AutoRunSettings()
{
}

void AutoRunSettings::SetApplications(const wxArrayString& apps)
{
    m_listApp->Clear();
    for ( size_t i = 0; i < apps.GetCount(); i++ )
    {
        m_listApp->Append(apps.Item(i));
    }
}

wxArrayString AutoRunSettings::GetApplications() const
{
    return m_arrayApps;
}

void AutoRunSettings::OnButtonAdd(wxCommandEvent& event)
{
#if defined(__UNIX__)
    wxString wildcard = _T("*");
#endif
#if defined(__WXMSW__)
    wxString wildcard = _T("*.exe");
#endif
    wxFileDialog dialog(this, _("Choose an application"), ::wxGetHomeDir(), wxEmptyString, wildcard, wxOPEN);
    if ( dialog.ShowModal() != wxID_OK )
        return;

    wxString path = dialog.GetPath();
    if ( m_listApp->FindString(path, true) != wxNOT_FOUND )
    {
        wxMessageDialog msgdlg(this, _("This application is already in the list.\n\nPlease choose another one."), _("Message"), wxOK | wxICON_INFORMATION);
        msgdlg.ShowModal();
    }
    else
    {
        m_listApp->Append(path);
    }
}

void AutoRunSettings::OnButtonDelete(wxCommandEvent& event)
{
    wxArrayInt arraySelected;
    int selectedCount = m_listApp->GetSelections(arraySelected);
    if ( selectedCount <= 0 )
        return;

    wxString message;
    if ( selectedCount > 1 )
        message = _("Are you sure you want to delete these items?");
    else
        message = _("Are you sure you want to delete this item?");
    wxMessageDialog dlg(this, message, _("Confirm"), wxYES_NO | wxNO_DEFAULT | wxICON_QUESTION);
    if ( dlg.ShowModal() != wxID_YES )
        return;

    while ( !arraySelected.IsEmpty() )
    {
        int iIndexToDelete = arraySelected.Last();
        m_listApp->Delete(iIndexToDelete);
        arraySelected.Remove(iIndexToDelete);
    }
}

void AutoRunSettings::OnButtonOK(wxCommandEvent& event)
{
    m_arrayApps.Empty();
    m_arrayApps = m_listApp->GetStrings();
    CloseDialog(wxID_OK);
}

void AutoRunSettings::OnButtonCancel(wxCommandEvent& event)
{
    CloseDialog(wxID_CANCEL);
}

void AutoRunSettings::OnListApplicationSelected(wxCommandEvent& event)
{
    wxArrayInt selections;
    int selectCount = m_listApp->GetSelections(selections);
    m_btnDelete->Enable(selectCount > 0);
}

void AutoRunSettings::CloseDialog(int retCode)
{
    if ( IsModal() )
    {
        EndModal(retCode);
    }
    else
    {
        Close();
    }
}
