#include "MeshUseOthersInternetDlg.h"
#include "ENMApp.h"
//(*InternalHeaders(MeshUseOthersInternetDlg)
#include <wx/bitmap.h>
#include <wx/intl.h>
#include <wx/image.h>
#include <wx/string.h>
//*)
#include "MeshInfoManager.h"
#include "ENMUtil.h"
#include <wx/wx.h>
//(*IdInit(MeshUseOthersInternetDlg)
const long MeshUseOthersInternetDlg::ID_STATICTEXT1 = wxNewId();
const long MeshUseOthersInternetDlg::ID_LISTCTRL1 = wxNewId();
const long MeshUseOthersInternetDlg::ID_BUTTON_REFRESH = wxNewId();
const long MeshUseOthersInternetDlg::ID_BUTTON_OK = wxNewId();
const long MeshUseOthersInternetDlg::ID_BUTTON_CANCEL = wxNewId();
const long MeshUseOthersInternetDlg::ID_STATICBITMAP1 = wxNewId();
//*)

BEGIN_EVENT_TABLE(MeshUseOthersInternetDlg,wxDialog)
	//(*EventTable(MeshUseOthersInternetDlg)
	//*)
END_EVENT_TABLE()

MeshUseOthersInternetDlg::MeshUseOthersInternetDlg(wxWindow* parent,wxWindowID id,const wxPoint& pos,const wxSize& size)
{
    wxString strImagePath = ::wxGetApp().strAppPath + _T("pic/UseOtherInternet.ico");
	//(*Initialize(MeshUseOthersInternetDlg)
	Create(parent, id, _("Mesh Client Mode"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("id"));
	SetClientSize(wxSize(450,330));
	Move(wxDefaultPosition);
	StaticText1 = new wxStaticText(this, ID_STATICTEXT1, _("Select one Internet Sharing Server to connect or click “Refresh” to re-scan Internet Sharing Server."), wxPoint(70,10), wxSize(368,40), 0, _T("ID_STATICTEXT1"));
	m_list = new wxListCtrl(this, ID_LISTCTRL1, wxPoint(15,56), wxSize(420,216), wxLC_REPORT, wxDefaultValidator, _T("ID_LISTCTRL1"));
	ButtonRefresh = new wxButton(this, ID_BUTTON_REFRESH, _("Refresh"), wxPoint(15,285), wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON_REFRESH"));
	ButtonOK = new wxButton(this, ID_BUTTON_OK, _("OK"), wxPoint(260,285), wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON_OK"));
	ButtonCancel = new wxButton(this, ID_BUTTON_CANCEL, _("Cancel"), wxPoint(352,285), wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON_CANCEL"));
	StaticBitmap1 = new wxStaticBitmap(this, ID_STATICBITMAP1, wxBitmap(wxImage(strImagePath)), wxPoint(15,10), wxDefaultSize, 0, _T("ID_STATICBITMAP1"));

	Connect(ID_BUTTON_REFRESH,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&MeshUseOthersInternetDlg::OnButtonRefreshClick);
	Connect(ID_BUTTON_OK,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&MeshUseOthersInternetDlg::OnButtonOKClick);
	Connect(ID_BUTTON_CANCEL,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&MeshUseOthersInternetDlg::OnButtonCancelClick);
	//*)
	wxListItem itemCol;
    itemCol.SetText(_("Hostname"));
    m_list->InsertColumn(0, itemCol);
    m_list->SetColumnWidth(0, 130);

    itemCol.SetText(_("Channel"));
    m_list->InsertColumn(1, itemCol);
    m_list->SetColumnWidth(1, 80);

    itemCol.SetText(_("Signal Strength"));
    m_list->InsertColumn(2, itemCol);
    m_list->SetColumnWidth(2, 130);

    itemCol.SetText(_("Status"));
    m_list->InsertColumn(3, itemCol);
    m_list->SetColumnWidth(3, 80);

    itemCol.SetAlign(wxLIST_FORMAT_CENTRE);

    #if defined(__UNIX__)
    wxIcon icon_UseOthersInternet(::wxGetApp().strAppPath + wxT("pic/UseOtherInternet.ico"), wxBITMAP_TYPE_ICO, 16, 16);
    #endif
    SetIcon(icon_UseOthersInternet);
}

MeshUseOthersInternetDlg::~MeshUseOthersInternetDlg()
{
	//(*Destroy(MeshUseOthersInternetDlg)
	//*)
}

bool MeshUseOthersInternetDlg::Show(bool ifShow)
{
    if ( ifShow )
    {
        RefreshList();
    }
    return wxDialog::Show(ifShow);
}
void MeshUseOthersInternetDlg::OnButtonRefreshClick(wxCommandEvent& event)
{
//    printf("OK Refresh click start");
//    RefreshList();
}
void MeshUseOthersInternetDlg::OnButtonOKClick(wxCommandEvent& event)
{
    printf("OK button click start");
    if (m_list->GetItemCount() == 0)
    {
        wxMessageBox(_("No Server detected!"));
        return;
    }
    printf("OK button click");
    ENM_String* sIP = new ENM_String();
    memset(sIP, 0, sizeof(ENM_String));
    //wxMessageBox(_("1"));
    MeshServerInfoList MeshServerInfo = MeshInfoManager::GetInstance()->GetMeshServerInfoList();
    //wxMessageBox(_("2"));
    wxString strMeshIP = MeshServerInfo[0].GetMeshIPAddress();
    printf("strMeshIP: %s", ENMUtil::WxStringToString(strMeshIP).c_str());
    wxString strDNS = MeshServerInfo[0].GetDNS();
    wxString strDNS_back = MeshServerInfo[0].GetDNS_back();
    //wxMessageBox(_("3"));
//    strcpy((char*)sIP->dcsString, ENMUtil::WxStringToString(strMeshIP + wxT("#") + strDNS + wxT("#") + strDNS_back ).c_str());
//    printf((char*)sIP->dcsString);

    MESH_GATEWAY_INFO gatewayinfo;
    memset(&gatewayinfo, 0, sizeof(MESH_GATEWAY_INFO));
    strcpy((char *)gatewayinfo.IPAddr, (ENMUtil::WxStringToString(strMeshIP)).c_str());
    strcpy((char *)gatewayinfo.DNS1, (ENMUtil::WxStringToString(strDNS)).c_str());
    strcpy((char *)gatewayinfo.DNS2, (ENMUtil::WxStringToString(strDNS_back)).c_str());
    //wxMessageBox(_("4"));
    DCS_EnableMeshClient(&gatewayinfo);
    //wxMessageBox(_("5"));
    ::wxGetApp().m_nMeshStatus = MESHSTATUS_MESHCLIENT;
    printf("OK button click end");
    Show(false);

}
void MeshUseOthersInternetDlg::OnButtonCancelClick(wxCommandEvent& event)
{
    printf("OK Cancel click start");
    SetReturnCode(wxID_CANCEL);
    //EndModal(wxID_CANCEL);
    Show(false);
}

void MeshUseOthersInternetDlg::RefreshList()
{
    printf("enter RefreshList\n");
    m_critsectList.Enter();
    m_list->DeleteAllItems();
    wxListItem newItem;
    printf("DeleteAllItems\n");
    m_MeshServerInfoList = MeshInfoManager::GetInstance()->GetMeshServerInfoList();

    printf("GetMeshServerInfoList();\n");
    for (int i = 0; i< (int)m_MeshServerInfoList.size(); i++)
    {
        newItem.SetId(i);

        newItem.SetColumn(0);
        newItem.SetText(m_MeshServerInfoList[i].GetHostName());
        m_list->InsertItem(newItem);

        newItem.SetColumn(1);
        int iChannel = m_MeshServerInfoList[i].GetChannel();
        newItem.SetText(wxString::Format(_T("%d"), iChannel));
        m_list->SetItem(newItem);

        newItem.SetColumn(2);
        int iSignalStrength = m_MeshServerInfoList[i].GetSignalStrength();
        newItem.SetText(wxString::Format(_T("%d"), 100)+wxT("%"));
        m_list->SetItem(newItem);

        newItem.SetColumn(3);
        bool bStatus = m_MeshServerInfoList[i].GetStatus();
        newItem.SetText(wxT("Ready"));
        m_list->SetItem(newItem);
    }
    m_critsectList.Leave();
    printf("leave RefreshList\n");
}


