#include "ProfileWirelessSettings.h"
#include <wx/image.h>
#include "ENMApp.h"
#include "PolicyManager.h"
#if defined(__WXMSW__)
#include "ENMUtil.h" // used for context help
#endif

const long ProfileWirelessSettings::ID_WNNAMETEXTCTRL = wxNewId();
const long ProfileWirelessSettings::ID_STSTATICTEXT = wxNewId();
const long ProfileWirelessSettings::ID_WIRELESSTYPESTATICTEXT = wxNewId();
const long ProfileWirelessSettings::ID_PNSTATICTEXT = wxNewId();
const long ProfileWirelessSettings::ID_DES2STATICTEXT = wxNewId();
const long ProfileWirelessSettings::ID_WSSTATICTEXT = wxNewId();
const long ProfileWirelessSettings::ID_ST2STATICLINE = wxNewId();
const long ProfileWirelessSettings::ID_PIC2STATICBITMAP = wxNewId();
const long ProfileWirelessSettings::ID_SNBUTTON = wxNewId();
const long ProfileWirelessSettings::ID_STCOMBOBOX = wxNewId();
const long ProfileWirelessSettings::ID_WTCOMBOBOX = wxNewId();
const long ProfileWirelessSettings::ID_PANEL1 = wxNewId();
const long ProfileWirelessSettings::ID_KEYSTATICTEXT = wxNewId();
const long ProfileWirelessSettings::ID_TIPSTATICTEXT = wxNewId();
const long ProfileWirelessSettings::ID_KEYTEXTCTRL = wxNewId();
const long ProfileWirelessSettings::ID_HELP = wxNewId();

ProfileWirelessSettings::ProfileWirelessSettings(wxWizard* wizard)
        : wxWizardPageSimple(wizard)
{
    #if defined(__WXMSW__)
    wxLocale m_locale;
    m_locale.AddCatalogLookupPathPrefix(wxT("resource"));
    if (true == wxFileExists(::wxGetApp().strAppPath + wxT("resource\\resource.mo")))
    {
       m_locale.AddCatalog(wxT("resource"));
    }
    #endif

    #if defined(__UNIX__)
    wxLocale m_locale;
    m_locale.AddCatalogLookupPathPrefix(wxT("resource"));
    if (true == wxFileExists(::wxGetApp().strAppPath + wxT("resource/resource.mo")))
    {
       m_locale.AddCatalog(wxT("resource"));
    }
    #endif

    #if defined(__UNIX__)
	m_sbPic2 = new wxStaticBitmap(this, ID_PIC2STATICBITMAP, wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic/step1.png")).Rescale(wxSize(530,48).GetWidth(),wxSize(530,48).GetHeight())), wxPoint(-20,0), wxSize(530,48), 0, _T("ID_PIC2STATICBITMAP"));
	#endif

	#if defined(__WXMSW__)
	m_sbPic2 = new wxStaticBitmap(this, ID_PIC2STATICBITMAP, wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic\\step1.png")).Rescale(wxSize(530,48).GetWidth(),wxSize(530,48).GetHeight())), wxPoint(-20,0), wxSize(530,48), 0, _T("ID_PIC2STATICBITMAP"));
	#endif

	#if defined(__WXMSW__)
	m_tcWNName = new wxTextCtrl(this, ID_WNNAMETEXTCTRL, wxEmptyString, wxPoint(230,65), wxSize(275,24), 0, wxDefaultValidator, _T("ID_WNNAMETEXTCTRL"));
	m_tcWNName->SetMaxLength(32);
	m_textSt = new wxStaticText(this, ID_STSTATICTEXT, _("Security Type:"), wxPoint(15,167), wxDefaultSize, 0, _T("ID_STSTATICTEXT"));
	m_textWirelessType = new wxStaticText(this, ID_WIRELESSTYPESTATICTEXT, _("Wireless Type:"), wxPoint(15,132), wxDefaultSize, 0, _T("ID_WIRELESSTYPESTATICTEXT"));
    #endif

    #if defined(__UNIX__)
	m_tcWNName = new wxTextCtrl(this, ID_WNNAMETEXTCTRL, wxEmptyString, wxPoint(230,65), wxSize(270,24), 0, wxDefaultValidator, _T("ID_WNNAMETEXTCTRL"));
	m_tcWNName->SetMaxLength(32);
	m_textSt = new wxStaticText(this, ID_STSTATICTEXT, _("Security Type:"), wxPoint(15,170), wxDefaultSize, 0, _T("ID_STSTATICTEXT"));
	m_textWirelessType = new wxStaticText(this, ID_WIRELESSTYPESTATICTEXT, _("Wireless Type:"), wxPoint(15,135), wxDefaultSize, 0, _T("ID_WIRELESSTYPESTATICTEXT"));
    #endif

	m_textPn = new wxStaticText(this, ID_PNSTATICTEXT, _("Wireless Network Name(SSID):"), wxPoint(15,70), wxSize(180,30), 0, _T("ID_PNSTATICTEXT"));
	m_textDes2 = new CustomStaticText(this, ID_DES2STATICTEXT, _("Input wireless network settings"), wxPoint(10,30), wxDefaultSize, 0, _T("ID_DES2STATICTEXT"));

	m_textWs = new CustomStaticText(this, ID_WSSTATICTEXT, _("Wireless Settings"), wxPoint(10,5), wxDefaultSize, 0, _T("ID_WSSTATICTEXT"));
	wxFont m_textWsFont(13, wxSWISS, wxFONTSTYLE_NORMAL, wxBOLD, false, _T("Arial"), wxFONTENCODING_DEFAULT);
	m_textWs->SetFont(m_textWsFont);

	m_lineSt2 = new wxStaticLine(this, ID_ST2STATICLINE, wxPoint(0,48), wxSize(510,1), wxLI_HORIZONTAL, _T("ID_ST2STATICLINE"));

	#if defined(__WXMSW__)
	m_buttonSn = new wxButton(this, ID_SNBUTTON, _("Scan for Networks"), wxPoint(320,95), wxSize(185,27), 0, wxDefaultValidator, _T("ID_SNBUTTON"));
	#endif
	#if defined(__UNIX__)
	m_buttonSn = new wxButton(this, ID_SNBUTTON, _("Scan for Networks"), wxPoint(290,95), wxSize(210,28), 0, wxDefaultValidator, _T("ID_SNBUTTON"));
	#endif

	m_cbbWt = new wxComboBox(this, ID_WTCOMBOBOX, wxEmptyString, wxPoint(230,130), wxSize(138,29), 0, 0, wxCB_READONLY, wxDefaultValidator, _T("ID_WTCOMBOBOX"));
	m_cbbWt->Append(_("Automatic"));
	m_cbbWt->Append(_T("802.11b"));
	m_cbbWt->Append(_T("802.11g"));
	m_cbbWt->Append(_T("802.11n"));
	m_cbbWt->SetSelection(0);
	m_cbbSt = new wxComboBox(this, ID_STCOMBOBOX, wxEmptyString, wxPoint(230,165), wxSize(138,29), 0, 0, wxCB_READONLY, wxDefaultValidator, _T("ID_STCOMBOBOX"));
	m_cbbSt->Append(_("NONE"));
	m_cbbSt->Append(_T("WEP"));
	m_cbbSt->Append(_T("WPA-PSK"));
	m_cbbSt->Append(_("UNKNOWN"));
    m_cbbSt->SetSelection(0);

    m_textKey = new wxStaticText(this, ID_KEYSTATICTEXT, _("Key:"), wxPoint(15,205), wxDefaultSize, 0, _T("ID_KEYSTATICTEXT"));
    m_tcKey = new wxTextCtrl(this, ID_KEYTEXTCTRL, wxEmptyString, wxPoint(230,200), wxSize(270,24), wxTE_PASSWORD, wxDefaultValidator, _T("ID_KEYTEXTCTRL"));
    m_tcKey->Disable();
    m_textKeyIdx = new wxStaticText(this, wxID_ANY, _("Key Index:"), wxPoint(15,235), wxSize(70,40));
	#if defined(__UNIX__)
	m_cbbIndex = new wxComboBox(this, wxID_ANY, wxEmptyString, wxPoint(230,230), wxSize(60,28), 0, 0, wxCB_READONLY, wxDefaultValidator);
	#endif
	#if defined(__WXMSW__)
	m_cbbIndex = new wxComboBox(this, wxID_ANY, wxEmptyString, wxPoint(230,233), wxSize(60,28), 0, 0, wxCB_READONLY, wxDefaultValidator);
	#endif
	m_cbbIndex->Append(_T("1"));
	m_cbbIndex->Append(_T("2"));
	m_cbbIndex->Append(_T("3"));
	m_cbbIndex->Append(_T("4"));
	m_cbbIndex->SetValue(_T("1"));
	m_cbbIndex->Enable(false);
    m_textTip = new wxStaticText(this, ID_TIPSTATICTEXT, wxEmptyString, wxPoint(230,260), wxDefaultSize, 0, _T("ID_TIPSTATICTEXT"));
//	m_buttonTypeSet->Disable();
//	m_bIfScan = false;
	m_bNameChange = false;
    memset(&ap, '\0', sizeof(APStatus));
	Connect(ID_STCOMBOBOX,wxEVT_COMMAND_COMBOBOX_SELECTED,(wxObjectEventFunction)&ProfileWirelessSettings::Onm_cbbStSelect);
	Connect(ID_SNBUTTON,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&ProfileWirelessSettings::Onm_buttonSnClick);
	Connect(ID_WNNAMETEXTCTRL,wxEVT_COMMAND_TEXT_UPDATED,(wxObjectEventFunction)&ProfileWirelessSettings::Onm_tcWNNameChange);
	Connect(ID_HELP,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&ProfileWirelessSettings::OnF1Press);
	InitButtonStatus();

    wxAcceleratorEntry entries[1];
    entries[0].Set( wxACCEL_NORMAL, WXK_F1, ID_HELP );
    wxAcceleratorTable accel(1, entries);
    SetAcceleratorTable(accel);
}

void ProfileWirelessSettings::InitButtonStatus()
{
    NETWORK_MODE networkMode = DataCenter::GetInstance()->GetCurrentNetworkMode();
    m_buttonSn->Enable( networkMode == NETWORK_MODE_WIRELESS_LAN_CONNECT || networkMode == NETWORK_MODE_WIRELESS_LAN_DISCONNECT );
}

void ProfileWirelessSettings::Onm_cbbStSelect(wxCommandEvent& event)
{
    m_tcKey->SetValue(_T(""));
    wxString currentText = m_cbbSt->GetValue();
    if ( currentText.Cmp(_T("WPA-PSK")) == 0 )
    {
        m_textTip->SetLabel(_T(""));
        m_tcKey->Enable(true);
        m_cbbIndex->Enable(false);
    }

    if ( currentText.Cmp(_T("WEP")) == 0 )
    {
        m_textTip->SetLabel(_("Use hexadecimal digits (0-9, a-f)"));
        m_tcKey->Enable(true);
        m_cbbIndex->Enable(true);
    }

    if ( currentText.Cmp(_T("NONE")) == 0 || currentText.Cmp(_T("UNKNOWN")) == 0 )
    {
        m_textTip->SetLabel(_T(""));
        m_tcKey->Enable(false);
        m_cbbIndex->Enable(false);
    }
}

void ProfileWirelessSettings::Onm_buttonSnClick(wxCommandEvent& event)
{
    PolicyManager* p = DataCenter::GetInstance()->GetPolicyManager();
    if ( !p->IsScanEnable() )
    {
        wxMessageDialog dlg(this, _("The current policy forbids scanning for wireless networks."), _("Message"), wxOK | wxICON_INFORMATION);
        dlg.ShowModal();
        return;
    }
    if ( (DataCenter::GetInstance()->GetCurrentNetworkMode() != NETWORK_MODE_WIRELESS_LAN_CONNECT) && (DataCenter::GetInstance()->GetCurrentNetworkMode() != NETWORK_MODE_WIRELESS_LAN_DISCONNECT) )
    {
        wxMessageDialog msg(this, _("Cannot find WLAN adapter!"), _("Message"), wxOK | wxICON_INFORMATION);
        msg.ShowModal();
        return;
    }

    ScanNetworkDlg* pScanNetworkDialog = DataCenter::GetInstance()->GetScanNetworkDlgHandle();
    if ( pScanNetworkDialog->IsShown() )
        pScanNetworkDialog->CloseDialog(wxID_CANCEL);
    pScanNetworkDialog->SetDialogMode(false);
    if ( pScanNetworkDialog->ShowModal() == wxID_OK && pScanNetworkDialog->GetSelectedNetwork(&ap) )
    {
        SetApStatus();
        wxString currentText = m_cbbSt->GetValue();
        if ( currentText.Cmp(_T("WPA-PSK")) == 0 )
        {
            m_textTip->SetLabel(_T(""));
            m_tcKey->Enable();
            m_tcKey->SetValue(_T(""));
            m_cbbIndex->Enable(false);
        }
        if (  currentText.Cmp(_T("WEP")) == 0 )
        {
            m_textTip->SetLabel(_("Use hexadecimal digits (0-9, a-f)"));
            m_tcKey->Enable();
            m_tcKey->SetValue(_T(""));
            m_cbbIndex->Enable(true);
        }
        if ( currentText.Cmp(_T("NONE")) == 0 ||  currentText.Cmp(_T("UNKNOWN")) == 0 )
        {
            m_textTip->SetLabel(_T(""));
            m_tcKey->Disable();
            m_tcKey->SetValue(_T(""));
            m_cbbIndex->Enable(false);
        }
    }
}

void ProfileWirelessSettings::SetApStatus()
{
    m_tcWNName->SetValue(wxString::FromUTF8((const char*)ap.ssid.ucSsid, ap.ssid.length));
    if (0 == ap.auth || 100 == ap.auth)
    {
        m_cbbSt->SetSelection(0);
    }
    else if (1 == ap.auth)
    {
        m_cbbSt->SetSelection(1);
    }
    else if (2 == ap.auth)
    {
        m_cbbSt->SetSelection(2);
    }
    else
    {
        m_cbbSt->SetSelection(3);
    }

    if (0 == ap.type)
    {
        m_cbbWt->SetValue(_T("802.11b"));
    }
    else if (1 == ap.type)
    {
        m_cbbWt->SetValue(_T("802.11g"));
    }
    else if (2 == ap.type)
    {
        m_cbbWt->SetValue(_T("802.11n"));
    }
    else
    {
        m_cbbWt->SetValue(_("Automatic"));
    }
}

void ProfileWirelessSettings::Onm_tcWNNameChange(wxCommandEvent& event)
{
    m_bNameChange = true;
}

void ProfileWirelessSettings::OnF1Press(wxCommandEvent& event)
{
#if defined(__UNIX__)
    if(wxFileExists(wxT("/usr/share/EasyNetworkManager/Intel_CMPC2.0_Easy_Network_User_Manual_Ubuntu.pdf")))
    {
        wxString cmd = wxT("evince /usr/share/EasyNetworkManager/Intel_CMPC2.0_Easy_Network_User_Manual_Ubuntu.pdf --page-label=27");
        //wxExecute(cmd);
    }
#endif
#if defined(__WXMSW__)
    ENMUtil::ShowContextHelp(this, _T("ProfileWirelessSetting"));
#endif
}
