#include "WGetMAC.h"

GetMAC::GetMAC()
{
    m_macAddress = new char[20];
}

GetMAC::~GetMAC()
{
    if (m_macAddress!=NULL)
        delete m_macAddress;
}

char *GetMAC::GetLocalMACAddress()
{
    NCB ncb;
    UCHAR uRetCode;
	LANA_ENUM lana_enum;
	int j=0;

    memset( &ncb, 0, sizeof(ncb) );
    ncb.ncb_command = NCBENUM;

    ncb.ncb_buffer = (unsigned char *) &lana_enum;
    ncb.ncb_length = sizeof(lana_enum);

	// NCBENUMԻȡǰϢжٸÿıŵ
	uRetCode = Netbios( &ncb );
	printf( "The NCBENUM returncode is: 0x%x \n", uRetCode );
	if ( uRetCode == 0 )
	{
		printf( "Ethernet Count is : %d\n\n", lana_enum.length);

		// ÿһΪţȡMACַ
		if (lana_enum.length>=1)
			getmac_one( lana_enum.lana[lana_enum.length-1]);
        else
            sprintf(m_macAddress, "00-00-00-00-00-00");
	}
	return m_macAddress;
}

void GetMAC::getmac_one(int lana_num)
{
    NCB ncb;
    UCHAR uRetCode;

    memset( &ncb, 0, sizeof(ncb) );
    ncb.ncb_command = NCBRESET;
    ncb.ncb_lana_num = lana_num;
	// ָ
	// ȶѡһNCBRESETԱгʼ
	uRetCode = Netbios( &ncb );
    printf( "The NCBRESET return code is:0x%x \n", uRetCode );

    memset( &ncb, 0, sizeof(ncb) );
    ncb.ncb_command = NCBASTAT;
    ncb.ncb_lana_num = lana_num; 	// ָ

    strcpy( (char *)ncb.ncb_callname,"*");
    ncb.ncb_buffer = (unsigned char *) &Adapter;

	// ָصϢŵı
	ncb.ncb_length = sizeof(Adapter);

	// ţԷNCBASTATԻȡϢ
	uRetCode = Netbios( &ncb );
    printf( "The NCBASTAT return code is: 0x%x \n", uRetCode );
    if ( uRetCode == 0 )
    {
		// MACַʽɳõ16ʽ0010-A4E4-5802
		sprintf(m_macAddress, "%02X-%02X-%02X-%02X-%02X-%02X",
			Adapter.adapt.adapter_address[0],
			Adapter.adapt.adapter_address[1],
			Adapter.adapt.adapter_address[2],
			Adapter.adapt.adapter_address[3],
			Adapter.adapt.adapter_address[4],
			Adapter.adapt.adapter_address[5] );
    }
    else
    {
        sprintf(m_macAddress, "00-00-00-00-00-00");
    }
}
