#ifndef _WIRELESS_EVENT_H_
#define _WIRELESS_EVENT_H_

#include <wx/event.h>
#include "wlan.h"

const unsigned long ID_WIRELESS_LOWEST = wxID_HIGHEST + 0x0400;

const unsigned long ID_WIRELESS_NETWORK_SWITCH = ID_WIRELESS_LOWEST + 3L;

BEGIN_DECLARE_EVENT_TYPES()
DECLARE_EVENT_TYPE(wxEVT_WIRELESS, -1)
END_DECLARE_EVENT_TYPES()

class WirelessSwitchEvent : public wxEvent
{
    public:
        WirelessSwitchEvent(unsigned long id = ID_WIRELESS_NETWORK_SWITCH);
        WirelessSwitchEvent(const WirelessSwitchEvent& event);
        virtual ~WirelessSwitchEvent();

        virtual wxEvent* Clone() const;

        void SetOldSsid(const WlanSsid& oldSsid);
        void SetNewSsid(const WlanSsid& newSsid);
        WlanSsid GetOldSsid() const;
        WlanSsid GetNewSsid() const;

    protected:

    private:
        WlanSsid m_stOldSsid;
        WlanSsid m_stNewSsid;
};

typedef void (wxEvtHandler::*wxWirelessSwitchEventFunction)(const WirelessSwitchEvent&);

#define EVT_WIRELESS(id, fn) DECLARE_EVENT_TABLE_ENTRY( wxEVT_WIRELESS, id, -1, \
    (wxObjectEventFunction) (wxEventFunction) (wxCommandEventFunction) (wxNotifyEventFunction) \
    wxStaticCastEvent( wxWirelessSwitchEventFunction, & fn ), (wxObject *) NULL ),

#endif // _WIRELESS_EVENT_H_
