/*******************************************************************************
**3456789 123456789 123456789 123456789 123456789 123456789 123456789 123456789
**      10        20        30        40        50        60        70        80
**
** notify-osd
**
** queue.h - implements singelton handling queue-logic for snap-decisions
**
** Copyright 2012 Canonical Ltd.
**
** Authors:
**    Mirco "MacSlow" Mueller <mirco.mueller@canonical.com>
**
** This program is free software: you can redistribute it and/or modify it
** under the terms of the GNU General Public License version 3, as published
** by the Free Software Foundation.
**
** This program is distributed in the hope that it will be useful, but
** WITHOUT ANY WARRANTY; without even the implied warranties of
** MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
** PURPOSE.  See the GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License along
** with this program.  If not, see <http://www.gnu.org/licenses/>.
**
*******************************************************************************/

#ifndef __SD_QUEUE_H
#define __SD_QUEUE_H

#include <glib-object.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus-glib-bindings.h>

#include "notification.h"

G_BEGIN_DECLS

#define QUEUE_TYPE             (queue_get_type ())
#define QUEUE(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), QUEUE_TYPE, Queue))
#define QUEUE_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), QUEUE_TYPE, QueueClass))
#define IS_QUEUE(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), QUEUE_TYPE))
#define IS_QUEUE_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), QUEUE_TYPE))
#define QUEUE_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), QUEUE_TYPE, QueueClass))

#define MAX_QUEUE_SIZE 50

typedef struct _Queue      Queue;
typedef struct _QueueClass QueueClass;

/* instance structure */
struct _Queue
{
	GObject parent;

	/* private */
	GList* list;
	gint   next_id;
};

/* class structure */
struct _QueueClass
{
	GObjectClass parent;
};

GType queue_get_type (void);

Queue*
queue_new ();

void
queue_del (Queue* self);

void
queue_inject (Queue*      self,
              Notification* n);

void
queue_remove (Queue*        self,
              Notification* n);

void
queue_remove_by_pid (Queue* self,
                     guint  pid);

void
queue_remove_by_id (Queue* self,
                    gint   id);

Notification*
queue_find_by_pid (Queue* self,
                   guint  pid);

Notification*
queue_find_by_id (Queue* self,
                  gint   id);

guint
queue_get_size (Queue* self);

gboolean
queue_is_full (Queue* self);

void
queue_reorder (Queue* self);

Notification*
queue_pop (Queue* self);

G_END_DECLS

#endif /* __SD_QUEUE_H */
