#include <stdio.h>
#include <fcntl.h>
#include <sys/select.h>
#include <string.h>
#include <linux/input.h>


#define SP_NODE_DRIVER_EVENT        			"/dev/input/event2"  
#define SP_DRIVER_EVENT_EVDEV_TYPE				0x01	
#define SP_DRIVER_EVENT_EVDEV_LEFT_KEY_CODE		273
#define SP_DRIVER_EVENT_EVDEV_RIGHT_KEY_CODE	272
#define SP_DRIVER_EVENT_EVDEV_KEY_PRESS			0x01
#define SP_DRIVER_EVENT_EVDEV_KEY_RELEASE		0x00

#define SP_RET_FAILED	-1
#define SP_RET_SUCCESS  0

#define SP_KEY_LEFT		1
#define SP_KEY_RIGHT	2

/*
 *	date: 20100309
 *	discription: use select machanisam to monitor the node /dev/input/event1, if it can be read, that is if there is some reading event coming, then will read the /dev/input/event1, it will get three values based on the evdev standard. 1: evdev type 2: evdev key code 3: evdev key value, then you can judge that is the key is your requirement or not.
 *	return: 1: left key press 2: right key press 0: no key or other key press  -1: some error occurs.	
 *	author:	leopard
 *	version: 1.0
*/

int main(int argc, char *argv[])
{
	int fd;

	int len;
		
	int key_flag = SP_RET_SUCCESS;

	struct input_event buf;

	fd_set infids;

	struct timeval timeout;

   	memset(&buf,0x00,sizeof(buf)); 

	fd = open(SP_NODE_DRIVER_EVENT, (O_RDONLY | O_SYNC));

	if (fd < 0)
	{
		printf("error: open\n");
		return SP_RET_FAILED;
	}

	FD_ZERO (&infids);

	FD_SET (fd, &infids);
	//struct timeval tm = {12,0};
	while(1)
	{
		if (select (fd + 1, &infids, NULL, NULL, NULL) < 1)
		{
			printf("select..error.\n");
			continue;
		}
		else
		{
			printf("before read\n");
			len=read(fd, &buf, sizeof(buf));
			if(len < 0)/*there is error about reading*/
				return SP_RET_FAILED;

			printf("type=%d,code=%d,value=%d\n",buf.type,buf.code,buf.value);

			if(buf.code == 116)
    		{
				system("shutdown -h now");
			}
		}
	}
	printf("exit\n");
	close(fd);
	return key_flag;
}

