/****************************************************************************

 * Copyright (c) 2008-2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.

File Name:          PMNew2Dialog.h

Description:

    This file defines class PMNew2Dialog.

Environment (opt):

    OS: Ubuntu
    SE: Code::Block

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                         Lin Xin 2008-7-20

  =====================================================================

****************************************************************************/

#ifndef PMNEW2DIALOG_H
#define PMNEW2DIALOG_H
#include <wx/wizard.h>
#include "wx/wxprec.h"
#include "wx/frame.h"
#include "wx/stattext.h"
#include "wx/log.h"
#include "wx/app.h"
#include "wx/checkbox.h"
#include "wx/checklst.h"
#include "wx/msgdlg.h"
#include "wx/radiobox.h"
#include "wx/menu.h"
#include "wx/sizer.h"
#include <wx/stattext.h>
#include <wx/textctrl.h>
#include <wx/checkbox.h>
#include <wx/statline.h>
#include <wx/panel.h>
#include <wx/statbmp.h>
#include <wx/dialog.h>
#include <wx/combobox.h>
#include <wx/button.h>


#include <wx/statbox.h>
#include <wx/statbmp.h>
#include <wx/combobox.h>
#include <wx/gauge.h>

#include "PMUtility.h"
#include "PowerSchemeMgmtProxy.h"

class PMNew2Dialog : public wxWizardPageSimple
{
    public:
        //constructor
        PMNew2Dialog(wxWizard *wizard);
        //destructor
        virtual ~PMNew2Dialog();

		wxStaticText* StaticTextBaner;
		wxStaticText* StaticTextBaner2;

  		//(*Declarations(PMNew2Dialog)
		wxStaticText* StaticText_UI_BatteryLife;
		wxGauge* Gauge_LCDBrightness;
		wxComboBox* ComboBox_SysStandby;
		wxComboBox* ComboBox_CloseLCD;
		wxCheckBox* CheckBox_LANStatus;
		wxStaticText* StaticText_UI_LCDBrightness2;
		wxGauge* Gauge_BatteryLife;
		wxStaticText* StaticText_UI_LCDBrightness;
		wxComboBox* ComboBox_LCDBrightness;
		wxStaticBox* StaticBox1;
		wxStaticBitmap* StaticBitmap_New2Top;
		wxComboBox* ComboBox_LANSpeed;
		wxStaticText* StaticText_UI_SysStandby;
		wxStaticText* StaticText_UI_CloseLCD;
		wxCheckBox* CheckBox_WLANStatus;
		wxStaticText* StaticText_UI_LANSpeed;
		wxStaticText* StaticText_UI_Performance;
		wxGauge* Gauge_Performance;
		wxStaticText* StaticText_UI_EffectiveOfSettings;
		//*)

	protected:

		//(*Identifiers(PMNew2Dialog)
		static const long ID_STATICBITMAP_NEW2TOP;
		static const long ID_STATICTEXT_UI_LCDBRIGHTNESS;
		static const long ID_STATICTEXT_UI_LANSPEED;
		static const long ID_STATICTEXT_UI_CLOSELCD;
		static const long ID_STATICTEXT_UI_SYSSTANDBY;
		static const long ID_COMBOBOX_LCDBRIGHTNESS;
		static const long ID_COMBOBOX_LANSPEED;
		static const long ID_COMBOBOX_CLOSEDLCD;
		static const long ID_COMBOBOX_SYSSTANDBY;
		static const long ID_STATICBOX1;
		static const long ID_CHECKBOX_LANSTATUS;
		static const long ID_CHECKBOX_WLANSTATUS;
		static const long ID_STATICTEXT_UI_EFFECTIVEOFSETTINGS;
		static const long ID_GAUGE_PERFORMANCE;
		static const long ID_STATICTEXT_UI_PERFORMANCE;
		static const long ID_STATICTEXT_UI_LCDBRIGHTNESS2;
		static const long ID_STATICTEXT_UI_BATTERYLIFE;
		static const long ID_GAUGE_LCDBrightness;
		static const long ID_GAUGE_BATTERYLIFE;
		//*)

    private:
        //init the dialog
        void Init();
        //initial the comboBox value
        void SetComboboxValue(void);
        //update effectiveness
        int UpdateEffectiveness(map<string, int>& valueMap);
        //comboBox select event
        void OnComboBox_Select(wxCommandEvent& event);

    private:

        wxWizardPageSimple *m_pagestep1;

        int m_iSchemeId;
        //
        SETTING_ITEM_VECTOR vLCDBrightnessItems;
        SETTING_ITEM_VECTOR vLANSpeedItems;
        SETTING_ITEM_VECTOR vCloseLCDItems;
        SETTING_ITEM_VECTOR vStandbyItems;

};
#endif
