/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLHtmlElement.h"

#include "HTMLHtmlElement.h"
#include "KURL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLHtmlElement);

/* Hash table */

static const HashTableValue JSHTMLHtmlElementTableValues[3] =
{
    { "version", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLHtmlElementVersion), (intptr_t)setJSHTMLHtmlElementVersion },
    { "constructor", DontEnum|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLHtmlElementConstructor), (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLHtmlElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 3, JSHTMLHtmlElementTableValues, 0 };
#else
    { 4, 3, JSHTMLHtmlElementTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSHTMLHtmlElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLHtmlElementConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLHtmlElementConstructorTableValues, 0 };
#else
    { 1, 0, JSHTMLHtmlElementConstructorTableValues, 0 };
#endif

class JSHTMLHtmlElementConstructor : public DOMConstructorObject {
public:
    JSHTMLHtmlElementConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSHTMLHtmlElementConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSHTMLHtmlElementPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSHTMLHtmlElementConstructor::s_info = { "HTMLHtmlElementConstructor", 0, &JSHTMLHtmlElementConstructorTable, 0 };

bool JSHTMLHtmlElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLHtmlElementConstructor, DOMObject>(exec, &JSHTMLHtmlElementConstructorTable, this, propertyName, slot);
}

bool JSHTMLHtmlElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLHtmlElementConstructor, DOMObject>(exec, &JSHTMLHtmlElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLHtmlElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLHtmlElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLHtmlElementPrototypeTableValues, 0 };
#else
    { 1, 0, JSHTMLHtmlElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSHTMLHtmlElementPrototype::s_info = { "HTMLHtmlElementPrototype", 0, &JSHTMLHtmlElementPrototypeTable, 0 };

JSObject* JSHTMLHtmlElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLHtmlElement>(exec, globalObject);
}

const ClassInfo JSHTMLHtmlElement::s_info = { "HTMLHtmlElement", &JSHTMLElement::s_info, &JSHTMLHtmlElementTable, 0 };

JSHTMLHtmlElement::JSHTMLHtmlElement(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLHtmlElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

JSObject* JSHTMLHtmlElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSHTMLHtmlElementPrototype(JSHTMLHtmlElementPrototype::createStructure(JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLHtmlElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLHtmlElement, Base>(exec, &JSHTMLHtmlElementTable, this, propertyName, slot);
}

bool JSHTMLHtmlElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLHtmlElement, Base>(exec, &JSHTMLHtmlElementTable, this, propertyName, descriptor);
}

JSValue jsHTMLHtmlElementVersion(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLHtmlElement* castedThis = static_cast<JSHTMLHtmlElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLHtmlElement* imp = static_cast<HTMLHtmlElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->version());
    return result;
}

JSValue jsHTMLHtmlElementConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLHtmlElement* domObject = static_cast<JSHTMLHtmlElement*>(asObject(slotBase));
    return JSHTMLHtmlElement::getConstructor(exec, domObject->globalObject());
}
void JSHTMLHtmlElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLHtmlElement, Base>(exec, propertyName, value, &JSHTMLHtmlElementTable, this, slot);
}

void setJSHTMLHtmlElementVersion(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLHtmlElement* castedThisObj = static_cast<JSHTMLHtmlElement*>(thisObject);
    HTMLHtmlElement* imp = static_cast<HTMLHtmlElement*>(castedThisObj->impl());
    imp->setVersion(valueToStringWithNullCheck(exec, value));
}

JSValue JSHTMLHtmlElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLHtmlElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}


}
