#ifndef CAMERAKEYEVENT_SYMBIAN_H
#define CAMERAKEYEVENT_SYMBIAN_H

/****************************************************************************
**
** Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the examples of the Qt Mobility Components.
**
** $QT_BEGIN_LICENSE:BSD$
** You may use this file under the terms of the BSD license as follows:
**
** "Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of Nokia Corporation and its Subsidiary(-ies) nor
**     the names of its contributors may be used to endorse or promote
**     products derived from this software without specific prior written
**     permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
** $QT_END_LICENSE$
**
****************************************************************************/

/*
 * Description:
 * This header can be used to register application on Symbian platforms
 * for the Camera capture button key events. Application can avoid native
 * camera application from starting by not forwarding the key event.
 *
 * Usage:
 * Application needs to include this header and include the needed Symbian
 * libraries. Optionally application can include camerakeyevent_symbian.pri
 * file. Application can register and unregister for the Camera capture
 * key events by creating/destructing the QSymbianCameraKeyListener helper
 * object. The widget needs to be shown before it registers for the
 * Camera key event.
 *
 * Libraries needed:
 * User needs to define following in the .pro file (or optionally include
 * the camerakeyevent_symbian.pri):
 * LIBS += -lcone -lws32
 *
 * Symbian Capabilities needed:
 * To use this header user needs to have SwEvent capability (included in
 * the camerakeyevent_symbian.pri):
 * TARGET.CAPABILITY += SwEvent
 */

#include <QtCore/QObject>

QT_BEGIN_NAMESPACE
QT_FORWARD_DECLARE_CLASS(QWidget)
QT_END_NAMESPACE

QT_USE_NAMESPACE

class QSymbianCameraKeyListener : public QObject
{
    Q_OBJECT
public:
    QSymbianCameraKeyListener(QWidget *parent = 0);
    ~QSymbianCameraKeyListener();
private:
    QWidget *m_widget;
};

#endif // CAMERAKEYEVENT_SYMBIAN_H
