/*
 * Copyright (c) 2015 Intel Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "PSHGravity.h"
#include "Log.h"

struct gravity_data {
        int64_t ts;
        int x;
        int y;
        int z;
} __attribute__ ((packed));

PSHGravity::PSHGravity(const struct sensor_device_t &device, const sensor_additional_information_t &information, const psh_private_data_t &data, PSHService *service)
        :PSHSensor(device, information, data, service)
{
        if (information.scale_android.size() == 3) {
                scaleX = information.scale_android[0];
                scaleY = information.scale_android[1];
                scaleZ = information.scale_android[2];
                ALOGV_IF(VERBOSE, "%s line: %d %f %f %f", __FUNCTION__, __LINE__, scaleX, scaleY, scaleZ);
        } else {
                ALOGW("%s line: %d invalid scale information: size: %d", __FUNCTION__, __LINE__, information.scale_android.size());
                scaleX = 1.0;
                scaleY = 1.0;
                scaleZ = 1.0;
        }
}

PSHGravity::~PSHGravity()
{

}

size_t PSHGravity::convertToEvent(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct gravity_data);

        if (bufSize % sizeof(struct gravity_data) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct gravity_data));
                return 0;
        }

        reallocEventsBuffer(count);

        const struct gravity_data *gravity = reinterpret_cast<const struct gravity_data *>(buf);
        for (int i = 0; i < count; i++) {
                mEvents[i].timestamp = gravity[i].ts;
                mEvents[i].data[0] = gravity[i].x * scaleX;
                mEvents[i].data[1] = gravity[i].y * scaleY;
                mEvents[i].data[2] = gravity[i].z * scaleZ;
        }
        return count;
}
