/*
 * Copyright (c) 2015 Intel Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef _PSH_SENSOR_H_
#define _PSH_SENSOR_H_

#include "Sensor.h"
#include "psh_private_data.h"
#include "PSHService.h"

class PSHSensor : public Sensor {
        psh_private_data_t priv_data;
        PSHService *mPSHService;
        int64_t lastTimestamp; // Workround for timestamp disorder.
        bool streamingOperationImpl(unsigned char cmd_id);
public:
        PSHSensor(const struct sensor_device_t &device, const sensor_additional_information_t &information, const psh_private_data_t &data, PSHService *service);
        virtual ~PSHSensor();
        virtual bool startStreaming(Session * session, int64_t samplingPeriodUs, int64_t maxReportLatencyUs);
        virtual bool stopStreaming(Session * session);
        virtual bool flushStreaming(Session * session);
        virtual bool setProperty(Session * session, void * property, size_t size);
        virtual size_t getProperty(Session * session, void * command, size_t commandSize, void **property);
        virtual size_t convertToEvent(const char * buf, size_t bufSize) = 0;
        virtual size_t convertToStreaming(const char * buf, size_t bufSize);
        virtual void handleEvents(int fd);
        virtual void handleEvents(const char * buf, size_t bufSize);
};

#endif
