/****************************************************************************

Copyright (c) 2009 Intel Corporation.  All rights reserved. 



DISCLAIMER OF WARRANTY

NEITHER INTEL NOR ITS SUPPLIERS MAKE ANY REPRESENTATION OR WARRANTY OR

CONDITION OF ANY KIND WHETHER EXPRESS OR IMPLIED (EITHER IN FACT OR BY

OPERATION OF LAW) WITH RESPECT TO THE SOURCE CODE.  INTEL AND ITS SUPPLIERS

EXPRESSLY DISCLAIM ALL WARRANTIES OR CONDITIONS OF MERCHANTABILITY OR

FITNESS FOR A PARTICULAR PURPOSE.  INTEL AND ITS SUPPLIERS DO NOT WARRANT

THAT THE SOURCE CODE IS ERROR-FREE OR THAT OPERATION OF THE SOURCE CODE WILL

BE SECURE OR UNINTERRUPTED AND HEREBY DISCLAIM ANY AND ALL LIABILITY ON

ACCOUNT THEREOF.  THERE IS ALSO NO IMPLIED WARRANTY OF NON-INFRINGEMENT.

SOURCE CODE IS LICENSED TO LICENSEE ON AN "AS IS" BASIS AND NEITHER INTEL

NOR ITS SUPPLIERS WILL PROVIDE ANY SUPPORT, ASSISTANCE, INSTALLATION,

TRAINING OR OTHER SERVICES.  INTEL AND ITS SUPPLIERS WILL NOT PROVIDE ANY

UPDATES, ENHANCEMENTS OR EXTENSIONS. 


File Name:          ClassGroupData.h

Description:

    This file defines class ClassGroupData.

Environment (opt):
    OS: Ubuntu
    SE: Eclipse

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                        Huang Miao  2008/9/16

  =====================================================================

****************************************************************************/

#ifndef __CLASSGROUPDATA_H__
#define __CLASSGROUPDATA_H__

#include <list>
#include "SESDataProvider.h"
#include "StudentInfoData.h"
#include "ClassDef.h"

#include <string>

namespace LibSESData
{
class CClassGroupData: public CSESDataProvider
{
public:
	CClassGroupData();
	virtual ~CClassGroupData();

protected:
	virtual int DOM2Member();
	virtual int Member2DOM();

public:
	//Modify by lx start 20081013: move to cpp
	std::list<CClassDef*> *GetPClassInfoList() const;

	void SetPClassInfoList(std::list<CClassDef*> *pClassInfoList);

	std::list<CStudentInfoData*> *GetPStudentsInfoList() const;

	void SetPStudentsInfoList(std::list<CStudentInfoData*> *pStudentsInfoList);
	//Modify by lx end

	int IsClassExist(std::string className);

	int GetClassInfo(std::string className, CClassDef** classDef);

	int AddNewClass(int index, CClassDef* pClassDef);

	int UpdateExistedClass(std::string previousClassName, CClassDef* pClassDef);

private:
	std::list<CClassDef*>* m_pClassInfoList;
	std::list<CStudentInfoData*>* m_pStudentsInfoList;
};
}

#endif /* __CLASSGROUPDATA_H__ */
