/****************************************************************************

Copyright (c) 2009 Intel Corporation.  All rights reserved. 



DISCLAIMER OF WARRANTY

NEITHER INTEL NOR ITS SUPPLIERS MAKE ANY REPRESENTATION OR WARRANTY OR

CONDITION OF ANY KIND WHETHER EXPRESS OR IMPLIED (EITHER IN FACT OR BY

OPERATION OF LAW) WITH RESPECT TO THE SOURCE CODE.  INTEL AND ITS SUPPLIERS

EXPRESSLY DISCLAIM ALL WARRANTIES OR CONDITIONS OF MERCHANTABILITY OR

FITNESS FOR A PARTICULAR PURPOSE.  INTEL AND ITS SUPPLIERS DO NOT WARRANT

THAT THE SOURCE CODE IS ERROR-FREE OR THAT OPERATION OF THE SOURCE CODE WILL

BE SECURE OR UNINTERRUPTED AND HEREBY DISCLAIM ANY AND ALL LIABILITY ON

ACCOUNT THEREOF.  THERE IS ALSO NO IMPLIED WARRANTY OF NON-INFRINGEMENT.

SOURCE CODE IS LICENSED TO LICENSEE ON AN "AS IS" BASIS AND NEITHER INTEL

NOR ITS SUPPLIERS WILL PROVIDE ANY SUPPORT, ASSISTANCE, INSTALLATION,

TRAINING OR OTHER SERVICES.  INTEL AND ITS SUPPLIERS WILL NOT PROVIDE ANY

UPDATES, ENHANCEMENTS OR EXTENSIONS. 


File Name:          CIntfData.h

Description:

    This file defines class CIntfData.

Environment (opt):
    OS: Ubuntu
    SE: Eclipse

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                        Stanley Sun 2008/09/08

  =====================================================================

****************************************************************************/

#ifndef INTFDATA_H_
#define INTFDATA_H_



#include "ParaXml.h"
#include "CommonMessage.h"
#include <string>
#include <sstream>

namespace IPCAPI
{

#define MESSAGENAME_LENGTH 64
#define STUDENTID_LENGTH 64
#define OID_LENGTH 10
#define RESULT_LENGTH 10


class CIntfData
{
public:
	CParaXml ParaXmlDoc;
public:
	CIntfData();
	virtual ~CIntfData();
	CIntfData(const std::string& name,const int OID,const std::string& SID);
	bool load(const std::string& srcString);
	bool toString(std::string& destString) const ;

	//add by wuky at 2008/9/16
	//copy construct
	CIntfData(const CIntfData &other);
	void GetMessage(std::string &strMessage) const;		//get Message
	void GetOperationID(int &iOperationID) const;			//get operation ID
	void GetStudentID(std::string &strStudendID) const;	//get Student ID
	void GetResult(int &iResult) const;							//get operation result

	void SetMessage(const std::string  &strMessage);	//set Message
	void SetOperationID(const int iOperationID);		//set Operation ID
	void SetStudentID(const std::string& strStudentID); //set Student ID
	void SetResult(int iResult); 								//set operation result

private:
	std::string MessageName;
	int OperationID;
	std::string StudentID;
	int iReturn;


};

}

#endif /*INTFDATA_H_*/
