#! /usr/bin/perl
#
# Launche gnome autostart applications in SES.
#

use strict;

sub get_exec_info
{
        my($filename) = @_[0];
        my($exec);
        my($line);
        my($is_app) = 0;
        my($is_auto) = 0;

        open(FILE, $filename) or die("$!: $filename\n");

        while (<FILE>)
        {
                $is_app = 1 if (/^\s*Type\s*=\s*Application\s*$/i);

                $is_auto = 1 if (/^\s*X-GNOME-Autostart-enabled\s*=\s*true\s*/i);

                # 'Exec=[bin filename]' match.
                if (/^\s*Exec\s*=/i)
                {
                        $exec = $_;
                        $exec =~ s/^\s*Exec\s*=(.*)$/$1/;
                        chomp($exec);
                }
        }

        close(FILE);

        return($exec, $is_auto && $is_app);
}

my $dir;
my $file;
my @desktop_files;

my @autostart_dirs =
(
    	"$ENV{'HOME'}/.config/autostart",
    	"/etc/SES/WM/startup.d"
);

foreach $dir (@autostart_dirs)
{
    	push(@desktop_files, `ls $dir/*.desktop`) if (-x $dir);
}

foreach $file (@desktop_files)
{
        chomp($file);
        my($exec, $auto) = get_exec_info($file);
        system("$exec &") if (length($exec) > 0); # && $auto);
}

