//===========================================================================
// Copyright (c) 1996-2009 Synaptics Incorporated. All rights reserved.
//
// RCS Header - Do not delete or modify.
//
// $RCSfile: Unknwn.h,v $
// $Source: /cvs/software/Driver/Linux/Include/Unknwn.h,v $
//===========================================================================

//--------------------------------------------------------------------------
// Linux version UnKnwn.h.h
//
// COM classes and interfaces we need.
//--------------------------------------------------------------------------

#ifndef __Unknwn_H
#define __Unknwn_H
//#include "/usr/include/c++/4.4/bits/ios_base.h" // For IsEqualGUID

// com stuff
typedef struct _GUID {
  unsigned long  Data1;
  unsigned short Data2;
  unsigned short Data3;
  unsigned char  Data4[ 8 ];
} GUID;
typedef GUID IID;
#define REFIID const IID &

#define REFGUID const GUID &

#define IsEqualGUID(rguid1, rguid2) !memcmp(&rguid1, &rguid2, sizeof(GUID))
#define IsEqualIID(riid1, riid2) IsEqualGUID(riid1, riid2)
#define IsEqualCLSID(rclsid1, rclsid2) IsEqualGUID(rclsid1, rclsid2)

extern const IID IID_IUnknown;

// IUnknown is a concrete base class on Linux
class IUnknown
{
  protected:
    // Create virtual protected destructor to force use of Release with all sub-classes
    virtual ~IUnknown() {}

  public:
    IUnknown():m_RefCount(0) {}
    HRESULT QueryInterface( REFIID riid, LPVOID* ppvObject ) 
    { 
      if (ppvObject == NULL)
        return E_POINTER;
      *ppvObject = NULL;
      HRESULT hr = E_NOINTERFACE;
      if (IsEqualIID(riid,IID_IUnknown)) {
        *ppvObject = (IUnknown *)(this);
        AddRef();
        hr = S_OK;
      }
      return hr;
    }
    ULONG   AddRef() { return InterlockedIncrement((LONG *)&m_RefCount); }
    ULONG   Release() 
    {
      ULONG ulRefCount = InterlockedDecrement((LONG *)&m_RefCount);
      if (ulRefCount == 0)
        delete this;
      return ulRefCount;
    }

  private:
    ULONG m_RefCount;
};
#endif //__Unknwn_H

