//===========================================================================
// Copyright (c) 1996-2011 Synaptics Incorporated. All rights reserved.
//
// RCS Header - Do not delete or modify.
//
// $RCSfile: main.cpp,v $
// $Source: /cvs/software/Driver/SynCom/TouchPadControl/main.cpp,v $
//===========================================================================
#include "TouchPadControl.h"
#include "TouchPadService.h"
#include <stdio.h>
#include <string.h>

int main(int argc, char* argv[])
{
  if(!(argc > 1)) {
    printf("usage: tpcontrol [on|off]\n");
    return -1;
  }

  BOOL bDisable;
  if(strcmp(argv[1], "on") == 0) {
    bDisable = false;
  }
  else if(strcmp(argv[1], "off") == 0) {
    bDisable = true;
  }
  else {
    printf("Error: unknown command.\n");
    return -1;
  }

  try {    
    SynComFactory factory;
    TouchPadService tpservice(factory.CreateSynAPI());
    TouchPadControl tpcontrol(tpservice.GetTouchPad());
    bDisable ? tpcontrol.Disable() : tpcontrol.Enable();
  }
  catch(std::exception& e) {
    printf("Error: %s\n", e.what());
  }  

  return 0;
}
