/*
 * <insert one-line description of what the program does>
 * Copyright (c) <2008-2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *

File Name:          ProxyInfo.c

Description:

Environment (opt):
 
Notes (opt):
  =====================================================================
  Revision   Revision History		Author     Date
  =====================================================================
  
  =====================================================================
****************************************************************************/


#include <stdio.h>
#include <string.h>
#include "InfoMgmt/InfoMgmt.h"
#include "GUI/error.h"

/* Description: Get the pathname of firefox configuration preference file
 * Module: Proxy Info
 * Parameter: ptr (javascript file path name which is the preference for firefox)
 * Return Value: 0 represent SUCCEED, POSITIVE INTEGER represent FAIL. 
*/
static int get_pathname(char *ptr)
{
	FILE *fp = NULL;
	char buf[MAXNUM_PER_LINE];
	char pathname[256], temp[256];

	/*parameter validity check*/
	if(ptr == NULL)
	{
		WriteLog(INFOMGMT_ERR_PARAM);
		return INFOMGMT_ERR_PARAM;
	}

	strcpy(pathname, (const char *)getenv("HOME"));
	strcat(pathname, FIREFOX_PROFILE_PATH);

	/*open firefox profile file ~/.mozilla/firefox/profiles.ini*/
	if((fp = fopen(pathname, "r")) == NULL)
	{
		WriteLog(INFOMGMT_ERR_NOFFPROF);
		return INFOMGMT_ERR_NOFFPROF;
	}

	/*get HOME path to generate the full pathname*/
	strcpy(ptr, (const char *)getenv("HOME"));
	strcat(ptr, FIREFOX_PROFILE_DIR);
	
	while(fgets(buf, MAXNUM_PER_LINE, fp))
	{
		if(sscanf(buf, "Path=%256s", temp))
		{
			strcat(ptr, temp);
			strcat(ptr, FIREFOX_PREF_FILENAME);
			*(ptr + strlen(ptr)) = '\0';
			fclose(fp);
			return 0;
		}
	}
	fclose(fp);
	WriteLog(INFOMGMT_ERR_NOFFPREF);
	return INFOMGMT_ERR_NOFFPREF;
}

/* Description: Get Proxy Information
 * Module: Proxy Info
 * Parameter: pPI (proxy info which we need)
 * Return Value: 0 represent SUCCEED, POSITIVE INTEGER represent FAIL. 
*/
int ProxyInfo_Construct(char *pPI)
{
	FILE *fp = NULL;
	char pathname[256];
	char buf[256], address[200], port[10];
	int ret = 0, type = -1;
	
	/*parameter validity check*/
	if(pPI == NULL)
	{
		WriteLog(INFOMGMT_ERR_PARAM);
		return INFOMGMT_ERR_PARAM;
	}
	if(ret = get_pathname(pathname))
		return ret;
	
	/*open prefs.js file*/
	if((fp = fopen(pathname, "r")) == NULL)
	{
		WriteLog(INFOMGMT_ERR_NOFFPREF);
		return INFOMGMT_ERR_NOFFPREF;
	}
	
	while(fgets(buf, MAXNUM_PER_LINE, fp))
	{
		/*parse the proxy type from prefs.js*/
		if(sscanf(buf, "user_pref(\"network.proxy.type\", %d);", &type))
		{
			switch(type)
			{
				case 2:
					//printf("automatic proxy configuration url:\n");
					/*type is "automatic proxy configuration url"*/
					fseek(fp, 0, SEEK_SET);
					break;
				case 1:
					//printf("mannual proxy configuration:\n");
					/*type is "mannual proxy configuration*/
					fseek(fp, 0, SEEK_SET);
					break;
				default:
					//printf("type is %d\n", type);
					/*other type*/
					fclose(fp);
					WriteLog(INFOMGMT_ERR_NOPROXY);
					return INFOMGMT_ERR_NOPROXY;
			}
			break;
		}
	}
	
	/*RE-read the preference file to get the detailed proxy info such as ip, port*/
	while(fgets(buf, MAXNUM_PER_LINE, fp))
	{
		/*get ip and port info for mannual proxy*/		
		if(type == 1)
		{
			sscanf(buf, "user_pref(\"network.proxy.http\", \"%[^\"]", address);
			if(sscanf(buf, "user_pref(\"network.proxy.http_port\", %[^)]", port))
			{
				strcpy(pPI, address);
				strcat(pPI, ":");
				strcat(pPI, port);
				fclose(fp);
				return 0;
			}
		}

		/*get autoconfig url*/
		if(type == 2 && sscanf(buf, "user_pref(\"network.proxy.autoconfig_url\", \"%[^\"]", pPI))
		{
			fclose(fp);
			return 0; 
		}
			
	}
	fclose(fp);
	WriteLog(INFOMGMT_ERR_NOPROXY);
	return INFOMGMT_ERR_NOPROXY;
	
}


